/*
  Copyright (C) 1997  Dimitrios P. Bouras

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   For author contact information, look in the README file.
*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <linux/if.h>
#include <arpa/inet.h>
#include <string.h>
#include <unistd.h>

/* Gets PPP interface address by reading /proc/net/route to make sure
   a ppp0 interface exists, and then requesting the interface address.
   Returns pointer to a string representation of the IP address, or NULL. */

static char *IFAddr(char *IFName)
{
	int skfd = -1;
	static char IP[16]={0};
	struct ifreq ifr;
	struct sockaddr_in *sinp;

	skfd = socket(AF_INET, SOCK_DGRAM, 0);			/* open net channel */
	if (skfd < 0)									/* make sure all is OK */
		return NULL;								/* if failed, bail out */
	do {
		strcpy(ifr.ifr_name, IFName);
		if (ioctl(skfd, SIOCGIFADDR, &ifr) < 0) {	/* get interface address */
			close(skfd);							/* if failed, close */
			return NULL;							/* socket and exit */
		}
		sinp = (struct sockaddr_in*)&ifr.ifr_addr;	/* point to data */
	} while (! sinp->sin_addr.s_addr);				/* sometimes 0 returned */
	close(skfd);									/* close the socket */
	strcpy(IP, inet_ntoa(sinp->sin_addr));			/* copy converted string */
	return IP;										/* return its address */
}

char *pppAddr(void)
{
	FILE *procfp;
	char routeLine[128], IF[5];

	procfp = fopen("/proc/net/route", "r");			/* open the route node */
	if (procfp == NULL)								/* failed to open? */
		return NULL;								/* return NULL string */
	while (fgets(routeLine, 128, procfp) != NULL) {	/* open OK, read line */
		if (sscanf(routeLine,"%s", IF))				/* parse interface */
			if (!strcmp(IF, "ppp0")) {				/* is it ppp0 interface? */
				fclose(procfp);						/* close the route node */
				return IFAddr(IF);					/* return ppp0's address */
			}
	}
	fclose(procfp);									/* nothing found, close */
	return NULL;									/* node and return NULL */
}

