/*      -------------------------------------------------------------------
	xldlas -- A Stastics Package

	Copyright (C) 1996 Thor Sigvaldason

	This file handles basic data manipulation like input and editing
	Loading, saving, and importing routines are in the files.c file.
	
        -------------------------------------------------------------------*/

#include "xldlas.h"

extern void say_status(char the_status[XLDLASMAX_INPUT]);
extern void inhibit_input();
extern void reenable_input();

extern void simple_line_output(char which_routine[XLDLASMAX_INPUT], char the_output[XLDLASMAX_INPUT]);
extern void begin_column_output(char the_output[XLDLASMAX_INPUT], int justify);
extern void add_column_output(char the_output[XLDLASMAX_INPUT], int justify);
extern void end_column_output();
extern void seperator_output(int howmany);
extern void begin_table_output(int how_many, char title[XLDLASMAX_INPUT]);
extern void end_table_output(int how_many);

extern void start_gen();
extern void sync_graph_browsers();

/*
	Tears missing values off the end of all variables in memory by lowering
	the number of observations to match those that are not missing values
*/
void rip_ends()
{
	void drop_variable(int to_drop, int shouldi);
	char string_one[XLDLASMAX_INPUT];
	int numb_dropped;
	int i;
	for(i=0; i < numb_variables; i++)
	{
		numb_dropped = 0;
		while(data_matrix[i].obs > 0 && *(fvector[i] + data_matrix[i].obs - 1) == missing_value)
		{
			if(data_matrix[i].obs == 1)
			{
				sprintf(string_one,"%d missing observation(s) ripped from the end of %s", numb_dropped, data_matrix[i].name);
				simple_line_output("rip",string_one);
				numb_dropped = 0;
				drop_variable(i,TRUE);
			}
			else
			{
				data_matrix[i].obs--;
				numb_dropped++;
			}
		}
		if(numb_dropped > 0)
		{
			sprintf(string_one,"%d missing observation(s) ripped from the end of %s", numb_dropped, data_matrix[i].name);
			simple_line_output("rip",string_one);
		}
	}
}


/*
	Drop a variable from memory
	if real_drop is TRUE, then actually erase the variable
	if not, then set all values between all_start and all_stop to missing
*/

void drop_variable(int to_drop, int shouldi)
{
	int i,j;
	char string_one[XLDLASMAX_INPUT];
	if(shouldi == TRUE)
	{
		sprintf(string_one,"%d observation(s) (all) dropped from %s", data_matrix[to_drop].obs, data_matrix[to_drop].name);
		simple_line_output("drop", string_one);
		if(to_drop == numb_variables - 1)
		{
			free(fvector[to_drop]);
			strcpy(data_matrix[to_drop].name,"");
			strcpy(data_matrix[to_drop].description,"");
			data_matrix[to_drop].obs = 0;
			numb_variables--;
		}
		else
		{
			numb_variables--;
			if(quick_dropping == FALSE)
			{
				for(i=to_drop; i < numb_variables; i++)
				{
					strcpy(data_matrix[i].name,data_matrix[i+1].name);
					strcpy(data_matrix[i].description,data_matrix[i+1].description);
					data_matrix[i].obs = data_matrix[i+1].obs;
					data_matrix[i].fmem_start = data_matrix[i+1].fmem_start;
					free(fvector[i]);
 					fvector[i] = (float *) malloc (MAX_OBS * sizeof(float));
					for(j = 0; j < data_matrix[i+1].obs; j++)
					{
						*(fvector[i] + j) = *(fvector[i+1] + j);
					}
				}
			}
			else
			{
				strcpy(data_matrix[to_drop].name,data_matrix[numb_variables].name);
				strcpy(data_matrix[to_drop].description,data_matrix[numb_variables].description);
				data_matrix[to_drop].obs = data_matrix[numb_variables].obs;
				data_matrix[to_drop].fmem_start = data_matrix[numb_variables].fmem_start;
				free(fvector[to_drop]);
				fvector[to_drop] = (float *) malloc (MAX_OBS * sizeof(float));
				for(j = 0; j < data_matrix[numb_variables].obs; j++)
				{
					*(fvector[to_drop] + j) = *(fvector[numb_variables] + j);
				}
			}		
			free(fvector[numb_variables]);
			strcpy(data_matrix[numb_variables].name,"");
			strcpy(data_matrix[numb_variables].description,"");
			data_matrix[numb_variables].obs = 0;
		}
		if(numb_variables == 0)
		{
			data_exists = FALSE;
			oktoquit = TRUE;
		}
	}
	else
	{
		all_start = fl_get_counter_value(drop_from_counter);
		all_stop = fl_get_counter_value(drop_to_counter);	
		if(all_stop < all_start)
		{
			fl_show_alert("From Value Greater than to Value!",
				      "",
				      "",
				      TRUE);
			return;
		}
		for(i = all_start - 1; i < all_stop; i++)
		{
			if(i < data_matrix[to_drop].obs)
			{
				*(fvector[to_drop] + i) = missing_value;
			}
		}
		rip_ends();
	}
	sync_graph_browsers(2);
}



/*
	Generate a table of output which lists the variable name
	number of observations and the text description of the variable
*/

void describe_data()
{
	int i;
	char string_one[XLDLASMAX_INPUT+XLDLASMAX_INPUT];
	if(strlen(data_matrix_description) > 0)
	{
		say_status("Describing Dataset");
		sprintf(string_one, "Dataset label: %-*s", DESC_LENGTH, data_matrix_description);
		simple_line_output("desc",string_one);
	}
	begin_table_output(3, "Data Description");
	begin_column_output("Name                    ", XLDLAS_JUST_CENTER);
	add_column_output("Obs  ", XLDLAS_JUST_CENTER);
	add_column_output("Description", XLDLAS_JUST_CENTER);
	end_column_output();
	seperator_output(3);
	for(i=0; i < numb_variables; i++)
	{
		sprintf(string_one,"%-*s", NAME_LENGTH, data_matrix[i].name);
		begin_column_output(string_one, XLDLAS_JUST_CENTER);
		sprintf(string_one,"  %5d", data_matrix[i].obs);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		sprintf(string_one,"  %-*s", DESC_LENGTH, data_matrix[i].description);
		add_column_output(string_one, XLDLAS_JUST_LEFT);
		end_column_output();
	}
	end_table_output(3);
	say_status("Ready");
}


/*
	Just a button bar shortcut to using the data --> describe menu
*/

void push_describe_data(FL_OBJECT *obj, long user_data)
{
	describe_data();
}


/*
	Check that a variable name is not already in use (and not of zero length)
*/
int check_variable_name(char proposed[XLDLASMAX_INPUT])
{
	int i;
	int name_ok;
	name_ok = TRUE;
	for(i=0; i < numb_variables; i++)
	{
		if(strcmp(data_matrix[i].name,proposed) == 0)
		{
			name_ok = FALSE;
			i=numb_variables+1;
		}		
	}
	return(name_ok);
}


/*
	Reads a variable in from the browser after an input or edit command
	is completed
*/
void read_variable()
{
	int i;
	int blanks_action;
	int place;
	char da_name[NAME_LENGTH];
	char da_desc[DESC_LENGTH];
	char string_number[XLDLASMAX_INPUT];
	say_status("Reading Inputed Data...");
	blanks_action = 0;
	strcpy(da_name, fl_get_input(name_input));
	strcpy(da_desc, fl_get_input(desc_input));

 	fvector[numb_variables] = (float *) malloc (MAX_OBS * sizeof(float));
 	place = 0;
 	for(i = 1; i <= fl_get_browser_maxline(input_browser); i++)
	{
		strncpy(string_number,fl_get_browser_line(input_browser,i),XLDLASMAX_INPUT-1);
		if(strlen(string_number) == 0)
		{
			if(blanks_action == 0)
			{
				blanks_action = fl_show_choice("Blank Lines Exist in Input",
								"Handle as:","", 3,
								"Zero","Missing","Ignore");
			}
			if(blanks_action == 1)
			{
				*(fvector[numb_variables] + place) = 0.0;
				place++;				
			}
			if(blanks_action == 2)
			{
				*(fvector[numb_variables] + place) = missing_value;
				place++;
			}
		}
		else
		{
			*(fvector[numb_variables] + place) = atof(string_number);
			place++;
		}
	}
	if(place == 0)
	{
		free (fvector[numb_variables]);
	}
	else
	{
		while(check_variable_name(da_name) == FALSE || strlen(da_name) == 0)
		{
			strncpy(da_name,fl_show_input("Supplied Variable Name is Invalid or Already in Use. Please Enter Another:",
		  					""),NAME_LENGTH-1);
		}
		strcpy(data_matrix[numb_variables].name,da_name);
		strcpy(data_matrix[numb_variables].description,da_desc);
		data_matrix[numb_variables].obs = place;
		data_matrix[numb_variables].fmem_start = fvector[numb_variables];
		oktoquit = FALSE;
		data_exists = TRUE;
		numb_variables++;
		sprintf(da_desc, "%d observation(s) read into %s", place, da_name);
		simple_line_output("input",da_desc);
		sync_graph_browsers(2);
	}
	rip_ends();
	say_status("Ready");
	reenable_input();
}



/*
	Attach an overall label to the dataset
*/

void label_dataset()
{
	char the_label[XLDLASMAX_INPUT];
	inhibit_input();
	say_status("Labeling Dataset");
	strcpy(the_label,data_matrix_description);
	strcpy(data_matrix_description,fl_show_input("Please enter a description of the dataset in memory:",
		  					the_label));
	
	strcpy(the_label,"Data description changed to: ");
	strcat(the_label,data_matrix_description);
	simple_line_output("label",the_label);
	say_status("Ready");
	reenable_input();
}


/*
	This happens when the user hits the done button
	in the variable input/edit window
*/

void end_input_variable(FL_OBJECT *obj, long arg)
{
	window_geometry[XLDLAS_INPUT][0] = obj->form->x;
	window_geometry[XLDLAS_INPUT][1] = obj->form->y;
	window_geometry[XLDLAS_INPUT][2] = obj->form->w;
	window_geometry[XLDLAS_INPUT][3] = obj->form->h;
	fl_hide_form(input_window);
	say_status("Ready");
	read_variable();
}


/*
	Same as above, but the window automatically
	disappears thanks to xforms
*/
int click_end_input_variable(FL_FORM *form, void *arg)
{
	window_geometry[XLDLAS_INPUT][0] = form->x;
	window_geometry[XLDLAS_INPUT][1] = form->y;
	window_geometry[XLDLAS_INPUT][2] = form->w;
	window_geometry[XLDLAS_INPUT][3] = form->h;
	say_status("Ready");
	read_variable();
	return(FL_OK);
}



/*
	This occurs when the user hits return in the variable
	entry part of the data input/edit window
*/
void return_data(FL_OBJECT *obj, long arg)
{
	fl_freeze_form(input_window);
	fl_addto_browser(input_browser,fl_get_input(input_object));
	fl_set_input(input_object,"");
	fl_set_focus_object(input_window,input_object);
	fl_unfreeze_form(input_window);
}


/*
	The add button in the input/edit window
*/
	
void add_data(FL_OBJECT *obj, long arg)
{
	fl_addto_browser(input_browser,fl_get_input(input_object));
}


/*
	The insert button in the input/edit window
*/
	
void insert_data(FL_OBJECT *obj, long arg)
{
	if (! fl_get_browser(input_browser)) return;
	fl_insert_browser_line(input_browser,fl_get_browser(input_browser),fl_get_input(input_object));
}


/*
	Did you know that double clicking in the input list window
	will copy the value to the little input area at the bottom?
*/

void double_click_add(FL_OBJECT *obj, long arg)
{
	if(! fl_get_browser(input_browser)) return;
	fl_set_input(input_object,fl_get_browser_line(input_browser,fl_get_browser(input_browser)));
}


/*
	The replace button in the input/edit wondow
*/
void replace_data(FL_OBJECT *obj, long arg)
{
	if (! fl_get_browser(input_browser)) return;
	fl_replace_browser_line(input_browser,fl_get_browser(input_browser),fl_get_input(input_object));
}


/*
	Wipe out the highlighted entry in the input/edit window
*/

void delete_data(FL_OBJECT *obj, long arg)
{
	if (! fl_get_browser(input_browser)) return;
	fl_delete_browser_line(input_browser,fl_get_browser(input_browser));
}


/*
	Clear all values from the input/edit window
*/
void clear_data(FL_OBJECT *obj, long arg)
{
	int choice;
	choice = fl_show_choice("About to delete all observations!",
					"Are you sure?","", 3,
					"Yes","No","Cancel");
		if(choice == 1)
		{
			fl_clear_browser(input_browser);
		}
}


/*
	Start up the input/edit window for a new variables
*/

void input_variable()
{
	inhibit_input();
	fl_clear_browser(input_browser);
	fl_set_input(input_object,"");
	fl_set_input(name_input,"");
	fl_set_input(desc_input,"");
	say_status("Inputing data from User");
	fl_set_form_minsize(input_window, 170, 400);
	if(window_geometry[XLDLAS_INPUT][0] != -1)
	{
		fl_set_form_geometry(input_window, 
					window_geometry[XLDLAS_INPUT][0],
					window_geometry[XLDLAS_INPUT][1],
					window_geometry[XLDLAS_INPUT][2],
					window_geometry[XLDLAS_INPUT][3]);
	}	
	fl_show_form(input_window,FL_PLACE_FREE,FL_FULLBORDER,"Input A New Variable");
}


/*
	Abort editing a variable by closing the chooser window
*/

int click_user_chose_variable(FL_FORM *form, void *arg)
{
	say_status("Ready");
	reenable_input();
	return(FL_OK);
}


/*
	Abort renaming a variable by closing the chooser window
*/

int click_user_rename_variable(FL_FORM *form, void *arg)
{
	say_status("Ready");
	reenable_input();
	return(FL_OK);
}


/*
	User Selected a variable to edit
*/
void user_chose_variable(FL_OBJECT *obj, long arg)
{
	int i;
	int which_variable;
	char string_one[XLDLASMAX_INPUT];
	fl_hide_form(variable_window);
	which_variable = fl_get_browser(variable_browser);
	if(which_variable == 0)
	{
		say_status("Ready");
		reenable_input();
	}
	else
	{
		which_variable--;
		fl_set_input(name_input, data_matrix[which_variable].name);
		fl_set_input(desc_input, data_matrix[which_variable].description);
		fl_clear_browser(input_browser);
		for(i=0; i < data_matrix[which_variable].obs; i++)
		{
			sprintf(string_one,"%f",*(fvector[which_variable] + i));
			fl_addto_browser(input_browser,string_one);
		}
		drop_variable(which_variable, TRUE);
		say_status("Editing Variable");
		if(window_geometry[XLDLAS_INPUT][0] != -1)
		{
			fl_set_form_geometry(input_window, 
						window_geometry[XLDLAS_INPUT][0],
						window_geometry[XLDLAS_INPUT][1],
						window_geometry[XLDLAS_INPUT][2],
						window_geometry[XLDLAS_INPUT][3]);
		}	
		fl_show_form(input_window,FL_PLACE_FREE,FL_FULLBORDER,"Edit Variable");
	}
	
}


/*
	Choose which variable to edit
*/
void start_edit_variable()
{
	int i;
	inhibit_input();
	say_status("Waiting for Variable Selection");
	fl_clear_browser(variable_browser);
	for(i=0; i < numb_variables; i++)
	{
		fl_addto_browser(variable_browser,data_matrix[i].name);
	}
	fl_show_form(variable_window,FL_PLACE_FREE,FL_TRANSIENT,"Choose a Variable");
}


/*
	List available variables in the drop window
*/
void show_variables()
{
	int i;
	fl_freeze_form(drop_window);
	fl_clear_browser(drop_browser);
	for(i=0; i < numb_variables; i++)
	{
		fl_addto_browser(drop_browser,data_matrix[i].name);
	}
	fl_unfreeze_form(drop_window);
}


/*
	Exit drop by closing the window
*/

int click_done_drop_variable(FL_OBJECT *obj, long arg)
{
	say_status("Ready");
	reenable_input();
	return(FL_OK);
}


/*
	Exit drop by hitting the done button
*/

void done_drop_variable(FL_OBJECT *obj, long arg)
{
	fl_hide_form(drop_window);
	say_status("Ready");
	reenable_input();
}


/*
	Wipe 'em all out (yikes!)
*/

void drop_all_variables(FL_OBJECT *obj, long arg)
{
	int i;
	fl_hide_form(drop_window);
	for(i = numb_variables - 1; i >= 0; i--)
	{
		drop_variable(i,real_drop);
	}
	say_status("Ready");
	reenable_input();
}


/*
	Drop a variable only if one is actually selected in the drop browser
*/

void user_drop_variable()
{
	int which_variable;
	which_variable = fl_get_browser(drop_browser);
	if(which_variable != 0) drop_variable(which_variable - 1,real_drop);
	show_variables();
}


/*
	Initialize dropping and the drop window
*/

void start_drop_variable()
{
	int i, largest;
	inhibit_input();
	largest = 0;
	for(i=0; i < numb_variables; i++)
	{
		if(data_matrix[i].obs > largest) largest = data_matrix[i].obs;
	}

	fl_set_counter_value(drop_from_counter, 1);
	fl_set_counter_bounds(drop_from_counter, 1, largest);
	fl_set_counter_step(drop_from_counter, 1, 10);

	fl_set_counter_value(drop_to_counter, largest);
	fl_set_counter_bounds(drop_to_counter, 1, largest);
	fl_set_counter_step(drop_to_counter, 1, 10);
	
	say_status("Drop Variables");
	fl_show_form(drop_window,FL_PLACE_FREE,FL_TRANSIENT,"Drop Variables!!");
	show_variables();
}


/*
	Set up the list chooser
*/

void start_list_variables()
{
	int i;
	int largest;
	inhibit_input();
	say_status("Waiting for Variable(s) Selection");
	fl_clear_browser(list_browser);
	largest = 0;
	for(i=0; i < numb_variables; i++)
	{
		if(data_matrix[i].obs > largest) largest = data_matrix[i].obs;
		fl_addto_browser(list_browser,data_matrix[i].name);
	}

	fl_set_counter_value(list_from_counter, 1);
	fl_set_counter_bounds(list_from_counter, 1, largest);
	fl_set_counter_step(list_from_counter, 1, 10);

	fl_set_counter_value(list_to_counter, largest);
	fl_set_counter_bounds(list_to_counter, 1, largest);
	fl_set_counter_step(list_to_counter, 1, 10);
	
	fl_show_form(list_window,FL_PLACE_FREE,FL_TRANSIENT,"Select Variables to List");
}


/*
	Abort listing by closing the list browser window
*/

int click_abort_list_variables(FL_FORM *form, void *arg)
{
	say_status("Ready");
	reenable_input();
	return(FL_OK);
}


/*
	Actually list the variables that have been selected
*/

void list_variables(FL_OBJECT *obj, long arg)
{
	int i, j, k, numb_list, to_list[MAX_VARS];
	char string_one[XLDLASMAX_INPUT];
	char string_two[XLDLASMAX_INPUT];
	fl_hide_form(list_window);
	all_start = fl_get_counter_value(list_from_counter);
	all_stop = fl_get_counter_value(list_to_counter);	
	if(all_stop < all_start)
	{
		fl_show_alert("From Value Greater than to Value!",
			      "",
			      "",
			      TRUE);
		reenable_input();
		say_status("Ready");
		return;
	}
	strcpy(string_one, "Variables: "); 
	numb_list = 0;
	for(i = 0; i < numb_variables; i++)
	{
		if(fl_isselected_browser_line(list_browser, i+1))
		{
			to_list[numb_list] = i;
			sprintf(string_two," %s", data_matrix[i].name);
			strcat(string_one, string_two);
			numb_list++;
		}
	}
	if(numb_list == 0)
	{
		reenable_input();
		say_status("Ready");
		return;
	}
	say_status("Listing Variable(s)");
	simple_line_output("list",string_one);
	begin_table_output(numb_list, "Data List");
	sprintf(string_one,"%*s",NAME_LENGTH,data_matrix[to_list[0]].name);
	begin_column_output(string_one, XLDLAS_JUST_CENTER);
	for(i = 1; i < numb_list; i++)
	{
		sprintf(string_one,"%*s",NAME_LENGTH,data_matrix[to_list[i]].name);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
	}
	end_column_output();
	seperator_output(numb_list);
	general_abort = FALSE;
	fl_show_form(abort_window,FL_PLACE_FREE,FL_FULLBORDER,"Abort List");
	for(i = all_start - 1; i < all_stop; i++)
	{
		fl_check_forms();
		if(general_abort == FALSE)
		{
			if(i >= data_matrix[to_list[0]].obs)
			{
				strcpy(string_one,"");
				for(k = 0 ; k < NAME_LENGTH - 4; k++)
				{
					strcat(string_one," ");
				}
				strcat(string_one,"n.a.");
			}
			else
			{
				sprintf(string_one,"%*.4f", NAME_LENGTH, *(fvector[to_list[0]] + i));
			}
			if(*(fvector[to_list[0]] + i) == missing_value)
			{
				strcpy(string_one,"");
				for(k = 0 ; k < NAME_LENGTH - 4; k++)
				{
					strcat(string_one," ");
				}
				strcat(string_one,"miss");
			}
			begin_column_output(string_one, XLDLAS_JUST_RIGHT);
			for(j = 1; j < numb_list; j++)
			{
				if(i >= data_matrix[to_list[j]].obs)
				{
					strcpy(string_one,"");
					for(k = 0 ; k < NAME_LENGTH - 4; k++)
					{
						strcat(string_one," ");
					}
					strcat(string_one,"n.a.");
				}
				else
				{
					sprintf(string_one,"%*.4f", NAME_LENGTH, *(fvector[to_list[j]] + i));
				}
				if(*(fvector[to_list[j]] + i) == missing_value)
				{
					strcpy(string_one,"");
					for(k = 0 ; k < NAME_LENGTH - 4; k++)
					{
						strcat(string_one," ");
					}
					strcat(string_one,"miss");
				}
				add_column_output(string_one, XLDLAS_JUST_RIGHT);
			}
			end_column_output();
		}
		else
		{
			sprintf(string_one,"List was aborted at observation %d",i);
			simple_line_output("abort", string_one); 
			i = all_stop;
		}
	}

	fl_hide_form(abort_window);
	end_table_output(numb_list);
	reenable_input();
	say_status("Ready");
}

void user_rename_variable(FL_OBJECT *obj, long arg)
{
	int which_variable, i;
	char da_name[NAME_LENGTH];
	which_variable = fl_get_browser(rename_browser);
	if(which_variable == 0)
	{
		fl_hide_form(rename_window);
		say_status("Ready");
		reenable_input();
		return;
	}
	else
	{
		say_status("Waiting for new name");
		which_variable--;
		strcpy(da_name,data_matrix[which_variable].name);
		strcpy(data_matrix[which_variable].name,"kitschchewing");
		strncpy(da_name,fl_show_input("New Variable Name (May be truncated to Name Length)",
		  					da_name),NAME_LENGTH-1);
		while(check_variable_name(da_name) == FALSE || strlen(da_name) == 0)
		{
			strncpy(da_name,fl_show_input("Supplied Variable Name is Invalid or Already in Use. Please Enter Another:",
		  					""),NAME_LENGTH-1);
		}
		strncpy(data_matrix[which_variable].name,da_name, NAME_LENGTH - 1);
	}
	fl_clear_browser(rename_browser);
	for(i=0; i < numb_variables; i++)
	{
		fl_addto_browser(rename_browser,data_matrix[i].name);
	}
	fl_show_form(rename_window,FL_PLACE_FREE,FL_TRANSIENT,"Choose a Variable");
	say_status("Ready");
	oktoquit = FALSE;
	reenable_input();
}


/*
	Choose which variable to rename
*/

void start_rename_variable()
{
	int i;
	inhibit_input();
	say_status("Waiting for Variable Selection");
	fl_clear_browser(rename_browser);
	for(i=0; i < numb_variables; i++)
	{
		fl_addto_browser(rename_browser,data_matrix[i].name);
	}
	fl_show_form(rename_window,FL_PLACE_FREE,FL_TRANSIENT,"Choose a Variable");
}


/*
	Call appropriate routine based on which menu item was selected
*/

void data_routines(FL_OBJECT *menu, long user_data)
{
	int choice;
	choice = fl_get_menu(menu);
	if(choice == 1)
	{
		if(numb_variables < MAX_VARS)
		{
			input_variable();
		}
		else
		{
		fl_show_alert("No Room to Add More Variables!",
			      "You can compile a \"bigger\" version of xldlas by editing the",
			      "source code file xldlas.h (see #define MAX_VARS) and recompiling.",
			      TRUE);
			
		}
	}
	if(choice == 2)
	{
		start_edit_variable();
	}
	if(choice == 3)
	{
		start_drop_variable();
	}
	if(choice == 4)
	{
		start_rename_variable();
	}
	if(choice == 5)
	{
		describe_data();
	}
	if(choice == 6)
	{
		start_list_variables();
	}
	if(choice == 7)
	{
		label_dataset();
	}
	if(choice == 8)
	{
		start_gen();
	}
}


