/*      ----------------------------------------------------------------
	xldlas -- A Stastics Package

	Copyright (C) 1996 Thor Sigvaldason

	This file is read by all *.c sourcecode to get definitions and
	global variables

        ----------------------------------------------------------------*/

/*
	More or less standard include files
*/

#include <forms.h>		/* You do have xforms installed don't you? */
#include <stdlib.h>
#include <signal.h>
#include <time.h>
#include <math.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <sys/wait.h>
#include <assert.h>


/*
	Some things you can only change at compile time
*/

#define XLDLAS_MAJOR	0			/* Current Major version number		*/
#define XLDLAS_MINOR	80			/* Current Minor version number		*/
#define XLDLAS_AUTHOR	"Thor Sigvaldason"	/* Please don't change (see License)	*/
#define	XLDLAS_DATE	"Feb 3 1997"		/* Roughly speaking			*/
#define XLDLAS_EMAIL	"thor@netcom.ca"	/* Subject to change			*/
#define XLDLAS_SITE1	"http://a42.com/~thor/xldlas/"
#define XLDLAS_SITE2	"ftp://sunsite.unc.edu/pub/Linux/X11/xapps/math/xldlas-X.Y-source.tgz"
#define XLDLAS_NUMB_BARS_MAX		50
#define XLDLAS_GA_MAXREAL		1000
#define XLDLAS_MAX_GA_CYCLES		50000
#define	XLDLAS_MAX_GA_BITSIZE		100
#define XLDLAS_MAX_GA_POOLSIZE		256
#define XLDLAS_MAX_OFFSET		2000	/* Max Horizontal Scrolling Main Window	*/


#define	MAX_OBS				10000	/* Maximum Observations			*/
#define MAX_VARS			100	/* Maximum Number of Variables          */

/*	
	If you need to handle larger data sets than this, then just 
	change the numbers above to suit your tastes (and recompile!).
*/

#define TRUE		1			/* Standard Logic Testing		*/
#define	FALSE		0			/* "			"		*/
#define TYPE_COLS	1			/* User supplied format for imports	*/
#define TYPE_ROWS	2			/* "				  "	*/
#define	TINY		1.0e-20			/* Need this to calculate Gamma function*/
#define MAXIT		100			/* Max iterations to calculate Gamma	*/
#define EPS 		3.0e-7			/* A very small number			*/	
#define FPMIN		1.0e-30			/* Smallest floating point value	*/



#define DESC_LENGTH 	256			/* Characters in a variable's descrip.  */
#define NAME_LENGTH 	20			/* Characters in a variable's name      */
#define XLDLASMAX_INPUT 1024			/* Length of most strings		*/
#define XLDLAS_MISSING	-999999.0		/* Default value for missing observation*/
#define QUICK_DROPPING	FALSE			/* TRUE is faster but less intuitive	*/



/*
	Lots of defaults which can be changed via .xldlasrc/preferences button
*/

#define XLDLAS_DEFAULT_KEY_BUTTON	FALSE;
#define XLDLAS_DEFAULT_OVERWRITE_BUTTON	TRUE;
#define XLDLAS_DEFAULT_NORMAL_BUTTON	TRUE;
#define XLDLAS_DEFAULT_OUTPUT_FORMAT	"postscript"
#define XLDLAS_DEFAULT_OUTPUT_OPTIONS	"eps 'helvetica' 20"
#define XLDLAS_DEFAULT_HIST_BARS	9
#define XLDLAS_DEFAULT_GNUPLOT_GEOMETRY	"300x240"
#define XLDLAS_DEFAULT_GA_CYCLES	500
#define XLDLAS_DEFAULT_NN_CYCLES	1000
#define XLDLAS_DEFAULT_NN_PICTEX	FALSE
#define XLDLAS_DEFAULT_NN_HIDDEN	4
#define XLDLAS_DEFAULT_NN_LEARN		0.10
#define XLDLAS_DEFAULT_NN_ANNEALING	FALSE
#define XLDLAS_DEFAULT_NN_SQUASH	3
#define XLDLAS_DEFAULT_GA_MUTATE	500
#define XLDLAS_DEFAULT_GA_MAXREAL	500
#define XLDLAS_DEFAULT_GA_BITSIZE	12
#define XLDLAS_DEFAULT_GA_POOLSIZE	100
#define XLDLAS_DEFAULT_GA_CROSS		200
#define XLDLAS_DEFAULT_GA_UPDATE	10
#define XLDLAS_DEFAULT_GA_SWAP		2
#define XLDLAS_DEFAULT_GA_PERTURBE	200
#define XLDLAS_DEFAULT_GA_TOLERANCE	0
#define XLDLAS_DEFAULT_PRINT_COMMAND	"lpr"
#define XLDLAS_DEFAULT_TEX_COMMAND	"tex"
#define XLDLAS_DEFAULT_DVIVIEW_COMMAND	"xdvi -expert -s 5"
#define XLDLAS_DEFAULT_DVIPRINT_COMMAND "dvips"
#define XLDLAS_DEFAULT_TEX_PREAMBLE	"\\input epsf \\input pictex"
#define XLDLAS_DEFAULT_TEX_GRAPHMACROL	"\\midinsert\\centerline{\\epsfbox{"
#define XLDLAS_DEFAULT_TEX_GRAPHMACROR	"}}\\endinsert"
#define XLDLAS_DEFAULT_ANOVA_TYPE	1

/*
	Defines some Labels for Making Windows Sticky
*/

#define	XLDLAS_NUMB_WINDOWS 14
#define XLDLAS_REGRESS	0
#define XLDLAS_GAFIT 	1
#define XLDLAS_NNFIT 	2
#define XLDLAS_ANOVA 	3
#define XLDLAS_GRAPH 	4
#define XLDLAS_PREFS 	5
#define XLDLAS_INPUT 	6
#define XLDLAS_GENERATE 7
#define XLDLAS_ABOUT 	8
#define XLDLAS_HELP 	9
#define XLDLAS_SIGN	10
#define XLDLAS_EQMEAN	11
#define XLDLAS_FILTER	12
#define XLDLAS_WATSON	13




/*
	Used by tabular output to TeX to determine justification
*/

#define XLDLAS_JUST_CENTER		1
#define XLDLAS_JUST_LEFT		2
#define XLDLAS_JUST_RIGHT		3

/*
	Below is the data structure for storing (vector of) variables
*/

struct vector_structure
{
		char	name[NAME_LENGTH];
		char	description[DESC_LENGTH];
		int	obs;
		float	*fmem_start;
};

/* These are the possible errors that can be returned by the tips routines. */

typedef enum {
  TOOLTIPS_ERROR_NOERROR,            /* There is no error. */
  TOOLTIPS_ERROR_NOTINITIALIZED,     /* The tooltips system is not
					initialized. */
  TOOLTIPS_ERROR_ALREADYINITIALIZED, /* The tooltips system is already
					initialized. */
  TOOLTIPS_ERROR_ALREADYSUSPENDED,   /* The tooltips system is already
					suspended. */
  TOOLTIPS_ERROR_NOTSUSPENDED,       /* The tooltips system is not currently 
					suspended. */
  TOOLTIPS_ERROR_ALREADYREGISTERED,  /* The XForms object is already 
					registered with the tooltips system. */
  TOOLTIPS_ERROR_NOTREGISTERED,      /* The XForms object is not registered 
					with the tooltips system. */
  TOOLTIPS_ERROR_NONEFROMFORM,       /* No XForms objects from this form are
					registered with the tooltips system. */
  TOOLTIPS_ERROR_BADJUSTIFICATION,   /* This justification combination is 
					invalid. */
  TOOLTIPS_ERROR_NOTENOUGHMEMORY,    /* There was a problem with memory 
					allocation. */
  TOOLTIPS_ERROR_NULLADDRESS,        /* The pointer passed was a NULL
					pointer. */
  TOOLTIPS_ERROR_UNKNOWNERROR        /* This is an unknown error. */
} TOOLTIPS_ERROR;


/*
	A structure used by various data generation commands
*/
struct math_thingy
{
		int 	operator;
		int	argument_type;
		char	float_argument[XLDLASMAX_INPUT];
		int	variable_argument;
		int	variable_lag;
};

	
struct	vector_structure data_matrix[MAX_VARS];		/*Data Attributes */
struct  math_thingy math_construct;			/* Math thingy 	  */
float	*fvector[MAX_VARS];				/*The actual data */
char	data_matrix_description[DESC_LENGTH];		/*What data is it?*/
							/*Flags		  */
float	ga_coefs[MAX_VARS][4];
float	ga_powers[MAX_VARS][4];


int	oktoquit, data_exists, gen_exists;
int	help_exists[11];
int	quick_dropping;
int	real_drop;
int	log_on;
int	texlog_on;
int	htmllog_on;
int	log_verbose_on;
int	texlog_verbose_on;
int	htmllog_verbose_on;
int	anova_type;
int	balloon_help;
							/*Flags		  */
int	numb_variables;					/*Vars in memory  */

int 	import_type;
int	graph_window_open;
int	assume_sample;

char	help_location[XLDLASMAX_INPUT];		/*Where are help files?	  */
FILE	*log_file;				/*File pointer for log    */
FILE	*texlog_file;				/*File pointer for tex log*/
FILE	*htmllog_file;				/*File pointer for htmllog*/
char	log_name[XLDLASMAX_INPUT];
char	texlog_name[XLDLASMAX_INPUT];
char	htmllog_name[XLDLASMAX_INPUT];
int     all_start;				/*Start obser for loops   */
int     all_stop;				/*End obser for loops     */
float	missing_value;				/*Value of missing obs	  */
char	line_of_output[XLDLASMAX_INPUT];	/*Used to display results */
char	filtered_tex_string[XLDLASMAX_INPUT];
float	working[MAX_OBS];
float	working_two[MAX_OBS];
int	worksize;
int	worksize_two;
int	gnuplot_pipe;
FILE	*gnuplot_datafile;
char	gnuplot_datafile_name[L_tmpnam];
pid_t	gnuplot_pid;
int	graph_key_on;
int	graph_overwrite_on;
int	graph_normal_on;
char	graph_output_format[XLDLASMAX_INPUT];
char	graph_output_options[XLDLASMAX_INPUT];
int	point_style[MAX_VARS];
int	line_style[MAX_VARS];
int	temp_varnumber;
int	numb_bars;
char	gnuplot_geometry[XLDLASMAX_INPUT];
extern  char **environ;
int	main_offset;

int ga_cycles;
int nn_cycles;
int nn_pictex;
int nn_squash;
int nn_hidden;
int nn_annealing;
float nn_learn;
int ga_update;
int ga_mutate;
int ga_force;
int ga_maxreal;
int ga_bitsize;
int ga_poolsize;
int ga_swap;
int ga_cross;
int ga_perturbe;
int ga_tolerance;

int ga_cross_ok;
int ga_mutate_ok;
int ga_perturbe_ok;
int ga_force;

int general_abort;
int pearls_of_wisdom;
int main_font;

char print_command[XLDLASMAX_INPUT];
char tex_command[XLDLASMAX_INPUT];
char dviview_command[XLDLASMAX_INPUT];
char dviprint_command[XLDLASMAX_INPUT];
char tex_preamble[XLDLASMAX_INPUT];
char tex_graphmacrol[XLDLASMAX_INPUT];
char tex_graphmacror[XLDLASMAX_INPUT];



extern void file_routines(FL_OBJECT *menu, long user_data);
extern void data_routines(FL_OBJECT *menu, long user_data);
extern void log_routines(FL_OBJECT *menu, long user_data);
extern void graph_routines(FL_OBJECT *menu, long user_data);
extern void analysis_routines(FL_OBJECT *menu, long user_data);
extern void help_routines(FL_OBJECT *menu, long user_data);

/*
	Variable to store window geometries
*/

int window_geometry[XLDLAS_NUMB_WINDOWS][4];

/*
	Do we really need all these xforms objects as global variables?
	Probably not (and _bad_ programming style), but is does make
	life easier
*/

FL_FORM		*frontend;
FL_FORM		*about_window;
FL_FORM		*input_window;
FL_FORM		*help_window;

FL_OBJECT	*main_browser;
FL_OBJECT	*input_browser;
FL_OBJECT	*input_object;
FL_OBJECT	*status_browser;
FL_OBJECT	*help_browser;

FL_OBJECT 	*file_menu;
FL_OBJECT 	*data_menu;
FL_OBJECT 	*log_menu;
FL_OBJECT 	*graph_menu;
FL_OBJECT 	*analysis_menu;
FL_OBJECT 	*help_menu;
FL_OBJECT	*test_menu;
FL_OBJECT	*filter_menu;
	
FL_OBJECT 	*load_button;
FL_OBJECT 	*save_button;
FL_OBJECT 	*describe_button;
FL_OBJECT 	*plot_button;
FL_OBJECT 	*regress_button;
FL_OBJECT 	*preferences_button;
FL_OBJECT 	*clear_button;

FL_OBJECT	*general_help_button;
FL_OBJECT	*file_help_button;
FL_OBJECT	*data_help_button;
FL_OBJECT	*log_help_button;
FL_OBJECT	*graph_help_button;
FL_OBJECT	*analysis_help_button;
FL_OBJECT	*license_help_button;
FL_OBJECT	*tutorial_help_button;
FL_OBJECT	*test_help_button;
FL_OBJECT	*filter_help_button;
FL_OBJECT	*horizontal_slider;

FL_OBJECT	*name_input;
FL_OBJECT	*desc_input;

FL_FORM		*variable_window;
FL_OBJECT	*variable_browser;

FL_FORM		*rename_window;
FL_OBJECT	*rename_browser;

FL_FORM		*summarize_window;
FL_OBJECT	*summarize_browser;
FL_OBJECT	*summarize_from_counter;
FL_OBJECT	*summarize_to_counter;

FL_FORM		*drop_window;
FL_OBJECT	*drop_browser;
FL_OBJECT	*drop_from_counter;
FL_OBJECT	*drop_to_counter;

FL_FORM		*list_window;
FL_OBJECT	*list_browser;
FL_OBJECT	*list_from_counter;
FL_OBJECT	*list_to_counter;

FL_FORM		*corr_window;
FL_OBJECT	*corr_browser;
FL_OBJECT	*corr_from_counter;
FL_OBJECT	*corr_to_counter;

FL_FORM		*regress_window;
FL_OBJECT	*regress1_browser;
FL_OBJECT	*regress2_browser;
FL_OBJECT	*regress_from_counter;
FL_OBJECT	*regress_to_counter;

FL_FORM		*graph_window;
FL_OBJECT	*xvar_browser;
FL_OBJECT	*yvar_browser;
FL_OBJECT	*choose_hist_button;
FL_OBJECT	*choose_plot_button;
FL_OBJECT	*graph_save_input;
FL_OBJECT	*graph_format_input;
FL_OBJECT	*graph_options_input;
FL_OBJECT	*graph_key_choice;
FL_OBJECT	*graph_title_input;
FL_OBJECT	*graph_xlabel_input;
FL_OBJECT	*graph_ylabel_input;
FL_OBJECT	*graph_from_counter;
FL_OBJECT	*graph_to_counter;
FL_OBJECT	*graph_bar_counter;
FL_OBJECT	*graph_key_button;
FL_OBJECT	*graph_normal_button;
FL_OBJECT	*graph_overwrite_button;
FL_OBJECT	*fit_variable_input;
FL_OBJECT	*fit_overwrite_button;
FL_OBJECT	*graph_xrange_auto_button;
FL_OBJECT	*graph_xrange_from_counter;
FL_OBJECT	*graph_xrange_to_counter;
FL_OBJECT	*graph_yrange_auto_button;
FL_OBJECT	*graph_yrange_from_counter;
FL_OBJECT	*graph_yrange_to_counter;



FL_FORM		*att_window;
FL_OBJECT	*att_point_counter;
FL_OBJECT	*att_line_counter;

FL_FORM		*ga_window;
FL_OBJECT	*ga_chart;
FL_OBJECT	*ga_from_counter;
FL_OBJECT	*ga_to_counter;
FL_OBJECT	*ga_cycles_counter;
FL_OBJECT	*ga_update_counter;
FL_OBJECT	*ga_mutate_counter;
FL_OBJECT	*ga_maxreal_counter;
FL_OBJECT	*ga_bitsize_counter;
FL_OBJECT	*ga_poolsize_counter;
FL_OBJECT	*ga_perturbe_counter;
FL_OBJECT	*ga_tolerance_counter;
FL_OBJECT	*ga_swap_counter;
FL_OBJECT	*ga_cross_counter;
FL_OBJECT	*ga_yvar_browser;
FL_OBJECT	*ga_xvars_browser;
FL_OBJECT	*ga_force_button;
FL_OBJECT	*ga_mutate_button;
FL_OBJECT	*ga_cross_button;
FL_OBJECT	*ga_perturbe_button;
FL_OBJECT	*ga_save_input;
FL_OBJECT	*ga_overwrite_button;
FL_OBJECT	*ga_go_button;
FL_OBJECT	*ga_stop_button;
FL_OBJECT	*ga_done_button;

FL_FORM		*log_window;
FL_OBJECT	*log_verbose_button;
FL_OBJECT	*log_on_button;
FL_OBJECT	*log_file_input;
FL_OBJECT	*log_view_button;
FL_OBJECT	*log_print_button;
FL_OBJECT	*log_done_button;

FL_FORM		*htmllog_window;
FL_OBJECT	*htmllog_verbose_button;
FL_OBJECT	*htmllog_on_button;
FL_OBJECT	*htmllog_file_input;
FL_OBJECT	*htmllog_view_button;
FL_OBJECT	*htmllog_done_button;

FL_FORM		*texlog_window;
FL_OBJECT	*texlog_verbose_button;
FL_OBJECT	*texlog_on_button;
FL_OBJECT	*texlog_file_input;
FL_OBJECT	*texlog_source_button;
FL_OBJECT	*texlog_dvi_button;
FL_OBJECT	*texlog_print_button;
FL_OBJECT	*texlog_done_button;

FL_FORM		*viewfile_window;
FL_OBJECT	*viewfile_browser;

FL_FORM		*abort_window;
FL_OBJECT	*general_abort_button;

FL_FORM		*prefs_window;
FL_OBJECT	*prefs_quick_dropping_button;
FL_OBJECT	*prefs_graph_key_on_button;
FL_OBJECT	*prefs_graph_overwrite_on_button;
FL_OBJECT	*prefs_graph_normal_on_button;
FL_OBJECT	*prefs_ga_cross_ok_button;
FL_OBJECT	*prefs_ga_mutate_ok_button;
FL_OBJECT	*prefs_ga_force_button;
FL_OBJECT	*prefs_ga_perturbe_ok_button;
FL_OBJECT	*prefs_pearls_of_wisdom_button;
FL_OBJECT	*prefs_numb_bars_counter;
FL_OBJECT	*prefs_ga_cycles_counter;
FL_OBJECT	*prefs_ga_update_counter;
FL_OBJECT	*prefs_ga_mutate_counter;
FL_OBJECT	*prefs_ga_maxreal_counter;
FL_OBJECT	*prefs_ga_bitsize_counter;
FL_OBJECT	*prefs_ga_poolsize_counter;
FL_OBJECT	*prefs_ga_swap_counter;
FL_OBJECT	*prefs_ga_cross_counter;
FL_OBJECT	*prefs_ga_perturbe_counter;
FL_OBJECT	*prefs_ga_tolerance_counter;
FL_OBJECT	*prefs_missing_value_input;
FL_OBJECT	*prefs_graph_output_format_input;
FL_OBJECT	*prefs_graph_output_options_input;
FL_OBJECT	*prefs_gnuplot_geometry_input;
FL_OBJECT	*prefs_print_command_input;
FL_OBJECT	*prefs_tex_command_input;
FL_OBJECT	*prefs_dviview_command_input;
FL_OBJECT	*prefs_dviprint_command_input;
FL_OBJECT	*prefs_tex_preamble_input;
FL_OBJECT	*prefs_tex_graphmacrol_input;
FL_OBJECT	*prefs_tex_graphmacror_input;
FL_OBJECT	*prefs_nnet_annealing_button;
FL_OBJECT	*prefs_nnet_pictex_button;
FL_OBJECT	*prefs_nn_learn_counter;
FL_OBJECT	*prefs_nn_cycles_counter;
FL_OBJECT	*prefs_balloon_help_button;
FL_OBJECT	*prefs_font_group;
FL_OBJECT	*prefs_font_small_button;
FL_OBJECT	*prefs_font_normal_button;
FL_OBJECT	*prefs_font_large_button;
FL_OBJECT	*prefs_assume_sample_button;

FL_FORM		*gen_window;
FL_OBJECT	*gen_data_browser;
FL_OBJECT	*gen_from_counter;
FL_OBJECT	*gen_to_counter;
FL_OBJECT	*gen_var_choice;
FL_OBJECT	*gen_name_input;
FL_OBJECT	*gen_desc_input;
FL_OBJECT	*gen_operator_browser;
FL_OBJECT	*gen_argument_browser;

FL_FORM		*anova_window;
FL_OBJECT	*anova_block_browser;
FL_OBJECT	*anova_variable_browser;
FL_OBJECT	*anova_one_button;
FL_OBJECT	*anova_two_button;
FL_OBJECT	*anova_from_counter;
FL_OBJECT	*anova_to_counter;
FL_OBJECT	*anova_block_counter;

FL_FORM		*nnet_window;
FL_OBJECT	*nnet_output_browser;
FL_OBJECT	*nnet_input_browser;
FL_OBJECT	*nnet_variable_input;
FL_OBJECT	*nnet_overwrite_button;
FL_OBJECT	*nnet_annealing_button;
FL_OBJECT	*nnet_from_counter;
FL_OBJECT	*nnet_to_counter;
FL_OBJECT	*nnet_cycles_counter;
FL_OBJECT	*nnet_learn_counter;
FL_OBJECT	*nnet_squasher_buttons;
FL_OBJECT	*nnet_go_button;
FL_OBJECT	*nnet_done_button;
FL_OBJECT	*nnet_step_button;
FL_OBJECT	*nnet_straight_button;
FL_OBJECT	*nnet_sigmoid_button;

FL_FORM		*do_nnet_window;
FL_OBJECT	*do_nnet_chart;
FL_OBJECT	*do_nnet_browser;
FL_OBJECT	*nnet_hidden_counter;
FL_OBJECT	*nnet_pictex_button;

FL_FORM		*sign_window;
FL_OBJECT	*sign_one_browser;
FL_OBJECT	*sign_two_browser;
FL_OBJECT	*sign_null_counter;
FL_OBJECT	*sign_from_counter;
FL_OBJECT	*sign_to_counter;

FL_FORM		*eqmean_window;
FL_OBJECT	*eqmean_one_browser;
FL_OBJECT	*eqmean_two_browser;
FL_OBJECT	*eqmean_null_counter;
FL_OBJECT	*eqmean_from_counter;
FL_OBJECT	*eqmean_to_counter;

FL_FORM		*watson_window;
FL_OBJECT	*watson_browser;
FL_OBJECT	*watson_from_counter;
FL_OBJECT	*watson_to_counter;

FL_FORM		*filter_window;
FL_OBJECT	*filter_browser;
FL_OBJECT	*filter_outliers_button;
FL_OBJECT	*filter_detrend_button;
FL_OBJECT	*filter_from_counter;
FL_OBJECT	*filter_to_counter;
