.\" $Id: ddd.man.in,v 1.104 1997/05/07 12:17:33 zeller Exp $ -*-nroff-*-
.\" DDD manual page
.\" Generated automatically from ddd.man.in by configure.
.\"
.\" Copyright (C) 1995-1997 Technische Universitaet Braunschweig, Germany.
.\" Written by Andreas Zeller <zeller@ips.cs.tu-bs.de>.
.\" 
.\" This file is part of DDD.
.\" 
.\" DDD is free software; you can redistribute it and/or modify it under
.\" the terms of the GNU General Public License as published by the Free
.\" Software Foundation; either version 2 of the License, or (at your
.\" option) any later version.
.\" 
.\" DDD is distributed in the hope that it will be useful, but WITHOUT ANY
.\" WARRANTY; without even the implied warranty of MERCHANTABILITY or
.\" FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
.\" for more details. 
.\" 
.\" You should have received a copy of the GNU General Public License
.\" along with DDD -- see the file COPYING.  If not, write to the Free
.\" Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
.\" MA 02111-1307, USA.
.\" 
.\" DDD is the data display debugger.
.\" For details, see the DDD World-Wide-Web page, 
.\" `http://www.cs.tu-bs.de/softech/ddd/',
.\" or send a mail to the DDD developers at `ddd@ips.cs.tu-bs.de'.
.\"
.TH ddd 1 "7 May 1997" "DDD 2.1"
.SH NAME
ddd, xddd - the data display debugger
.PSPIC PICS/dddlogo21.ps 10cm
.SH SYNOPSIS
.na
.TP
.B ddd
.RB "[\|" \-\-help "\|]"
.RB "[\|" \-\-gdb "\|]"
.RB "[\|" \-\-dbx "\|]"
.RB "[\|" \-\-xdb "\|]"
.RB "[\|" \-\-debugger
.I name\c
\&\|]
.RB "[\|" \-\-host
.I hostname
.RB "[\|" \-\-login
.I username\c
\&\|]\|]
.RB "[\|" \-\-rhost
.I hostname
.RB "[\|" \-\-login
.I username\c
\&\|]\|]
.RB "[\|" \-\-vsl\-library
.I library\c
\&\|]
.RB "[\|" \-\-vsl\-path
.I path\c
\&\|]
.RB "[\|" \-\-exec\-window "\|]"
.RB "[\|" \-\-no\-exec\-window "\|]"
.RB "[\|" \-\-attach\-windows "\|]"
.RB "[\|" \-\-separate\-windows "\|]"
.RB "[\|" \-\-scrolled\-graph\-editor "\|]"
.RB "[\|" \-\-panned\-graph\-editor "\|]"
.RB "[\|" \-\-trace "\|]"
.RB "[\|" \-\-nw "\|]"
.RB "[\|" \-\-tty "\|]"
.RB "[\|" \-\-fullname "\|]"
.RB "[\|" \-\-version "\|]"
.RB "[\|" \-\-configuration "\|]"
.RB "[\|" \-\-check\-configuration "\|]"
.RB "[\|" \-\-manual "\|]"
.RB "[\|" \-\-license "\|]"
.RB "[\|"\c
.I gdb-options\c
\&\|]
.RB "[\|"\c
.I x-options\c
\&\|]
.RB "[\|"\c
.I vsl-options\c
\&\|]
.RB "[\|" \c
.I program
.RB "[\|" \c
.I core \c
\&\||\|
.I process-id\c
\&\|]\|]
.ad b
.TP
but usually just
.TP
.B ddd
.I program
.ad b
.\"
.\" ---------------
.SH DESCRIPTION
.\" ---------------
The purpose of a debugger such as \s-2DDD\s+2 is to allow you to see
what is going on \*(lqinside\*(rq another program while it
executes\(em\&or what another program was doing at the moment it
crashed.
.PP
\s-2DDD\s+2 can do four main kinds of things (plus other things in support of
these) to help you catch bugs in the act:
.IP \(bu 2
Start your program, specifying anything that might affect its
behavior.
.br
.IP \(bu 2
Make your program stop on specified conditions.
.br
.IP \(bu 2
Examine what has happened, when your program has stopped.
.br
.IP \(bu 2
Change things in your program, so you can experiment with correcting the
effects of one bug and go on to learn about another.
.PP
.\"
\*(lqClassical\*(rq \s-2UNIX\s+2 debuggers such as the \s-2GNU\s+2
debugger (\s-2GDB\s+2) provide a command-line interface and a
multitude of commands for these and other debugging purposes.
\s-2DDD\s+2 is a \fIwrapper\fR around an inferior \s-2GDB\s+2,
\s-2DBX\s+2, or \s-2XDB\s+2 debugger.  In addition to the command-line
interface of the inferior debugger, \s-2DDD\s+2 provides a common
\fIgraphical user interface\fR to support debugging tasks.  The
\s-2DDD\s+2 \fIgraphical data display\fR allows for interactive
exploration of data structures.
.\"
.\" ---------------
.SH "INVOKING DDD"
.\" ---------------
.\"
You can run \s-2DDD\s+2 with no arguments or options.  However, the
most usual way to start \s-2DDD\s+2 is with one argument or two,
specifying an executable program as the argument:
.sp
.br
  \fBddd\ program\fR
.br
.sp
.\"
You can also start with both an executable program and a core file specified:
.sp
.br
  \fBddd\ program\ core\fR
.br
.sp
.\"
You can, instead, specify a process ID as a second argument, if you want
to debug a running process:
.sp
.br
  \fBddd\ program\ 1234\fR
.br
.sp
.\"
would attach \s-2DDD\s+2 to process \c
.B 1234\c
\& (unless you also have a file
named `\|\c
.B 1234\c
\&\|'; \s-2DDD\s+2 does check for a core file first).
.\"
.PP
By default, \s-2DDD\s+2 uses \s-2GDB\s+2 as inferior debugger.  Use
.sp
.br
  \fBddd\ \-\-dbx program\fR
.br
.sp
or
.sp
.br
  \fBddd\ \-\-xdb program\fR
.br
.sp
.\"
to run \s-2DBX\s+2 or \s-2XDB\s+2 as inferior debugger.
.PP
To learn more about \s-2DDD\s+2 options, run
.sp
.br
  \fBddd\ \-\-help\fR
.br
.sp
to get a list of frequently used options, or see the `\fBOPTIONS\fR'
section, below.
.\"
.\" ---------------
.SH "THE DDD WINDOWS"
.\" ---------------
.\"
.PSPIC PICS/ddd-all.ps 15.3cm
\s-2DDD\s+2 is composed of three main windows:
.br
.IP \(bu 2
The \fIData Window\fR shows the current data of the debugged program.
.br
.IP \(bu 2
The \fISource Window\fR shows the current source code of the debugged
program.
.br
.IP \(bu 2
The \fIDebugger Console\fR accepts debugger commands and shows
debugger messages.
.PP
By default, \s-2DDD\s+2 groups these main windows into one single
window, but \s-2DDD\s+2 can also be configured to treat each one
separately.
.PP
Besides these main windows, there are some other optional windows
.br
.IP \(bu 2
The \fICommand Tool\fR offers buttons for frequently used commands.
It is usually placed on the source window.
.br
.IP \(bu 2
The \fIMachine Code Window\fR shows the current machine code.  It is
usually placed beneath the current source.
.br
.IP \(bu 2
The \fIExecution Window\fR shows the input and output of the debugged
program.
.PP
\s-2DDD\s+2 also has several temporary \fIdialogs\fR for showing and
entering additional information.
.PP
In this manual page, we discuss all the functionality associated with
these windows.  We start with the debugger console and its commands,
continue with the source window, and continue with the data window.
But before that, we tell you how to get help while working with
\s-2DDD\s+2.
.\"
.\"
.\" ---------------
.SH "GETTING HELP"
.\" ---------------
.\"
.SS "Button Tips"
.\"
You can get a short help text on most \s-2DDD\s+2 buttons by simply
moving the mouse pointer on it and leave it there.  After a second, a
small window (called \fIbutton tip\fR) pops up, giving a hint on the
button's meaning.  The button tip disappears as soon as you move the
mouse pointer to another item.
.\"
.SS "The Status Line"
.\"
The status line also displays information about the currently selected
item.  By clicking on the status line, you can redisplay the most
recent messages.
.\"
.SS "Context-Sensitive Help"
.\"
You can get detailed help on any visible \s-2DDD\s+2 item by pressing the
`\fBF1\fR' key and moving the question mark arrow on the item you
want help for.  Clicking on the item pops up a detailed help text.
.PP
The \s-2DDD\s+2 dialogs all contain `\fBHelp\fR' buttons that give
detailed information about the dialog.
.\"
.SS "Help on Debugger Commands"
.\"
You can get help on \s-2GDB\s+2 and \s-2DBX\s+2 commands by entering
`\fBhelp\fR' at the `\fB(gdb)\fR' or `\fB(dbx)\fR' prompt.  You can
get help on \s-2XDB\s+2 commands by entering `\fBhelp\fR' at the
`\fB>\fR' prompt.
.PP
See the following section for details on entering commands.
.\"
.\" ---------------
.SH "ENTERING COMMANDS"
.\" ---------------
.\"
In the \fIdebugger console\fR, you can interact with the command
interface of the inferior debugger.  Enter commands at the \fIdebugger
prompt\fR\(em\&that is, `\fB(gdb)\fR' for \s-2GDB\s+2, `\fB(dbx)\fR'
for \s-2DBX\s+2, and `\fB>\fR' for \s-2XDB\s+2.  You can use arbitrary
debugger commands; use the \s-2\fBRETURN\fR\s+2 key to enter them.
.PP
.PSPIC PICS/ddd-console.ps 15.3cm
.PP
You can \fIrepeat\fR previous and next commands by pressing the
`\fBUp\fR' and `\fBDown\fR' arrow keys, respectively.  If you enter
an empty line, the last command is repeated as well.  The `\fBCommand
History...\fR' item in the `\fBCommands...\fR' menu shows the command
history.
.PP
You can \fIsearch\fR for previous commands by pressing `\fBCtrl+R\fR'.
This invokes \fIincremental search mode,\fR where you can enter a
string to be searched in previous commands.  Press `\fBCtrl+R\fR'
again to repeat the search, or `\fBCtrl+S\fR' to search in the reverse
direction.  To return to normal mode, press \s-2\fBESC\fR\s+2, or use
any cursor command.
.PP
.PSPIC PICS/ddd-history.ps 15.3cm
.PP
Using \s-2GDB\s+2, you can also \fIcomplete\fR commands and arguments
by pressing the `\s-2\fBTAB\fR\s+2' key; pressing the `\s-2\fBTAB\fR\s+2'
key multiple times shows one possible expansion after the other.
.PP
Here are some of the most frequently needed debugger commands.
.\"
.SS "Common GDB commands"
.TP
.B break \fR[\|\fIfile\fB:\fR\|]\fIfunction
\&
Set a breakpoint at \c
.I function\c
\& (in \c
.I file\c
\&).
.TP
.B run \fR[\|\fIarglist\fR\|]
Start your program (with \c
.I arglist\c
\&, if specified).
.TP
.B where
Display the program stack.
.TP
.BI print " expr"\c
\&
Display the value of an expression.
.TP
.B cont
Continue running your program (after stopping, e.g. at a breakpoint).
.TP
.B next
Execute next program line (after stopping); step \c
.I over\c
\& any
function calls in the line.
.TP
.B step
Execute next program line (after stopping); step \c
.I into\c
\& any
function calls in the line.
.TP
.B help \fR[\|\fIname\fR\|]
Show information about the command \c
.I name\c
\&, or general usage information.
.TP
.B quit
Exit \s-2DDD\s+2.
.PP
For full details on \s-2GDB\s+2 commands, see \c
.I 
Using \s-2GDB\s+2: A Guide to the \s-2GNU\s+2 Source-Level Debugger\c
\&, by Richard M. Stallman and Roland H. Pesch.  
The same text is available online as the \c
.B gdb\c
\& entry in the \c
.B info\c
\& program.
.PP
.\"
.SS "Common DBX commands"
.TP
.B stop in \fIfunction
\&
Set a breakpoint at \c
.I function.
.TP
.B stop at \fIline
\&
Set a breakpoint at \c
.I line.
.TP
.B file \fIfile
\&
Change the current file to \c
.I file.
.TP
.B run \fR[\|\fIarglist\fR\|]
Start your program (with \c
.I arglist\c
\&, if specified).
.TP
.B where
Display the program stack.
.TP
.BI print " expr"\c
\&
Display the value of an expression.
.TP
.B cont
Continue running your program (after stopping, e.g. at a breakpoint).
.TP
.B next
Execute next program line (after stopping); step \c
.I over\c
\& any
function calls in the line.
.TP
.B step
Execute next program line (after stopping); step \c
.I into\c
\& any
function calls in the line.
.TP
.B help \fR[\|\fIname\fR\|]
Show information about the command \c
.I name\c
\&, or general usage information.
.TP
.B quit
Exit \s-2DDD\s+2.
.PP
For full details on \s-2DBX\s+2 commands, see the \s-2DBX\s+2
documentation.
.\"
.SS "Common XDB commands"
.TP
.B b \fR[\|\fIfile\fB:\fR\|]\fIline
\&
Set a breakpoint at line \c
.I line\c
\& (in \c
.I file\c
\&).
.TP
.B b \fIfunction
\&
Set a breakpoint at \c
.I function.
.TP
.B r \fR[\|\fIarglist\fR\|]
Start your program (with \c
.I arglist\c
\&, if specified).
.TP
.B t
Display the program stack.
.TP
.BI p " expr"\c
\&
Display the value of an expression.
.TP
.B c
Continue running your program (after stopping, e.g. at a breakpoint).
.TP
.B S
Execute next program line (after stopping); step \c
.I over\c
\& any
function calls in the line.
.TP
.B s
Execute next program line (after stopping); step \c
.I into\c
\& any
function calls in the line.
.TP
.B h \fR[\|\fIname\fR\|]
Show information about the command \c
.I name\c
\&, or general usage information.
.TP
.B q
Exit \s-2DDD\s+2.
.PP
For full details on \s-2XDB\s+2 commands, see the \s-2XDB\s+2
documentation.
.\"
.\" ---------------
.SH "OPENING FILES"
.\" ---------------
.\"
If you did not invoke \s-2DDD\s+2 specifying a program to be debugged,
you can use the `\fBFile\fR' menu to open programs, core dumps and
sources.
.PP
.PSPIC PICS/ddd-open.ps 15.3cm
.PP
To open a program to be debugged, select `\fBOpen Program\fR' from the
`\fBFile\fR' menu.
.PP
To open a core dump for the program, select `\fBOpen Core Dump\fR'
from the `\fBFile\fR' menu.
.PP
To open an arbitrary source file, select `\fBOpen Source\fR' from the
`\fBFile\fR' menu.
.PP
Note: With \s-2XDB\s+2 and some \s-2DBX\s+2 versions, the debugged
program must be specified upon invocation and cannot be changed at run
time.
.\"
.\" ---------------
.SH "LOOKING UP ITEMS"
.\" ---------------
.\"
If the source of the debugged program is available, the \fIsource
window\fR displays its current source text.  (If a source text cannot
be found, use the \s-2GDB\s+2 `\fBdirectory\fR' command to specify
source text directories).
.PP
In the source window, you can lookup and examine function and variable
definitions as well as search for arbitrary occurrences in the source
text.
.\"
.SS "Looking up Definitions"
.\"
If you wish to lookup a specific function or variable definition whose
name is visible in the source text, click with the \fIleft mouse
button\fR on the function or variable name.  The name is copied to the
argument field.  Click on the `\fBLookup()\fR' button to find its
definition.
.PP
.PSPIC PICS/ddd-source-popup.ps 15.3cm
.PP
As a shorter alternative, you can simply press the \fIright mouse
button\fR on the function name and select the `\fBlookup\fR' item from
the source popup menu.
.PP
As another alternative, you can enter the function name in the
argument field and click on the `\fBLookup()\fR' button to find its
definition.
.PP
Finally, you can use the \s-2GDB\s+2 `\fBinfo line\fR' command.
Type `\fBhelp info line\fR' at the `\fB(gdb)\fR' prompt for
details.
.\"
.SS "Textual Search"
.\"
If the item you wish to search is visible in the source text, click
with the \fIleft mouse button\fR on it.  The identifier is copied to
the argument field.  Click on the `\fBFind\s-2>>\s+2()\fR' button to find
following occurrences and on the  `\fBFind\s-2<<\s+2()\fR' button to find
previous occurrences.
.PP
As an alternative, you can enter the item in the argument field and
click on one of the `\fBFind\fR' buttons.
.PP
By default, \s-2DDD\s+2 finds only complete words.  To search for
arbitrary substrings, change the value of the `\fBFind Words Only\fR'
option in the `\fBSource Options\fR' menu.
.PP
.PSPIC PICS/ddd-source.ps 15.3cm
.\"
.SS "Looking up Previous Locations"
.\"
Use the `\fBBack\fR' and `\fBForward\fR' buttons to lookup previous or
next looked-up locations.  The location found is underlined.
.\"
.\"
.\"
.\"
.\" ---------------
.SH "BREAKPOINTS"
.\" ---------------
.\"
Using the source window, you can make the program stop at certain
\fIbreakpoints\fR and trace its execution.
.\"
.SS "Setting Breakpoints by Location"
.\"
If the source line is visible, click with the \fIleft mouse button\fR
on the source line number and then on the `\fBBreak at ()\fR' button.
.PP
As an alternative, you can simply press the \fIright mouse button\fR
on the source line number and select the `\fBSet Breakpoint\fR' item
from the line popup menu.
.PP
.PSPIC PICS/ddd-line-popup.ps 15.3cm
.PP
As another alternative, you can enter the line number in the argument
field (indicated by `\fB():\fR') and click on the `\fBBreak at ()\fR'
button.
.PP
As yet another alternative, you can select `\fBEdit Breakpoints...\fR'
in the `\fBSource\fR' menu, click on the `\fBNew\fR' button and enter
the line number.
.PP
And finally, you can also use the \s-2GDB\s+2 `\fBbreak\fR' command or
the \s-2DBX\s+2 `\fBstop\fR' command.  Type `\fBhelp break\fR' at the
`\fB(gdb)\fR' prompt (or `\fBhelp stop\fR' at the `\fB(dbx)\fR'
prompt) for details.  The \s-2XDB\s+2 `\fBb\fR' command works as well.
.PP
(If you find this number of alternatives confusing, be aware that
\s-2DDD\s+2 users fall into three categories, which must all be
supported.  \fINovice users\fR explore \s-2DDD\s+2 and may prefer to
use one single mouse button.  \fIAdvanced users\fR know how to use
shortcuts and prefer popup menus.  \fIExperienced users\fR prefer the
command line interface.)
.PP
Breakpoints are indicated by a plain stop sign, 
or as `\fB#\fIn\fB#\fR', where \fIn\fR is the breakpoint number.
.\"
.\"
.SS "Setting Breakpoints by Name"
.\"
If the function name is visible, click with the \fIleft
mouse button\fR on the function name.  The function name is copied to
the argument field.  Click on the `\fBBreak at ()\fR' button to set a
breakpoint there.
.PP
As a shorter alternative, you can simply press the \fIright
mouse button\fR on the function name and select the `\fBbreak\fR' item
from the popup menu.
.PP
As another alternative, you can enter the function name in the
argument field (possibly using name completion by pressing the
`\fB\s-2TAB\s+2\fR' key) and click on the `\fBBreak at ()\fR' button.
.PP
As yet another alternative, you can click on `\fBNew\fR' from the
Breakpoint editor (invoked through `\fBEdit Breakpoints...\fR'
in the `\fBSource\fR' menu) and enter the function name.
.PP
Finally, you can use the \s-2GDB\s+2 `\fBbreak\fR' command or the
\s-2DBX\s+2 `\fBstop\fR' command.  Type `\fBhelp break\fR' at the
`\fB(gdb)\fR' prompt (or `\fBhelp stop\fR' at the `\fB(dbx)\fR'
prompt) for details.  The \s-2XDB\s+2 `\fBb\fR' command works as well.
.\"
.\"
.SS "Disabling Breakpoints"
.\"
Note: \s-2DBX\s+2 does not support breakpoint disabling.
.PP
To temporarily disable a breakpoint, press the \fIright mouse
button\fR on the breakpoint name and select the `\fBDisable
Breakpoint\fR' item from the breakpoint popup menu.  To enable it
again, select `\fBEnable Breakpoint\fR'.
.PP
.PSPIC PICS/ddd-bp-popup.ps 15.3cm
.PP
As an alternative, you can select the breakpoint and click on
`\fBDisable\fR' or `\fBEnable\fR' in the Breakpoint editor (invoked
through `\fBEdit Breakpoints...\fR' in the `\fBSource\fR' menu).
.PP
Disabled breakpoints are indicated by a grey stop sign, or 
`\fB_\fIn\fB_\fR', where \fIn\fR is the breakpoint number.
.PP
Finally, you can use the \s-2GDB\s+2 `\fBdisable\fR' command.  Type
`\fBhelp disable\fR' at the `\fB(gdb)\fR' prompt for details.
.\"
.\"
.SS "Temporary Breakpoints"
.\"
A \fItemporary breakpoint\fR is immediately deleted as soon as it is
reached.  To set a temporary breakpoint,  press the \fIright mouse
button\fR on the source line number and select the `\fBSet Temporary
Breakpoint\fR' item from the popup menu.
.PP
Temporary breakpoints are convenient to make the program continue up
to a specific location: just set the temporary breakpoint at this
location and continue execution.
.PP
The `\fBContinue Until Here\fR' item from the popup menu sets a
temporary breakpoint on the source line number and immediately
continues execution.  In \s-2GDB\s+2, execution stops when a source
line greater than the source line is reached, or when the current
stack frame is exited.  In \s-2DBX\s+2 and \s-2XDB\s+2, execution
stops when the temporary breakpoint is reached.
.\"
.\"
.SS "Deleting Breakpoints"
.\"
If the breakpoint is visible, click with the \fIleft mouse button\fR
on the breakpoint.  The breakpoint location is copied to the argument
field.  Click on the `\fBClear at ()\fR' button to delete all
breakpoints there.
.PP
If the function name is visible, click with the \fIleft mouse
button\fR on the function name.  The function name is copied to the
argument field.  Click on the `\fBClear at ()\fR' button to set a
breakpoint there.
.PP
As a shorter alternative, you can simply press the \fIright mouse
button\fR on the breakpoint and select the `\fBDelete Breakpoint\fR'
item from the popup menu.
.PP
As yet another alternative, you can select the breakpoint and click on
`\fBDelete\fR' in the Breakpoint editor (invoked through `\fBEdit
Breakpoints...\fR' in the `\fBSource\fR' menu).
.PP
Finally, you can use the \s-2GDB\s+2 `\fBclear\fR' and `\fBdelete\fR'
commands.  Type `\fBhelp clear\fR' or `\fBhelp delete\fR' at
the `\fB(gdb)\fR' prompt for details.
.\"
.\"
.SS "Finding Breakpoints"
.\"
If you wish to lookup a specific breakpoint, select the
`\fBLookup\fR' item from the `\fBBreakpoints\fR' menu.  After
selecting a breakpoint from the list and clicking the
`\fBLookup\fR' button, the breakpoint location is displayed.
.PP
As an alternative, you can enter `\fB#\fIn\fR' in the argument field,
where \fIn\fR is the breakpoint number and click on the `\fBLookup()\fR'
button to find its definition.
.\"
.\"
.SS "Breakpoint Conditions"
.\"
Using the Breakpoint Editor (invoked through `\fBEdit
Breakpoints...\fR' in the `\fBSource\fR' menu), you can specify
\fIbreakpoint conditions\fR.  Reaching the breakpoint stops 
the program only if the associated condition is met\(em\&that is, if
the condition expression evaluates to a non-zero value.
.PP
To set a breakpoint condition, select the appropriate breakpoint in
the Breakpoint Editor and click on the `\fBCondition...\fR' button.
You can then enter (or change) the condition in a special dialog.
.PP
.PSPIC PICS/ddd-cond.ps 15.3cm
.PP
As a faster alternative, you can also press the \fIright mouse
button\fR on the breakpoint in the source code and select the `\fBSet
Condition...\fR' item from the popup menu.
.\"
.\"
.SS "Breakpoint Ignore Counts"
.\"
Using the Breakpoint Editor (invoked through `\fBEdit
Breakpoints...\fR' in the `\fBSource\fR' menu), you can specify
\fIignore counts\fR.  If an ignore count is set, each crossing of the
breakpoint decrements the ignore count.  The program stops only if the
ignore count is zero.
.PP
To set a breakpoint ignore count, select the appropriate breakpoint in
the Breakpoint Editor and click on the `\fBIgnore Count...\fR' button.
You can then enter (or change) the ignore count in a special dialog.
.PP
As a faster alternative, you can also press the \fIright mouse
button\fR on the breakpoint in the source code and select the `\fBSet
Ignore Count...\fR' item from the popup menu.
.\"
.SS "More Breakpoint Features"
.\"
More breakpoint features can be invoked through the debugger console.
Enter `\fBhelp breakpoints\fR' at the `\fB(gdb)\fR' prompt.
.\"
.\" ---------------
.SH "RUNNING THE PROGRAM"
.\" ---------------
.\"
.SS "Starting Program Execution"
.\"
Select `\fBRun\fR' from the `\fBProgram\fR' menu to start execution of
the debugged program.  You will then be prompted for the arguments to
give to your program.  You can either select from a list of previously
used arguments or enter own arguments in the text field.  Afterwards,
press the `\fBOK\fR' button to start execution with the selected
arguments.
.PP
.PSPIC PICS/ddd-arguments.ps 15.3cm
.PP
To run your program again, with the same arguments, select `\fBRun
Again\fR' from the `\fBProgram\fR' menu or press the `\fBRun\fR'
button below.  You may also enter `\fBrun\fR', followed by arguments
at the debugger prompt instead.
.PP
By default, input and output of the debugged program go to the debugger
console.  As an alternative, \s-2DDD\s+2 can also invoke an \fIexecution
window\fR, where the program terminal input and output is shown.  See
the `\fBRun in Execution Window\fR' item in the `\fBOptions...\fR'
menu for details.
.\"
.\"
.SS "Stopping the Program"
.\"
The program stops as soon as a breakpoint is reached.  The current
execution position is highlighted by an arrow.
.PP
You can interrupt a running program any time by clicking the
`\fBInterrupt\fR' button or typing \fBCtrl+C\fR in a \s-2DDD\s+2 window.
.\"
.\"
.SS "Resuming Execution"
.\"
To resume execution, at the address where your program last stopped,
click on the `\fBContinue\fR` button.  Any breakpoints set at that
address are bypassed.
.PP
To execute just one source line, click on the `\fBStep\fR' button.
The program is executed until control reaches a different source line,
which may be in a different function.
.PP
To continue to the next line in the current function, click on the
`\fBNext\fR' button.  This is similar to `\fBStep\fR', but any
function calls appearing within the line of code are executed without
stopping.
.PP
To continue running until the current function returns, use the
`\fBFinish\fR' button.  The returned value (if any) is printed.
.PP
.PSPIC PICS/ddd-tool.ps 15.3cm
.PP
To continue running until a line after the current source line is
reached, use the `\fBContinue Until Here\fR' facility from the line
popup menu.  See `\fBTemporary Breakpoints\fR', above, for a
discussion.
.\"
.\"
.SS "Examining the Stack"
.\"
When your program has stopped, the first thing you need to know is
where it stopped and how it got there.
.PP
\s-2DDD\s+2 provides a \fIbacktrace window\fR showing a summary of 
how your program got where it is.  To enable the backtrace window,
select `\fBBacktrace...\fR' from the `\fBStatus\fR' menu.
.PP
The `\fBUp\fR' button selects the function that called the current
one.
.PP
The `\fBDown\fR' button selects the function that was called by
the current one.
.PP
You can also directly type the `\fBup\fR' and `\fBdown\fR' commands at
the debugger prompt.  Typing \fBCtrl+Up\fR and \fBCtrl+Down\fR,
respectively, will also move you through the stack.
.PP
.PSPIC PICS/ddd-backtrace.ps 15.3cm
.\"
.\"
.SS "Examining Threads"
.\"
Note: Thread support is available with \s-2GDB\s+2 only.
.\"
In some operating systems, a single program may have more than one
\fIthread\fR of execution.  The precise semantics of threads differ
from one operating system to another, but in general the threads of a
single program are akin to multiple processes\(em\&except that they
share one address space (that is, they can all examine and modify the
same variables).  On the other hand, each thread has its own registers
and execution stack, and perhaps private memory.
.PP
For debugging purposes, \s-2DDD\s+2 lets you display the list of
threads currently active in your program and lets you select the
\fIcurrent thread\fR\(em\&the thread which is the focus of debugging.
\s-2DDD\s+2 shows all program information from the perspective of
the current thread.
.PP
To view all currently active threads in your program, select
`\fBThreads\fR' from the `\fBstatus\fR' menu.  The current thread is
highlighted.  Select any thread to make it the current thread.
.PP
.PSPIC PICS/ddd-threads.ps 15.3cm
.PP
For more information on threads, see the section `\fBDebugging
programs with multiple threads\fR' in the \s-2GDB\s+2 documentation.
.\"
.\"
.\" ---------------
.SH "EXAMINING DATA"
.\" ---------------
.\"
.TP
\s-2DDD\s+2 provides three means to examine data.
.TP 10
.B "Value Hints"
The quickest way to examine variables is to move the pointer on an
occurrence in the source text.  The value is displayed in the source
line; after a second, a popup window shows the variable value.  This
is useful for quick examination of several simple variables.
.TP 10
.B "Printing Values"
If you want to reuse variable values at a later time, you can print
the value in the debugger console.  This allows for displaying and
examining larger data structures.
.TP 10
.B "Displaying Values"
If you want to examine complex data structures, you can display them
graphically in the data display.  Displays remain effective until you
delete them; they are updated each time the program stops.  This is
useful for large dynamic structures.
.PP
.\"
.\"
.SS "Displaying Simple Values"
.\"
To display the value of a simple variable, move the mouse pointer on
its name.  After a second, a small window (called \fIvalue tip\fR)
pops up showing the value of the variable pointed at.  The window
disappears as soon as you move the mouse pointer away from the
variable.  The value is also shown in the status line.
.PP
.PSPIC PICS/ddd-value-tip.ps 15.3cm
.PP
The variable value can also be printed in the debugger console, making
it available for further operations.  To print a variable value,
select the desired variable by clicking the \fIleft mouse button\fR on
its name.  The variable name is copied to the argument field.  By
clicking the `\fBPrint()\fR' button, a new display is created in the
data window.
.PP
As a shorter alternative, you can simply press the \fIright mouse
button\fR on the variable name and select the `\fBPrint\fR' item from
the popup menu.
.PP
.PSPIC PICS/ddd-print-popup.ps 15.3cm
.\"
.SS "Displaying Complex Values"
.\"
To explore complex data structures, you can use the \fIgraphical data
display\fR in the \fIdata window\fR.  The data window holds
\fIdisplays\fR showing names and the values of variables.  The display
is updated each time the program stops.
.PP
To create a new display, select the desired variable by clicking the
\fIleft mouse button\fR on its name.  The variable name is copied to
the argument field.  By clicking the `\fBDisplay()\fR' button, a new
display is created in the data window.
.PP
As a shorter alternative, you can simply press the \fIright mouse
button\fR on the variable name and select the `\fBDisplay\fR' item from
the popup menu.
.PP
As another alternative, you may also enter the expression to be
displayed in the argument field and press the `\fBDisplay()\fR'
button.
.PP
If the data window is visible, you may click on the `\fBNew
Display\fR' button.  Enter the expression to be displayed in the
resulting prompt dialog.
.PP
.PSPIC PICS/ddd-new-display.ps 15.3cm
.PP
Finally, you may also enter
.sp
.br
  \fBgraph display \fIexpr\fR [\|\fBat (\fIx, y\fB)\fR\|] [\|\fBdependent
on \fIdisplay\fR\|]
.sp
.br
\&at the debugger prompt.  If the suffix `\fBat \fB(\fIx, y\fB)\fR' is
specified, the new data display is created at the position (\fIx\fR,
\fIy\fR); otherwise, a default position is assigned.  If the suffix
`\fBdependent on \fIdisplay\fR' is given, an edge from display
numbered \fIdisplay\fR to the new display is created; otherwise, no
edge is created.
.\"
.\"
.SS "Selecting Displays"
.\"
Each display in the data window has a \fItitle bar\fR containing the
\fIdisplay number\fR and the displayed expression (the \fIdisplay
name\fR).  Below the title, the \fIdisplay value\fR is shown.
.PP
You can select individual displays by clicking on them with the
\fIleft mouse button\fR.  The resulting expression is shown in the
\fIargument field\fR, below.
.PP
You can \fIextend\fR an existing selection by pressing the \fBShift\fR
key while selecting.  You can also \fItoggle\fR an existing selection
by pressing the \fBShift\fR key while selecting already selected
displays.
.PP
Single displays may also be selected by using the arrow keys.
.\"
.\"
.SS "Selecting Multiple Displays"
.\"
Multiple displays are selected by pressing and holding the \fIleft
mouse button\fR somewhere on the window background.  By moving the
pointer while holding the button, a selection rectangle is shown; all
displays fitting in the rectangle are selected when the mouse button
is released.
.PP
If the \fBShift\fR key is pressed while selecting, the existing
selection is \fIextended\fR.
.PP
By double-clicking on a display, the display itself and all connected
displays are automatically selected.
.PP
.PSPIC PICS/ddd-select-display.ps 15.3cm
.PP
.\"
.\"
.SS "Selecting Display Parts"
.\"
If a display is composed from several values (that is, a C/C++
\fIclass\fR, \fIstruct\fR, \fIunion\fR, or \fIarray\fR; or a
Pascal/Modula \fIRECORD\fR or \fIARRAY\fR), you can
select individual parts by clicking on their names or values.  The
resulting expression is shown in the \fIargument field\fR, below.
.PP
Selection of multiple display parts is not supported.
.\"
.\"
.SS "Showing and Hiding Values"
.\"
\fIAggregate Values\fR can be shown \fIexpanded\fR, that is,
displaying all details, or \fIhidden\fR, that is, displayed as
`\fB{...}\fR'.
.PP
To show details about an aggregate, select the aggregate by clicking
the \fIleft mouse button\fR on its name or value and click on the
`\fBShow()\fR' button.  Details are shown for the aggregate itself as
well as for all contained sub-aggregates.
.PP
To hide details about an aggregate, select the aggregate by clicking
the \fIleft mouse button\fR on its name or value and click on the
`\fBHide()\fR' button.
.PP
As a faster alternative, you can also press the \fIright mouse
button\fR on the aggregate and select the appropriate menu item.
.PP
.PSPIC PICS/ddd-hide-display.ps 15.3cm
.PP
.\"
.SS "Rotating Arrays"
.\"
Arrays can be aligned horizontally or vertically.  To change the
alignment of an array, select it and then click on the `\fBRotate()\fR'
button.
.PP
As a faster alternative, you can also press the \fIright mouse
button\fR on the array and select the `\fBRotate\fR' menu item.
.PP
.PSPIC PICS/ddd-rotate-display.ps 15.3cm
.PP
.\"
.\"
.SS "Displaying Dependent Values"
.\"
Dependent displays are created from an existing display.  The
dependency is indicated by arrows leading from the originating display
to the dependent display.
.PP
To create a dependent display, select the originating display or
display part and click on the `\fBNew Display\fR' button.  A prompt
dialog appears where you can enter a new expression \fIEXPR\fR in the
argument field.  By clicking on `\fBOK\fR', the new display showing
\fIEXPR\fR is created.
.PP
As a faster alternative, you can also press the \fIright mouse
button\fR on the originating display part and select the `\fBNew
Display...\fR' menu item.
.PP
Using dependent displays, you can investigate the data structure of a
\*(lqtree\*(rq for example and lay it out according to your intuitive
image of the \*(lqtree\*(rq data structure.
.PP
By default, \s-2DDD\s+2 does not recognize shared data structures
(i.e. a data object referenced by multiple other data objects).  See
the section on \fIExamining Shared Data Structures\fR, below, for
details on how to examine such structures.
.\"
.\"
.SS "Dereferencing Pointers"
.\"
Since so many data structures are realized using pointers, there is a
shortcut for creating dependent displays showing the value of a
dereferenced pointer.
.PP
To dereference a pointer, select the originating pointer value or name
and click on the `\fBDisplay * ()\fR' button.  A new display showing
the dereferenced pointer value is created.
.PP
As a faster alternative, you can also press the \fIright mouse
button\fR on the originating pointer value or name and select the
`\fBDisplay *\fR' menu item.
.\"
.\"
.SS "Displaying Local Variables"
.\"
You can display all local variables at once by choosing `\fBDisplay
Local Variables\fR' from the `\fBData\fR' menu.  When you using
\s-2DBX\s+2 or \s-2XDB\s+2, this displays all local variables,
including the arguments of the current function.  When you are using
\s-2GDB\s+2, function arguments are contained in a separate display,
activated by `\fBDisplay Arguments\fR'.
.PP
The display showing the local variables can be manipulated just like
any other data display.  Individual variables can be selected and
dereferenced.
.PP
.PSPIC PICS/ddd-locals.ps 15.3cm
.PP
.\"
.\"
.SS "Displaying Program Status"
.\"
Besides local variables, you can create a display from the output of
an arbitrary debugger command.  By entering
.sp
.br
  \fBgraph display `\fIcommand\fB`\fR
.sp
.br
the output of \fIcommand\fR is turned into a \fIstatus display\fR
updated each time the program stops.  For instance, by entering
.sp
.br
  \fBgraph display `where`\fR
.sp
.br
a status display named `\fBWhere\fR' is created that shows the current
backtrace.
.PP
If you are using \s-2GDB\s+2, \s-2DDD\s+2 provides a panel from
which you can choose useful status displays.  In the `\fBData\fR'
menu, select the `\fBStatus Displays...\fR' item and pick your choice
from the list.
.PP
.PSPIC PICS/ddd-status-displays.ps 15.3cm
.PP
Note that status displays are quite time-consuming, so you
should delete them as soon as you don't need them any more.
.\"
.\"
.SS "Displaying Multiple Array Items"
.\"
When debugging C or C++ programs, one often has to deal with pointers
to arrays of dynamically determined size.  Both \s-2DDD\s+2 and
\s-2GDB\s+2 provide special support for such dynamic arrays.
.PP
To display several successive objects of the same type (a section of
an array, or an array of dynamically determined size), use the
notation \fB[\fIFROM\fB..\fITO\fB]\fR in display expressions.
\fIFROM\fR and \fITO\fR denote the first and last array position to
display.  Thus,
.sp
.br
  \fBgraph display argv[0..9]\fR
.sp
.br
creates ten new display nodes for `\fBargv[0]\fR',
`\fBargv[1]\fR', ..., `\fBargv[9]\fR'.
.PP
Using \s-2GDB\s+2 as inferior debugger, you can use \fIartificial arrays\fR.
Typing
.sp
.br
  \fBgraph display argv[0] @ 10\fR
.sp
.br
creates a single array display node containing `\fBargv[0]\fR' up to
`\fBargv[9]\fR'.  Generally, by using the `\fB@\fR' operator, you
can specify the number of array elements to be displayed.
.PP
For more details on artificial arrays, see the \s-2GDB\s+2 documentation.
.\"
.\"
.SS "Altering Variable Values"
.\"
Using the `\fBSet ()\fR' button or the `\fBSet Value\fR' menu item in
the data popup menu, you can alter the value of the selected variable,
to resume execution with the changed value.  In a dialog, you can
modify the variable value at will; clicking the `\fBOK\fR' or
`\fBApply\fR' button commits your change.
.PP
Note that most inferior debuggers have no support for changing entire
structures; you must change each primitive structure member
separately.
.PP
.PSPIC PICS/ddd-set.ps 15.3cm
.\"
.\"
.SS "Deleting Displays"
.\"
To delete a single display, select it and click on the `\fBDelete()\fR'
button.  As an alternative, you can also press the \fIright mouse
button\fR on the display and select the `\fBDelete Display\fR' item.
.PP
When a display is deleted, its immediate ancestors and descendants are
automatically selected, so that you can easily delete entire graphs.
.PP
To delete several displays at once, select the `\fBDelete...\fR' item
in the Display Editor (invoked through the `\fBEdit Displays...\fR'
item in the `\fBData\fR' menu).  Select any number of display items in
the usual way and delete them by pressing `\fBDelete\fR'.
.PP
As an alternative, you can also type
.sp
.br
  \fBgraph undisplay \fIdisplays...\fR
.sp
.br
at the debugger prompt, where \fIdisplays...\fR is a space-separated
list of display numbers to delete.
.\"
.\"
.SS "Disabling or Enabling Displays"
.\"
Note: \s-2DBX\s+2 and \s-2XDB\2+2 do not support display disabling.
.PP
Unlike a \fIdeleted\fR display item, a \fIdisabled\fR display item
remains in the display, but its value is not shown until it is enabled
again.
.PP
Displays are enabled and disabled the same way they are deleted, using
the `\fBDisable()\fR'/`\fBEnable()\fR' button, the
`\fBDisable\fR'/`\fBEnable Display\fR' popup menu item, or the
`\fBDisable\fR'/`\fBEnable\fR' buttons in the Display Editor.
.PP
As an alternative, you can also type
.sp
.br
  \fBgraph disable display \fIdisplays...\fR
.sp
.br
and
.sp
.br
  \fBgraph enable display \fIdisplays...\fR
.sp
.br
at the debugger prompt.  \fIdisplays...\fR is a space-separated list
of display numbers to disable or enable.

.\"
.SS "Examining Shared Data Structures"
.\"
By default, \s-2DDD\s+2 does not recognize shared data
structures\(em\&that is, a data object referenced by multiple other
data objects.  For instance, if two pointers \fBp1\fR and \fBp2\fR
point at the same data object \fBd\fR, the data displays \fBd\fR,
\fB*p1\fR, and \fB*p2\fR will be separate, although they denote the
same object.
.PP
\s-2DDD\s+2 provides a special mode which makes it detect these
situations.  \s-2DDD\s+2 recognizes if two or more data displays are
stored at the same physical address, and if this is so, merges all
these \fIaliases\fR into one single data display, the \fIoriginal data
display\fR.  This mode is called \fIAlias Detection\fR; it is enabled
via the `\fBDetect Aliases\fR' item `\fBData\fR' menu.
.PP
When alias detection is enabled, \s-2DDD\s+2 inquires the memory
location (the \fIaddress\fR) of each data display after each program
step.  If two displays have the same address, they are merged into
one.  More specifically, only the one which has least recently changed
remains (the \fIoriginal data display\fR); all other aliases are
\fIsuppressed\fR, i.e. completely hidden.  The edges leading to the
aliases are replaced by edges leading to the original data display.
.PP
An edge created by alias detection is somewhat special: rather than
connecting two displays directly, it goes through an \fIedge hint\fR,
describing an arc connecting the two displays and the edge hint.
.PP
Each edge hint is a placeholder for a suppressed alias; selecting an
edge hint is equivalent to selecting the alias.  This way, you can
easily delete display aliases by simply selecting the edge hint and
clicking on `\fBDelete ()\fR'.
.PP
Edge hints can be made invisible by disabling `\fBShow Edge Hints\fR'
in the `\fBData Options\fR' menu.
.PP
.PSPIC PICS/ddd-aliases.ps 15.3cm
.PP
To access suppressed display aliases, you can also use the Display
Editor.  Suppressed displays are listed in the Display Editor as
\fIaliases\fR of the original data display.  Via the Display Editor,
you can select, change, and delete suppressed displays.
.PP
.PSPIC PICS/ddd-edit-displays.ps 15.3cm
.PP
Suppressed displays become visible again as soon as
.br
.IP \(bu 2
alias detection is disabled, 
.br
.IP \(bu 2
their address changes such that they are no more aliases, or
.br
.IP \(bu 2
the original data display is deleted, such that the least recently
changed alias becomes the new original data display.
.PP
Please note the following \fIcaveats\fR with alias detection:
.br
.IP \(bu 2
Alias detection requires that the current programming language
provides a means to determine the address of an arbitrary data
object.  Currently, only C and C++ are supported.
.br
.IP \(bu 2
Some inferior debuggers (for instance, SunOS \s-2DBX\s+2) produce
incorrect output for address expressions.  Given a pointer \fBp\fR,
you may verify the correct function of your inferior debugger by
comparing the values of \fBp\fR and \fB&p\fR (unless \fBp\fR actually
points to itself).  You can also examine the data display addresses,
as shown in the Display Editor.
.br
.IP \(bu 2
Alias detection slows down \s-2DDD\s+2 considerably, which is why it
is disabled by default.  You may consider to enable it only at
need\(em\&for instance, while examining some complex data
structure\(em\&and disable it while examining control flow (i.e.,
stepping through your program).  \s-2DDD\s+2 will automatically
restore edges and data displays when switching modes.
.PP
.\"
.\"
.SS "Refreshing the Data Window"
.\"
Although the data window refreshes itself automatically each time the
program stops, there are some situations where you should refresh it
explicitly.
.PP
The data window should be refreshed whenever:
.br
.IP \(bu 2
you disabled, enabled or deleted displays items at the debugger
prompt,
.br
.IP \(bu 2
the display stays unchanged although all items should be deleted
(e.g. because you chose another file to debug),
.br
.IP \(bu 2
you think it could be useful.
.PP
You can refresh the data window by selecting the `\fBRefresh
Displays\fR' item in the `\fBData\fR' menu.
.PP
As an alternative, you can press the \fIright mouse button\fR
on the background of the data window and select the `\fBRefresh
Display\fR' item.
.PP
Typing
.sp
.br
  \fBgraph refresh\fR
.sp
.br
at the debugger prompt has the same effect.
.\"
.\"
.\"
.\" ---------------
.SH "GRAPH EDITING"
.\" ---------------
.\"
The \s-2DDD\s+2 data window offers some basic functionality to
manipulate the display graph.
.\"
.\"
.SS "Moving Displays Around"
.\"
From time to time, you may wish to move displays at another place in
the data window.  You can move a single display by pressing and
holding the \fIleft mouse button\fR on the display title.  Moving the
pointer while holding the button causes all selected displays to move
along with the pointer.
.PP
If the data window becomes too small to hold all displays, scroll bars
are created.  If your \s-2DDD\s+2 is set up to use \fIpanners\fR
instead, a panner is created in the lower right edge.  When the panner
is moved around, the window view follows the position of the panner.
See `\fBCUSTOMIZING DDD\fR', below, for details on how to set up
scroll bars or panners.
.PP
For fine-grain movements, selected displays may also be moved using
the arrow keys.  Pressing \fBShift\fR and an arrow key moves displays
by single pixels.  Pressing `\fBCtrl\fR' and arrow keys moves displays
by grid positions.
.PP
Edge hints can be selected and moved around like other displays.  If
an arc goes through the edge hint, you can change the shape of the arc
by moving the edge hint around.
.\"
.\"
.SS "Aligning Displays"
.\"
You can align all displays on the nearest grid position by selecting
`\fBAlign Displays\fR' from the `\fBGraph\fR' menu.  This is useful
for keeping edges horizontal or vertical.
.PP
You can enforce alignment by selecting `\fBSnap to Grid\fR' in the
`\fBData Options\fR' menu.  If `\fBSnap to Grid\fR' is
enabled, displays can be moved on grid positions only.
.\"
.\"
.SS "Layouting the Display Graph"
.\"
You can layout the entire graph as a tree by selecting `\fBLayout
Graph\fR' from the `\fBData\fR' menu.
.PP
Layouting the graph may introduce \fIedge hints\fR; that is, edges are
no more straight lines, but lead to an edge hint and from there to
their destination.  You can make edge hints invisible by disabling
`\fBShow Edge Hints\fR' in the `\fBData Options\fR' menu.  Edge hints
can be moved around like arbitrary displays.
.PP
To enable a more compact layout, you can set the `\fBCompact
Layout\fR' option in the `\fBData Options\fR' menu.  This realizes an
alternate layout algorithm, where successors are placed next to their
parents.  This algorithm is suitable for homogeneous data structures
only.
.PP
You can enforce layout by setting the `\fBAutomatic Layout\fR' option
in the `\fBData Options\fR' menu.  If `\fBAutomatic Layout\fR' is
enabled, the graph is layouted after each change.
.PP
.PSPIC PICS/ddd-layout.ps 15.3cm
.\"
.\"
.SS "Rotating the Display Graph"
.\"
You can rotate the entire graph clockwise by 90 degrees by selecting
`\fBRotate Graph\fR' from the `\fBData\fR' menu.
.PP
If the graph was previously layouted, you may need to layout it again.
Subsequent layouts will respect the direction of the last rotation.
.\"
.\"
.SS "Printing the Display Graph"
.\"
\s-2DDD\s+2 allows for printing the graph picture on PostScript
printers or into files.  This is useful for documenting program states.
.PP
.PSPIC PICS/ddd-print-graph.ps 15.3cm
.PP
To print the graph on a PostScript printer, select the `\fBPrint
Graph...\fR' item from the `\fBFile\fR' menu.  Enter the printing
command in the `\fBPrint Command\fR' field.  Click on the
`\fBPrint\fR' button to start printing.
.PP
To re-print the display graph using the previous settings, select the
`\fBPrint Again\fR' item from the `\fBFile\fR' menu.
.PP
As an alternative, you may also print the graph in a file.  Click on
the `\fBFile\fR' button and enter the file name in the `\fBFile
Name\fR' field.  Click on the `\fBPrint\fR' button to create the file.
.PP
When the graph is printed in a file, two formats are available:
.br
.IP \(bu 2
\fBPostScript\fR - suitable for enclosing it in another document;
.br
.IP \(bu 2
\fB\s-2FIG\s+2\fR - suitable for editing, using the \s-2XFIG\s+2 graphic
editor, or for conversion into other formats (among others
\s-2IBMGL\s+2, \s-2L\s-2A\s+2T\dE\uX\s+2, \s-2PIC\s+2), 
using the \s-2TRANSFIG\s+2 or \s-2FIG2DEV\s+2 package.
.PP
.PSPIC PICS/ddd-print-output.ps 15.3cm
.\"
.\"
.\" ---------------
.SH "MACHINE-LEVEL DEBUGGING"
.\" ---------------
.\"
Note: Machine-level support is available with \s-2GDB\s+2 only.
.PP
Sometimes, it is desirable to examine a program not only at the
source level, but also at the machine level.  \s-2DDD\s+2 provides
special machine code and register windows for this task.
.\"
.\"
.SS "Examining Machine Code"
.\"
To enable machine-level support, select `\fBDisplay Machine Code\fR'
from the `\fBSource Options\fR' menu.  With `\fBDisplay Machine
Code\fR' enabled, an additional \fImachine code window\fR shows up,
displaying the machine code of the current function.  By moving the
sash at the right of the separating line between source and machine
code, you can resize the source and machine code windows.
.PP
The machine code window works very much like the source window.  You
can set, clear, and change breakpoints by selecting the address and
pressing a `\fBBreak at ()\fR' or `\fBClear at ()\fR' button; the
usual popup menus are also available.  Breakpoints and the current
execution position are displayed simultaneously in both source and
machine code.
.PP
The `\fBLookup()\fR' button can be used to look up the machine code
for a specific function\(em\&or the function for a specific address.
Just click on the location in one window and press `\fBLookup()\fR'
to see the corresponding code in the other window.
.PP
If source code is not available, only the machine code window is
updated.
.\"
.\"
.SS "Execution"
.\"
All execution facilities available in the source code window are
available in the machine code window as well.  Two special facilities
are convenient for machine-level debugging:
.PP
To execute just one machine instruction, click on the `\fBStepi\fR' button.
.PP
To continue to the next instruction in the current function, click on
the `\fBNexti\fR' button.  This is similar to `\fBStepi\fR', but any
subroutine calls are executed without stopping.
.PP
.PSPIC PICS/ddd-code.ps 15.3cm
.\"
.\"
.SS "Registers"
.\"
\s-2DDD\s+2 provides a \fIregister window\fR showing the machine
register values after each program stop.  To enable the register
window, select `\fBRegisters...\fR' from the `\fBStatus\fR' menu.
.PP
By selecting one of the registers, its name is copied to the argument
field.  You can use it as value for `\fBDisplay()\fR', for instance,
to have its value displayed in the data window.
.PP
.PSPIC PICS/ddd-registers.ps 15.3cm
.\"
.\"
.\" ---------------------
.SH "EDITING SOURCE CODE"
.\" ---------------------
.\"
In \s-2DDD\s+2 itself, you cannot change the source file currently
displayed.  \s-2DDD\s+2 allows you to invoke a \fItext editor\fR
instead.  To invoke a text editor for the current source file, select
the `\fBEdit\fR' button or the `\fBEdit Source...\fR' item from the
`\fBSource\fR' menu.
.PP
The editor command is specified in the `\fBeditCommand\fR' resource.
By default, \s-2DDD\s+2 tries to invoke the first available editor
from the following list:
.br
.IP \(bu 2
The editor specified in the `\fBXEDITOR\fR' environment variable;
.br
.IP \(bu 2
The `\fBgnuclient\fR' program, invoking a separate window from a running
\fBEmacs\fR editor;
.br
.IP \(bu 2
The `\fBemacsclient\fR' program, invoking a separate window from a running
\fBEmacs\fR editor;
.br
.IP \(bu 2
A `\fBxterm\fR' terminal emulator running the editor specified in the
`\fBEDITOR\fR' environment variable;
.br
.IP \(bu 2
A `\fBxterm\fR' terminal emulator running the `\fBvi\fR' editor.
.PP
After the editor has exited, the source code shown is automatically
brought up-to-date.
.PP
If you have \s-2DDD\s+2 and an editor running in parallel, you can
also update the source code manually by selecting the `\fBReload
Source...\fR' item from the `\fBSource\fR' menu.  This reloads the
source code shown from the source file.  As \s-2DDD\s+2
automatically reloads the source code if the debugged program has been
recompiled, this should seldom be necessary.
.\"
.\"
.\" ---------------
.SH "QUITTING DDD"
.\" ---------------
.\"
To exit \s-2DDD\s+2, select `\fBExit\fR' from the `\fBFile\fR' menu.
You may also type the `\fBquit\fR' command at the debugger prompt.
\s-2GDB\s+2 and \s-2XDB\s+2 also accept the `\fBq\fR' command or an
end-of-file character (usually \fBCtrl+D\fR).
.PP
An interrupt (\fBCtrl+C\fR or \fBInterrupt\fR) does not exit from
\s-2DDD\s+2, but rather terminates the action of any debugger
command that is in progress and returns to the debugger command level.
It is safe to type the interrupt character at any time because the
debugger does not allow it to take effect until a time when it is
safe.
.PP
In case an ordinary interrupt does not succeed, you can also use an 
abort (\fBCtrl+\\\fR or \fBAbort\fR), which sends a \s-2QUIT\s+2 signal
to the inferior debugger.  Use this in emergencies only; the inferior
debugger may be left inconsistent after a \s-2QUIT\s+2 signal.
.PP
As a last resort\(em\&if \s-2DDD\s+2 hangs, for example\(em\&, you may
also interrupt \s-2DDD\s+2 itself using an interrupt signal
(\s-2SIGINT\s+2).  This can be done by pressing \fBCtrl+C\fR in the
shell \s-2DDD\s+2 was started from, or by using the \s-2UNIX\s+2
`\fBkill\fR' command.  An interrupt signal interrupts any
\s-2DDD\s+2 action; the inferior debugger is interrupted as well.
Since this interrupt signal can result in internal inconsistencies,
use this as a last resort in emergencies only; save your work as soon
as possible and restart \s-2DDD\s+2.
.\"
.\"
.\" ---------------
.SH "REMOTE DEBUGGING"
.\" ---------------
.\"
It is possible to have the inferior debugger run on a remote
\s-2UNIX\s+2 host.  This is useful when the remote host has a slow
network connection or when \s-2DDD\s+2 is available on the local
host only.
.PP
In order to run the inferior debugger on a remote host, you need
`\fBremsh\fR' (called `\fBrsh\fR' on \s-2BSD\s+2 systems) access on
the remote host.
.PP
To run the debugger on a remote host \fIhostname\fR, invoke \s-2DDD\s+2 as
.sp
.br
  \fBddd\ \-\-host \fIhostname\fB \fIremote-program\fR
.br
.sp
If your remote  \fIusername\fR differs from the local username, use
.sp
.br
  \fBddd\ \-\-host \fIhostname\fB\ \-\-login \fIusername\fB\c
 \fIremote-program\fR
.br
.sp
instead.
.PP
There are a few \fIcaveats\fR in remote mode:
.IP \(bu 2
The remote debugger is started in your remote home directory.  Hence,
you must specify an absolute path name for \fIremote-program\fR (or a
path name relative to your remote home directory).  Same applies to
remote core files.  Also, be sure to specify a remote process id when
debugging a running program.
.br
.IP \(bu 2
The remote debugger is started non-interactively.  Some \s-2DBX\s+2
versions have trouble with this.  If you don't get a prompt from the
remote debugger, use the `\fB\-\-rhost\fR' option instead of
`\fB\-\-host\fR'.  This will invoke the remote debugger via an
interactive shell on the remote host, which may lead to better
results.
.br
Note: using `\fB\-\-rhost\fR', \s-2DDD\s+2 invokes the inferior
debugger as soon as a shell prompt appears.  The first output on the
remote host ending in a space character or `\fB>\fR' and not followed
by a newline is assumed to be a shell prompt.  If necessary, adjust
your shell prompt on the remote host.
.br
.IP \(bu 2
To run the remote program, \s-2DDD\s+2 invokes an `\fBxterm\fR' terminal
emulator on the remote host, giving your current `\fBDISPLAY\fR'
environment variable as address.  If the remote host cannot invoke
`\fBxterm\fR', or does not have access to your X display, start
\s-2DDD\s+2 with the `\fB\-\-no\-exec\-window\fR' option.  The program
input/output will then go through the \s-2DDD\s+2 debugger console.
.br
.IP \(bu 2
In remote mode, all sources are loaded from the remote host; file
dialogs scan remote directories.  This may result in somewhat slower
operation than normal.
.br
.IP \(bu 2
To help you find problems due to remote execution, run \s-2DDD\s+2 with the
`\fB\-\-trace\-shell\-commands\fR' option.  This prints the shell
commands issued by \s-2DDD\s+2 on standard error.
.\"
.\"
.\" ---------------
.SH "ROOT DEBUGGING"
.\" ---------------
.\"
Sometimes, you may require to debug programs with root privileges, but
without actually logging in as root.  This is usually done by
installing the debugger \fIsetuid root\fR, that is, having the
debugger run with root privileges.  For security reasons, you cannot
install \s-2DDD\s+2 as a setuid program.  Instead, you should invoke
\s-2DDD\s+2 such that a \fIsetuid\fR copy of the inferior debugger
is used.
.PP
Here is an example.  Have a \fIsetuid root\fR copy of \s-2GDB\s+2
installed as `\fBrootgdb\fR'.  Then invoke
.sp
.br
  \fBddd\ \-\-debugger rootgdb\fR
.br
.sp
to debug programs with root privileges.
.PP
Since a program like `\fBrootgdb\fR' grants root privileges to any
invoking user, you should give it very limited access.
.\"
.\"
.\" ---------------
.SH "INTEGRATING DDD"
.\" ---------------
.\"
You can run \s-2DDD\s+2 as an inferior debugger in other debugger
front-ends, combining their special abilities with those of
\s-2DDD\s+2.
.\"
.SS "General Information"
.\"
To have \s-2DDD\s+2 run as an inferior debugger in other front-ends,
set up your debugger front-end such that `\fBddd \-\-tty\fR' is
invoked instead of the inferior debugger.  When \s-2DDD\s+2 is
invoked using the `\fB\-\-tty\fR' option, it enables its
\fI\s-2TTY\s+2 interface\fR, taking additional debugger commands from
standard input and forwarding debugger output to standard output, just
as if the inferior debugger had been invoked directly.  All remaining
\s-2DDD\s+2 functionality stays unchanged.
.PP
In case your debugger front-end uses the \s-2GDB\s+2
`\fB\-fullname\fR' option to have \s-2GDB\s+2 report source code
positions, the `\fB\-\-tty\fR' option is not required.  \s-2DDD\s+2
recognizes the `\fB\-fullname\fR' option, finds that it has been
invoked from a debugger front-end and automatically enables
the \s-2TTY\s+2 interface.
.PP
You may also invoke `\fBddd \-\-tty\fR' directly, entering
\s-2DDD\s+2 commands from your \s-2TTY\s+2, or use \s-2DDD\s+2 as
the end of a pipe, controlled by a remote program.  Be aware, however,
that the \s-2TTY\s+2 interface does not support line editing and
command completion and that \s-2DDD\s+2 exits as soon as it receives
a \s-2EOF\s+2 on its standard input.  Also, do not try to run
\s-2DDD\s+2 with \s-2DDD\s+2 as inferior debugger.
.PP
The `\fB\-\-tty\fR' option automatically disables the debugger
console, as its facilities are supposed to be provided by the
integrating front-end.  If the front-end also provides source and/or
data facilities, you may be interested in disabling the \s-2DDD\s+2
source window or the \s-2DDD\s+2 data window, too.  Use the
`\fB\-\-no\-source\-window\fR' and `\fB\-\-no\-data\-window\fR'
options for this purpose.
.\"
.\"
.SS "Using DDD with GNU Emacs"
.\"
Use `\fBM-x gdb\fR' or `\fBM-x dbx\fR' to start a debugging session.
At the prompt, enter `\fBddd \-\-tty\fR', followed by
`\fB\-\-dbx\fR' or `\fB\-\-gdb\fR', if required, and the name of the
program to be debugged.  Proceed as usual.
.\"
.SS "Using DDD with XEmacs"
.\"
Set the variable \fBgdb-command-name\fR to \fB"ddd"\fR, by inserting
the following line in your \fB$HOME/.emacs\fR file or evaluating it by
pressing \s-2\fBESC\fR\s+2 \s-2\fB:\fR\s+2\fR (\s-2\fBESC\fR\s+2
\s-2\fBESC\fR\s+2 for XEmacs 19.13 and earlier):
.br
.sp
  \fB(setq gdb-command-name "ddd")\fR
.sp
.br
Use `\fBM-x gdb\fR' or `\fBM-x gdbsrc\fR' 
to start a debugging session.  Proceed as usual.
.\"
.SS "Using DDD with XXGDB"
.\"
Invoke \fBxxgdb\fR as
.br
.sp
 \fBxxgdb \-db_name ddd \-db_prompt '(gdb) '
.sp
.br
.\" ---------------
.SH "PREFERENCES"
.\" ---------------
.\"
You can set up your personal \s-2DDD\s+2 preferences by using the
`\fBOptions\fR' menu from the menu bar.  These options affect your
running \s-2DDD\s+2 process only, unless you save these preferences
for a later \s-2DDD\s+2 invocation.
.\"
.SS "Frequent Preferences"
.PP
.PSPIC PICS/ddd-prefs-menu.ps 15.3cm
.PP
If you want to run your debugged process in a separate terminal
emulator window, set the `\fBRun in Execution Window\fR' option.  This
is useful for programs that have special terminal requirements not
provided by the debugger window, as raw keyboard processing or
terminal control sequences.
.PP
By default, \s-2DDD\s+2 finds only complete words.  This is
convenient for clicking on an identifier in the source text and search
for exactly this identifier.  If you want to find all occurrences,
including word parts, unset the `\fBFind Words Only\fR' option.
.PP
If you wish to display machine code of selected funtions, set the
`\fBDisplay Machine Code\fR' option.  This makes \s-2DDD\s+2 run a
little slower, so it is disabled by default.
.PP
Through the `\fBPreferences...\fR' item, you can set up more
preferences, which are dicussed here.
.\"
.SS "General Preferences"
.PP
.PSPIC PICS/ddd-general-prefs.ps 15.3cm
.PP
By default, when you move the pointer over a button, \s-2DDD\s+2
gives a hint on the button's meaning in a small window.  Experienced
users may find these \fIbutton tips\fR disturbing; this is why you
can disable them by unsetting the `\fBAutomatic display of button
hints as popup tips\fR' option.
.PP
The button hints are also displayed in the status line.  Disabling
hints in status line (by unsetting the `\fBAutomatic display of button
hints in the status line\fR' option) and disabling button tips as well
makes \s-2DDD\s+2 run slightly faster.
.PP
By default, when you move the pointer over a variable in the source
code, \s-2DDD\s+2 displays the variable value in a small window.
Users may find these \fIvalue tips\fR disturbing; this is why you can
disable them by unsetting the `\fBAutomatic display of variable
values as popup tips\fR' option.
.PP
The variable values are also displayed in the status line.  Disabling
variable values in status line (by unsetting the `\fBAutomatic display
of variable values in the status line\fR' option) and disabling value
tips as well will make \s-2DDD\s+2 run slightly faster.
.PP
If you want to use \s-2\fBTAB\fR\s+2 key completion in all text
windows, set the `\fBTAB key completes in all windows\fR' option.
This is useful if you have pointer-driven keyboard focus (see below)
and no special usage for the \s-2\fBTAB\fR\s+2 key.  Otherwise, the
\s-2\fBTAB\fR\s+2 key completes in the debugger console only.
.PP
If you frequently switch between \s-2DDD\s+2 and other multi-window
applications, you may like to set the `\fBIconify all windows at
once\fR' option.  This way, all \s-2DDD\s+2 windows are iconified
and deiconified as a group.
.PP
If you are bothered by X warnings, you can suppress them by setting
the `\fBSuppress X warnings\fR' option.
.PP
When debugging a modal X application, \s-2DDD\s+2 may interrupt it
while it has grabbed the pointer, making further interaction
impossible.  If the `\fBUngrab mouse pointer when interrupting modal X
application\fR' option is set, \s-2DDD\s+2 will check after each
interaction whether the pointer is grabbed.  If this is so,
\s-2DDD\s+2 will instruct the debugged program to ungrab the mouse
pointer such that you can continue to use your display.
.PP
If you want to save the command history for the next \s-2DDD\s+2
invocation, set the `\fBSave command history on exit\fR' option.
Note: This option is always set if your \s-2GDB\s+2 is set up to save
its command history.
.PP
The `\fBReset\fR' button restores the most recently saved preferences.
.\"
.SS "Source Preferences"
.PP
.PSPIC PICS/ddd-source-prefs.ps 15.3cm
.PP
In the source text, the current execution position and breakpoints are
indicated by symbols (``glyphs'').  As an alternative, \s-2DDD\s+2
can also indicate these positions using text characters.  If you wish
to disable glyphs, unset the `\fBUse Glyphs\fR' option.  This also
makes \s-2DDD\s+2 run slightly faster, especially when scrolling.
.PP
By default, \s-2DDD\s+2 caches source files in memory.  This is
convenient for remote debugging, since remote file access may be slow.
If you want to reduce memory usage, unset the `\fBCache source
files\fR' option.
.PP
By default, \s-2DDD\s+2 caches machine code in memory.  This is bad
for memory usage, but convenient for speed, since disassembling a
function each time it is reached may take time.  If you want to reduce
memory usage, unset the `\fBCache machine code\fR' option.
.PP
Some \s-2DBX\s+2 and \s-2XDB\s+2 variants do not properly handle paths
in source file specifications.  If you want the inferior debugger to
refer to source locations by source base names only, unset the `\fBRefer
to sources by full path name\fR' option.
.PP
The `\fBReset\fR' button restores the most recently saved preferences.
.\"
.SS "Data Preferences"
.PP
.PSPIC PICS/ddd-data-prefs.ps 15.3cm
.PP
If you want \s-2DDD\s+2 to detect aliases, set the `\fBDetect
Aliases\fR' option.  Note that alias detection makes \s-2DDD\s+2 run
slower.  See `\fBExamining Shared Data Structures\fR', above, for
details on alias detection.
.PP
Graph layout and alias detection may introduce \fIedge hints\fR; that
is, edges are no more straight lines, but lead to an edge hint and
from there to their destination.  These edge hints can be selected and
moved around like displays.  You can make edge hints visible by
setting the `\fBShow Edge Hints\fR' option.
.PP
To facilitate alignment of data displays, you can set the
`\fBAuto-align displays\fR' option.  If auto-alignment is enabled,
displays can be moved on grid positions only.
.PP
To enable a more compact layout, you can set the `\fBCompact
Layout\fR' option.  This realizes an alternate layout algorithm, where
successors are placed next to their parents.  This algorithm is
suitable for homogeneous data structures only.
.PP
To enforce layout, you can set the `\fBRe-layout graph
automatically\fR' option.  If automatic layout is enabled, the graph
is layouted after each change.
.PP
In the `\fBGrid Size\fR' scale, you can change the spacing of grid points.
A spacing of 0 disables the grid.  Default is 16.
.PP
The `\fBReset\fR' button restores the most recently saved preferences.
.\"
.SS "Startup Preferences"
.PP
.PSPIC PICS/ddd-startup-prefs.ps 15.3cm
.PP
By default, \s-2DDD\s+2 uses one single window for commands, source,
and data.  To have separate windows for source, data, and debugger
console, set the `\fBWindows\fR' option to `\fBSeparate Windows\fR'.
This change takes only effect after you have saved options and
restarted \s-2DDD\s+2.  See also the `\fB\-\-attach\-windows\fR' and
`\fB\-\-separate\-windows\fR' options, below.
.PP
\s-2DDD\s+2 can display the status line at the bottom (`\fBat
bottom\fR') or at the top (`\fBat top\fR').  This change
takes only effect after you have saved options and restarted
\s-2DDD\s+2.  Pick your choice.
.PP
\s-2DDD\s+2 can locate the tool buttons in the command tool (`\fBin
command tool\fR') or in another line of buttons below the program
source (`\fBin source window\fR').  Pick your choice.
.PP
By default, \s-2DDD\s+2 directs keyboard input to the item your
mouse pointer points at.  If you prefer a click-to-type keyboard focus
(that is, click on an item to make it accept keyboard input), set the
`\fBKeyboard Focus\fR' option on `\fBClick to type\fR'.
.PP
By default, \s-2DDD\s+2 uses Motif scroll bars to scroll the data
window.  Many people find this inconvenient, since you can scroll in
the horizontal or vertical direction only.  As an alternative,
\s-2DDD\s+2 provides a panner (a kind of two-dimensional scroll bar).
This is much more comfortable, but may be incompatible with your Motif
toolkit.  To set up \s-2DDD\s+2 such that it uses panners by
default, set the `\fBData Scrolling\fR' option to `\fBPanner\fR'.
This change takes only effect after you have saved options and
restarted \s-2DDD\s+2.  See also the `\fB\-\-panned\-graph\-editor\fR' and
`\fB\-\-scrolled\-graph\-editor\fR' options, below.
.PP
By default, \s-2DDD\s+2 runs with \s-2GDB\s+2 as inferior debugger.
To change this default, set the `\fBDebugger Type\fR' option to
another debugger.  This change takes only effect after you have saved
options and restarted \s-2DDD\s+2.  See also the `\fB\-\-gdb\fR',
`\fB\-\-dbx\fR', and `\fB\-\-xdb\fR' options, below.
.PP
The `\fBReset\fR' button restores the most recently saved preferences.
.\"
.SS "Saving Options"
.\"
You can save the current option settings by selecting `\fBSave
Options\fR' in the `\fBOptions\fR' menu.  Options are saved in a file
named `\fB.dddinit\fR' in your home directory.
.\"
.SS "Other Customizations"
.\"
Other personal \s-2DDD\s+2 resources can also be set in your
`\fB.dddinit\fR' file.  See the `\fBRESOURCES\fR' section, below.
.PP
The inferior debugger can be customized through the
`\fBSettings...\fR' item.  See the `\fBDEBUGGER SETTINGS\fR' section,
below.
.\"
.\" ---------------
.SH "DEBUGGER SETTINGS"
.\" ---------------
.\"
If you use \s-2GDB\s+2 as inferior debugger, you can change its
settings using the `\fBSettings...\fR' item in the `\fBOptions\fR'
menu.  Using the settings editor, you can determine whether C++ names
are to be demangled, how many array elements are to print, and so on.
.PP
.PSPIC PICS/ddd-settings.ps 15.3cm
.PP
The capabilities of the settings editor depend on the capabilities of
your inferior debugger\(em\&that is, your \s-2GDB\s+2 version.
Clicking on `\fB?\fR' gives an an explanation on the specific item;
the \s-2GDB\s+2 documentation gives more details.
.PP
Clicking on `\fBReset\fR' restores the most recently saved settings.
.PP
Some debugger settings are insensitive and cannot be changed, because
doing so would endanger \s-2DDD\s+2 operation.  See the
`\fBgdbInitCommands\fR' resource for details.
.PP
All debugger settings (except source and object paths) 
are saved with \s-2DDD\s+2 options.
.\"
.\"
.\" ---------------
.SH "RESOURCES"
.\" ---------------
.\"
\s-2DDD\s+2 understands all of the core X Toolkit resource names and
classes.  The following resources are specific to \s-2DDD\s+2.
.\"
.\"
.SS "Setting DDD Fonts"
.\"
This is the default font setting in \s-2DDD\s+2:
.sp
.br
  \fBDdd*fontList: \\
  \-*\-helvetica\-bold\-r\-*\-*\-12\-*\-*\-*\-*\-*\-*\-*=charset,\\
  \-*\-helvetica\-bold\-r\-*\-*\-10\-*\-*\-*\-*\-*\-*\-*=small,\\
  \-*\-lucidatypewriter\-medium\-r\-*\-*\-12\-*\-*\-*\-*\-*\-*\-*=tt,\\
  \-*\-helvetica\-bold\-r\-*\-*\-12\-*\-*\-*\-*\-*\-*\-*=key,\\
  \-*\-helvetica\-medium\-r\-*\-*\-12\-*\-*\-*\-*\-*\-*\-*=rm,\\
  \-*\-helvetica\-medium\-o\-*\-*\-12\-*\-*\-*\-*\-*\-*\-*=sl,\\
  \-*\-helvetica\-bold\-r\-*\-*\-12\-*\-*\-*\-*\-*\-*\-*=bf,\\
  \-*\-helvetica\-bold\-o\-*\-*\-12\-*\-*\-*\-*\-*\-*\-*=bs,\\
  \-*\-helvetica\-bold\-r\-*\-*\-14\-*\-*\-*\-*\-*\-*\-*=Logo,\\
  \-*\-helvetica\-bold\-r\-*\-*\-12\-*\-*\-*\-*\-*\-*\-*=logo,\\
  \-*\-symbol\-*\-*\-*\-12\-*\-*\-*\-*\-*\-*\-*=symbol\fR
.br
.sp
.TP
The font names are used as follows:
.TP 10
.B "charset" 
The default font in buttons, menus, etc.
.TP 10
.B "small"
The default font in a slightly smaller size. 
.TP 10
.B "tt"
The fixed-width font (teletype) used in texts.
.TP 10
.B "key"
The font used for describing key caps.
.TP 10
.B "rm"
Roman font.  In help texts.
.TP 10
.B "sl"
Slanted font.  In help texts.
.TP 10
.B "bf"
Bold face.  In help texts.
.TP 10
.B "bs"
Slanted bold face.  In help texts.
.TP 10
.B "Logo"
The \s-2DDD\s+2 logo font (uppercase letters).
.TP 10
.B "logo"
The \s-2DDD\s+2 logo font (lowercase letters).
.TP 10
.B "symbol"
The symbol font.  In help texts.
.PP
Here is an alternative, resolution-independent setting, which you may
copy into your `\fB$HOME/.dddinit\fR' file:
.sp
.br
  \fBDdd*fontList: \\
  \-*\-helvetica\-bold\-r\-*\-*\-*\-90\-*\-*\-*\-*\-*\-*=charset,\\
  \-*\-helvetica\-bold\-r\-*\-*\-*\-80\-*\-*\-*\-*\-*\-*=small,\\
  \-*\-lucidatypewriter\-medium\-r\-*\-*\-*\-90\-*\-*\-*\-*\-*\-*=tt,\\
  \-*\-helvetica\-bold\-r\-*\-*\-*\-90\-*\-*\-*\-*\-*\-*=key,\\
  \-*\-helvetica\-medium\-r\-*\-*\-*\-90\-*\-*\-*\-*\-*\-*=rm,\\
  \-*\-helvetica\-medium\-o\-*\-*\-*\-90\-*\-*\-*\-*\-*\-*=sl,\\
  \-*\-helvetica\-bold\-r\-*\-*\-*\-90\-*\-*\-*\-*\-*\-*=bf,\\
  \-*\-helvetica\-bold\-o\-*\-*\-*\-90\-*\-*\-*\-*\-*\-*=bs,\\
  \-*\-helvetica\-bold\-r\-*\-*\-*\-120\-*\-*\-*\-*\-*\-*=Logo,\\
  \-*\-helvetica\-bold\-r\-*\-*\-*\-90\-*\-*\-*\-*\-*\-*=logo,\\
  \-*\-symbol\-*\-*\-*\-*\-90\-*\-*\-*\-*\-*\-*=symbol\fR
.br
.sp
The fonts in text fields are specified as follows:
.sp
.br
  \fBDdd*XmTextField.FontList: \\
  \-*\-lucidatypewriter\-medium\-r\-*\-*\-12\-*\-*\-*\-*\-*\-*\-*=charset
  Ddd*XmText.FontList: \\
  \-*\-lucidatypewriter\-medium\-r\-*\-*\-12\-*\-*\-*\-*\-*\-*\-*=charset\fR
.br
.sp
And here is another resolution-independent alternative:
.sp
.br
  \fBDdd*XmTextField.FontList: \\
  \-*\-lucidatypewriter\-medium\-r\-*\-*\-*\-90\-*\-*\-*\-*\-*\-*=charset
  Ddd*XmText.FontList: \\
  \-*\-lucidatypewriter\-medium\-r\-*\-*\-*\-90\-*\-*\-*\-*\-*\-*=charset\fR
.br
.sp
These are the fonts in the command tool:
.sp
.br
  \fBDdd*tool_buttons.run.fontList: \\
  \-*\-helvetica\-bold\-r\-*\-*\-12\-*\-*\-*\-*\-*\-*\-*=charset
  Ddd*tool_buttons.break.fontList: \\
  \-*\-helvetica\-bold\-r\-*\-*\-12\-*\-*\-*\-*\-*\-*\-*=charset
  Ddd*tool_buttons*fontList: \\
  \-*\-helvetica\-medium\-r\-*\-*\-10\-*\-*\-*\-*\-*\-*\-*=charset\fR
.br
.sp
The resolution-independent alternative looks like this:
.sp
.br
  \fBDdd*tool_buttons.run.fontList: \\
  \-*\-helvetica\-bold\-r\-*\-*\-*\-90\-*\-*\-*\-*\-*\-*=charset
  Ddd*tool_buttons.break.fontList: \\
  \-*\-helvetica\-bold\-r\-*\-*\-*\-90\-*\-*\-*\-*\-*\-*=charset
  Ddd*tool_buttons*fontList: \\
  \-*\-helvetica\-medium\-r\-*\-*\-*\-80\-*\-*\-*\-*\-*\-*=charset\fR
.br
.sp
Pick your choice and copy and modify the appropriate resources to your
`\fB$HOME/.dddinit\fR' file.  For fonts within the data display, see
the `\fBvslDefs\fR' resource, below.
.\"
.\"
.\"
.SS "Setting DDD Colors"
.\"
.PP
These are the most important color resources used in \s-2DDD\s+2:
.TP 30
.B Ddd*foreground:
.B black
.TP 30
.B Ddd*background:
.B grey
.TP 30
.B Ddd*XmText.background:
.B grey90
.TP 30 
.B Ddd*XmTextField.background:
.B grey90
.TP 30 
.B Ddd*GraphEdit.background:
.B grey90
.TP 30 
.B Ddd*XmList.background:
.B grey90
.TP 30 
.B Ddd*graph_edit.nodeColor:
.B black
.TP 30 
.B Ddd*graph_edit.edgeColor:
.B blue4
.TP 30 
.B Ddd*graph_edit.selectColor:
.B black
.TP 30 
.B Ddd*graph_edit.gridColor:
.B black
.TP 30 
.B Ddd*graph_edit.frameColor:
.B grey50
.TP 30 
.B Ddd*graph_edit.outlineColor:
.B grey50
.PP
Again, you can copy and modify the appropriate resources to your
`\fB$HOME/.dddinit\fR' file.  For colors within the data display, see
the `\fBvslDefs\fR' resource, below.
.\"
.\"
.\"
.SS "Options and Preferences"
.\"
The following resources determine \s-2DDD\s+2 options and
preferences.
.TP
.B "buttonTips (\fPclass\fB Tips)"
Whether button tips are enabled (`\fBtrue\fR', default) or
not (`\fBfalse\fR').  Button tips are helpful for novices, but
may be distracting for experienced users.
.TP
.B "buttonDocs (\fPclass\fB Docs)"
Whether the display of button hints in the status line is enabled
(`\fBtrue\fR', default) or not (`\fBfalse\fR').
.TP
.B "cacheMachineCode (\fPclass\fB CacheMachineCode)"
Whether to cache disassembled machine code (`\fBtrue\fR', default) or
not (`\fBfalse\fR').  Caching machine code requires more memory, but
makes \s-2DDD\s+2 run faster.
.TP
.B "cacheSourceFiles (\fPclass\fB CacheSourceFiles)"
Whether to cache source files (`\fBtrue\fR', default) or not
(`\fBfalse\fR').  Caching source files requires more memory, but makes
\s-2DDD\s+2 run faster.
.TP
.B "dataWindow (\fPclass\fB Window)"
If `\fBfalse\fR', no data window is created upon start-up.
.TP
.B "debuggerConsole (\fPclass\fB Window)"
If `\fBfalse\fR', no debugger console is created upon start-up.
.TP
.B "disassemble (\fPclass\fB Disassemble)"
If this is `\fBtrue\fR', the source code is automatically
disassembled.  The default is `\fBfalse\fR'.  See also the
`\fB\-\-disassemble\fR' and `\fB\-\-no\-disassemble\fR' options,
below.
.TP
.B "displayGlyphs (\fPclass\fB DisplayGlyphs)"
If this is `\fBtrue\fR', the current execution position and breakpoints
are displayed as glyphs; otherwise, they are shown through characters
in the text.  The default is `\fBtrue\fR'.  See also the
`\fB\-\-glyphs\fR' and `\fB\-\-no\-glyphs\fR' options, below.
.TP
.B "findWordsOnly (\fPclass\fB FindWordsOnly)"
If this is `\fBtrue\fR' (default), the `\fBFind\fR' commands find
complete words only.  Otherwise, arbitrary occurrences are found.
.TP
.B "globalTabCompletion (\fPclass\fB GlobalTabCompletion)"
If this is `\fBtrue\fR' (default), the \s-2\fBTAB\fR\s+2 key completes
arguments in all windows.  If this is `\fBfalse\fR', the
\s-2\fBTAB\fR\s+2 key completes arguments in the debugger console
only.
.TP
.B "groupIconify (\fPclass\fB GroupIconify)"
If this is `\fBtrue\fR', (de)iconifying any \s-2DDD\s+2 window
causes all other \s-2DDD\s+2 windows to (de)iconify as well.
Default is `\fBfalse\fR', meaning that each \s-2DDD\s+2 window can
be iconified on its own.
.TP
.B "indentAmount (\fPclass\fB IndentAmount)"
The number of columns used for the code line number display (default:
\fB8\fR)
.TP
.B "pannedGraphEditor (\fPclass\fB PannedGraphEditor)"
What shall \s-2DDD\s+2 use if the graph gets too large to be
displayed?  If this is `\fBtrue\fR', an Athena panner is used (a kind
of two-directional scrollbar).  If this is `\fBfalse\fR' (default),
two Motif scrollbars are used.  See also the
`\fB\-\-scrolled\-graph\-editor\fR' and `\fB\-\-panned\-graph\-editor\fR'
options, below.
.TP
.B "paperSize (\fPclass\fB PaperSize)"
The paper size used for printing, in format \fIWIDTH\fR x
\fIHEIGHT\fR.  The default is A4 format, or `\fB210mm x 297mm\fR'.
.TP
.B "saveHistoryOnExit (\fPclass\fB SaveHistoryOnExit)"
If `\fBtrue\fR' (default), the command history is automatically saved
when \s-2DDD\s+2 exits.  If the inferior debugger saves its
command history, its history file is used, otherwise,
`\fB$HOME/.ddd_history\fR' is used.
.TP
.B "separateDataWindow (\fPclass\fB Separate)"
If `\fBtrue\fR', the data window and the debugger console are realized
in different top-level windows.  If `\fBfalse\fR' (default), the data
window is attached to the debugger console.  See also the
`\fB\-\-attach\-windows\fR' and `\fB\-\-attach\-data\-window\fR'
options, below.
.TP
.B "separateExecWindow (\fPclass\fB Separate)"
If `\fBtrue\fR', the debugged program is executed in a separate
execution window.  If `\fBfalse\fR' (default), the debugged program is
executed in the console window.  See also the `\fB\-\-exec\-window\fR'
and `\fB\-\-no\-exec\-window\fR' options, below.
.TP
.B "separateSourceWindow (\fPclass\fB Separate)"
If `\fBtrue\fR', the source window and the debugger console are
realized in different top-level windows.  If `\fBfalse\fR' (default),
the source window is attached to the debugger console.  See also the
`\fB\-\-attach\-windows\fR' and `\fB\-\-attach\-source\-window\fR'
options, below.
.TP
.B "sourceWindow (\fPclass\fB Window)"
If `\fBfalse\fR', no source window is created upon start-up.
.TP
.B "statusAtBottom (\fPclass\fB StatusAtBottom)"
If `\fBtrue\fR' (default), the status line is placed at the bottom of
the \s-2DDD\s+2 source window.  If `\fBfalse\fR', the status line is
placed at the top of the \s-2DDD\s+2 source window.  See also the
`\fB\-\-status\-at\-bottom\fR' and `\fB\-\-status\-at\-top\fR'
options, below.
.TP
.B "suppressWarnings (\fPclass\fB SuppressWarnings)"
If `\fBtrue\fR', X warnings are suppressed.  This is
sometimes useful for executables that were built on a machine with a
different X or Motif configuration.  By default, this is
`\fBfalse\fR'.
.TP
.B "tabWidth (\fPclass\fB TabWidth)"
The tab width used in the source window (default: \fB8\fR)
.TP
.B "ungrabMousePointer (\fPclass\fB UngrabMousePointer)"
When debugging a modal X application, \s-2DDD\s+2 may interrupt it
while it has grabbed the pointer, making further interaction
impossible.  If this is `\fBtrue\fR' (default), \s-2DDD\s+2 will
check after each interaction whether the pointer is grabbed.  If this
is so, \s-2DDD\s+2 will instruct the debugged program to ungrab the
mouse pointer.
.TP
.B "useSourcePath (\fPclass\fB UseSourcePath)"
If this is `\fBfalse\fR' (default), the inferior debugger refers to
source code locations only by their base names.  If this is
`\fBtrue\fR' (default), \s-2DDD\s+2 uses the full source code paths.
.TP
.B "valueTips (\fPclass\fB Tips)"
Whether value tips are enabled (`\fBtrue\fR', default) or not
(`\fBfalse\fR').  Value tips affect \s-2DDD\s+2 performance and may
be distracting for some experienced users.
.TP
.B "valueDocs (\fPclass\fB Docs)"
Whether the display of variable values in the status line is enabled
(`\fBtrue\fR', default) or not (`\fBfalse\fR').
.\"
.\"
.\"
.SS "Debugger Settings"
.\"
The following resources determine the inferior debugger.
.TP
.B "dbxInitCommands (\fPclass\fB DBXInitCommands)"
This string contains a list of newline-separated commands that are
initially sent to \s-2DBX\s+2.  By default, it is empty.
.br
Do not use this resource to customize \s-2DBX\s+2; instead, use a
personal `\fB$HOME/.dbxinit\fR' or `\fB$HOME/.dbxrc\fR' file.  See
your \s-2DBX\s+2 documentation for details.
.TP
.B "dbxSettings (\fPclass\fB DBXSettings)"
This string contains a list of newline-separated commands that are
also initially sent to \s-2DBX\s+2.  By default, it is empty.
.br
In future \s-2DDD\s+2 releases, this resource will be used to save
and restore debugger settings.
.TP
.B "debugger (\fPclass\fB Debugger)"
The type of the inferior debugger (`\fBgdb\fR', `\fBdbx\fR', or
`\fBxdb\fR').  Default value is `\fBgdb\fR'.  This resource is usually
set through the `\fB\-\-gdb\fR', `\fB\-\-dbx\fR', and `\fB\-\-xdb\fR'
options; see below for details.
.TP
.B "debuggerCommand (\fPclass\fB DebuggerCommand)"
The name under which the inferior debugger is to be invoked.  If this
string is empty, the debugger type (`\fBdebugger\fR' resource) is
used.  This resource is usually set through the `\fB\-\-debugger\fR'
option; see below for details.
.TP
.B "debuggerHost (\fPclass\fB DebuggerHost)"
The host where the inferior debugger is to be executed; an empty
string (default) means the local host.  See the `\fB\-\-host\fR'
option, below, and `\fBREMOTE DEBUGGING\fR', above.
.TP
.B "debuggerHostLogin (\fPclass\fB DebuggerHostLogin)"
The login user name on the remote host; an empty string (default)
means using the local user name.  See the `\fB\-\-login\fR'
option, below, and `\fBREMOTE DEBUGGING\fR', above.
.TP
.B "debuggerRHost (\fPclass\fB DebuggerRHost)"
The host where the inferior debugger is to be executed; an empty
string (default) means to use the `\fBdebuggerHost\fR' resource.  In
contrast to `\fBdebuggerHost\fR', using this resource causes
\s-2DDD\s+2 to login interactively to the remote host and invoke the
inferior debugger from the remote shell.  See also the
`\fB\-\-rhost\fR' option, below, and `\fBREMOTE DEBUGGING\fR', above.
.TP
.B "fullNameMode (\fPclass\fB TTYMode)"
If this is `\fBtrue\fR', \s-2DDD\s+2 reports the current source
position on standard output in \s-2GDB\s+2 `\fB\-\-fullname\fR'
format.  See also the `\fB\-\-fullname\fR' option, below.
.TP
.B "gdbInitCommands (\fPclass\fB GDBInitCommands)"
This string contains a list of newline-separated commands that are
initially sent to \s-2GDB\s+2.  As a side-effect, all settings
specified in this resource are considered fixed and cannot be changed
through the \s-2GDB\s+2 settings panel, unless preceded by white
space.  By default, the `\fBgdbInitCommands\fR' resource contains some
settings vital to \s-2DDD\s+2:
.sp
.br
  \fBDdd*gdbInitCommands: \\
  set height 0\\n\\
  set width 0\\n\\
   set verbose off\\n\\
  set prompt (gdb) \\n\fR
.br
.sp
While the `\fBset height\fR', `\fBset width\fR', and `\fBset
prompt\fR' settings are fixed, the `\fBset verbose\fR' settings can be
changed through the \s-2GDB\s+2 settings panel (although being reset
upon each new \s-2DDD\s+2 invocation).
.br
Do not use this resource to customize \s-2GDB\s+2; instead, use a
personal `\fB$HOME/.gdbinit\fR' file.  See your \s-2GDB\s+2
documentation for details.
.TP
.B "gdbSettings (\fPclass\fB GDBSettings)"
This string contains a list of newline-separated commands that are
also initially sent to \s-2GDB\s+2.  Its default value is
.sp
.br
  \fBDdd*gdbSettings: \\
  set print repeats 0\\n\\
  set print asm-demangle on\\n\fR
.br
.sp
This resource is used to save and restore the debugger settings.
.TP
.B "questionTimeout (\fPclass\fB QuestionTimeout)"
The time (in seconds) to wait for the inferior debugger to reply.
Default is \fB10\fR.
.TP
.B "rHostInitCommands (\fPclass\fB RHostInitCommands)"
These commands are initially executed in a remote interactive
session, using the `\fB\-\-rhost\fR' option.  By default, it sets up
the remote terminal such that it suits \s-2DDD\s+2:
.sp
.br
  \fBDdd*rHostInitCommands: stty -echo -onlcr\fR
.br
.sp
You may add other commands here\(em\&for instance, to set the
executable path or to invoke a suitable shell.
.TP
.B "synchronousDebugger (\fPclass\fB SynchronousDebugger)"
If `\fBtrue\fR', X events are not processed while the debugger is
busy.  This may result in slightly better performance on
single-processor systems.  See also the `\fB\-\-sync\-debugger\fR'
option, below.
.TP
.B "ttyMode (\fPclass\fB TTYMode)"
If `\fBtrue\fR', enable \s-2TTY\s+2 interface, taking additional
debugger commands from standard input and forwarding debugger output
on standard output.  See also the `\fB\-\-tty\fR' and
`\fB\-\-fullname\fR' options, below.
.TP
.B "useTTYCommand (\fPclass\fB UseTTYCommand)"
If `\fBtrue\fR', use the \s-2GDB\s+2 `\fBtty\fR' command for
redirecting input/output to the separate execution window.  If
`\fBfalse\fR', use explicit redirection through shell redirection
operators `\fB<\fR' and `\fB>\fR'.  The default is `\fBfalse\fR'
(explicit redirection), since on some systems, the `\fBtty\fR' command
does not work properly.
.TP
.B "xdbInitCommands (\fPclass\fB XDBInitCommands)"
This string contains a list of newline-separated commands that are
initially sent to \s-2XDB\s+2.  By default, it is empty.
.br
Do not use this resource to customize \s-2DBX\s+2; instead, use a
personal `\fB$HOME/.xdbrc\fR' file.  See your \s-2XDB\s+2
documentation for details.
.TP
.B "xdbSettings (\fPclass\fB XDBSettings)"
This string contains a list of newline-separated commands that are
also initially sent to \s-2XDB\s+2.  By default, it is empty.
.br
In future \s-2DDD\s+2 releases, this resource will be used to save
and restore debugger settings.
.PP
.\"
.\"
.\"
.SS "User-defined Buttons"
.\"
The following resources can be used to create user-defined buttons.
.TP
.B "consoleButtons (\fPclass\fB ConsoleButtons)"
A colon-separated list of buttons to be added under the debugger
console.  Each button issues the command given by its name.
.sp
The following characters have special meanings:
.RS
.br
.IP \(bu 2
Commands ending with '\fB...\fR' insert their name, followed by a space, in
the debugger console.
.br
.IP \(bu 2
Commands ending with a control character (that is, `\fB^\fR' followed
by a letter or `\fB?\fR') insert the given control character.
.br
.IP \(bu 2
The string `\fB()\fR' is replaced by the current contents 
of the argument field `()'.
.RE
.sp
.RS
The following button names are reserved:
.TP 10
.B "Clear"
Clear current command
.TP 10
.B "Prev"
Show previous command
.TP 10
.B "Next"
Show next command
.TP 10
.B "Apply"
Send the given command to the debugger.
.TP 10
.B "Back"
Lookup previously selected source position.
.TP 10
.B "Forward"
Lookup next selected source position.
.TP 10
.B "Edit"
Edit current source file.
.TP 10
.B "Reload"
Reload source file.
.TP 10
.B "Complete"
Complete current command.
.TP 10
.B "Yes"
Answer current debugger prompt with `\fByes\fR'.  This button is
visible only if the debugger asks a yes/no question.
.TP 10
.B "No"
Answer current debugger prompt with `\fBno\fR'.  This button is
visible only if the debugger asks a yes/no question.
.RE
.sp
.RS
.PP
The name of the button widget is built from the button specification.
First, trailing `\fB...\fR' and `\fB^\fR' specifications removed.
Then, any non-identifier character (letter, number, underscore) is
replaced by `\fB_\fR' (underscore).  Thus, the button specification
`\fBdisplay *()...\fR' results in a widget named `\fBdisplay____\fR'.
Unless a `\fBlabelString\fR' resource is specified, the capitalized
button specification is used as label.
.PP
The default resource value is empty\(em\&no console buttons are
created.
.PP
Here are some examples to insert into your `\fB$HOME/.dddinit\fR' file.
These are the settings of \s-2DDD\s+2 1.x:
.sp
.br
  \fBDdd*consoleButtons: Yes:No:break^C\fR
.br
.sp
This setting creates some more buttons:
.sp
.br
  \fBDdd*consoleButtons: \\
  Yes:No:run:Clear:Prev:Next:Apply:break^C\fR
.br
.sp
See also the `\fBdataButtons\fR', `\fBsourceButtons\fR' and
`\fBtoolButtons\fR' resources, below.
.RE
.sp
.TP
.B "dataButtons (\fPclass\fB DataButtons)"
A colon-separated list of buttons to be added under the data display.
Each button issues the command given by its name.  See the
`\fBconsoleButtons\fR' resource, above, for details on button syntax.
.RS
.PP
The default resource value is empty\(em\&no source buttons are
created.
.RE
.TP
.B "sourceButtons (\fPclass\fB SourceButtons)"
A colon-separated list of buttons to be added under the debugger
console.  Each button issues the command given by its name.  See the
`\fBconsoleButtons\fR' resource, above, for details on button syntax.
.RS
.PP
The default resource value is empty\(em\&no source buttons are
created.
.PP
Here are some example to insert into your `\fB$HOME/.dddinit\fR' file.
These are the settings of \s-2DDD\s+2 1.x:
.sp
.br
  \fBDdd*sourceButtons: \\
  run:step:next:stepi:nexti:cont:\\
  finish:kill:up:down:\\
  Back:Forward:Edit:interrupt^C\fR
.br
.sp
This setting creates some buttons which are not found on the command tool:
.sp
.br
  \fBDdd*sourceButtons: \\
  print *():graph display *():print /x ():\\
  whatis ():ptype ():watch ():until:shell\fR
.br
.sp
An even more professional setting uses customized button labels:
.sp
.br
  \fBDdd*sourceButtons: \\
  print *(()):graph display *(()):print /x ():\\
  whatis ():ptype ():watch ():until:shell
  Ddd*graph_display______.labelString: Display *()
  Ddd*print______.labelString:         Print *()
  Ddd*whatis___.labelString:           What is ()\fR
.br
.sp
See also the `\fBconsoleButtons\fR' and `\fBdataButtons\fR' resources,
above, and the `\fBtoolButtons\fR' resource, below.
.RE
.TP
.B "toolBar (\fPclass\fB ToolBar)"
Whether the tool buttons (see  the `\fBtoolButtons\fR' resource,
below) should be shown in a tool bar below the source window
(\fBtrue\fR) or within the command tool (\fBfalse\fR, default).
Enabling the tool bar disables the command tool and vice versa.
.TP
.B "toolButtons (\fPclass\fB ToolButtons)"
A colon-separated list of buttons to be included in the command tool
or the tool bar (see the `\fBtoolBar\fR' resource, above).  Each
button issues the command given by its name.  See the
`\fBconsoleButtons\fR' resource, above, for details on button syntax.
.RS
.PP
The default resource value is
.sp
.br
  \fBDdd*toolButtons: \\
  run:interrupt^C:step:stepi:\\
  next:nexti:cont:finish:\\
  up:down:Back:Forward:Edit:kill\fR
.br
.sp
For each button, its location in the command tool must be specified
using \fBXmForm\fR constraint resources.  Each side of a button is
attached to a row or column position.  Rows are numbered from 0 (top
side) to 8 (bottom side); columns likewise are numbered from 0 (left
side) to 8 (right side).  The position of the \fBbreak\fR button, for
instance, is specified as:
.sp
.br
  \fBDdd*tool_buttons.break.topPosition:    1
  Ddd*tool_buttons.break.bottomPosition: 2
  Ddd*tool_buttons.break.leftPosition:   0
  Ddd*tool_buttons.break.rightPosition:  8\fR
.br
.sp
while the \fBBack\fR button position is specified as
.sp
.br
  \fBDdd*tool_buttons.Back.topPosition:     6
  Ddd*tool_buttons.Back.bottomPosition:  7
  Ddd*tool_buttons.Back.leftPosition:    0
  Ddd*tool_buttons.Back.rightPosition:   4\fR
.br
.sp
The number of rows and columns (default: 8) can be changed by setting the
`\fBfractionBase\fR' resource to a different value:
.sp
.br
  \fBDdd*tool_buttons.fractionBase:         10\fR
.br
.sp
If you change the `\fBfractionBase\fR' resource, you must provide new
positions for \fIall\fR buttons in the command tool.  See the
`\fBDdd\fR' app-defaults file for more details.
.PP
If the `\fBtoolButtons\fR' resource value is empty, the command tool is
not created.
.RE
.TP
.B "toolRightOffset (\fPclass\fB Offset)"
The distance between the right border of the command tool and the
right border of the source text (in pixels).  Default is 8 pixels.
.TP
.B "toolTopOffset (\fPclass\fB Offset)"
The distance between the upper border of the command tool and the
upper border of the source text (in pixels).  Default is 8 pixels.
.TP
.B "verifyButtons (\fPclass\fB VerifyButtons)"
If true (default), verify for each button whether its command is
actually supported by the inferior debugger.  If the command is
unknown, the button is disabled.  If this resource is false, no
checking is done: all commands are accepted `as is'.
.\"
.\"
.\"
.SS "Data Display Resources"
.\"
The following resources control the data display.
.TP
.B "vslDefs (\fPclass\fB VSLDefs)"
A string with additional \s-2VSL\s+2 definitions that are appended to
the builtin \s-2VSL\s+2 library.  This resource can be used to
override specific \s-2VSL\s+2 definitions that affect the data display.
.RS
.PP
The general pattern to replace a function definition \fIFUNCTION\fR with a new
definition \fINEW_DEF\fR is:
.sp
.br
\fB#pragma replace \fIFUNCTION\fR
.br
\fIFUNCTION\fB(\fIARGS\fR...\fB) = \fINEW_DEF\fB;\fR
.br
.sp
The following \s-2VSL\s+2 functions are frequently used:
.TP 10
.B "color(\fIBOX\fB, \fIFOREGROUND\fB [\|, \fIBACKGROUND\fB\|])"
Set the \fIFOREGROUND\fR and \fIBACKGROUND\fR colors of \fIBOX\fR.
.TP 10
.B "display_color(\fIBOX\fB)"
The color used in data displays.
Default: \fBcolor(\fIBOX\fB, "black", "grey95")
.TP 10
.B "title_color(\fIBOX\fB)"
The color used in the title bar.
Default: \fBcolor(\fIBOX\fB, "black")
.TP 10
.B "disabled_color(\fIBOX\fB)"
The color used for disabled boxes.
Default: \fBcolor(\fIBOX\fB, "white", "grey50")
.TP 10
.B "simple_color(\fIBOX\fB)"
The color used for simple values.
Default: \fBcolor(\fIBOX\fB, "black")
.TP 10
.B "pointer_color(\fIBOX\fB)"
The color used for pointers.
Default: \fBcolor(\fIBOX\fB, "blue4")
.TP 10
.B "struct_color(\fIBOX\fB)"
The color used for structures.
Default: \fBcolor(\fIBOX\fB, "black")
.TP 10
.B "array_color(\fIBOX\fB)"
The color used for arrays.
Default: \fBcolor(\fIBOX\fB, "blue4")
.TP 10
.B "reference_color(\fIBOX\fB)"
The color used for references.
Default: \fBcolor(\fIBOX\fB, "blue4")
.TP 10
.B "stdfontfamily()"
The font family used.  One of \fBfamily_times()\fR, 
\fBfamily_courier()\fR, \fBfamily_helvetica()\fR, 
\fBfamily_new_century()\fR, or \fBfamily_typewriter()\fR (default).
.TP 10
.B "stdfontsize()"
The font size used (in pixels).  \fB0\fR means to use
\fBstdfontpoints()\fR instead.  Default value: \fB12\fR.
.TP 10
.B "stdfontpoints()"
The font size used (in 1/10 points).  \fB0\fR (default) means to use
\fBstdfontsize()\fR instead.
.TP 10
.B "stdfontweight()"
The font weight used.  Either \fBweight_medium()\fR (default) or
\fBweight_bold()\fR.
.PP
To set the pointer color to "red4", use
.sp
.br
  \fBDdd*vslDefs: \\
  #pragma replace pointer_color\\n\\
  pointer_color(box) = color(box, "red4");\\n\fR
.br
.sp
To set the default font size to resolution-independent 10.0 points, use
.sp
.br
  \fBDdd*vslDefs: \\
  #pragma replace stdfontsize\\n\\
  #pragma replace stdfontpoints\\n\\
  stdfontsize() = 0;\\n
  stdfontpoints() = 100;\\n\fR
.br
.sp
To set the default font to 12-pixel courier, use
.sp
.br
  \fBDdd*vslDefs: \\
  #pragma replace stdfontsize\\n\\
  #pragma replace stdfontfamily\\n\\
  stdfontsize() = 12;\\n\\
  stdfontfamily() = family_courier();\\n\fR
.br
.sp
See the file `\fBddd.vsl\fR' for further definitions to override using
the `\fBvslDefs\fR' resource.
.RE
.sp
.TP
.B "vslLibrary (\fPclass\fB VSLLibrary)"
The \s-2VSL\s+2 library to use.  `\fBbuiltin\fR' (default) means to
use the built-in library, any other value is used as file name.
.TP
.B "vslPath (\fPclass\fB VSLPath)"
A colon-separated list of directories to search for \s-2VSL\s+2
include files.  Default is `\fB.\fR', the current directory.
.RS
.PP
If your \s-2DDD\s+2 source distribution is installed in
`\fB/opt/src\fR', you can use the following settings to read the
\s-2VSL\s+2 library from `\fB/home/joe/ddd.vsl\fR':
.sp
.br
  \fBDdd*vslLibrary:  /home/joe/ddd.vsl
  Ddd*vslPath:  \\
  .:/opt/src/ddd/ddd:/opt/src/ddd/vsllib\fR
.br
.sp
\s-2VSL\s+2 include files referenced by `\fB/home/joe/ddd.vsl\fR' are
searched first in the current directory `\fB.\fR', then in
`\fB/opt/src/ddd/ddd/\fR', and then in `\fB/opt/src/ddd/vsllib/\fR'.
.PP
Instead of supplying another \s-2VSL\s+2 library, it is often easier
to specify some minor changes to the built-in library.  See the
`\fBvslDefs\fR' resource, above, for details.
.RE
.\"
.\"
.\"
.\"
.\"
.\"
.SS "Customizing Helper Programs"
.\"
The following resources determine external programs invoked by \s-2DDD\s+2.
.TP
.B "editCommand (\fPclass\fB EditCommand)"
A command string to invoke an editor on the specific file.
`\fB@LINE@\fR' is replaced by the current line number, `\fB@FILE@\fR'
by the file name.  The default is to invoke \fB$XEDITOR\fR first, then
\fB$EDITOR\fR, then \fBvi\fR:
.sp
.br
  \fBDdd*editCommand: \\
  ${XEDITOR=false} +@LINE@ @FILE@ \\
  || xterm \-e ${EDITOR=vi} +@LINE@ @FILE@\fR
.br
.sp
.br
This `\fB.dddinit\fR' setting invokes an editing session
for an \fIXEmacs\fR editor running \fIgnuserv\fR:
.sp
.br
  \fBDdd*editCommand: gnuclient +@LINE@ @FILE@\fR
.br
.sp
This `\fB.dddinit\fR' setting invokes an editing session
for an \fIEmacs\fR editor running \fIemacsserver\fR:
.sp
.br
  \fBDdd*editCommand: emacsclient +@LINE@ @FILE@\fR
.br
.sp
.TP
.B "listCoreCommand (\fPclass\fB listCoreCommand)"
The commmand to list all core files on the remote host.  The string
`\fB@MASK@\fR' is replaced by a file filter.  The default setting is:
.sp
.br
  \fBDdd*listCoreCommand: \\
  file @MASK@ | grep '.*:.*core.*' \\
  | cut \-d: \-f1\fR
.br
.sp
.TP
.B "listDirCommand (\fPclass\fB listDirCommand)"
The commmand to list all directories on the remote host.  The string
`\fB@MASK@\fR' is replaced by a file filter.  The default setting is:
.sp
.br
  \fBDdd*listDirCommand: \\
  file @MASK@ | grep '.*:.*directory.*' \\
  | cut \-d: \-f1\fR
.br
.sp
.TP
.B "listExecCommand (\fPclass\fB listExecCommand)"
The commmand to list all executable files on the remote host.  The string
`\fB@MASK@\fR' is replaced by a file filter.  The default setting is:
.sp
.br
  \fBDdd*listExecCommand: \\
  file @MASK@ | grep '.*:.*exec.*' \\
  | grep \-v  '.*:.*script.*' \\
  | cut \-d: \-f1 | grep \-v '.*\\.o$'\fR
.br
.sp
.TP
.B "listSourceCommand (\fPclass\fB listSourceCommand)"
The commmand to list all source files on the remote host.  The string
`\fB@MASK@\fR' is replaced by a file filter.  The default setting is:
.sp
.br
  \fBDdd*listSourceCommand: \\
  file @MASK@ | grep '.*:.*text.*' \\
  | cut \-d: \-f1\fR
.br
.sp
.TP
.B "printCommand (\fPclass\fB PrintCommand)"
The command to print a postscript file.  Usually `\fBlp\fR' or
`\fBlpr\fR'.
.TP
.B "rshCommand (\fPclass\fB RshCommand)"
The remote shell command to invoke tty-based commands on remote
hosts.  Usually, `\fBremsh\fR', `\fBrsh\fR', or `\fBon\fR'.
.TP
.B "termCommand (\fPclass\fB TermCommand)"
The command to invoke a separate tty for showing the input/output of
the debugged program.  A bourne shell command to run in the separate
tty is appended this string.  A simple value is
.sp
.br
  \fBDdd*termCommand: xterm \-e /bin/sh \-c\fR
.br
.TP
.B "termType (\fPclass\fB TermType)"
The terminal type provided by the `\fBtermCommand\fR'
resource\(em\&that is, the value of the \fBTERM\fR environment
variable to be passed to the debugged program.  Default:
`\fBxterm\fR'.
.TP
.B "wwwCommand (\fPclass\fB WWWCommand)"
The command to invoke a \s-2WWW\s+2 browser.  The string `\fB@URL@\fR'
is replaced by the \s-2URL\s+2 to open.  Default is to try a running
Netscape first, then to invoke a new Netscape process, then to let a
running Emacs do the job, then to invoke Mosaic, then to invoke Lynx.
.RS
.PP
To specify `\fBnetscape-3.0\fR' as browser, use the setting:
.sp
.br
  \fBDdd*wwwCommand: \\
  netscape\-3.0 \-remote 'openURL(@URL@)' \\
  || netscape\-3.0 '@URL@'\fR
.br
.sp
This command first tries to connect to a running \fBnetscape-3.0\fR browser;
if this fails, it starts a new \fBnetscape-3.0\fR process.
.RE
.TP
.B "wwwPage (\fPclass\fB WWWPage)"
The \s-2DDD\s+2 \s-2WWW\s+2 page.  Value:
.sp
.br
  \fBDdd*wwwPage: http://www.cs.tu\-bs.de/softech/ddd/\fR
.br
.sp
.\"
.\"
.\"
.SS "Obtaining Diagnostics"
.\"
The following resources are used for debugging \s-2DDD\s+2 and to
obtain specific \s-2DDD\s+2 information.
.TP
.B "appDefaultsVersion (\fPclass\fB Version)"
The version of the \s-2DDD\s+2 app-defaults file.  If this string
does not match the version of the current \s-2DDD\s+2 executable,
\s-2DDD\s+2 issues a warning.
.TP
.B "checkConfiguration (\fPclass\fB CheckConfiguration)"
If true, check the \s-2DDD\s+2 environment (in particular, the X
configuration), report any possible problem causes and exit.  See also
the `\fB\-\-check\-configuration\fR' option, below.
.TP
.B "dddinitVersion (\fPclass\fB Version)"
The version of the \s-2DDD\s+2 executable that last wrote the
`\fB$HOME/.dddinit\fR' file.  If this string does not match the
version of the current \s-2DDD\s+2 executable, \s-2DDD\s+2 issues
a warning.
.TP
.B "showConfiguration (\fPclass\fB ShowConfiguration)"
If `\fBtrue\fR', show the \s-2DDD\s+2 configuration on standard
output and exit.  See also the `\fB\-\-configuration\fR' option,
below.
.TP
.B "showInvocation (\fPclass\fB ShowInvocation)"
If `\fBtrue\fR', show the \s-2DDD\s+2 invocation options on standard
output and exit.  See also the `\fB\-\-help\fR' option, below.
.TP
.B "showLicense (\fPclass\fB ShowLicense)"
If `\fBtrue\fR', show the \s-2DDD\s+2 license on standard output and
exit.  See also the `\fB\-\-license\fR' option, below.
.TP
.B "showManual (\fPclass\fB ShowManual)"
If `\fBtrue\fR', show this \s-2DDD\s+2 manual page on standard
output and exit.  If the standard output is a terminal, the manual
page is shown in a pager (\fB$PAGER\fR, `\fBless\fR' or `\fBmore\fR').
See also the `\fB\-\-manual\fR' option, below.
.TP
.B "showVersion (\fPclass\fB ShowVersion)"
If `\fBtrue\fR', show the \s-2DDD\s+2 version on standard output and
exit.  See also the `\fB\-\-version\fR' option, below.
.TP
.B "traceDialog (\fPclass\fB Trace)"
If `\fBtrue\fR', show the dialog between \s-2DDD\s+2 and the
inferior debugger on standard output.  Default is `\fBfalse\fR'.
.TP
.B "traceShellCommands (\fPclass\fB Trace)"
If `\fBtrue\fR', show the programs invoked by \s-2DDD\s+2 on
standard output.  Default is `\fBfalse\fR'.
.\"
.\"
.\"
.SS "More Resources"
.\"
The `\fBDdd\fR' application defaults file contains even more
information about setting \s-2DDD\s+2 resources.  The `\fBDdd\fR'
file comes with the \s-2DDD\s+2 distribution.
.\"
.\"
.\" ---------------
.SH "ACTIONS"
.\" ---------------
.\"
.\"
The following \s-2DDD\s+2 actions may be used in translation tables.
.\"
.SS "General Actions"
.\"
These actions are used to assign the keyboard focus.
.TP
.B ddd\-next\-tab\-group ()
Assign focus to the next tab group.
.TP
.B ddd\-prev\-tab\-group ()
Assign focus to the previous tab group.
.TP
.B ddd\-previous\-tab\-group ()
Assign focus to the previous tab group.
.TP
.B ddd\-get\-focus ()
Assign focus to the element that just received input.
.\"
.\"
.\"
.SS "Data Display Actions"
.\"
These actions are used in the \s-2DDD\s+2 graph editor.
.TP
.B end ()
End the action initiated by \fBselect\fR.  Bound to a button up event.
.TP
.B extend ()
Extend the current selection.  Bound to a button down event.
.TP
.B extend\-or\-move ()
Extend the current selection.  Bound to a button down event.
If the pointer is dragged, move the selection.
.TP
.B follow ()
Continue the action initiated by \fBselect\fR.  Bound to a pointer
motion event.
.TP
.B hide\-edges (\fR[\fBany\fR|\fBboth\fR|\fBfrom\fR|\fBto\fR]\fB)
Hide some edges.  \fBany\fR means to process all edges where either
source or target node are selected. \fBboth\fR means to process all
edges where both nodes are selected. \fBfrom\fR means to process all
edges where at least the source node is selected. \fBto\fR means to
process all edges where at least the target node is selected.  Default
is \fBany\fR.
.TP
.B layout (\fR[\fBregular\fR|\fBcompact\fR]\fB, \fR[[\fB+\fR|\fB\-\fR]\fIdegrees\fR]]\fB)
Layout the graph.  \fBregular\fR means to use the regular layout
algorithm; \fBcompact\fR uses an alternate layout algorithm, where
successors are placed next to their parents.  Default is
\fBregular\fR.  \fIdegrees\fR indicates in which direction the graph
should be layouted.  Default is the current graph direction.
.TP
.B move\-selected (\fIx-offset\fB, \fIy-offset\fB)
Move all selected nodes in the direction given by \fIx-offset\fR and
\fIy-offset\fR.  \fIx-offset\fR and \fIy-offset\fR is either given as
a numeric pixel value, or as `\fB+grid\fR', or `\fB\-grid\fR', meaning
the current grid size.
.TP
.B normalize ()
Place all nodes on their positions and redraw the graph.
.TP
.B rotate (\fR[[\fB+\fR|\fB\-\fR]\fIdegrees\fR]\fB)
Rotate the graph around \fIdegrees\fR degrees.  
\fIdegrees\fR must be a multiple of 90.  Default is \fB+90\fR.
.TP
.B select ()
Select the node pointed at.  Clear all other selections.  Bound to a
button down event.
.TP
.B select\-all ()
Select all nodes in the graph.
.TP
.B select\-first ()
Select the first node in the graph.
.TP
.B select\-next ()
Select the next node in the graph.
.TP
.B select\-or\-move ()
Select the node pointed at.  Clear all other selections.  Bound to a
button down event. If the pointer is dragged, move the selected node.
.TP
.B select\-prev ()
Select the previous node in the graph.
.TP
.B show\-edges (\fR[\fBany\fR|\fBboth\fR|\fBfrom\fR|\fBto\fR]\fB)
Show some edges.  \fBany\fR means to process all edges where either
source or target node are selected. \fBboth\fR means to process all
edges where both nodes are selected. \fBfrom\fR means to process all
edges where at least the source node is selected. \fBto\fR means to
process all edges where at least the target node is selected.  Default
is \fBany\fR.
.TP
.B snap\-to\-grid ()
Place all nodes on the nearest grid position.
.TP
.B toggle ()
Toggle the current selection\(em\&if the node pointed at is selected,
it will be unselected, and vice versa.  Bound to a button down event.
.TP
.B toggle\-or\-move ()
Toggle the current selection\(em\&if the node pointed at is selected,
it will be unselected, and vice versa.  Bound to a button down event.
If the pointer is dragged, move the selection.
.TP
.B unselect\-all ()
Clear the selection.
.\"
.\"
.SS "Debugger Console Actions"
.\"
These actions are used in the debugger console and other text fields.
.TP
.B gdb\-backward\-character ()
Move one character to the left.  Bound to \fBCtrl+B\fR and \fBLeft\fR.
.TP
.B gdb\-beginning\-of\-line ()
Move cursor to the beginning of the current line, after the prompt.
Bound to \fBCtrl+A\fR and \fBHome\fR.
.TP
.B gdb\-control (\fIcontrol-character\fB)
Send the given \fIcontrol-character\fR to the inferior debugger.
The \fIcontrol-character\fR must be specified in the form `\fB^\fIX\fR',
where \fIX\fR is an upper-case letter or `\fB?\fR'.
Bound to \fBCtrl+C\fR and \fBCtrl+\\\fR.
.TP
.B gdb\-complete\-arg (\fIcommand\fB)
Complete current argument as if \fIcommand\fR was prepended.
Bound to \fBCtrl+T\fR.
.TP
.B gdb\-complete\-command ()
Complete current command line in the debugger console.
Bound to \s-2\fBTAB\fR\s+2 and \fBCtrl+T\fR.
.TP
.B gdb\-complete\-tab (\fIcommand\fB)
If global \s-2TAB\s+2 completion is enabled, complete current 
argument as if \fIcommand\fR was prepended.  Otherwise, proceed as if
the \s-2TAB\s+2 key was hit.  Bound to \s-2\fBTAB\fR\s+2.
.TP
.B gdb\-delete\-or\-control (\fIcontrol-character\fB)
Like \fBgdb-control\fR, but effective only if the cursor is at the end
of a line.  Otherwise, \fIcontrol-character\fR is ignored and the
character following the cursor is deleted.  Bound to \fBCtrl+D\fR.
.TP
.B gdb\-end\-of\-line ()
Move cursor to the end of the current line.  Bound to \fBCtrl+E\fR and
\fBEnd\fR.
.TP
.B gdb\-next\-history ()
Recall next command from history.  Bound to \fBCtrl+N\fR and \fBDown\fR.
.TP
.B gdb\-prev\-history ()
Recall previous command from history.  Bound to \fBCtrl+P\fR and \fBUp\fR.
.TP
.B gdb\-previous\-history ()
Recall previous command from history.  Bound to \fBCtrl+P\fR and \fBUp\fR.
.TP
.B gdb\-forward\-character ()
Move one character to the right.  Bound to \fBCtrl+F\fR and \fBRight\fR.
.TP
.B gdb\-insert\-graph\-arg ()
Insert the contents of the data display argument field `\fB()\fR'.
.TP
.B gdb\-insert\-source\-arg ()
Insert the contents of the source argument field `\fB()\fR'.
.TP
.B gdb\-isearch\-prev ()
Enter reverse incremental search mode.  Bound to \fBCtrl+R\fR.
.TP
.B gdb\-isearch\-next ()
Enter incremental search mode.  Bound to \fBCtrl+S\fR.
.TP
.B gdb\-isearch\-exit ()
Exit incremental search mode.  Bound to \s-2\fBESC\fR\s+2.
.TP
.B gdb\-set\-line (\fIvalue\fB)
Set the current line to \fIvalue\fR.  Bound to \fBCtrl+U\fR.
.\"
.\" ---------------
.SH "OPTIONS"
.\" ---------------
.\"
You can use the following options when starting \s-2DDD\s+2.  All
options may be abbreviated, as long as they are unambiguous; single
dashes may also be used.  \s-2DDD\s+2 also understands the usual X
options such as `\fB\-display\fR' or `\fB\-geometry\fR'; see
\fBX(1)\fR for details.
.PP
All other arguments and options are passed to the inferior debugger.
To pass an option to the inferior debugger that conflicts with an X
option, or with a \s-2DDD\s+2 option listed here, use the
`\fB\-\-debugger\fR' option, below.
.PP
.\"
.TP
.B \-\-attach\-windows
Attach the source and data windows to the debugger console, creating
one single big \s-2DDD\s+2 window.  This is the default setting.
.TP
.B \-\-attach\-source\-window
Attaches only the source window to the debugger console.
.TP
.B \-\-attach\-data\-window
Attaches only the source window to the debugger console.
.TP
.B \-\-button\-tips
Enable button tips.
.TP
.B \-\-configuration
Show the \s-2DDD\s+2 configuration settings and exit.
.TP
.B \-\-check\-configuration
Check the \s-2DDD\s+2 environment (in particular, the X configuration),
report any possible problem causes and exit.
.TP
.B \-\-dbx
Run the \s-2DBX\s+2 debugger as inferior debugger.
.TP
.B \-\-debugger \fIname\fR
Invoke the inferior debugger \fIname\fR.  This is useful if you have
several debugger versions around, or if the inferior debugger cannot
be invoked as `\fBgdb\fR', `\fBdbx\fR', or `\fBxdb\fR', respectively.
This option can also be used to pass options to the inferior debugger
that would otherwise conflict with \s-2DDD\s+2 options.
For instance, to pass a `\fB\-d \fIdirectory\fR' option to \s-2XDB\s+2, use:
.sp
.br
  \fBddd\ \-\-debugger "xdb \-d \fIdirectory\fB"\fR
.br
.sp
.TP
.B \-\-disassemble
Disassemble the source code.  See also the `\fB\-\-no\-disassemble\fR'
option, below.
.TP
.B \-\-exec\-window
Run the debugged program in a specially created execution window.
This is useful for programs that have special terminal requirements
not provided by the debugger window, as raw keyboard processing or
terminal control sequences.
.TP
.B \-\-fullname
Enable \s-2TTY\s+2 interface, taking additional debugger commands
from standard input and forwarding debugger output on standard output.
Current positions are issued in \s-2GDB\s+2 `\fB\-fullname\fR' format
suitable for debugger front-ends.
.TP
.B \-\-gdb
Run the \s-2GDB\s+2 debugger as inferior debugger.
.TP
.B \-\-glyphs
Display the current execution position and breakpoints as glyphs.
See also the `\fB\-\-no\-glyphs\fR' option, below.
.TP
.B \-\-help
Give a list of frequently used options.  Show options of the
inferior debugger as well.
.TP
.B \-\-host \fIhostname\fR
Invoke the inferior debugger directly on the remote host \fIhostname\fR.  See
`\fBREMOTE DEBUGGING\fR', above.
.TP
.B \-\-license
Show the \s-2DDD\s+2 license and exit.
.TP
.B \-\-login \fIusername\fR
Use \fIusername\fR as remote user name.  See `\fBREMOTE DEBUGGING\fR', above.
.TP
.B \-\-manual
Show this manual page and exit.
.TP
.B \-\-no\-button\-tips
Disable button tips.
.TP
.B \-\-no\-data\-window
Do not create the data window upon start-up.
.TP
.B \-\-no\-debugger\-console
Do not create the debugger console upon start-up.
.TP
.B \-\-no\-disassemble
Do not disassemble the source code.
.TP
.B \-\-no\-exec\-window
Do not run the debugged program in a specially created execution
window; use the debugger console instead.  Useful for programs that have
little terminal input/output, or for remote debugging.
.TP
.B \-\-no\-glyphs
Display the current execution position and breakpoints as text
characters.  Do not use glyphs.
.TP
.B \-\-no\-source\-window
Do not create the source window upon start-up.
.TP
.B \-\-no\-value\-tips
Disable value tips.
.TP
.B \-\-nw
Do not use the X window interface.  Start the inferior debugger on
the local host.
.TP
.B \-\-panned\-graph\-editor
Use an Athena panner to scroll the data window.  Most people prefer
panners on scroll bars, since panners allow two-dimensional scrolling.
However, the panner is off by default, since some Motif
implementations do not work well with Athena widgets.  See also
\fB\-\-scrolled\-graph\-editor\fR, below.
.TP
.B \-\-rhost \fIhostname\fR
Run the inferior debugger interactively on the remote host \fIhostname\fR.
See `\fBREMOTE DEBUGGING\fR', above.
.TP
.B \-\-separate\-windows
Separate the console, source and data windows.  See also the
`\fB\-\-attach\fR' options, above.
.TP
.B \-\-scrolled\-graph\-editor
Use Motif scroll bars to scroll the data window.  This is the default
in most \s-2DDD\s+2 configurations.  See also
\fB\-\-panned\-graph\-editor\fR, above.
.TP
.B \-\-status\-at\-bottom
Place the status line at the bottom of the source window.
.TP
.B \-\-status\-at\-top
Place the status line at the top of the source window.
.TP
.B \-\-sync\-debugger
Do not process X events while the debugger is busy.  This may result
in slightly better performance on single-processor systems.
.TP
.B \-\-trace\-dialog
Show the interaction between \s-2DDD\s+2 and the inferior debugger
on standard error.  This is useful for debugging \s-2DDD\s+2.
.TP
.B \-\-trace\-shell\-commands
Show the shell commands issued by \s-2DDD\s+2 on standard error.  This
is useful for debugging \s-2DDD\s+2.
.TP
.B \-\-trace
Show both interaction and shell commands.
.TP
.B \-\-tty
Enable \s-2TTY\s+2 interface, taking additional debugger commands
from standard input and forwarding debugger output on standard output.
Current positions are issued in a format readable for humans.
.TP
.B \-\-value\-tips
Enable value tips.
.TP
.B \-\-version
Show the \s-2DDD\s+2 version and exit.
.TP
.B \-\-vsl\-library \fIlibrary\fR
Load the \s-2VSL\s+2 library \fIlibrary\fR instead of using the
\s-2DDD\s+2 built-in library.  This is useful for customizing
display shapes and fonts.
.TP
.B \-\-vsl\-path \fIpath\fR
Search \s-2VSL\s+2 libraries in \fIpath\fR (a colon-separated
directory list).
.TP
.B \-\-vsl\-help
Show a list of further options controlling the \s-2VSL\s+2
interpreter.  These options are intended for debugging purposes and
are subject to change without further notice.
.TP
.B \-\-xdb
Run \s-2XDB\s+2 as inferior debugger.
.\"
.\" ---------------
.SH "FILES"
.\" ---------------
.\"
.PD 0
.TP 20
.B $HOME/.dddinit
Individual \s-2DDD\s+2 resource file.  \s-2DDD\s+2 options are saved here.
.TP
.B $HOME/.ddd_history
Default \s-2DDD\s+2 command history file.
.TP
.B $HOME/.gdbinit
\s-2GDB\s+2 initialization file.
.TP
.B $HOME/.dbxinit
\s-2DBX\s+2 initialization file.
.TP
.B $HOME/.dbxrc
Alternate \s-2DBX\s+2 initialization file.
.TP
.B $HOME/.xdbrc
\s-2XDB\s+2 initialization file.
.PD
.\"
.\" ---------------
.SH "SEE ALSO"
.\" ---------------
.BR X (1),
.BR gdb (1),
.BR dbx (1),
.BR xdb (1),
.BR remsh (1),
.BR rsh (1)
.PP
.RB "`\|" gdb "\|'"
entry in
.B info.
.PP
.I
Using \s-2GDB\s+2: A Guide to the \s-2GNU\s+2 Source-Level Debugger\c
\&, by Richard M. Stallman and Roland H. Pesch.
.PP
.I
\s-2DDD\s+2\(em\&A Free Graphical Front-End for \s-2UNIX\s+2 Debuggers\c
\&, by Andreas Zeller and Dorothea L\o'"u'tkehaus, Computer Science Report
95-07, Technische Universit\o'"a't Braunschweig, 1995.
.PP
.I
\s-2DDD\s+2 \(em ein Debugger mit graphischer Datendarstellung\c
\&, by Dorothea L\o'"u'tkehaus, Diploma Thesis, Technische
Universit\o'"a't Braunschweig, 1994.
.PP
The \s-2DDD\s+2 
.IR "\s-2FTP\s+2 site" ,
.sp
.br
  \fBftp://ftp.ips.cs.tu-bs.de/pub/local/softech/ddd/\fR
.br
.sp
.PP
The \s-2DDD\s+2
.IR "World-Wide-Web page" ,
.sp
.br
  \fBhttp://www.cs.tu-bs.de/softech/ddd/\fR
.br
.sp
.PP
The \s-2DDD\s+2
.IR "Mailing List" ,
.sp
.br
   \fBddd-users@ips.cs.tu-bs.de\fR
.br
.sp
For more information on this list, send a mail to
.sp
.br
   \fBddd-users-request@ips.cs.tu-bs.de\fR  .
.br
.sp
.PP
.\"
.\" ---------------
.SH LIMITATIONS
.\" ---------------
.\"
.SS "Limitations using GDB"
.\"
Some \s-2GDB\s+2 settings are essential for \s-2DDD\s+2 to work correctly.
These settings with their correct values are:
.sp
.br
  \fBset height 0\fR
.br
  \fBset width 0\fR
.br
  \fBset print repeats 0\fR
.br
  \fBset verbose off\fR
.br
  \fBset prompt (gdb) \fR
.br
.sp
\s-2DDD\s+2 sets these values automatically when invoking \s-2GDB\s+2.
.PP
If these values are changed, there may be some malfunctions,
especially in the data display.  If you want to display C strings
(i.e., `\fBchar *\fR'-fields), it might be useful to change the
settings of `\fBprint repeats\fR' and `\fBprint elements\fR'.  But to
recognize array structures correctly, you should have `\fBprint
repeats\fR' set to 0.  Also, do not change the setting of `\fBprint
elements\fR' while there are array structures in the data display.
.PP
When debugging at the machine level with \s-2GDB\s+2 4.12 and earlier
as inferior debugger, use a `\fBdisplay /x $pc\fR' command to ensure
the program counter value is updated correctly at each stop.  You may
also enter the command in \fB$HOME/.gdbinit\fR or (better yet) upgrade
to the most recent \s-2GDB\s+2 version.
.PP
.\"
.SS "Limitations using DBX"
.\"
When used for debugging Modula-2 or Pascal programs, \s-2DDD\s+2
always numerates array elements starting with zero, instead of using
correct array subscripts.
.PP
With some \s-2DBX\s+2 versions (notably Solaris \s-2DBX\s+2),
\s-2DDD\s+2 strips C-style and C++-style comments from the
\s-2DBX\s+2 output in order to interpret it properly.  This also
affects the output of the debugged program when sent to the debugger
console.  Using the separate execution window avoids these problems.
.PP
In some \s-2DBX\s+2 versions (notably \s-2DEC\s+2 \s-2DBX\s+2 and
\s-2AIX\s+2 \s-2DBX\s+2), there is no automatic data display.
As an alternative, \s-2DDD\s+2 uses the `\fBprint\fR' command to
access data values.  This means that variable names are interpreted
according to the current frame; variables outside the current frame
cannot be displayed.
.\"
.SS "Limitations using XDB"
.\"
There is no automatic data display in \s-2XDB\s+2.  As a workaround,
\s-2DDD\s+2 uses the `\fBp\fR' command to access data values.  This
means that variable names are interpreted according to the current
frame; variables outside the current frame cannot be displayed.
.\"
.SS "General Limitations"
.\"
If command output is sent to the debugger console, it is impossible
for \s-2DDD\s+2 to distinguish between the output of the debugged
program and the output of the inferior debugger.  For instance, if
your program output includes debugger prompts or debugger-like output,
\s-2DDD\s+2 will likely become confused.  To avoid such problems,
use the separate execution window.
.PP
If the inferior debugger changes the default \s-2TTY\s+2 settings, for
instance through a `\fBstty\fR' command in its initialization file,
\s-2DDD\s+2 will likely become confused.  The same applies to
debugged programs which change the default \s-2TTY\s+2 settings.
.\"
.\"
.\"
.\" ---------------
.SH "REPORTING BUGS"
.\" ---------------
.\"
If you find a bug in \s-2DDD\s+2, please send us a bug report.  We
will either attempt to fix the bug\(em\&or include the bug description
in the \s-2DDD\s+2 `\fBBUGS\fR' file, such that others can attempt
to fix it.  (Instead of sending bug reports, you may also send
\fIfixes\fR; \s-2DDD\s+2 is an excellent tool for debugging itself
:-)
.\"
.SS "Where to Send Bug Reports"
.\"
We recommend that you send bug reports for \s-2DDD\s+2 via electronic
mail to
.sp
.br
  \fBddd-bugs@ips.cs.tu-bs.de\fR
.br
.sp
As a last resort, send bug reports on paper to:
.sp
.br
.DS
  Technische Universit\o'"a't Braunschweig 
.br
  Institut f\o'"u'r Programmiersprachen
.br
  und Informationssysteme 
.br
  Abteilung Softwaretechnologie 
.br
  \s-2DDD\s+2-Bugs 
.br
  B\o'"u'ltenweg 88
.br
  D-38092 Braunschweig 
.br
  \s-2GERMANY\s+2 
.br
.DE
.\"
.SS "Is it a \s-2DDD\s+2 Bug?"
.\"
Before sending in a bug report, try to find out whether the problem
cause really lies within \s-2DDD\s+2.  A common cause of problems
are incomplete or missing X or Motif installations, for instance, or
bugs in the X server or Motif itself.  Running \s-2DDD\s+2 as
.br
.sp
  \fBddd \-\-check\-configuration\fR
.sp
.br
checks for common problems and gives hints on how to repair them.
.PP
Another potential cause of problems is the inferior debugger;
occasionally, they show bugs, too.  To find out whether a bug was
caused by the inferior debugger, run \s-2DDD\s+2 as
.br
.sp
  \fBddd \-\-trace\fR
.sp
.br
This shows the dialog between \s-2DDD\s+2 and the inferior debugger
on standard error while \s-2DDD\s+2 is running.  Compare the
debugger output to the output of \s-2DDD\s+2 and determine which one
is wrong.
.\"
.SS "How to Report Bugs"
.\"
Here are some guidelines for bug reports:
.br
.IP \(bu 2
The fundamental principle of reporting bugs usefully is this:
\fIreport all the facts\fR.  If you are not sure whether to state a fact or
leave it out, state it!
.br
.IP \(bu 2
Keep in mind that the purpose of a bug report is to enable someone to
fix the bug if it is not known.  It is not very important what happens
if the bug is already known.  Therefore, always write your bug reports
on the assumption that the bug is not known.
.br
.IP \(bu 2
Your bug report should be self-contained.  Do not refer to information
sent in previous mails; your previous mail may have been forwarded to
somebody else.
.br
.IP \(bu 2
Please report each bug in a separate message.  This makes it easier
for us to track which bugs have been fixed and to forward your bugs
reports to the appropriate maintainer.
.br
.IP \(bu 2
Please report bugs in English; this increases the chances of finding
someone who can fix the bug.  Do not assume one particular person will
receive your bug report.
.br
.PP
.\"
.SS "What to Include in a Bug Report"
.\"
To enable us to fix a \s-2DDD\s+2 bug, you \fImust\fR include the
following information:
.br
.IP \(bu 2
Your \s-2DDD\s+2 configuration.  Invoke \s-2DDD\s+2 as
.br
.sp
  \fBddd \-\-configuration\fR
.sp
.br
to get the configuration information.  If this does not work, please
include at least the \s-2DDD\s+2 version, the type of machine you
are using, and its operating system name and version number.
.br
.IP \(bu 2
The debugger you are using and its version (e.g., `\fBgdb-4.16\fR' or
`\fBdbx as shipped with Solaris 2.5\fR').
.br
.IP \(bu 2
The compiler you used to compile \s-2DDD\s+2 and its version (e.g.,
`\fBgcc-2.8.0\fR').
.br
.IP \(bu 2
A description of what behavior you observe that you believe is
incorrect.  For example, \*(lq\s-2DDD\s+2 gets a fatal signal\*(rq or
\*(lq\s-2DDD\s+2 exits immediately after attempting to create the data
window\*(lq.
.br
.IP \(bu 2
If possible, include a \fIdialog trace\fR showing the interaction
between \s-2DDD\s+2 and the inferior debugger.  Such a dialog
trace is created by invoking \s-2DDD\s+2 with the `\fB\-\-trace\fR'
option.  Include all trace output from the \s-2DDD\s+2 invocation up
to the first bug occurrence.
.br
.IP \(bu 2
If you wish to suggest changes to the \s-2DDD\s+2 source, send us context
diffs.  If you even discuss something in the \s-2DDD\s+2 source, refer to
it by context, \fInever\fR by line number.
.PP
Be sure to include this information in \fIevery\fR single bug report.
.\"
.\"
.\" ---------------
.SH HISTORY
.\" ---------------
The history of \s-2DDD\s+2 is a story of code recycling.  The oldest
parts of \s-2DDD\s+2 were written in 1990, when \fIAndreas Zeller\fR
designed \s-2VSL\s+2, a box-based visual structure language for
visualizing data and program structures.  The \s-2VSL\s+2 interpreter
and the \s-2BOX\s+2 library became part of Andreas' Diploma Thesis, a
graphical syntax editor based on the Programming System Generator
\s-2PSG\s+2.
.PP
In 1992, the \s-2VSL\s+2 and Box libraries were recycled for the
\s-2NORA\s+2 project.  For \s-2NORA\s+2, an experimental
inference-based software development tool set, Andreas wrote a graph
editor (based on \s-2VSL\s+2 and the \s-2BOX\s+2 libraries) and
facilities for inter-process knowledge exchange.  Based on these
tools, \fIDorothea L\o'"u'tkehaus\fR realized \s-2DDD\s+2 as her Diploma
Thesis, 1994.
.PP
The original \s-2DDD\s+2 had no source window; this was added by
Dorothea during the winter of 1994/1995.  In the first quarter of
1995, finally, Andreas completed \s-2DDD\s+2 by adding command and
execution windows, extensions for \s-2DBX\s+2 and remote debugging as
well as configuration support for several architectures.  Since then,
many people have contributed to the success of \s-2DDD\s+2; see the
file `\fBCONTRIBUTORS\fR' in the \s-2DDD\s+2 distribution for
details.
.PP
Major \s-2DDD\s+2 events:
.PD 0
.TP 20
April, 1995
\s-2DDD\s+2 0.9: First \s-2DDD\s+2 beta release
.TP
May, 1995
\s-2DDD\s+2 1.0: First public \s-2DDD\s+2 release
.TP
December, 1995
\s-2DDD\s+2 1.4: Machine-level debugging, glyphs, \s-2EMACS\s+2 integration
.TP
October, 1996
\s-2DDD\s+2 2.0: Color displays, \s-2XDB\s+2 support, generic
\s-2DBX\s+2 support, command tool.
.TP
May, 1997
\s-2DDD\s+2 2.1: Alias detection, button tips, status displays.
.PD
.\"
.\"
.\" ---------------
.SH "EXTENDING DDD"
.\" ---------------
.\"
If you have any contributions to be incorporated into \s-2DDD\s+2,
please send them to `\fBddd@ips.cs.tu-bs.de\fR'.  For suggestions on
what might be done, see the file `\fBTODO\fR' in the \s-2DDD\s+2
distribution.
.\"
.\" ---------------
.SH "IF YOU LIKE DDD..."
.\" ---------------
.\"
If you appreciate this software, or have any suggestions, 
please send us a picture postcard.  Our address is:
.PP
.DS
  Technische Universit\o'"a't Braunschweig 
.br
  Institut f\o'"u'r Programmiersprachen
.br
  und Informationssysteme 
.br
  Abteilung Softwaretechnologie 
.br
  B\o'"u'ltenweg 88
.br
  D-38092 Braunschweig 
.br
  \s-2GERMANY\s+2 
.br
.DE
.PP
You may also leave a message in the \s-2DDD\s+2 Guestbook.
It is accessible via our \s-2DDD\s+2 \s-2WWW\s+2 page,
.sp
.br
  \fBhttp://www.cs.tu-bs.de/softech/ddd/\fR .
.br
.sp
.\" --------------------
.SH PRINTING THIS MANUAL
.\" --------------------
.\"
Invoke \s-2DDD\s+2 with the `\fB\-\-manual\fR' option to show this
manual page on standard output.  This text output is suitable for
installation as formatted manual page (as
`\fB/usr/local/man/cat1/ddd.1\fR' or similar) on \s-2UNIX\s+2 systems.
.PP
A PostScript copy of this manual page, including several \s-2DDD\s+2
screen shots and diagrams, is included in the \s-2DDD\s+2 source
distribution and available separately as `\fBddd.man.ps.gz\fR' in
.sp
.br
  \fBftp://ftp.ips.cs.tu-bs.de/pub/local/softech/ddd/doc/\fR
.br
.sp
This directory also contains other documentation related to \s-2DDD\s+2.
.PP
A \s-2ROFF\s+2 copy of this manual page, suitable for installation as
manual page on \s-2UNIX\s+2 systems (as
`\fB/usr/local/man/man1/ddd.1\fR' or similar), is included in the
\s-2DDD\s+2 source distribution.
.sp
.PP
.\"
.\"
.\" ---------------
.SH COPYRIGHT
.\" ---------------
.\"
\s-2DDD\s+2 is Copyright \(co 1995, 1996, 1997
Technische Universit\o'"a't Braunschweig, Germany.
.PP
\s-2DDD\s+2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
.PP
\s-2DDD\s+2 is distributed in the hope that it will be useful,
but \fIwithout any warranty\fR; without even the implied warranty of
\fImerchantability\fR or \fIfitness for a particular purpose\fR.
See the License for more details.
.PP
You should have received a copy of the License along with
\s-2DDD\s+2.  If not, invoke \s-2DDD\s+2 with the
`\fB\-\-license\fR' option; this will print a copy on standard
output.  To read the License from within \s-2DDD\s+2, use the
`\fBDDD License...\fR' item in the `\fBHelp\fR' menu.
.PP
This \s-2DDD\s+2 manual page is Copyright \(co 1995, 1996, 1997
Technische Universit\o'"a't Braunschweig, Germany.
.PP
Permission is granted to make and distribute verbatim copies of this
manual page provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual page under the conditions for verbatim copying, provided that
the entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual page into another language, under the above conditions for
modified versions, except that this permission notice may be included
in translations approved by the Free Software Foundation instead of in
the original English.
