# An Example Program Showing How Environments Work
# ================================================
# Last modified June 2 1995, S.G.

# Help Description to be added to the help menu
#----------------------------------------------
set help_title "Environment Example"

set help_text  {
 {normal} {This tutorial application shows how the standard environments\
 maintained by GroupKit can be queried, how new environments can be created,\
 and how environments can be shared. Its interface displays 

-several existing environment statistics,

-a user created date which is updated every few seconds

-a shared environment containing a global counter which is incremented\
 by a participant pressing a button.
}}

# Procedures
#===========

# Display a variety of information in the environment
proc displayEnvironment {} {
    .message_stack delete 0 end
    insertInfo .message_stack [local_env date] ""
    insertInfo .message_stack "Global Counter:" [shared_env globalcounter]
    insertInfo .message_stack "Connections" ""
    insertInfo .message_stack "- Internet:" [userprefs internetdomain]
    insertInfo .message_stack "- Registrar:" [registrar host]
    insertInfo .message_stack "Local Participant" ""
    insertInfo .message_stack "- Number:" [users local.usernum]
    insertInfo .message_stack "- Name:" [users local.username]
    foreach number [users keys remote] {
       insertInfo .message_stack "Remote Participant" ""
       insertInfo .message_stack "- Number:" [users remote.$number.usernum]
       insertInfo .message_stack "- Name:" [users remote.$number.username]
    }
}

#Insert the information into the listbox
proc insertInfo {w message content} {
	$w insert end [concat $message $content]
}

# Update an environment every 3 seconds to contain the current date
proc setDate {} {
    local_env date [gk_info date]
    after 3000 setDate
}

# Main
#=====
gk_initConf $argv

# Construct the application window, a "Message Stack" that displays events,
# and a button for incrementing a counter
wm minsize . 60 20
gk_defaultMenu .menubar
.menubar itemcommand 2 add command \
       -label "$help_title" \
       -command "gk_topicWindow .helpWindow \
                    -title \"$help_title\" \
                    -text \"$help_text\""
listbox .message_stack -width 40 -height 15 -bd 2 -relief ridge
button .counter_button -text "Increment Global Counter" \
	-command {shared_env globalcounter [expr 1+[shared_env globalcounter]]}
pack .menubar -side top -fill x
pack .message_stack -side top  -fill both -expand t
pack .counter_button -side top

# Create the new local environment, set the date in it, and attach event 
# notification to it
gk_newenv -bind local_env
setDate

# Create a new shared environment that contains a global counter
gk_newenv -bind -share shared_env
shared_env globalcounter 0

# Handle events generated by the environments
# Whenever the shared environment gets changed, update the display
shared_env bind changeEnvInfo displayEnvironment

# Whenever the local environment gets changed, update the display
local_env bind changeEnvInfo displayEnvironment

# We need to "touch" our environment to propagate it to the new participant
gk_bind updateEntrant {shared_env globalcounter [shared_env globalcounter]}
