;;; All the nationalities of the modern world, weighted by approx population
;;; in millions. Weights are based on 1990 population estimates, with a ceiling
;;; of 100, so we can have a chance of games with other than Chinese and
;;; Indian sides...

;;; Note that the "name" of a side is not defined, since the names correspond
;;; better to the physical countries, not nationalities (a subtle distinction).

#| should add these in...
Kazakhstan	Kazakh		 16
Kirghizistan	Kirghiz		  4
Latvia		Latvian		  3
Lithuania	Lithuanian	  4
Tajikistan	Tajik		  4
Turkmenistan	Turkman		  3
Uzbekistan	Uzbek		 17
|#

(set side-library '(
  (17 (noun "Afghan") (emblem-name "flag-afghanistan"))
  (3 (noun "Albanian") (emblem-name "flag-albania"))
  (25 (noun "Algerian") (emblem-name "flag-algeria"))
  (100 #|250|# (noun "American") (emblem-name "flag-usa"))
  (10 (noun "Angolan") (emblem-name "flag-angola"))
  (3 (noun "Armenian") (emblem-name "flag-armenia"))
  (32 (noun "Argentinian") (emblem-name "flag-argentina"))
  (17 (noun "Australian") (emblem-name "flag-australia"))
  (7 (noun "Austrian") (emblem-name "flag-austria"))
  (7 (noun "Azerbaijani") (emblem-name "flag-azerbaijan"))
  (100 #|116|# (noun "Bangladeshi") (emblem-name "flag-bangladesh"))
  (10 (noun "Belgian") (emblem-name "flag-belgium"))
  (10 (noun "Belarussian") (emblem-name "flag-belarus"))
  (5 (noun "Beninese") (emblem-name "flag-benin"))
  (7 (noun "Bolivian") (emblem-name "flag-bolivia"))
  ;; The noun and plural-noun below are *not* typos!
  ((noun "Motswana") (plural-noun "Batswana") (emblem-name "flag-botswana"))
  (100 #|150|# (noun "Brazilian") (emblem-name "flag-brazil"))
  (57 (noun "British") (emblem-name "flag-uk"))
  (9 (noun "Bulgarian") (emblem-name "flag-bulgaria"))
  (42 (noun "Burmese") (emblem-name "flag-burma"))
  (8 (noun "Cambodian") (emblem-name "flag-cambodia"))
  (11 (noun "Cameroonian") (emblem-name "flag-cameroon"))
  (27 (noun "Canadian") (emblem-name "flag-canada"))
  (13 (noun "Chilean") (emblem-name "flag-chile"))
  (100 #|1135|# (noun "Chinese") (emblem-name "flag-china"))
  (31 (noun "Colombian") (emblem-name "flag-colombia"))
  (2 (noun "Congolese") (emblem-name "flag-congo"))
  (3 (noun "Costa Rican") (emblem-name "flag-costa-rica"))
  (10 (noun "Cuban") (emblem-name "flag-cuba"))
  ((noun "Cypriot") (emblem-name "flag-cyprus"))
  (10 (noun "Czech") (emblem-name "flag-czech"))
; add back in when we get a picture of the Slovakian flag
;  (6 (noun "Slovakian") (emblem-name "flag-slovakia"))
  (5 (noun "Danish") (emblem-name "flag-denmark"))
  ((noun "Djiboutian") (emblem-name "flag-djibouti"))
  (15 (noun "Dutch") (emblem-name "flag-netherlands"))
  (11 (noun "Ecuadorean") (emblem-name "flag-ecuador"))
  (54 (noun "Egyptian") (emblem-name "flag-egypt"))
  (2 (noun "Estonian") (emblem-name "flag-estonia"))
  (47 (noun "Ethiopian") (emblem-name "flag-ethiopia"))
  ((noun "Fijian") (emblem-name "flag-fiji"))
  (65 (noun "Filipino") (adjective "Philippine") (emblem-name "flag-philippines"))
  (5 (noun "Finn") (adjective "Finnish") (emblem-name "flag-finland"))
  (56 (noun "French") (emblem-name "flag-france"))
  ((noun "Gabonese") (emblem-name "flag-gabon"))
  (5 (noun "Georgian") (emblem-name "flag-georgia"))
  (76 (noun "German") (emblem-name "flag-germany"))
  (15 (noun "Ghanaian") (emblem-name "flag-ghana"))
  (10 (noun "Greek") (emblem-name "flag-greece"))
  (9 (noun "Guatemalan") (emblem-name "flag-guatemala"))
  (7 (noun "Guinean") (emblem-name "flag-guinea"))
  ((noun "Guyanese") (emblem-name "flag-guyana"))
  (7 (noun "Haitian") (emblem-name "flag-haiti"))
  (5 (noun "Honduran") (emblem-name "flag-honduras"))
  (11 (noun "Hungarian") (emblem-name "flag-hungary"))
  ((noun "Icelander") (adjective "Icelandic") (emblem-name "flag-iceland"))
  (100 #|853|# (noun "Indian") (emblem-name "flag-india"))
  (181 (noun "Indonesian") (emblem-name "flag-indonesia"))
  (57 (noun "Iranian") (emblem-name "flag-iran"))
  (19 (noun "Iraqi") (emblem-name "flag-iraq"))
  (4 (noun "Irish") (emblem-name "flag-ireland"))
  (5 (noun "Israeli") (emblem-name "flag-israel"))
  (57 (noun "Italian") (emblem-name "flag-italy"))
  (3 (noun "Jamaican") (emblem-name "flag-jamaica"))
  (100 #|123|# (noun "Japanese") (emblem-name "flag-japan"))
  (4 (noun "Jordanian") (emblem-name "flag-jordan"))
  (25 (noun "Kenyan") (emblem-name "flag-kenya"))
  (65 (noun "Korean") (emblem-name "flag-korea"))
  (2 (noun "Kuwaiti") (emblem-name "flag-kuwait"))
  (4 (noun "Laotian") (emblem-name "flag-laos"))
  (3 (noun "Lebanese") (emblem-name "flag-lebanon"))
  (3 (noun "Liberian") (emblem-name "flag-liberia"))
  (5 (noun "Libyan") (emblem-name "flag-libya"))
  (12 (noun "Madagascaran") (emblem-name "flag-madagascar"))
  (17 (noun "Malaysian") (emblem-name "flag-malaysia"))
  ((noun "Maltese") (emblem-name "flag-malta"))
  (2 (noun "Mauritanian") (emblem-name "flag-mauritania"))
  (89 (noun "Mexican") (emblem-name "flag-mexico"))
  ((noun "Micronesian") (emblem-name "flag-micronesia"))
  (4 (noun "Moldovan") (emblem-name "flag-moldova"))
  (2 (noun "Mongolian") (emblem-name "flag-mongolia"))
  (25 (noun "Moroccan") (emblem-name "flag-morocco"))
  (16 (noun "Mozambican") (emblem-name "flag-mozambique"))
  (2 (noun "Namibian") (emblem-name "flag-namibia"))
  (19 (noun "Nepalese") (emblem-name "flag-nepal"))
  (3 (noun "New Zealander") (emblem-name "flag-new-zealand"))
  (4 (noun "Nicaraguan") (emblem-name "flag-nicaragua"))
  (100 #|113|# (noun "Nigerian") (emblem-name "flag-nigeria"))
  (4 (noun "Norwegian") (emblem-name "flag-norway"))
  ((noun "Omani") (emblem-name "flag-oman"))
  (100 #|123|# (noun "Pakistani") (emblem-name "flag-pakistan"))
  (2 (noun "Panamanian") (emblem-name "flag-panama"))
  ((noun "Papuan") (emblem-name "flag-papua"))
  (4 (noun "Paraguayan") (emblem-name "flag-paraguay"))
  (22 (noun "Peruvian") (emblem-name "flag-peru"))
  (38 (noun "Polish") (emblem-name "flag-poland"))
  (10 (noun "Portuguese") (emblem-name "flag-portugal"))
  (23 (noun "Romanian") (emblem-name "flag-romania"))
  (100 #|148|# (noun "Russian") (emblem-name "flag-russia"))
  (7 (noun "Rwandan") (emblem-name "flag-rwanda"))
  (14 (noun "Saudi") (emblem-name "flag-saudi"))
  (7 (noun "Senegalese") (emblem-name "flag-senegal"))
  (56 (noun "Siamese") (emblem-name "flag-thailand"))
  ((noun "Slovenian") (emblem-name "flag-slovenia"))
  (7 (noun "Somalian") (emblem-name "flag-somalia"))
  (35 (noun "South African") (emblem-name "flag-south-africa"))
  (39 (noun "Spanish") (emblem-name "flag-spain"))
  (17 (noun "Sri Lankan") (emblem-name "flag-sri-lanka"))
  (25 (noun "Sudanese") (emblem-name "flag-sudan"))
  (8 (noun "Swede") (adjective "Swedish") (emblem-name "flag-sweden"))
  (7 (noun "Swiss") (emblem-name "flag-switzerland"))
  (13 (noun "Syrian") (emblem-name "flag-syria"))
  (27 (noun "Tanzanian") (emblem-name "flag-tanzania"))
  (3 (noun "Togolese") (emblem-name "flag-togo"))
  ((noun "Tongan") (emblem-name "flag-tonga"))
  (8 (noun "Tunisian") (emblem-name "flag-tunisia"))
  (56 (noun "Turk") (emblem-name "flag-turkey"))
  (18 (noun "Ugandan") (emblem-name "flag-uganda"))
  (52 (noun "Ukrainian") (emblem-name "flag-ukraine"))
  (3 (noun "Uruguayan") (emblem-name "flag-uruguay"))
  (20 (noun "Venezuelan") (emblem-name "flag-venezuela"))
  (67 (noun "Vietnamese") (emblem-name "flag-vietnam"))
  (11 (noun "Yemeni") (emblem-name "flag-yemen"))
  (36 (noun "Zairean") (emblem-name "flag-zaire"))
  (8 (noun "Zambian") (emblem-name "flag-zambia"))
  (10 (noun "Zimbabwean") (emblem-name "flag-zimbabwe"))
  ))
