//===============================================================
// vglcnv.h GL Canvas C++ class .h file - X11R5
//
// Copyright (C) 1995,1996  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================

#ifndef VGLCNV_H
#define VGLCNV_H

#include <v/v_defs.h>		// Basic defs
#include <v/vapp.h>		// for theApp
#include <v/vpane.h>		// we are derived from vPane
#include <v/vfont.h>		// for font stuff

extern "C"
{
#include <X11/Xlib.h>
#include <X11/cursorfont.h>

// OpenGL stuff here

#include <X11/GLw/GLwDrawA.h>	// Xt OpenGL drawing area widget.
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glx.h>


    void CchangeCB(Widget w, XtPointer client_data, XtPointer call_data);

    void CHJumpProcCB(Widget w, XtPointer This, XtPointer pc_ptr);
    void CHScrollProcCB(Widget w, XtPointer This, XtPointer position);
    void CVJumpProcCB(Widget w, XtPointer This, XtPointer pc_ptr);
    void CVScrollProcCB(Widget w, XtPointer This, XtPointer position);

    void CgraphicsInit(Widget w, XtPointer clientData, XtPointer call);

    void CExposeEV(Widget w, XtPointer client_data, XEvent* event, char *x);

    void CEnterEV(Widget w, XtPointer client_data, XEvent* event, char *x);
    void CLeaveEV(Widget w, XtPointer client_data, XEvent* event, char *x);

    void CMouseDownEV(Widget w, XtPointer client_data, XEvent* event, char *x);
    void CMouseUpEV(Widget w, XtPointer client_data, XEvent* event, char *x);
    void CMouseMoveEV(Widget w, XtPointer client_data, XEvent* event, char *x);
    void CNVKeyInEV(Widget w, XtPointer client_data, XEvent* event, char *x);
}

const unsigned int vGL_Default = 0;
const unsigned int vGL_RGB = 0x0001;
const unsigned int vGL_Alpha = 0x0002;
const unsigned int vGL_Indexed = 0x0004;
const unsigned int vGL_DoubleBuffer = 0x0008;
const unsigned int vGL_Stereo = 0x0010;
const unsigned int vGL_Stencil = 0x0020;
const unsigned int vGL_Accum = 0x0040;
const unsigned int vGL_Depth = 0x0080;

    typedef int VCursor;		// For cursors

// Define Cursor stuff

const VCursor VC_None = 0;		// No/Default cursor
const VCursor VC_Arrow = 1;		// XC_top_left_arrow
const VCursor VC_CenterArrow = 2;	// XC_center_ptr
const VCursor VC_CrossHair = 3;		// XC_crosshair
const VCursor VC_EWArrows = 4;		// XC_sb_h_double_arrow
const VCursor VC_Hand = 5;		// XC_hand2
const VCursor VC_IBar = 6;		// XC_xterm
const VCursor VC_Icon = 7;		// XC_icon
const VCursor VC_NSArrows = 8;		// XC_sb_v_double_arrow
const VCursor VC_Pencil = 9;		// XC_Pencil
const VCursor VC_Question = 10;		// XC_question_arrow
const VCursor VC_Sizer = 11;		// XC_sizing
const VCursor VC_Wait = 12;		// XC_watch
const VCursor VC_X = 13;		// XC_X_cursor
const VCursor VC_LAST = 13;
const int maxCursors = 13;

    class vWindow;		// we are part of a window

    class vBaseGLCanvasPane : public vPane
      {
	friend void CchangeCB(Widget w, XtPointer client_data, XtPointer call_data);
	friend void CHJumpProcCB(Widget w, XtPointer This, XtPointer pc_ptr);
	friend void CHScrollProcCB(Widget w, XtPointer This, XtPointer position);
	friend void CVJumpProcCB(Widget w, XtPointer This, XtPointer pc_ptr);
	friend void CVScrollProcCB(Widget w, XtPointer This, XtPointer position);

	friend void CgraphicsInit(Widget w, XtPointer clientData, XtPointer call);
	friend void CExposeEV(Widget w, XtPointer client_data, XEvent* event, char *x);

	friend void CEnterEV(Widget w, XtPointer client_data, XEvent* event, char *x);
	friend void CLeaveEV(Widget w, XtPointer client_data, XEvent* event, char *x);

	friend void CMouseDownEV(Widget w, XtPointer client_data, XEvent* event, char *x);
	friend void CMouseUpEV(Widget w, XtPointer client_data, XEvent* event, char *x);
	friend void CMouseMoveEV(Widget w, XtPointer client_data, XEvent* event, char *x);
	friend void CNVKeyInEV(Widget w, XtPointer client_data, XEvent* event, char *x);

      public:		//---------------------------------------- public

	vBaseGLCanvasPane(unsigned int vGLmode = vGL_Default, PaneType pt = P_Canvas);

 	virtual ~vBaseGLCanvasPane();

	virtual void ShowPane(int OnOrOff);

	void SetWidthHeight(int width, int height);
	// Cursor
	void SetCursor(VCursor id);
        VCursor GetCursor() { return _currentCursor; }

	void UnSetCursor(void);

	// Scrolling
	virtual void HPage(int Shown, int Top);	// Horiz page event
	virtual void VPage(int Shown, int Top);	// Vert page event
	virtual void HScroll(int step);		// Horiz scroll event
	virtual void VScroll(int step);		// Vert scroll event
	virtual void SetHScroll(int Shown, int Top);  // Set Horiz Scroll bar
	virtual void SetVScroll(int Shown, int Top);  // Set Vert Scroll bar
	virtual int GetVScroll(int& Shown, int& Top);
	virtual int GetHScroll(int& Shown, int& Top);
	virtual void ShowHScroll(int OnOff);
	virtual void ShowVScroll(int OnOff);

	// Events
	virtual void MouseDown(int x, int y, int button);	// Mouse Down at x,y
	virtual void MouseUp(int x, int y, int button);		// Mouse Up at x,y
	virtual void MouseMove(int x, int y, int button);	// Mouse Moved to x,y
	virtual void MouseMotion(int x, int y) {}	// no button: Mouse Moved to x,y

	virtual void EnterFocus();
	virtual void LeaveFocus();

	// Expose/redraw event
	virtual void Redraw(int x, int y, int width , int height);
	virtual void Resize(int newW, int newH);  // Resize event

	// Information
	virtual int GetWidth() { return _width; }   // Get width of canvas
	virtual int GetHeight() { return _height; } // Get Height of canvas

	// OpenGL specific stuff

	virtual void graphicsInit(void);

	void vglMakeCurrent(void)
	  {
	    glXMakeCurrent(theApp->display(), XtWindow(_drawWindow), glxContext);
	  }

 	virtual void vglFlush();

	
	XVisualInfo* GetXVisualInfo() { return _visinfo; }

	// Platform dependent

	Widget DrawingWindow() { return _drawWindow; }
	Drawable GetXDrawable() { return (_Drawable == 0) ? 
			(_Drawable = (Drawable)XtWindow(_drawWindow)) : _Drawable;}

      protected:	//--------------------------------------- protected

	virtual void initialize(vWindow* pWindow, Widget pWidget);
	XVisualInfo* chooseIndexed(unsigned int glMode);
	XVisualInfo* chooseRGB(unsigned int glMode);

	int _height;	// height of draw window
	int _width;	// width of draw window
	
	GLXContext glxContext;

      private:		//--------------------------------------- private

	// Widgets for the canvas
	Widget _drawCanvas;		// whole canvas window
	Widget _drawHScroll;		// horiz scroll
	Widget _drawVScroll;		// vertical scroll
	Widget _drawWindow;		// window for drawing
	Drawable _Drawable;

	static VCursor _currentCursor;	// for cursor
	static XVisualInfo* _visinfo;
	static int _doubleBuffer;		// if we have double buffering
	static unsigned int _vGLmode;

	int _hasFocus;			// for focus workaround
	int _mouseDown;			// for tracking mouse

	int _HOn;		// on or off
	int _VOn;

	int _HScrlShown;
	int _HScrlTop;
	int _VScrlShown;
	int _VScrlTop;

	void ChangeCB(void);
	// Allow dual use for Athena and Motif
	void HJumpProcCB(float percent, int motifValue);
	void VJumpProcCB(float percent, int motifValue);
	void HScrollProcCB(int);
	void VScrollProcCB(int);

	void DrawHScroll(int Shown, int Top);
	void DrawVScroll(int Shown, int Top);

	void ExposeEV(int x, int y, int width, int height);
	void EnterEV(void);
	void LeaveEV(void);
	void MouseUpEV(int x, int y, int button);
	void MouseDownEV(int x, int y, int button);
	void MouseMoveEV(int x, int y, int button);
      };
#endif
