;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Ast/app.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jan 19 11:51:05 1995                          */
;*    Last change :  Wed Dec  6 10:06:27 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    A little module which implement application arity checks.        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_app
   (include "Ast/node.sch")
   (import  tools_error
	    tools_location
	    engine_param
	    ast_sexp
	    ast_dump)
   (export (correct-app?        <integer>  <ast>)
	   (foreign-applicable? <obj>      <obj>)
	   (app-error           <symbol>   <ast>)))

;*---------------------------------------------------------------------*/
;*    Before inlining a call, we are obliged to check that the         */
;*    call is correct (good number of arguments). We perform here      */
;*    an `ad hoc' process to do so.                                    */
;*---------------------------------------------------------------------*/
(define *error-msg* #unspecified)
(define *error-val* #unspecified)

;*---------------------------------------------------------------------*/
;*    applicable? ...                                                  */
;*---------------------------------------------------------------------*/
(define (foreign-applicable? obj name)
   (if (ffunction? obj)
       #t
       (begin
	  (set! *error-msg* "Incorrect application expression")
	  (set! *error-val* name)
	  #f)))

;*---------------------------------------------------------------------*/
;*    correct-app? ...                                                 */
;*---------------------------------------------------------------------*/
(define (correct-app? arity ast)
   (let* ((actuals (app-actuals ast))
	  (len     (length actuals)))
      (if (>=fx arity 0)
	  (cond
	     ((=fx len arity)
	      #t)
	     ((<fx len arity)
	      (set! *error-msg* "Too few arguments provided")
	      (set! *error-val* (ast->sexp ast))
	      #f)
	     (else
	      (set! *error-msg* "Too many arguments provided")
	      (set! *error-val* (ast->sexp ast))
	      #f))
	  (cond
	     ((<=fx (negfx arity) (+fx len 1))
	      #t)
	     (else
	      (set! *error-msg* "Too few arguments provided")
	      (set! *error-val* (ast->sexp ast))
	      #f)))))

;*---------------------------------------------------------------------*/
;*    app-error ...                                                    */
;*---------------------------------------------------------------------*/
(define (app-error name ast)
   (user-error/location (ast-location ast)
			(current-function)
			*error-msg*
			*error-val*
			(get-error-expression name (ast-location ast)))) 

;*---------------------------------------------------------------------*/
;*    get-error-expression ...                                         */
;*    -------------------------------------------------------------    */
;*    We build an error expression.                                    */
;*---------------------------------------------------------------------*/
(define (get-error-expression name location)
   (sexp->ast (if (and (>fx *compiler-debug* 0) (loc? location))
		  `(error/location ',name
				   ,*error-msg*
				   ',*error-val*
				   ,(loc-full-fname location)
				   ,(loc-pos location))
		  `(error ',name ,*error-msg* ',*error-val*))
	      '()
	      #f
	      location
	      'read))

