;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Ast/ast.sch              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Dec 25 10:34:38 1994                          */
;*    Last change :  Fri Feb  9 14:17:01 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The general AST interface include file                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The directives clause                                            */
;*---------------------------------------------------------------------*/
(directives
   (include "Misc/union.sch"
	    "Tools/location.sch"))

;*---------------------------------------------------------------------*/
;*    variable ...                                                     */
;*---------------------------------------------------------------------*/
(define-union variable
   (define-struct global
      name            ;; symbol     : the global's name
      module          ;; symbol     : the global's module
      target-name     ;; string     ; the global's target name
      import          ;; { static, export, top-level, foreign }
      class           ;; { function, variable, inline, c-function, ... }
      eval?           ;; boolean    : should eval know this global ?
      library?        ;; boolean    : is it a library variable
      value           ;; { function, foreign }
      occurrence      ;; integer    : the number of occurrences
      access          ;; { read, write }
      info            ;; obj        : a user free slot.
      cfa-info        ;; obj        : a cfa free slot.
      type            ;; type       : the variable type
      pragma          ;; s-exp      : pragma about the variable
      fast-alpha)     ;;            : a slot for fast alpha conversion.
   (define-struct local
      name            ;; symbol     : the global's name
      key             ;; integer    : a identification key
      value           ;; { function, return }
      occurrence      ;; integer    : the number of occurences
      access          ;; { read, write, cell }
      info            ;; obj        : a user free slot.
      cfa-info        ;; obj        : a cfa free slot.
      type            ;; type       : the local's type
      fast-alpha      ;;            : a slot for fast alpha conversion.
      target-name
      user))          ;; symbol     : is it a user variable (verbose)

;*---------------------------------------------------------------------*/
;*    function ...                                                     */
;*---------------------------------------------------------------------*/
(define-struct function
   inline?       ;; { t, f }   : is it a inline function ?
   property      ;; property*  : a property list
   arity         ;; integer    : the arity
   args          ;; local*     : the formals
   body          ;; s-exp      : the body
   info          ;; obj        : a user free slot.
   cfa-info      ;; obj        : a cfa free slot.
   escape?       ;; { t, f }   : is it an escaping function ?
   the-closure   ;; variable   : the associated closure
   kaptured      ;; local*     : the list of the kaptured variables
   type-res      ;; type       :
   sef?)         ;; bool       : side effect free ?

;*---------------------------------------------------------------------*/
;*    return ...                                                       */
;*---------------------------------------------------------------------*/
(define-struct return
   handler       ;; { t, f }   : the associated handling function
   detached)     ;; { t, f }   : is the handler detached (after globalize)

;*---------------------------------------------------------------------*/
;*    ffunction ...                                                    */
;*---------------------------------------------------------------------*/
(define-struct ffunction
   arity         ;; integer    : the arity
   type-args     ;; type       : the formal parameters
   info          ;; obj        : a user free slot.
   cfa-info      ;; obj        : a cfa free slot.
   type-res      ;; type       :
   infix         ;; bool       : is it a infix macro
   sef?)         ;; bool       : side effect free ?



  

