;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Ast/env.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Dec 25 11:32:49 1994                          */
;*    Last change :  Tue Oct  3 14:22:07 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The global environment manipulation                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_env
   (include "Ast/ast.sch")
   (import  tools_shape
	    engine_param)
   (export  (initialize-Genv!)
	    (set-Genv!              <Genv>)
	    (get-Genv) 
	    (find-global            <symbol> . <symbol>)
	    (bind-global!           <symbol> <symbol>)
	    (unbind-global!         <symbol> <symbol>)
	    (for-each-global!       <procedure>)
	    (global-bucket-position <symbol> <symbol>)))

;*---------------------------------------------------------------------*/
;*    *Genv* ...                                                       */
;*    -------------------------------------------------------------    */
;*    The Global environment (for global variable definitions).        */
;*---------------------------------------------------------------------*/
(define *Genv* 'the-global-environment)

;*---------------------------------------------------------------------*/
;*    get-hash-number ...                                              */
;*---------------------------------------------------------------------*/
(define (get-hash-number o)
   (string->0..2^x-1 (symbol->string o) 12))

;*---------------------------------------------------------------------*/
;*    set-Genv! ...                                                    */
;*---------------------------------------------------------------------*/
(define (set-Genv! Genv)
   (set! *Genv* Genv)
   (struct-set! *Genv* 2 get-hash-number)
   (struct-set! *Genv* 3 car)
   (struct-set! *Genv* 5 eq?))
		 
;*---------------------------------------------------------------------*/
;*    get-Genv ...                                                     */
;*---------------------------------------------------------------------*/
(define (get-Genv)
   (struct-set! *Genv* 2 'get-hash-number)
   (struct-set! *Genv* 3 'car)
   (struct-set! *Genv* 5 'eq?)
   *Genv*)

;*---------------------------------------------------------------------*/
;*    initialize-Genv! ...                                             */
;*---------------------------------------------------------------------*/
(define (initialize-Genv!)
   (set! *Genv* (make-hash-table 4096 get-hash-number car eq? 1024)))

;*---------------------------------------------------------------------*/
;*    find-global ...                                                  */
;*---------------------------------------------------------------------*/
(define (find-global name . module)
   [assert check (name module) (and (symbol? name)
				    (or (null? module)
					(symbol? (car module))))]
   (let ((bucket (get-hash name *Genv*))
	 (module (if (null? module) '() (car module))))
      (cond
	 ((not (pair? bucket))
	  #f)
	 ((null? (cdr bucket))
	  #f)
	 ((null? module)
	  (cadr bucket))
	 (else
	  (let loop ((globals (cdr bucket)))
	     (cond
		((null? globals)
		 #f)
		((eq? (global-module (car globals)) module)
		 (car globals))
		(else
		 (loop (cdr globals)))))))))

;*---------------------------------------------------------------------*/
;*    bind-global! ...                                                 */
;*---------------------------------------------------------------------*/
(define (bind-global! name module)
   (assert check (name module) (and (symbol? name) (symbol? module)))
   (let ((global (find-global name module)))
      (if (global? global)
	  (if (not *lib-mode*)
	      (error "bind-global!"
		     "Illegal global redefinition"
		     (shape global))
	      global)
	  (let ((new    (make-global))
		(bucket (get-hash name *Genv*)))
	     (global-name-set!   new name)
	     (global-module-set! new module)
	     (if (not (pair? bucket))
		 (put-hash! (list name new) *Genv*)
		 (let ((new-bucket (cons new (cdr bucket))))
		    (set-cdr! bucket new-bucket)))
	     new))))

;*---------------------------------------------------------------------*/
;*    unbind-global! ...                                               */
;*---------------------------------------------------------------------*/
(define (unbind-global! name module)
   (let ((global (find-global name module)))
      (if (not (global? global))
	  (error "unbind-global!"
		 "Can't find global"
		 `(@ ,name ,module))
	  (let ((bucket (get-hash name *Genv*)))
	     (let loop ((cur  (cdr bucket))
			(prev bucket))
		(if (eq? (car cur) global)
		    (set-cdr! prev (cdr cur))
		    (loop (cdr cur) (cdr prev))))))))
   
;*---------------------------------------------------------------------*/
;*    for-each-global! ...                                             */
;*---------------------------------------------------------------------*/
(define (for-each-global! proc)
   (for-each-hash (lambda (bucket) (for-each proc (cdr bucket)))
		  *Genv*))
   
;*---------------------------------------------------------------------*/
;*    global-bucket-position                                           */
;*---------------------------------------------------------------------*/
(define (global-bucket-position name module)
   (let ((bucket (get-hash name *Genv*)))
      (if (not (pair? bucket))
	  -1
	  (let loop ((globals (cdr bucket))
		     (pos     0))
	     (cond
		((null? globals)
		 -1)
		((eq? (global-module (car globals)) module)
		 pos)
		(else
		 (loop (cdr globals)
		       (+fx pos 1))))))))
   
