;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Ast/exit.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Apr 21 14:19:17 1995                          */
;*    Last change :  Wed May 17 16:46:13 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `set-exit' and `jmp-exit' management.                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_exit
   (include "Ast/node.sch"
	    "Tools/trace.sch"
	    "Type/type.sch")
   (import  engine_param
	    parse_definition
	    type_env
	    type_cache
	    tools_location
	    tools_progn
	    tools_shape
	    ast_substitute
	    ast_sexp
	    ast_env
	    ast_local)
   (export  (set-exit->ast  <sexp> <stack> <obj> <loc> <site>)
	    (jump-exit->ast <sexp> <stack> <obj> <loc> <site>)))

;*---------------------------------------------------------------------*/
;*    set-exit->ast ...                                                */
;*    -------------------------------------------------------------    */
;*    set-exit are always compiled as `set-jmp' `longjmp', then, we    */
;*    always have to make them nested into a globalized function.      */
;*    This function is called the `handling' function.                 */
;*---------------------------------------------------------------------*/
(define (set-exit->ast exp stack entering loc site)
   (define (make-local-exit exit handler)
      (let ((local (make-local-variable exit *exit*)))
	 (local-value-set! local (return handler #f))
	 local))
   (let ((loc (find-location/loc exp loc)))
      (match-case exp
	 ((?- (?exit) . ?body)
	  (let* ((hdlg-name (gensym 'handling-function))
		 (hdlg-sexp `(labels ((,hdlg-name () #unspecified))
				(,hdlg-name)))
		 (hdlg-ast  (sexp->ast hdlg-sexp
				       stack
				       entering
				       loc
				       site))
		 (hdlg-fun  (car (let-fun-locals hdlg-ast)))
		 (exit      (make-local-exit exit hdlg-fun))
		 (body      (sexp->ast (normalize-progn body)
				       (cons exit stack)
				       entering
				       loc
				       'read))
		 (exit-body (ast-set-ex-it loc
					  #f
					  #f
					  (ast-var loc #f #f exit)
					  body)))
	     ;; this function can't be inlined otherwise the
	     ;; `set-exit' is fault
	     (function-inline?-set! (local-value hdlg-fun) #f)
	     (function-body-set!    (local-value hdlg-fun) exit-body)
	     hdlg-ast))
	 (else
	  (user-error/location loc
			       (current-function)
			       "Illegal `set-exit' form"
			       exp
			       (sexp->ast ''() stack entering loc site))))))

;*---------------------------------------------------------------------*/
;*    jump-exit->ast ...                                               */
;*---------------------------------------------------------------------*/
(define (jump-exit->ast exp stack entering loc site)
   (let ((loc (find-location/loc exp loc)))
      (match-case exp
	 ((?- ?exit . ?value)
	  (let ((value (sexp->ast (normalize-progn value)
				  stack
				  entering
				  loc
				  'read))
		(exit  (sexp->ast exit
				  stack
				  entering
				  loc
				  'read)))
	     (ast-jump-ex-it loc #f #f exit value)))
	 (else
	  (user-error/location loc
			       (current-function)
			       "Illegal `jmp-exit' form"
			       exp
			       (sexp->ast ''() stack entering loc site))))))
	 
   
      
      
