;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cfa/top.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr  5 10:06:47 1995                          */
;*    Last change :  Mon Apr 10 15:36:04 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `top' management                                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_top
   (include "Cfa/approx.sch"
	    "Ast/node.sch"
	    "Tools/trace.sch")
   (import  cfa_cfa
	    cfa_special
	    cfa_approx
	    type_cache
	    ast_dump
	    tools_error
	    tools_set)
   (export  (add-top!    <approx>)
	    (add-obj!    <approx>)
	    (spread-top! <approx>)))

;*---------------------------------------------------------------------*/
;*    add-top! ...                                                     */
;*---------------------------------------------------------------------*/
(define (add-top! approx)
   [assert check (approx) (approx? approx)]
   (trace (cfa loop) "!!! add-top!: " (approx-shape approx) #\Newline)
   (if (approx-top-locked? approx)
       (internal-error "add-top!"
		       "Attempting to top an untopable approx"
		       (approx-shape approx))
       (begin
	  (if (and (not (approx-top? approx))
		   (not (approx-top-locked? approx)))
	      (begin
		 (approx-top?-set! approx #t)
		 (continue-cfa!)))
	  #unspecified)))

;*---------------------------------------------------------------------*/
;*    add-obj! ...                                                     */
;*---------------------------------------------------------------------*/
(define (add-obj! approx)
   (trace (cfa loop) "!!! add-obj!: " (approx-shape approx) #\Newline)
   (if (and (not (approx-type-locked? approx))
	    (not (set-member? (approx-type approx) *obj*)))
       (begin
	  (set-extend! (approx-type approx) *obj*)
	  (continue-cfa!))))

;*---------------------------------------------------------------------*/
;*    spread-top! ...                                                  */
;*    -------------------------------------------------------------    */
;*    Spread top don't mean to add `obj' or `top'. It just means       */
;*    that allocation should have `obj' and `top' in their             */
;*    approximation fields.                                            */
;*---------------------------------------------------------------------*/
(define (spread-top! approx)
   (trace (cfa loop) "!!! spread-top!: " (approx-shape approx) #\Newline)
   (if (eq? (approx-stamp approx) *cfa-stamp*)
       #f
       (begin
	  (approx-stamp-set! approx *cfa-stamp*)
	  (for-each-set alloc-spread-top! (approx-alloc approx)))))

;*---------------------------------------------------------------------*/
;*    alloc-spread-top! ...                                            */
;*---------------------------------------------------------------------*/
(define (alloc-spread-top! alloc)
   [assert check (alloc) (is-alloc? alloc)]
   (let* ((var      (var-variable (app-fun alloc)))
	  (val      (global-value var))
	  (iforeign (cond
		       ((function? val)
			(function-cfa-info val))
		       ((ffunction? val)
			(ffunction-cfa-info val))
		       (else
			(internal-error "alloc-spread-top!"
					"Illegal function"
					(ast->sexp alloc))))))
      ((ispecial-spread-top! iforeign) alloc)))
	    
 
