;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cfa/type.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Mar 10 15:35:48 1995                          */
;*    Last change :  Wed Oct 11 11:19:34 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    During the analysis, we have computed types. We write them       */
;*    in the variable type slots.                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_type
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Type/type.sch"
	    "Cfa/approx.sch"
	    "Tvector/tvector.sch")
   (import  cfa_approx
	    cfa_cache
	    type_cache
	    cfa_funcall
	    cfa_collect
	    cfa_dead
	    type_pptype
	    ast_typeof
	    ast_dump
	    ast_env
	    tools_set
	    tools_shape
	    tools_speek)
   (export  (type-settings! <global>*)))

;*---------------------------------------------------------------------*/
;*    type-settings! ...                                               */
;*---------------------------------------------------------------------*/
(define (type-settings! globals)
   (trace cfa
	  #\Newline "======================================"
	  #\Newline "type-settings: "
	  #\Newline "--------------------------------------"
	  #\Newline)
   (for-each type-fun-set! globals)
   (for-each-global! (lambda (global)
			(if (and (eq? (global-class global) 'variable)
				 (eq? (global-import global) 'static))
			    (set-variable-type! global))))
   globals)

;*---------------------------------------------------------------------*/
;*    set-variable-type! ...                                           */
;*---------------------------------------------------------------------*/
(define (set-variable-type! var)
   (cond
      ((type? (variable-type var))
       (trace cfa (shape var) "  already typed: " (shape (variable-type var))
	      #\Newline)
       #unspecified)
      (else
       (let ((type (get-type var)))
	  (if (type? type)
	      (begin
		 (trace cfa (shape var) ": " (type-id->string type) #\Newline)
		 (variable-type-set! var type)))
	  #unspecified))
      (else
       #unspecified)))

;*---------------------------------------------------------------------*/
;*    set-variable-type/value! ...                                     */
;*---------------------------------------------------------------------*/
(define (set-variable-type/value! var val)
   (cond
      ((type? (variable-type var))
       (trace cfa (shape var) "  already typed: " (shape (variable-type var))
	      #\Newline)
       #unspecified)
      (else
       (let ((type (get-type var)))
	  (if (type? type)
	      (begin
		 (trace cfa (shape var) ": " (type-id->string type) #\Newline)
		 (variable-type-set! var type)))
	  #unspecified))))

;*---------------------------------------------------------------------*/
;*    type-fun-set! ...                                                */
;*---------------------------------------------------------------------*/
(define (type-fun-set! var)
   (trace cfa (shape var) #\: #\Newline)
   (if (alive-function? var)
       (let* ((value   (variable-value var))
	      (formals (function-args value))
	      (body    (function-body value)))
	  ;; the formals
	  (for-each set-variable-type! formals)
	  ;; the body
	  (type-ast-set! body)
	  ;; Now, we set the type of the result
	  (cond
	     ((type? (function-type-res value))
	      (trace cfa "  already typed: "
		     (shape (function-type-res value))
		     #\Newline)
	      #unspecified)
	     (else
	      (let ((type (typeof body)))
		 (if (not (eq? type *obj*))
		     (begin
			(trace cfa (shape var) ": " (type-id->string type)
			       #\Newline)
			(function-type-res-set! value type))))))
	  ;; ok, it's over for this function
	  (trace cfa #a012 #\Newline #\Newline))
       (trace cfa "  dead function" #a012 #\Newline #\Newline)))
			      
;*---------------------------------------------------------------------*/
;*    type-ast-set! ...                                                */
;*---------------------------------------------------------------------*/
(define (type-ast-set! ast)
   (let loop ((ast ast))
      (let ((type (get-type ast)))
	 (if (type? type) (ast-type-set! ast type))
	 (trace (cfa loop init)
		"   type-ast-set!: " (ast->sexp ast) #\Newline
		"            type: " (shape type) #\Newline))
      (ast-case ast
	 ((atom)
	  #unspecified)
	 ((kwote)
	  #unspecified)
	 ((var)
	  #unspecified)
	 ((prag-ma)
	  (for-each loop (prag-ma-values ast))
	  #unspecified)
	 ((fail)
	  (loop (fail-proc ast))
	  (loop (fail-msg ast))
	  (loop (fail-obj ast))
	  #unspecified)
	 ((sequence)
	  (for-each loop (sequence-exp ast))
	  #unspecified)
	 ((conditional)
	  (loop (conditional-test ast))
	  (loop (conditional-then ast))
	  (loop (conditional-else ast))
	  #unspecified)
	 ((switch)
	  (loop (switch-test ast))
	  (for-each (lambda (clause)
		       (loop (cdr clause)))
		    (switch-clauses ast))
	  #unspecified)
	 ((setq)
	  (loop (setq-val ast))
	  #unspecified)
	 ((let-var)
	  (for-each (lambda (binding)
		       (type-ast-set! (cdr binding))
		       (set-variable-type/value! (car binding) (cdr binding)))
		    (let-var-bindings ast))
	  (loop (let-var-body ast))
	  #unspecified)
	 ((let-fun)
	  (for-each type-fun-set! (let-fun-locals ast))
	  (loop (let-fun-body ast))
	  #unspecified)
	 ((set-ex-it)
	  (loop (set-ex-it-body ast))
	  #unspecified)
	 ((jump-ex-it)
	  (loop (jump-ex-it-exit ast))
	  (loop (jump-ex-it-value ast))
	  #unspecified)
	 ((app-ly)
	  (loop (app-ly-fun ast))
	  (loop (app-ly-value ast))
	  #unspecified)
	 ((funcall)
	  (loop (funcall-fun ast))
	  (for-each loop (funcall-actuals ast))
	  #unspecified)
	 ((app)
	  (for-each loop (app-actuals ast)))
	 ((make-box)
	  (loop (make-box-value ast))
	  #unspecified)
	 ((box-ref)
	  (loop (box-ref-var ast))
	  #unspecified)
	 ((box-set!)
	  (loop (box-set!-var ast))
	  (loop (box-set!-value ast))
	  #unspecified))))

;*---------------------------------------------------------------------*/
;*    get-type ...                                                     */
;*---------------------------------------------------------------------*/
(define (get-type node)
   (let ((approx (get-approx node)))
      ;; if there is no approximation for this node, it means that
      ;; the function or the node has been introduced by an
      ;; optimization (e.g. the tvector optimization), then, we
      ;; use the regular `typeof' function to set the type of this node.
      (if (not (approx? approx))
	  (typeof node)
	  (let ((atype (approx-type approx)))
	     (if (=fx (set-length atype) 1)
		 (let ((type (car (set->list atype))))
		    (cond
		       ((eq? type *obj*)
			#f)
		       ((eq? type *vector*)
			;; this could be an optimized case, we have
			;; to look at the allocations
			(let ((alloc (set->list (approx-alloc approx))))
			   (if (null? alloc)
			       *vector*
			       (let* ((all (car alloc))
				      (var (var-variable (app-fun all)))
				      (fun (variable-value var)))
				  (cond
				     ((not (function? fun))
				      *vector*)
				     ((not (type? (function-type-res fun)))
				      *vector*)
				     (else
				      (function-type-res fun)))))))
		       (else
			type)))
		 #f)))))


