;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cforeign/enum.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Jan 27 11:02:31 1996                          */
;*    Last change :  Thu Feb  1 18:37:16 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The installation of C enums.                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cforeign_install-c-enum
   (include "Type/type.sch"
	    "Ast/ast.sch")
   (import  tools_error
	    tools_shape
	    parse_cforeign
	    parse_static-export
	    ast_env
	    engine_param
	    cforeign_type
	    type_env
	    type_coercion
	    type_tools)
   (export  (install-c-enum-accessors!)
	    (add-c-enum! s)))

;*---------------------------------------------------------------------*/
;*    install-c-enum-accessors! ...                                    */
;*---------------------------------------------------------------------*/
(define (install-c-enum-accessors!)
   (let loop ((l   (get-c-enum-list))
	      (res '()))
      (if (null? l)
	  res
	  (loop (cdr l) (append (make-c-enum-access (car l)) res)))))

;*---------------------------------------------------------------------*/
;*    make-c-enum-access ...                                           */
;*---------------------------------------------------------------------*/
(define (make-c-enum-access tinfo)
   (let ((type (vector-ref tinfo 1)))
      (if (type? (type-alias type))
	  (make-c-enum-access-alias tinfo)
	  (make-c-enum-access-unalias tinfo))))

;*---------------------------------------------------------------------*/
;*    make-c-enum-access-alias ...                                     */
;*---------------------------------------------------------------------*/
(define (make-c-enum-access-alias tinfo)
   (let* ((type  (vector-ref tinfo 1))
	  (atype (get-aliased-type (vector-ref tinfo 0)))
	  (t-exp (type-exp atype))
	  (slots (cdr t-exp)))
      (make-c-enum-access-slots tinfo slots atype)))

;*---------------------------------------------------------------------*/
;*    make-c-enum-access-unalias ...                                   */
;*---------------------------------------------------------------------*/
(define (make-c-enum-access-unalias tinfo)
   (let* ((type  (vector-ref tinfo 1))
	  (t-exp (type-exp type))
	  (slots (cdr t-exp)))
      (make-c-enum-access-slots tinfo slots type)))

;*---------------------------------------------------------------------*/
;*    make-c-enum-access-slots ...                                     */
;*---------------------------------------------------------------------*/
(define (make-c-enum-access-slots tinfo slots atype)
   (let* ((type           (vector-ref tinfo 1))
	  (tid            (type-id type))
	  (atid           (type-id atype))
	  (t-name         (type-name type))
	  (t-name-sans-$  (string-sans-$ t-name))
	  (t-exp          (type-exp type))
	  (batid          (symbol-append 'b atid))
	  (btid           (symbol-append 'b tid)))
      
      ;; the two conversion allocation fonctions (they are not
      ;; simple coercion because the first one allocate and the
      ;; second one destructurate).
      (define (tid->btid)
	 `(macro ,btid
	     ,(symbol-append tid '-> btid)
	     (symbol ,tid)
	     "cobj_to_foreign"))

      (define (btid->tid)
	 `(macro ,tid
	     ,(symbol-append btid '-> tid)
	     (,btid)
	     "FOREIGN_TO_COBJ"))

      ;; the predicate
      (define (bid?)
	 `(define-inline (,(symbol-append btid '?::bool) o::obj)
	     (if (foreign? o)
		 (eq? (foreign-id o) ',batid)
		 #f)))

      ;; equality (using ==)
      (define (=id)
	 `(define-inline (,(symbol-append '= tid '::bool)
			  ,(symbol-append 'o1:: tid)
			  ,(symbol-append 'o2:: tid))
	     (pragma::bool "($1 == $2)" o1 o2)))

      ;; in safe mode, the predicate bid? should not be removed
      ;; until type coercion. Then, we mark it as used with this
      ;; simili-hack
      (if (not *unsafe-type*)
	  (begin
	     (parse-static (list
			    `(inline ,(symbol-append btid '?::bool) o::obj)))
	     (let ((btid? (find-global (symbol-append btid '?))))
		(global-import-set! btid? 'export)
		(global-occurrence-set! btid? 1000))))

      ;; slots accessors
      (define (slot-accessors)
	 (let loop ((slots slots)
		    (res   '()))
	    (if (null? slots)
		res
		(let* ((slot        (car slots))
		       (slot-id     (car slot))
		       (slot-name   (cadr slot))
		       (access-name (symbol-append tid
						   '-
						   slot-id))
		       (access     `(define-inline (,(symbol-append
						      access-name
						      '::
						      tid))
				       (,(symbol-append 'pragma:: tid)
					,slot-name))))
		   (loop (cdr slots)
			 (cons access res))))))
      
      (parse-c-foreign (list (tid->btid) (btid->tid)) 'import)
      
      (cons* (=id) (bid?) (slot-accessors))))

;*---------------------------------------------------------------------*/
;*    *c-enum-list* ...                                                */
;*---------------------------------------------------------------------*/
(define *c-enum-list* '())

;*---------------------------------------------------------------------*/
;*    add-c-enum! ...                                                  */
;*---------------------------------------------------------------------*/
(define (add-c-enum! s)
   (set! *c-enum-list* (cons s *c-enum-list*)))

;*---------------------------------------------------------------------*/
;*    get-c-enum-list ...                                              */
;*---------------------------------------------------------------------*/
(define (get-c-enum-list)
   (reverse! *c-enum-list*))

