;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cforeign/pointer.scm     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jul  7 15:18:00 1995                          */
;*    Last change :  Sat Jan 27 11:28:31 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The installation of c pointers.                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cforeign_install-c-pointer
   (include "Type/type.sch"
	    "Ast/ast.sch")
   (import  tools_error
	    tools_shape
	    parse_cforeign
	    parse_static-export
	    ast_env
	    engine_param
	    cforeign_type
	    type_env
	    type_coercion
	    type_tools)
   (export  (install-c-pointer-accessors!)
	    (add-c-pointer! a)))

;*---------------------------------------------------------------------*/
;*    install-c-pointer-accessors! ...                                 */
;*---------------------------------------------------------------------*/
(define (install-c-pointer-accessors!)
   (let loop ((l   (get-c-pointer-list))
	      (res '()))
      (if (null? l)
	  res
	  (loop (cdr l) (append (make-c-pointer-access (car l)) res)))))

;*---------------------------------------------------------------------*/
;*    make-c-pointer-access ...                                        */
;*---------------------------------------------------------------------*/
(define (make-c-pointer-access tinfo)
   (let ((type (vector-ref tinfo 1)))
      (if (type? (type-alias type))
	  (make-c-pointer-access-aliased tinfo)
	  (make-c-pointer-access-unaliased tinfo))))

;*---------------------------------------------------------------------*/
;*    make-c-pointer-access-aliased ...                                */
;*---------------------------------------------------------------------*/
(define (make-c-pointer-access-aliased tinfo)
   (let* ((atype          (vector-ref tinfo 0))
	  (atid           (type-id atype))
	  (at-name        (type-name atype))
	  (at-name-sans-$ (string-sans-$ at-name))
	  (type           (vector-ref tinfo 1))
	  (tid            (type-id type))
	  (t-name         (type-name type))
	  (t-exp          (type-exp atype))
	  (btid           (symbol-append 'b tid))
	  (batid          (symbol-append 'b atid))
	  (atid           (type-id atype))
	  (item-type-id   (cadr t-exp))
	  (item-type-id*  (symbol-append item-type-id '*))
	  (item-type      (find-type item-type-id))
	  (item-type-name (type-name item-type)))

      ;; the user allocation form without initialization
      (define (make-id*)
	 `(define-inline (,(symbol-append 'make- tid ':: atid) len::long)
	     (,(symbol-append 'pragma:: atid)
	      ,(string-append "(" at-name-sans-$ ")GC_MALLOC( "
			      "sizeof( " (string-sans-$ item-type-name) " )"
			      " * $1 )")
	      len)))
      
      ;; the predicate
      (define (bid?)
	 `(define-inline (,(symbol-append btid '?::bool) o::obj)
	     (if (foreign? o)
		 (eq? (foreign-id o) ',batid)
		 #f)))

      ;; equality (using ==)
      (define (=id)
	 `(define-inline (,(symbol-append '= tid '::bool)
			  ,(symbol-append 'o1:: atid)
			  ,(symbol-append 'o2:: atid))
	     (pragma::bool "($1 == $2)" o1 o2)))

      ;; null-test
      (define (id-null?)
	 `(define-inline (,(symbol-append tid '-null?::bool)
			  ,(symbol-append 'o:: atid))
	     (pragma::bool ,(string-append "($1 == (" at-name-sans-$ ")0L)")
			   o)))
      
      (define (getter*-and-setter*)
	 (let* ((c-struct?      (eq? (type-class (get-aliased-type item-type))
				     'c-struct))
		(item-type-id   (if c-struct?
				    item-type-id*
				    item-type-id))
		(item-type-name (if c-struct?
				    (string-sans-$
				     (make-typed-declaration item-type "*"))
				    item-type-name)))
	     (list
	      `(define-inline (,(symbol-append tid '-ref:: item-type-id)
			       ,(symbol-append 'o:: atid)
			       i::long)
		  (,(symbol-append 'c- atid '-ref)
		   o
		   (pragma ,item-type-name)
		   i))
	      `(define-inline (,(symbol-append tid '-set!::obj)
			       ,(symbol-append 'o:: atid)
			       i::long
			       ,(symbol-append 'v:: item-type-id))
		  (,(symbol-append 'c- atid '-set!)
		   o
		   (pragma ,item-type-name)
		   i
		   v)))))
      
      ;; in safe mode, the predicate bid? should not be removed
      ;; until type coercion. Then, we mark it as used with this
      ;; simili-hack
      (if (not *unsafe-type*)
	  (begin
	     (parse-static (list
			    `(inline ,(symbol-append btid '?::bool) o::obj)))
	     (let ((btid? (find-global (symbol-append btid '?))))
		(global-import-set! btid? 'export)
		(global-occurrence-set! btid? 1000))))

      (cons* (make-id*) (=id) (id-null?) (bid?) (getter*-and-setter*))))

;*---------------------------------------------------------------------*/
;*    make-c-pointer-access-unsaliased ...                             */
;*---------------------------------------------------------------------*/
(define (make-c-pointer-access-unaliased tinfo)
   (let* ((type           (vector-ref tinfo 1))
	  (tid            (type-id type))
	  (t-name         (type-name type))
	  (t-name-sans-$  (string-sans-$ t-name))
	  (t-exp          (type-exp type))
	  (btid           (symbol-append 'b tid))
	  (item-type-id   (cadr t-exp))
	  (item-type-id*  (symbol-append item-type-id '*))
	  (item-type      (find-type item-type-id))
	  (item-type-name (type-name item-type)))

      ;; the two conversion allocation fonctions (they are not
      ;; simple coercion because the first one allocate and the
      ;; second one destructurate).
      (define (tid->btid)
	 `(macro ,btid
	     ,(symbol-append tid '-> btid)
	     (symbol ,tid)
	     "cobj_to_foreign"))

      (define (btid->tid)
	 `(macro ,tid
	     ,(symbol-append btid '-> tid)
	     (,btid)
	     "FOREIGN_TO_COBJ"))

      ;; the user allocation form without initialization
      (define (make-id*)
	 `(define-inline (,(symbol-append 'make- tid ':: tid) len::long)
	     (,(symbol-append 'pragma:: tid)
	      ,(string-append "(" t-name-sans-$ ")GC_MALLOC( "
			      "sizeof( " (string-sans-$ item-type-name) " )"
			      " * $1 )")
	      len)))
      
      ;; the predicate
      (define (bid?)
	 `(define-inline (,(symbol-append btid '?::bool) o::obj)
	     (if (foreign? o)
		 (eq? (foreign-id o) ',btid)
		 #f)))

      ;; equality (using ==)
      (define (=id)
	 `(define-inline (,(symbol-append '= tid '::bool)
			  ,(symbol-append 'o1:: tid)
			  ,(symbol-append 'o2:: tid))
	     (pragma::bool "($1 == $2)" o1 o2)))

      ;; null-test
      (define (id-null?)
	 `(define-inline (,(symbol-append tid 'null?::bool)
			  ,(symbol-append 'o:: tid))
	     (pragma::bool ,(string-append "($1 == (" t-name-sans-$ ")0L)") o)))
      
      ;; the getter and setter
      (define (c-getter*-and-setter*)
	 (if (eq? (type-class (get-aliased-type item-type)) 'c-struct)
	     (list
	      `(macro ,item-type-id*
		  ,(symbol-append 'c- tid '-ref)
		  (,tid obj long)
		  "C_POINTER_REF_ADDR")
	      `(macro obj
		  ,(symbol-append 'c- tid '-set!)
		  (,tid obj long ,item-type-id*)
		  "C_POINTER_SET_ADDR"))
	     (list
	      `(macro ,item-type-id
		  ,(symbol-append 'c- tid '-ref)
		  (,tid obj long)
		  "C_POINTER_REF")
	      `(macro obj
		  ,(symbol-append 'c- tid '-set!)
		  (,tid obj long ,item-type-id)
		  "C_POINTER_SET"))))

      (define (getter*-and-setter*)
	 (let* ((c-struct?     (eq? (type-class (get-aliased-type item-type))
				    'c-struct))
		(item-type-id  (if c-struct?
				   item-type-id*
				   item-type-id))
	       (item-type-name (if c-struct?
				   (string-sans-$
				    (make-typed-declaration item-type "*"))
				   item-type-name)))
	     (list
	      `(define-inline (,(symbol-append tid '-ref:: item-type-id)
			       ,(symbol-append 'o:: tid)
			       i::long)
		  (,(symbol-append 'c- tid '-ref)
		   o
		   (pragma ,item-type-name)
		   i))
	      `(define-inline (,(symbol-append tid '-set!::obj)
			       ,(symbol-append 'o:: tid)
			       i::long
			       ,(symbol-append 'v:: item-type-id))
		  (,(symbol-append 'c- tid '-set!)
		   o
		   (pragma ,item-type-name)
		   i
		   v)))))
      
      ;; in safe mode, the predicate bid? should not be removed
      ;; until type coercion. Then, we mark it as used with this
      ;; simili-hack
      (if (not *unsafe-type*)
	  (begin
	     (parse-static (list
			    `(inline ,(symbol-append btid '?::bool) o::obj)))
	     (let ((btid? (find-global (symbol-append btid '?))))
		(global-import-set! btid? 'export)
		(global-occurrence-set! btid? 1000))))

      (parse-c-foreign (cons* (tid->btid) 
			      (btid->tid)
			      (c-getter*-and-setter*))
		       'import)
      (cons* (make-id*) (=id) (id-null?) (bid?) (getter*-and-setter*))))

;*---------------------------------------------------------------------*/
;*    *c-pointer-list* ...                                             */
;*---------------------------------------------------------------------*/
(define *c-pointer-list* '())

;*---------------------------------------------------------------------*/
;*    add-c-pointer! ...                                               */
;*---------------------------------------------------------------------*/
(define (add-c-pointer! s)
   (set! *c-pointer-list* (cons s *c-pointer-list*)))

;*---------------------------------------------------------------------*/
;*    get-c-pointer-list ...                                           */
;*---------------------------------------------------------------------*/
(define (get-c-pointer-list)
   (reverse! *c-pointer-list*))









   
