;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cnst/walk.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Feb  3 09:46:40 1995                          */
;*    Last change :  Fri Jul 21 10:13:36 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `constant compilation'                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cnst_walk
   (include "Tools/pass.sch"
	    "Tools/trace.sch"
	    "Ast/ast.sch")
   (import  tools_shape
	    engine_param
	    ast_env
	    ast_dump
	    ast_global
	    cnst_alloc
	    cnst_cache
	    cnst_ast
	    cnst_initialize)
   (export  (cnst-walk! <global>*)))

;*---------------------------------------------------------------------*/
;*    cnst-walk! ...                                                   */
;*---------------------------------------------------------------------*/
(define (cnst-walk! globals)
   (pass-prelude "Cnst"
		 start-cnst-cache!
		 start-cnst-alloc!
		 initialize-init!)
   (verbose 2 "        [" *init-mode* #\] #\Newline)
   (for-each (lambda (global)
		(enter-function (global-shape global))
		(let* ((fun      (global-value global))
		       (new-body (cnst (function-body fun))))
		   (function-body-set! fun new-body))
		(leave-function))
	     globals)
   (pass-postlude globals
		  initialize-stop!
		  stop-cnst-alloc!
		  stop-cnst-cache!))

