;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.8/Engine/interp.scm        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jan 15 09:54:05 1993                          */
;*    Last change :  Tue Jan 30 17:07:02 1996 (serrano)                */
;*                                                                     */
;*    L'interprete interne. Il est important que ce module n'importe   */
;*    rien pour que la variable `the-module-environment' soit la plus  */
;*    vide possible. C'est pour cette raison qu'on passe en parametre  */
;*    `version' et `silent'.                                           */
;*---------------------------------------------------------------------*/
 
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module engine_interp
   (import engine_param) ;; on import ce module pour que toutes les
                         ;; variables de controle soient connues de
                         ;; l'interprete.
   (export (interp version verbose file startup path args)))

;*---------------------------------------------------------------------*/
;*    interp ...                                                       */
;*---------------------------------------------------------------------*/
(define (interp version verbose file startup path args)
   (set! *bigloo-interpreter* #t)
   (if (and (>=fx verbose 0) (not (string? file)))
       (begin
	  (version)
	  (print "Welcome to the interpreter")))
   ;; on definie la variable `(command-line)'
   (set! *the-command-line* (interp-parse-args args))
   ;; on charge le fichier de startup
   (if (string? startup)
       (cond
	  ((file-exists? startup)
	   (loadq startup))
	  ((and (string? (getenv "HOME"))
		(file-exists? (string-append (getenv "HOME") "/" startup)))
	   (loadq (string-append (getenv "HOME") "/" startup)))
	  ((file-exists? (string-append path "/" startup))
	   (loadq (string-append path "/" startup)))
	  (else
	   (fprint (current-error-port)
		   "*** WARNING:bigloo"
		   #\Newline
		   "Can't file startup file -- " startup))))
   ;; on rentre dans l'interprete
   (if (string? file)
       (loadq file)
       (repl))
   0)

;*---------------------------------------------------------------------*/
;*    interp-parse-args ...                                            */
;*---------------------------------------------------------------------*/
(define (interp-parse-args args)
   (let loop ((args (cdr args))
	      (res  '()))
      (cond
	 ((null? args)
	  (cons *src* (reverse res)))
	 ((string=? (car args) "-i")
	  (loop (cdr args) res))
	 ((and (string? *src*) (string=? (car args) *src*))
	  (loop (cdr args) res))
	 (else
	  (loop (cdr args) (cons (car args) res))))))
			   

