;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Globalize/free.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jan 27 14:20:15 1995                          */
;*    Last change :  Fri Mar 22 15:46:40 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The search of free variables.                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module globalize_free
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Globalize/globalize.sch")
   (import  tools_shape
	    tools_speek
	    globalize_ast
	    parse_definition
	    engine_param
	    type_cache
	    ast_dump
	    ast_global
	    ast_local
	    globalize_global-closure
	    globalize_cache)
   (export  (get-free-vars      <ast>      <local>)
	    (free-from          <local>**  <local>)
	    (the-closure        <variable> <loc>)
	    (the-global-closure <global>   <loc>)))

;*---------------------------------------------------------------------*/
;*    *round* ...                                                      */
;*---------------------------------------------------------------------*/
(define *round* 0)

;*---------------------------------------------------------------------*/
;*    mark-var! ...                                                    */
;*---------------------------------------------------------------------*/
(define (mark-var! local)
   (let ((info (local-info local)))
      (if (var-Ginfo? info)
	  (var-Ginfo-free-mark-set! info *round*)
	  (fun-Ginfo-free-mark-set! info *round*))))

;*---------------------------------------------------------------------*/
;*    bind-var! ...                                                    */
;*---------------------------------------------------------------------*/
(define (bind-var! local integrator)
   (let ((finfo (local-info integrator)))
      (fun-Ginfo-bound-set! finfo (cons local (fun-Ginfo-bound finfo)))
      (mark-var! local)))

;*---------------------------------------------------------------------*/
;*    free-var? ...                                                    */
;*---------------------------------------------------------------------*/
(define (free-var? local)
   (let ((info (local-info local)))
      (if (var-Ginfo? info)
	  (not (eq? (var-Ginfo-free-mark info) *round*))
	  (not (eq? (fun-Ginfo-free-mark info) *round*)))))
       
;*---------------------------------------------------------------------*/
;*    get-free-vars ...                                                */
;*    -------------------------------------------------------------    */
;*    We don't need a stack, we just have to mark all bound and free   */
;*    variables.                                                       */
;*---------------------------------------------------------------------*/
(define (get-free-vars ast integrator)
   (trace (globalize loop) "get-free-vars [" (shape integrator) "] : "
	  #\Newline)
   (let ((free (fun-Ginfo-free (local-info integrator))))
      (if (or (null? free) (pair? free))
	  free
	  (let ((free (internal-get-free-vars! ast integrator)))
	     (fun-Ginfo-free-set! (local-info integrator) free)
	     free))))

;*---------------------------------------------------------------------*/
;*    internal-get-free-vars! ...                                      */
;*    -------------------------------------------------------------    */
;*    This function, makes a side effect on integrator because,        */
;*    it maintains `bound' variables list.                             */
;*---------------------------------------------------------------------*/
(define (internal-get-free-vars!  ast integrator)
   (set! *round* (+fx *round* 1))
   ;; we mark integrator and its formals
   (bind-var! integrator integrator)
   (for-each (lambda (l) (bind-var! l integrator))
	     (function-args (local-value integrator)))
   ;; we can now walk across the body
   (let loop ((ast   ast)
	      (free  '()))
      (trace (globalize loop) "  internal-get-free-vars ["
	     (shape integrator) "] : "
	     #\Newline
	     "   ast  : " (shape ast) #\Newline
	     "   ast? : " (ast? ast) #\Newline
	     "   free : " (shape free) #\Newline)
      (ast-case ast
	 ((atom)
	  free)
	 ((kwote)
	  free)
	 ((var)
	  (let ((var (var-variable ast)))
	     (cond
		((global? var)
		 free)
		((free-var? var)
		 ;; to avoid multiples copies we mark var as bound
		 (mark-var! var)
		 (cons var free))
		(else
		 free))))
	 ((make-box)
	  (loop (make-box-value ast) free))
	 ((box-ref)
	  (loop (box-ref-var ast) free))
	 ((box-set!)
	  (loop (box-set!-var ast)
		(loop (box-set!-value ast)
		      free)))
	 ((fun)
	  (let ((var (the-closure (var-variable (fun-value ast)) #f)))
	     (cond
		((global? var)
		 free)
		((free-var? var)
		 ;; to avoid multiples copies we mark var as bound
		 (mark-var! var)
		 (cons var free))
		(else
		 free))))
	 ((prag-ma)
	  (let liip ((values (prag-ma-values ast))
		     (free   free))
	     (if (null? values)
		 free
		 (liip (cdr values) (loop (car values) free)))))
	 ((fail)
	  (loop (fail-proc ast)
		(loop (fail-msg ast)
		      (loop (fail-obj ast)
			    free))))
	 ((sequence)
	  (let liip ((asts (sequence-exp ast))
		     (free free))
	     (if (null? asts)
		 free
		 (liip (cdr asts) (loop (car asts) free)))))
	 ((conditional)
	  (loop (conditional-test ast)
		(loop (conditional-then ast)
		      (loop (conditional-else ast)
			    free))))
	 ((setq)
	  (loop (setq-val ast)
		(loop (setq-var ast) free)))
	 ((let-var)
	  (let liip ((bindings  (let-var-bindings ast))
		     (free      free))
	     (if (null? bindings)
		 (loop (let-var-body ast) free)
		 (begin
		    (bind-var! (car (car bindings)) integrator)
		    (liip (cdr bindings) (loop (cdr (car bindings)) free))))))
	 ((let-fun)
	  ;; we mark all locals functions
	  (for-each (lambda (f)
		       ;; we mark as bound the function
		       (bind-var! f integrator)
		       ;; and the closure if there is one.
		       (if (function-escape? (local-value f))
			   (bind-var! (the-local-closure f (ast-location ast))
				      integrator)))
		    (let-fun-locals ast))
	  (let liip ((locals (let-fun-locals ast))
		     (free   free))
	     (if (null? locals)
		 (loop (let-fun-body ast) free)
		 (let* ((local (car locals))
			(fun   (local-value local))
			(info  (local-info local)))
		    (for-each (lambda (l)
				 (bind-var! l integrator))
			      (function-args fun))
		    (liip (cdr locals)
			  (loop (function-body fun)
				free))))))
	 ((set-ex-it)
	  (bind-var! (var-variable (set-ex-it-exit ast)) integrator)
	  (loop (set-ex-it-body ast) free))
	 ((jump-ex-it)
	  (loop (jump-ex-it-exit ast)
		(loop (jump-ex-it-value ast) free)))
	 ((funcall)
	  (let liip ((asts (funcall-actuals ast))
		     (free free))
	     (if (null? asts)
		 (loop (funcall-fun ast)
		       free)
		 (liip (cdr asts)
		       (loop (car asts)
			     free)))))
	 ((app-ly)
	  (loop (app-ly-fun ast)
		(loop (app-ly-value ast)
		      free)))
	 ((app)
	  (let liip ((asts (app-actuals ast))
		     (free (let ((var (var-variable (app-fun ast))))
			      (cond
				 ((global? var)
				  free)
				 ((and (function-escape? (local-value var))
				       (free-var? var))
				  (mark-var! var)
				  (cons (the-closure var (app-location ast))
					free))
				 (else
				  free)))))
	     (if (null? asts)
		 free
		 (liip (cdr asts)
		       (loop (car asts)
			     free)))))
	 ((switch)
	  (let liip ((clauses (switch-clauses ast))
		     (free    free))
	     (if (null? clauses)
		 (loop (switch-test ast) free)
		 (liip (cdr clauses)
		       (loop (cdr (car clauses))
			     free))))))))
    
;*---------------------------------------------------------------------*/
;*    the-closure ...                                                  */
;*---------------------------------------------------------------------*/
(define (the-closure variable loc)
   (if (global? variable)
       (the-global-closure variable loc)
       (the-local-closure variable loc)))

;*---------------------------------------------------------------------*/
;*    the-global-closure ...                                           */
;*---------------------------------------------------------------------*/
(define (the-global-closure global loc)
   (let ((closure (function-the-closure (global-value global))))
      (if (global? closure)
	  closure
	  (let* ((closure  (declare-global-variable! (global-import global)
						     (global-module global)
						     'variable
						     (parse-formal-ident
						      (symbol-append
						       (global-name global)
						       '-env::obj))))
		 (gloclo   (make-global-closure global))
		 (arity    (function-arity (global-value global)))
		 (make-clo (if (<fx arity 0)
			       *make-va-procedure*
			       *make-fx-procedure*)))
	     (function-the-closure-set! (global-value global) closure)
	     ;; this next setting is require by the Cfa pass
	     ;; (file Cfa/closure.scm) when light and extra-light
	     ;; closures are built.
	     (function-the-closure-set! (global-value gloclo) closure)
	     (global-type-set!       closure *procedure*)
	     (global-class-set!      closure 'sprocedure)
	     ;; we put several occurrence of the variable in order to
	     ;; be sure that it would not be remove by any optimisations.
	     (global-occurrence-set! closure 100)
	     [assert check (*make-va-procedure*) (global? *make-va-procedure*)]
	     [assert check (*make-fx-procedure*) (global? *make-fx-procedure*)]
	     (global-value-set!      closure
				     (ast-app loc
					      #f
					      #f
					      (ast-var
					       loc
					       #f
					       #f
					       make-clo)
					      (list (ast-var loc #f #f gloclo)
						    (ast-atom loc #f #f arity)
						    (ast-atom loc #f #f 0))
					      #f
					      #f
					      #f
					      #f))
	     (global-occurrence-set! make-clo
				     (+fx 1 (global-occurrence make-clo)))
	     (trace (globalize loop) "J'ai pluge pour la globale: "
		    (shape closure) " l'ast: " (ast->sexp (global-value
							   closure))
		    #\Newline)
	     closure))))

;*---------------------------------------------------------------------*/
;*    the-local-closure ...                                            */
;*---------------------------------------------------------------------*/
(define (the-local-closure local loc)
   (let ((info (local-info local)))
      (if (local? (fun-Ginfo-the-closure info))
	  (fun-Ginfo-the-closure info)
	  (let ((closure (make-local-variable (local-name local) *procedure*)))
	     (local-info-set! closure (default-var-Ginfo))
	     (fun-Ginfo-the-closure-set! info closure)
	     closure))))
      
;*---------------------------------------------------------------------*/
;*    free-from ...                                                    */
;*---------------------------------------------------------------------*/
(define (free-from sets integrator)
   (set! *round* (+fx *round* 1))
   ;; we re-mark all bound variables.
   (let ((finfo (local-info integrator)))
      (trace (integrate loop)
	     "   bound(" (shape integrator) ") : "
	     (shape (fun-Ginfo-bound finfo))
	     #\Newline
	     "   sets: " (shape sets)
	     #\Newline)
      (for-each mark-var! (fun-Ginfo-bound finfo)))
   ;; then, we scan sets
   (map (lambda (set)
	   (let loop ((set set)
		      (res '()))
	      (cond
		 ((null? set)
		  res)
		 ((free-var? (car set))
		  (loop (cdr set) (cons (car set) res)))
		 (else
		  (loop (cdr set) res)))))
	sets))
   
