;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../ctn.scm ...                                                  */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 15 14:10:09 1995                          */
;*    Last change :  Wed Mar 15 15:12:00 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The computation of `Cn' and `Ct'.                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module integrate_ctn
   (include "Tools/trace.sch"
	    "Ast/ast.sch"
	    "Integrate/integrate.sch")
   (import  tools_shape
	    integrate_a)
   (export  (Cn&Ct! <a-set>)))

;*---------------------------------------------------------------------*/
;*    Cn&Ct! ...                                                       */
;*    -------------------------------------------------------------    */
;*    This function returns the list of the globalized functions due   */
;*    to the Cn property.                                              */
;*---------------------------------------------------------------------*/
(define (Cn&Ct! A)
   (let loop ((As    A)
	      (G/cn '()))
      (if (null? As)
	  (begin
	     (trace-ctn)
	     G/cn)
	  (let* ((A  (car As))
		 (f  (car A))
		 (g  (cadr A))
		 (k  (caddr A))
		 (fi (variable-info f))
		 (gi (variable-info g)))
	     (cond
		((global? g)
		 (loop (cdr As) G/cn))
		((eq? k 'tail)
		 (ifun-Ct-set! fi (cons g (ifun-Ct fi)))
		 (if (and (not (eq? f g))
			  (not (memq g (ifun-kont fi))))
		     (ifun-kont-set! fi (cons g (ifun-kont fi))))
		 (loop (cdr As) G/cn))
		((eq? k 'escape)
		 (if (not (memq g (ifun-kont fi)))
		     (ifun-kont-set! fi (cons g (ifun-kont fi))))
		 (loop (cdr As) G/cn))
		((ifun-U gi)
		 (ifun-Ct-set! fi (cons g (ifun-Ct fi)))
		 (if (not (memq g (ifun-kont fi)))
		     (ifun-kont-set! fi (cons g (ifun-kont fi))))
		 (loop (cdr As) G/cn))
		(else
		 (ifun-Cn-set! fi (cons g (ifun-Cn fi)))
		 (if (not (ifun-G? gi))
		     (begin
			(ifun-G?-set! gi #t)
			(loop (cdr As) (cons g G/cn)))
		     (loop (cdr As) G/cn))))))))

;*---------------------------------------------------------------------*/
;*    trace-ctn ...                                                    */
;*---------------------------------------------------------------------*/
(define (trace-ctn)
   (when-trace '(integrate loop)
	       (lambda ()
		  (fprint *trace-port* "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~")
		  (fprint *trace-port* "C: " #\Newline)
		  (for-each (lambda (p)
			       (let ((ifun (variable-info p)))
				  (fprint *trace-port*
					  " --> " (shape p) #\: #\Newline
					  "   Cn        : "
					  (shape (ifun-Cn ifun))
					  #\Newline
					  "   Ct        : "
					  (shape (ifun-Ct ifun))
					  #\Newline
					  "   Cont      : "
					  (shape (ifun-kont ifun)))))
			    *phi*)
		  (fprint *trace-port* "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"))))

