;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/callcc.scm                   */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Nov  3 13:57:49 1992                          */
;*    Last change :  Wed Apr  3 14:37:59 1996 (serrano)                */
;*                                                                     */
;*    On test differents call/cc                                       */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module callcc
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-callcc)))

;*---------------------------------------------------------------------*/
;*    cons-gd ...                                                      */
;*---------------------------------------------------------------------*/
(define-macro (cons-gd a d)
   `(let ((a ,a))
       (cons a ,d)))

;*---------------------------------------------------------------------*/
;*    qnc-plante ...                                                   */
;*---------------------------------------------------------------------*/
(define (qnc-plante x)
   (labels ((f1 (a) (+fx a x)))
      (set! x (+fx x 1))
      f1))

;*---------------------------------------------------------------------*/
;*    list-length ...                                                  */
;*---------------------------------------------------------------------*/
(define list-length
   (lambda (obj)
      (call/cc
       (lambda (return)
	  (letrec ((r (lambda (obj)
			 (cond ((null? obj) 0)
			       ((pair? obj)
				(+ (r (cdr obj)) 1))
			       (else (return #f))))))
	     (r obj))))))

;*---------------------------------------------------------------------*/
;*    test1 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test1)
   (let (v)
      (let ((k (call/cc (lambda (x) (set! v x)))))
	 (if k
	     v
	     (lambda (x) x)))))

;*---------------------------------------------------------------------*/
;*    test2 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test2 prefix)
   (call/cc (lambda (exit)
	       (if (not (string? prefix))
		   (exit #f)
		   (exit (mgensym prefix))))))
   
(define mgensym
   (let ((v -1))
      (lambda args
	 (set! v (+ 1 v))
	 (if (null? args)
	     (string->symbol (string-append "&" (integer->string v)))
	     (string->symbol (string-append (car args)
					    (integer->string v)))))))

;*---------------------------------------------------------------------*/
;*    test3 ...                                                        */
;*    -------------------------------------------------------------    */
;*    Cette fonction test les interferences possibles entre le GC et   */
;*    call/cc                                                          */
;*---------------------------------------------------------------------*/
(define (test3) 
   (let ((s (make-string (* 1024 600))))
      (eval '(define resume (lambda (v) (display "not initialized"))))
      (eval '(define (callcc-foo n)
		(bind-exit (stop)
			   (define (loop f)
			      (call/cc (lambda (k)
					  (set! resume k)
					  (f)))
			      (loop f))
			   (loop (lambda () (begin
					       (set! n (- n 1))
					       (if (= n 0)
						   (stop n)
						   (resume n))))))))
      (eval '(callcc-foo 100))))

;*---------------------------------------------------------------------*/
;*    make-box ...                                                     */
;*---------------------------------------------------------------------*/
(define (make-box value)
  (let ((box
         (call/cc
          (lambda (exit)
            (letrec
                ((behavior
                  (call/cc
                   (lambda (store)
                     (exit (lambda (msg . new)
                             (call/cc
                              (lambda (caller)
                                (case msg
                                  ((get) (store (cons (car behavior) caller)))
                                  ((set)
                                   (store (cons (car new) caller)) ) )))))))))
              ((cdr behavior) (car behavior)) ) ) ) ) )
    (box 'set value)
    box ) )

(define box1 (make-box 33))

;*---------------------------------------------------------------------*/
;*    lambda-trace                                                     */
;*---------------------------------------------------------------------*/
(define (lambda-trace x)
   (let (r)
      (try (ccbar1 x)
	   (lambda (k a b c)
	      (set! r c)
	      (k #unspecified)))
      r))

(define (ccbar1 x)
   (car (call/cc (lambda (exit)
		    (ccbar2 exit x)))))

(define (ccbar2 f x)
   (f x))

;*---------------------------------------------------------------------*/
;*    test-callcc ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-callcc)
   (test-module "callcc" "callcc.scm" #t)
   (test "call/cc(r4)" (call/cc (lambda (exit)
				   (for-each (lambda (x)
						(if (negative? x)
						    (exit x)))
					     '(54 0 37 -3 245 19))
				   #t))
	 -3)
   (test "call/cc(r4)" (list-length '(1 2 3 4)) 4)
   (test "call/cc(r4)" (list-length '(a b . c)) #f)
   (test "call/cc(simple)" (call/cc (lambda (k) 'a)) 'a)
   (test "call/cc(simple)" (call/cc (lambda (k) (k 'a))) 'a)
   (test "call/cc(simple)" (call/cc (lambda (k) (cons (k 'a) 1))) 'a)
   (test "call/cc(set!)" ((test1) #f) #f)
   (test "call/cc(set!)" ((lambda (a)
			       (begin (set! a (call/cc (lambda (k) k)))
				      (a (lambda (x) 1))))
			    2)
	 1)
   (test "call/cc(set!)" ((lambda (a b)
			       (begin (set! a (call/cc (lambda (k) k)))
				      (begin (set! b (+ 1 b))
					     (a (lambda (x) b)))))
			    3 0)
	 2)
   (test "call/cc(set!)"
	 ((lambda (foo)
	     (begin
		(set! foo ((lambda (z)
			      (lambda (x)
				 ((lambda (y) (begin (set! z x) y))
				  z)))
			   'z))
		(cons-gd (foo (call/cc (lambda (k) ; store A and return Z
				       (k 'a))))
		      (cons-gd (foo (call/cc (lambda (k) ; store B, return A
					     (cons-gd 1 (k 'b)))))
			    (cons-gd (foo (call/cc (lambda (k)
						   (cons-gd 2 (k k)))))
				  (cons-gd ((lambda (x)
					    (if (symbol? x) 'ee (x 'e)))
					 (foo 'd))
					(cons-gd (foo 'f)
					      '())))))))
	  'foo)
	 '(z a d ee d))
   (test "call/cc(set!)"
	 ((lambda (foo)
	     (begin
		(set! foo ((lambda (z)
			      (lambda (x u)
				 ((lambda (y) (begin (set! z x) y))
				  z)))
			   'z))
		(cons-gd (foo (call/cc (lambda (k)
				       (k 'a)))
			   1)
		      (cons-gd (foo (call/cc (lambda (k)
					     (cons-gd 1 (k 'b))))
				 2)
			    (cons-gd (foo (call/cc (lambda (k)
						   (cons-gd 2 (k k))))
				       3)
				  (cons-gd ((lambda (x)
					    (if (symbol? x) 'ee (x 'e)) )
					 (foo 'd 4))
					(cons-gd (foo 'f 5) '())))))))
	  'foo)
	 '(z a d ee d))
   (test "call/cc(set!)" (test2 'toto) #f)
   (test "call/cc(set!)" (test2 "TOTO") 'toto0)
   (test "call/cc(gc)" (test3) 0)
   (test "box" (box1 'get) 33)
   (test "box" (begin (box1 'set 44) (box1 'get)) 44)
   (test "eval" (begin
		   (eval '(define (next-leaf-generator obj eot)
			     (letrec ((return #f)
				      (cont (lambda (x)
					       (recur obj)
					       (set! cont (lambda (x)
							     (return eot)))
					       (cont #f)))
				      (recur (lambda (obj)
						(if (pair? obj)
						    (for-each recur obj)
						    (begin
						       (call/cc
							(lambda (c)
							   (set! cont c)
							   (return obj))))))))
				(lambda ()
				   (call/cc
				    (lambda (ret)
				       (set! return ret) (cont #f)))))))

		   (eval '(define (leaf-eq? x y)
			     (let* ((eot (list 'eot))
				    (xf (next-leaf-generator x eot))
				    (yf (next-leaf-generator y eot)))
				(let loop ((x (xf)) (y (yf)))
				   (cond ((not (eq? x y)) #f)
					 ((eq? eot x) #t)
					 (else
					  (loop (xf) (yf))))))))

		   (eval '(leaf-eq? '(a a) '(a b))))
	 #f)
   (test "lambda-stack" (lambda-trace 1) 1)
   (test "cell-ref" ((qnc-plante 4) 5) 10))


		  
   
	    

