/*---------------------------------------------------------------------*/
/*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*=====================================================================*/
/*   Ieee/string.scm                                                   */
/*   Bigloo (v1.8)                                                     */
/*   Manuel Serrano (c)       Thu Apr 11 10:48:22 PDT 1996             */
/*=====================================================================*/
#define THE_GC BOEHM_GC
#define BIGLOO_DEBUG 1

#include <bigloo.h>
#include <signal.h>

/* The C generated type (for typed structures) */
extern obj_t _string_____r4_strings_6_7_45( obj_t, obj_t, obj_t );
extern obj_t _string_____r4_strings_6_7_236( obj_t, obj_t, obj_t );
static obj_t symbol1402___r4_strings_6_7 = BUNSPEC;
DEFINE_STRING( string1357___r4_strings_6_7, aux2357, "index out of range", 18 );
static obj_t symbol1419___r4_strings_6_7 = BUNSPEC;
extern bool_t string_cigt( obj_t, obj_t );
static obj_t symbol1375___r4_strings_6_7 = BUNSPEC;
DEFINE_STRING( string1347___r4_strings_6_7, aux2358, "blit-string", 11 );
static obj_t symbol1372___r4_strings_6_7 = BUNSPEC;
extern obj_t _string_append___r4_strings_6_7_245( obj_t, obj_t );
extern obj_t _string_ci_____r4_strings_6_7_221( obj_t, obj_t, obj_t );
static obj_t symbol1426___r4_strings_6_7 = BUNSPEC;
extern obj_t _string_upcase___r4_strings_6_7_209( obj_t, obj_t );
extern obj_t string_for_read( obj_t );
static obj_t symbol1391___r4_strings_6_7 = BUNSPEC;
extern obj_t blit_string_ur____r4_strings_6_7_25( obj_t, obj_t, obj_t, obj_t, obj_t );
extern obj_t list__string___r4_strings_6_7_155( obj_t );
extern bool_t string_____r4_strings_6_7_167( obj_t, obj_t );
extern bool_t string_____r4_strings_6_7_232( obj_t, obj_t );
DEFINE_STRING( string1345___r4_strings_6_7, aux2360, "Type `BINT' expected", 20 );
static obj_t symbol1377___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1404___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1366___r4_strings_6_7 = BUNSPEC;
DEFINE_STRING( string1389___r4_strings_6_7, aux2361, "Illegal index", 13 );
extern obj_t make_string___r4_strings_6_7_49( int, obj_t );
static obj_t symbol1394___r4_strings_6_7 = BUNSPEC;
extern obj_t _substring_ur___r4_strings_6_7_194( obj_t, obj_t, obj_t, obj_t );
static obj_t *__cnst;
extern obj_t reverse____r4_pairs_and_lists_6_3_107( obj_t );
extern obj_t check_version____bigloo_18( obj_t, char *, obj_t );
DEFINE_STRING( string1384___r4_strings_6_7, aux2362, "Type `LONG' expected", 20 );
extern bool_t bigloo_strcmp( obj_t, obj_t );
static obj_t symbol1378___r4_strings_6_7 = BUNSPEC;
extern bool_t strcicmp( obj_t, obj_t );
extern unsigned char string_ref_ur___r4_strings_6_7_193( obj_t, long );
extern obj_t _string_for_read___r4_strings_6_7_166( obj_t, obj_t );
extern obj_t string_to_bstring( char * );
static obj_t symbol1353___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1365___r4_strings_6_7 = BUNSPEC;
extern obj_t _string_ci_____r4_strings_6_7_11( obj_t, obj_t, obj_t );
extern obj_t _string__list___r4_strings_6_7_217( obj_t, obj_t );
static obj_t symbol1431___r4_strings_6_7 = BUNSPEC;
extern bool_t string_lt( obj_t, obj_t );
DEFINE_STRING( string1424___r4_strings_6_7, aux2363, "Type `INT' expected", 19 );
static obj_t symbol1392___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1420___r4_strings_6_7 = BUNSPEC;
DEFINE_STRING( string1367___r4_strings_6_7, aux2364, "Type `PAIR' expected", 20 );
static obj_t tvectors_declarations____r4_strings_6_7_61();
extern obj_t _string_set_ur____r4_strings_6_7_76( obj_t, obj_t, obj_t, obj_t );
static obj_t symbol1422___r4_strings_6_7 = BUNSPEC;
extern obj_t _string_ci______r4_strings_6_7_43( obj_t, obj_t, obj_t );
extern bool_t string_cige( obj_t, obj_t );
extern obj_t _list__string___r4_strings_6_7_204( obj_t, obj_t );
static obj_t symbol1423___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1354___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1364___r4_strings_6_7 = BUNSPEC;
extern obj_t initialization___r4_strings_6_7();
extern obj_t initialization___error();
static obj_t symbol1346___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1415___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1429___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1421___r4_strings_6_7 = BUNSPEC;
extern obj_t _string_set____r4_strings_6_7_22( obj_t, obj_t, obj_t, obj_t );
static obj_t symbol1411___r4_strings_6_7 = BUNSPEC;
extern obj_t _string______r4_strings_6_7_172( obj_t, obj_t, obj_t );
static obj_t symbol1361___r4_strings_6_7 = BUNSPEC;
extern long string_length___r4_strings_6_7_227( obj_t );
extern obj_t _string_fill____r4_strings_6_7_203( obj_t, obj_t, obj_t );
extern obj_t _string___r4_strings_6_7( obj_t, obj_t );
DEFINE_STRING( string1344___r4_strings_6_7, aux2365, "Type `BSTRING' expected", 23 );
static obj_t symbol1376___r4_strings_6_7 = BUNSPEC;
static obj_t loop_local1182( obj_t );
extern obj_t blit_string____r4_strings_6_7_126( obj_t, obj_t, obj_t, obj_t, obj_t );
static obj_t symbol1407___r4_strings_6_7 = BUNSPEC;
extern obj_t _string______r4_strings_6_7_18( obj_t, obj_t, obj_t );
extern obj_t make_string( long, unsigned char );
extern obj_t _string_ref_ur___r4_strings_6_7_226( obj_t, obj_t, obj_t );
static obj_t symbol1370___r4_strings_6_7 = BUNSPEC;
extern obj_t error_location___error_27( obj_t, obj_t, obj_t, obj_t, obj_t );
extern obj_t string_downcase____r4_strings_6_7_100( obj_t );
static obj_t symbol1427___r4_strings_6_7 = BUNSPEC;
extern bool_t string_ge( obj_t, obj_t );
DEFINE_STRING( string1360___r4_strings_6_7, aux2366, "string-set!", 11 );
extern obj_t string__list___r4_strings_6_7_22( obj_t );
extern obj_t _make_string___r4_strings_6_7_239( obj_t, obj_t, obj_t );
DEFINE_STRING( string1359___r4_strings_6_7, aux2368, "Type `UCHAR' expected", 21 );
DEFINE_STRING( string1380___r4_strings_6_7, aux2369, "", 0 );
static obj_t symbol1432___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1362___r4_strings_6_7 = BUNSPEC;
extern obj_t _string_downcase___r4_strings_6_7_212( obj_t, obj_t );
static obj_t symbol1371___r4_strings_6_7 = BUNSPEC;
extern obj_t string_to_symbol( char * );
static obj_t symbol1352___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1400___r4_strings_6_7 = BUNSPEC;
extern obj_t blit_string( obj_t, obj_t, obj_t, obj_t, obj_t );
static obj_t symbol1386___r4_strings_6_7 = BUNSPEC;
extern obj_t substring_ur___r4_strings_6_7_255( obj_t, long, long );
extern bool_t string____r4_strings_6_7_141( obj_t );
static obj_t symbol1413___r4_strings_6_7 = BUNSPEC;
extern bool_t string______r4_strings_6_7_155( obj_t, obj_t );
static obj_t symbol1408___r4_strings_6_7 = BUNSPEC;
DEFINE_STRING( string1388___r4_strings_6_7, aux2370, "substring", 9 );
static obj_t symbol1373___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1385___r4_strings_6_7 = BUNSPEC;
extern bool_t string_____r4_strings_6_7_230( obj_t, obj_t );
extern obj_t _string_downcase____r4_strings_6_7_39( obj_t, obj_t );
static obj_t symbol1412___r4_strings_6_7 = BUNSPEC;
extern obj_t string_upcase___r4_strings_6_7_224( obj_t );
static obj_t symbol1409___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1382___r4_strings_6_7 = BUNSPEC;
extern bool_t string_ci______r4_strings_6_7_112( obj_t, obj_t );
DEFINE_STRING( string1349___r4_strings_6_7, aux2371, "/udir/serrano/prgm/project/bigloo/Ieee/string.scm", 49 );
static obj_t symbol1358___r4_strings_6_7 = BUNSPEC;
extern bool_t string_ci______r4_strings_6_7_131( obj_t, obj_t );
extern unsigned char string_ref___r4_strings_6_7_35( obj_t, long );
extern obj_t _substring___r4_strings_6_7( obj_t, obj_t, obj_t, obj_t );
static obj_t symbol1399___r4_strings_6_7 = BUNSPEC;
extern obj_t _blit_string____r4_strings_6_7_7( obj_t, obj_t, obj_t, obj_t, obj_t, obj_t );
static obj_t symbol1416___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1343___r4_strings_6_7 = BUNSPEC;
extern obj_t string_set____r4_strings_6_7_56( obj_t, long, unsigned char );
static obj_t symbol1406___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1393___r4_strings_6_7 = BUNSPEC;
extern bool_t string_le( obj_t, obj_t );
extern obj_t _string_ref___r4_strings_6_7_61( obj_t, obj_t, obj_t );
static obj_t symbol1425___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1369___r4_strings_6_7 = BUNSPEC;
extern obj_t _string_____r4_strings_6_7_63( obj_t, obj_t, obj_t );
static obj_t symbol1418___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1403___r4_strings_6_7 = BUNSPEC;
extern long list_length( obj_t );
extern obj_t string_upcase____r4_strings_6_7_99( obj_t );
static obj_t symbol1401___r4_strings_6_7 = BUNSPEC;
extern bool_t string_cile( obj_t, obj_t );
static obj_t symbol1381___r4_strings_6_7 = BUNSPEC;
extern bool_t string_gt( obj_t, obj_t );
extern bool_t string______r4_strings_6_7_208( obj_t, obj_t );
extern obj_t _string_ci_____r4_strings_6_7_240( obj_t, obj_t, obj_t );
static obj_t symbol1387___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1350___r4_strings_6_7 = BUNSPEC;
extern obj_t string_downcase___r4_strings_6_7_41( obj_t );
static obj_t symbol1417___r4_strings_6_7 = BUNSPEC;
extern obj_t string_fill____r4_strings_6_7_145( obj_t, unsigned char );
extern obj_t _string____r4_strings_6_7_133( obj_t, obj_t );
static obj_t symbol1363___r4_strings_6_7 = BUNSPEC;
extern obj_t string_append___r4_strings_6_7_48( obj_t );
static obj_t symbol1405___r4_strings_6_7 = BUNSPEC;
extern bool_t string_cilt( obj_t, obj_t );
static obj_t symbol1368___r4_strings_6_7 = BUNSPEC;
extern obj_t _string_ci______r4_strings_6_7_12( obj_t, obj_t, obj_t );
extern obj_t string_append( obj_t, obj_t );
static obj_t symbol1395___r4_strings_6_7 = BUNSPEC;
extern obj_t string_for_read___r4_strings_6_7_226( obj_t );
static obj_t initialize_constants____r4_strings_6_7_47();
extern obj_t string_set_ur____r4_strings_6_7_47( obj_t, long, unsigned char );
static obj_t symbol1351___r4_strings_6_7 = BUNSPEC;
extern bool_t string_ci_____r4_strings_6_7_52( obj_t, obj_t );
extern obj_t string___r4_strings_6_7( obj_t );
static obj_t symbol1428___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1383___r4_strings_6_7 = BUNSPEC;
extern obj_t c_substring( obj_t, long, long );
DEFINE_STRING( string1348___r4_strings_6_7, aux2372, "Index and length out of range", 29 );
static obj_t initialize_imported_modules____r4_strings_6_7_237();
static obj_t symbol1397___r4_strings_6_7 = BUNSPEC;
extern obj_t substring___r4_strings_6_7( obj_t, long, long );
static obj_t symbol1414___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1398___r4_strings_6_7 = BUNSPEC;
DEFINE_STRING( string1356___r4_strings_6_7, aux2373, "string-ref", 10 );
extern obj_t _blit_string_ur____r4_strings_6_7_243( obj_t, obj_t, obj_t, obj_t, obj_t, obj_t );
static obj_t symbol1430___r4_strings_6_7 = BUNSPEC;
extern bool_t string_ci_____r4_strings_6_7_201( obj_t, obj_t );
extern obj_t _string_copy___r4_strings_6_7_217( obj_t, obj_t );
extern obj_t _string_length___r4_strings_6_7_156( obj_t, obj_t );
extern bool_t string_ci_____r4_strings_6_7_106( obj_t, obj_t );
static obj_t symbol1379___r4_strings_6_7 = BUNSPEC;
static obj_t require_initialization____r4_strings_6_7_5 = BUNSPEC;
extern obj_t _string_upcase____r4_strings_6_7_92( obj_t, obj_t );
static obj_t symbol1390___r4_strings_6_7 = BUNSPEC;
extern obj_t string_copy___r4_strings_6_7_30( obj_t );
extern obj_t __debug____error_22;
static obj_t symbol1374___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1355___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1396___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1410___r4_strings_6_7 = BUNSPEC;

DEFINE_EXPORT_PROCEDURE( list__string_env___r4_strings_6_7_156, aux2374, _list__string___r4_strings_6_7_204, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( make_string_env___r4_strings_6_7_250, aux2375, va_generic_entry, _make_string___r4_strings_6_7_239, -2 );
DEFINE_EXPORT_PROCEDURE( blit_string_ur__env___r4_strings_6_7_163, aux2376, _blit_string_ur____r4_strings_6_7_243, 0L, 5 );
DEFINE_EXPORT_PROCEDURE( string_downcase__env___r4_strings_6_7_138, aux2377, _string_downcase____r4_strings_6_7_39, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string__env___r4_strings_6_7_186, aux2378, _string____r4_strings_6_7_133, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_ci___env___r4_strings_6_7_182, aux2379, _string_ci_____r4_strings_6_7_11, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( substring_ur_env___r4_strings_6_7_191, aux2380, _substring_ur___r4_strings_6_7_194, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( blit_string__env___r4_strings_6_7_71, aux2381, _blit_string____r4_strings_6_7_7, 0L, 5 );
DEFINE_EXPORT_PROCEDURE( string___env___r4_strings_6_7_192, aux2382, _string_____r4_strings_6_7_45, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string___env___r4_strings_6_7_175, aux2383, _string_____r4_strings_6_7_63, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string__list_env___r4_strings_6_7_23, aux2384, _string__list___r4_strings_6_7_217, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_ref_ur_env___r4_strings_6_7_129, aux2385, _string_ref_ur___r4_strings_6_7_226, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_ci____env___r4_strings_6_7_116, aux2386, _string_ci______r4_strings_6_7_12, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_set_ur__env___r4_strings_6_7_142, aux2387, _string_set_ur____r4_strings_6_7_76, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( string_copy_env___r4_strings_6_7_159, aux2388, _string_copy___r4_strings_6_7_217, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string____env___r4_strings_6_7_255, aux2390, _string______r4_strings_6_7_172, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_ci___env___r4_strings_6_7_61, aux2391, _string_ci_____r4_strings_6_7_221, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_env___r4_strings_6_7_215, aux2392, va_generic_entry, _string___r4_strings_6_7, -1 );
DEFINE_EXPORT_PROCEDURE( substring_env___r4_strings_6_7_240, aux2393, _substring___r4_strings_6_7, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( string_upcase__env___r4_strings_6_7_72, aux2394, _string_upcase____r4_strings_6_7_92, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_ref_env___r4_strings_6_7_110, aux2395, _string_ref___r4_strings_6_7_61, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_set__env___r4_strings_6_7_24, aux2396, _string_set____r4_strings_6_7_22, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( string_fill__env___r4_strings_6_7_172, aux2397, _string_fill____r4_strings_6_7_203, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_upcase_env___r4_strings_6_7_94, aux2398, _string_upcase___r4_strings_6_7_209, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_ci___env___r4_strings_6_7_57, aux2403, _string_ci_____r4_strings_6_7_240, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_downcase_env___r4_strings_6_7_227, aux2405, _string_downcase___r4_strings_6_7_212, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_length_env___r4_strings_6_7_54, aux2406, _string_length___r4_strings_6_7_156, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_for_read_env___r4_strings_6_7_34, aux2407, _string_for_read___r4_strings_6_7_166, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_append_env___r4_strings_6_7_44, aux2408, va_generic_entry, _string_append___r4_strings_6_7_245, -1 );
DEFINE_EXPORT_PROCEDURE( string____env___r4_strings_6_7_156, aux2409, _string______r4_strings_6_7_18, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_ci____env___r4_strings_6_7_2, aux2410, _string_ci______r4_strings_6_7_43, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string___env___r4_strings_6_7_27, aux2411, _string_____r4_strings_6_7_236, 0L, 2 );

obj_t initialization___r4_strings_6_7()
{{PUSH_TRACE(symbol1431___r4_strings_6_7);
{obj_t res1144_980;
if(CBOOL(require_initialization____r4_strings_6_7_5)){require_initialization____r4_strings_6_7_5 = BFALSE;
__debug____error_22 = BINT(1);
initialize_imported_modules____r4_strings_6_7_237();
tvectors_declarations____r4_strings_6_7_61();
initialize_constants____r4_strings_6_7_47();
{obj_t aux1143_699;
aux1143_699 = symbol1432___r4_strings_6_7;
check_version____bigloo_18(aux1143_699, "Bigloo (v1.8)", BCHAR(((unsigned char)'b')));
}require_initialization____r4_strings_6_7_5 = BFALSE;
res1144_980 = BUNSPEC;
} else {res1144_980 = BUNSPEC;
}POP_TRACE();
return res1144_980;
}}}

obj_t initialize_imported_modules____r4_strings_6_7_237()
{initialization___error();
return BUNSPEC;
}

obj_t initialize_constants____r4_strings_6_7_47()
{symbol1343___r4_strings_6_7 = string_to_symbol("_blit-string!");
symbol1346___r4_strings_6_7 = string_to_symbol("BLIT-STRING!");
symbol1350___r4_strings_6_7 = string_to_symbol("_blit-string-ur!");
symbol1351___r4_strings_6_7 = string_to_symbol("BLIT-STRING-UR!");
symbol1352___r4_strings_6_7 = string_to_symbol("_string-for-read");
symbol1353___r4_strings_6_7 = string_to_symbol("STRING-FOR-READ");
symbol1354___r4_strings_6_7 = string_to_symbol("_string-downcase!");
symbol1355___r4_strings_6_7 = string_to_symbol("STRING-DOWNCASE!");
symbol1358___r4_strings_6_7 = string_to_symbol("string-downcase!");
symbol1361___r4_strings_6_7 = string_to_symbol("_string-upcase!");
symbol1362___r4_strings_6_7 = string_to_symbol("STRING-UPCASE!");
symbol1363___r4_strings_6_7 = string_to_symbol("string-upcase!");
symbol1364___r4_strings_6_7 = string_to_symbol("_string-downcase");
symbol1365___r4_strings_6_7 = string_to_symbol("STRING-DOWNCASE");
symbol1366___r4_strings_6_7 = string_to_symbol("string-downcase");
symbol1368___r4_strings_6_7 = string_to_symbol("_string-upcase");
symbol1369___r4_strings_6_7 = string_to_symbol("STRING-UPCASE");
symbol1370___r4_strings_6_7 = string_to_symbol("string-upcase");
symbol1371___r4_strings_6_7 = string_to_symbol("_string-fill!");
symbol1372___r4_strings_6_7 = string_to_symbol("STRING-FILL!");
symbol1373___r4_strings_6_7 = string_to_symbol("_string-copy");
symbol1374___r4_strings_6_7 = string_to_symbol("STRING-COPY");
symbol1375___r4_strings_6_7 = string_to_symbol("_string->list");
symbol1376___r4_strings_6_7 = string_to_symbol("STRING->LIST");
symbol1377___r4_strings_6_7 = string_to_symbol("LIST->STRING");
symbol1378___r4_strings_6_7 = string_to_symbol("list->string");
symbol1379___r4_strings_6_7 = string_to_symbol("STRING-APPEND");
symbol1381___r4_strings_6_7 = string_to_symbol("string-append");
symbol1382___r4_strings_6_7 = string_to_symbol("loop");
symbol1383___r4_strings_6_7 = string_to_symbol("_substring-ur");
symbol1385___r4_strings_6_7 = string_to_symbol("SUBSTRING-UR");
symbol1386___r4_strings_6_7 = string_to_symbol("_substring");
symbol1387___r4_strings_6_7 = string_to_symbol("SUBSTRING");
symbol1390___r4_strings_6_7 = string_to_symbol("substring");
symbol1391___r4_strings_6_7 = string_to_symbol("_string-ci>=?");
symbol1392___r4_strings_6_7 = string_to_symbol("STRING-CI>=?");
symbol1393___r4_strings_6_7 = string_to_symbol("_string-ci<=?");
symbol1394___r4_strings_6_7 = string_to_symbol("STRING-CI<=?");
symbol1395___r4_strings_6_7 = string_to_symbol("_string-ci>?");
symbol1396___r4_strings_6_7 = string_to_symbol("STRING-CI>?");
symbol1397___r4_strings_6_7 = string_to_symbol("_string-ci<?");
symbol1398___r4_strings_6_7 = string_to_symbol("STRING-CI<?");
symbol1399___r4_strings_6_7 = string_to_symbol("_string>=?");
symbol1400___r4_strings_6_7 = string_to_symbol("STRING>=?");
symbol1401___r4_strings_6_7 = string_to_symbol("_string<=?");
symbol1402___r4_strings_6_7 = string_to_symbol("STRING<=?");
symbol1403___r4_strings_6_7 = string_to_symbol("_string>?");
symbol1404___r4_strings_6_7 = string_to_symbol("STRING>?");
symbol1405___r4_strings_6_7 = string_to_symbol("_string<?");
symbol1406___r4_strings_6_7 = string_to_symbol("STRING<?");
symbol1407___r4_strings_6_7 = string_to_symbol("_string-ci=?");
symbol1408___r4_strings_6_7 = string_to_symbol("STRING-CI=?");
symbol1409___r4_strings_6_7 = string_to_symbol("_string=?");
symbol1410___r4_strings_6_7 = string_to_symbol("STRING=?");
symbol1411___r4_strings_6_7 = string_to_symbol("_string-set-ur!");
symbol1412___r4_strings_6_7 = string_to_symbol("STRING-SET-UR!");
symbol1413___r4_strings_6_7 = string_to_symbol("_string-ref-ur");
symbol1414___r4_strings_6_7 = string_to_symbol("STRING-REF-UR");
symbol1415___r4_strings_6_7 = string_to_symbol("_string-set!");
symbol1416___r4_strings_6_7 = string_to_symbol("STRING-SET!");
symbol1417___r4_strings_6_7 = string_to_symbol("_string-ref");
symbol1418___r4_strings_6_7 = string_to_symbol("STRING-REF");
symbol1419___r4_strings_6_7 = string_to_symbol("string-ref");
symbol1420___r4_strings_6_7 = string_to_symbol("_string-length");
symbol1421___r4_strings_6_7 = string_to_symbol("STRING-LENGTH");
symbol1422___r4_strings_6_7 = string_to_symbol("STRING");
symbol1423___r4_strings_6_7 = string_to_symbol("_make-string");
symbol1425___r4_strings_6_7 = string_to_symbol("MAKE-STRING");
symbol1426___r4_strings_6_7 = string_to_symbol("make-string");
symbol1427___r4_strings_6_7 = string_to_symbol("STRING?");
symbol1428___r4_strings_6_7 = string_to_symbol("TVECTORS-DECLARATIONS!");
symbol1429___r4_strings_6_7 = string_to_symbol("INITIALIZE-CONSTANTS!");
symbol1430___r4_strings_6_7 = string_to_symbol("INITIALIZE-IMPORTED-MODULES!");
symbol1431___r4_strings_6_7 = string_to_symbol("INITIALIZATION");
symbol1432___r4_strings_6_7 = string_to_symbol("__R4_STRINGS_6_7");
return BUNSPEC;
}

obj_t tvectors_declarations____r4_strings_6_7_61()
{{PUSH_TRACE(symbol1428___r4_strings_6_7);
{obj_t res1147_983;
res1147_983 = BUNSPEC;
POP_TRACE();
return res1147_983;
}}}

bool_t string____r4_strings_6_7_141(obj_t obj_567)
{{PUSH_TRACE(symbol1427___r4_strings_6_7);
{bool_t res1148_984;
res1148_984 = STRINGP(obj_567);
POP_TRACE();
return res1148_984;
}}}

obj_t _string____r4_strings_6_7_133(obj_t env_1016, obj_t obj_1017)
{return BBOOL(string____r4_strings_6_7_141(obj_1017));
}

obj_t make_string___r4_strings_6_7_49(int k_568, obj_t char_569)
{{PUSH_TRACE(symbol1425___r4_strings_6_7);
{obj_t res1149_985;
if(NULLP(char_569)){res1149_985 = make_string((long)(k_568), ((unsigned char)' '));
} else {obj_t aux1084_570;
{obj_t pair_850;
if(PAIRP(char_569)){pair_850 = char_569;
} else {{obj_t aux1340_1212;
aux1340_1212 = symbol1426___r4_strings_6_7;
error_location___error_27(aux1340_1212, string1367___r4_strings_6_7, char_569, string1349___r4_strings_6_7, BINT(6064));
}FAILURE(BFALSE,BFALSE,BFALSE);}aux1084_570 = CAR(pair_850);
}{unsigned char aux2235_1965;
{obj_t aux2237_1967;
if(CHARP(aux1084_570))aux2237_1967 = aux1084_570;
 else {{obj_t aux1342_1214;
aux1342_1214 = symbol1426___r4_strings_6_7;
error_location___error_27(aux1342_1214, string1359___r4_strings_6_7, aux1084_570, string1349___r4_strings_6_7, BINT(6047));
}FAILURE(BFALSE,BFALSE,BFALSE);}aux2235_1965 = (unsigned char)CCHAR(aux2237_1967);
}res1149_985 = make_string((long)(k_568), aux2235_1965);
}}POP_TRACE();
return res1149_985;
}}}

obj_t _make_string___r4_strings_6_7_239(obj_t env_1018, obj_t k_1019, obj_t char_1020)
{{int aux2215_1947;
{obj_t aux2216_1948;
if(INTEGERP(k_1019))aux2216_1948 = k_1019;
 else {FAILURE(symbol1423___r4_strings_6_7,string1424___r4_strings_6_7,k_1019);}aux2215_1947 = CINT(aux2216_1948);
}return make_string___r4_strings_6_7_49(aux2215_1947, char_1020);
}}

obj_t string___r4_strings_6_7(obj_t chars_571)
{{PUSH_TRACE(symbol1422___r4_strings_6_7);
{obj_t res1150_986;
res1150_986 = list__string___r4_strings_6_7_155(chars_571);
POP_TRACE();
return res1150_986;
}}}

obj_t _string___r4_strings_6_7(obj_t env_1021, obj_t chars_1022)
{return string___r4_strings_6_7(chars_1022);
}

long string_length___r4_strings_6_7_227(obj_t string_572)
{{PUSH_TRACE(symbol1421___r4_strings_6_7);
{long res1151_987;
res1151_987 = STRING_LENGTH(string_572);
POP_TRACE();
return res1151_987;
}}}

obj_t _string_length___r4_strings_6_7_156(obj_t env_1023, obj_t string_1024)
{{long aux2199_1933;
{obj_t aux2200_1934;
if(STRINGP(string_1024))aux2200_1934 = string_1024;
 else {FAILURE(symbol1420___r4_strings_6_7,string1344___r4_strings_6_7,string_1024);}aux2199_1933 = string_length___r4_strings_6_7_227(aux2200_1934);
}return BINT(aux2199_1933);
}}

unsigned char string_ref___r4_strings_6_7_35(obj_t string_573, long k_574)
{{PUSH_TRACE(symbol1418___r4_strings_6_7);
{unsigned char res1152_988;
if(BOUND_CHECK(k_574, STRING_LENGTH(string_573))){res1152_988 = STRING_REF(string_573, k_574);
} else {obj_t aux2188_1922;
{obj_t aux1332_1207;
aux1332_1207 = error_location___error_27(string1356___r4_strings_6_7, string1357___r4_strings_6_7, BINT(k_574), string1349___r4_strings_6_7, BINT(7001));
if(CHARP(aux1332_1207))aux2188_1922 = aux1332_1207;
 else {{obj_t aux1334_1208;
aux1334_1208 = symbol1419___r4_strings_6_7;
error_location___error_27(aux1334_1208, string1359___r4_strings_6_7, aux1332_1207, string1349___r4_strings_6_7, BINT(7001));
}FAILURE(BFALSE,BFALSE,BFALSE);}}res1152_988 = (unsigned char)CCHAR(aux2188_1922);
}POP_TRACE();
return res1152_988;
}}}

obj_t _string_ref___r4_strings_6_7_61(obj_t env_1025, obj_t string_1026, obj_t k_1027)
{{unsigned char aux2170_1904;
{long aux2175_1909;
obj_t aux2171_1905;
{obj_t aux2176_1910;
if(INTEGERP(k_1027))aux2176_1910 = k_1027;
 else {FAILURE(symbol1417___r4_strings_6_7,string1384___r4_strings_6_7,k_1027);}aux2175_1909 = (long)CINT(aux2176_1910);
}if(STRINGP(string_1026))aux2171_1905 = string_1026;
 else {FAILURE(symbol1417___r4_strings_6_7,string1344___r4_strings_6_7,string_1026);}aux2170_1904 = string_ref___r4_strings_6_7_35(aux2171_1905, aux2175_1909);
}return BCHAR(aux2170_1904);
}}

obj_t string_set____r4_strings_6_7_56(obj_t string_576, long k_577, unsigned char char_578)
{{PUSH_TRACE(symbol1416___r4_strings_6_7);
{obj_t res1153_989;
if(BOUND_CHECK(k_577, STRING_LENGTH(string_576))){res1153_989 = STRING_SET(string_576, k_577, char_578);
} else {res1153_989 = error_location___error_27(string1360___r4_strings_6_7, string1357___r4_strings_6_7, BINT(k_577), string1349___r4_strings_6_7, BINT(7412));
}POP_TRACE();
return res1153_989;
}}}

obj_t _string_set____r4_strings_6_7_22(obj_t env_1028, obj_t string_1029, obj_t k_1030, obj_t char_1031)
{{unsigned char aux2154_1888;
long aux2148_1882;
obj_t aux2144_1878;
{obj_t aux2155_1889;
if(CHARP(char_1031))aux2155_1889 = char_1031;
 else {FAILURE(symbol1415___r4_strings_6_7,string1359___r4_strings_6_7,char_1031);}aux2154_1888 = (unsigned char)CCHAR(aux2155_1889);
}{obj_t aux2149_1883;
if(INTEGERP(k_1030))aux2149_1883 = k_1030;
 else {FAILURE(symbol1415___r4_strings_6_7,string1384___r4_strings_6_7,k_1030);}aux2148_1882 = (long)CINT(aux2149_1883);
}if(STRINGP(string_1029))aux2144_1878 = string_1029;
 else {FAILURE(symbol1415___r4_strings_6_7,string1344___r4_strings_6_7,string_1029);}return string_set____r4_strings_6_7_56(aux2144_1878, aux2148_1882, aux2154_1888);
}}

unsigned char string_ref_ur___r4_strings_6_7_193(obj_t string_580, long k_581)
{{PUSH_TRACE(symbol1414___r4_strings_6_7);
{unsigned char res1154_990;
res1154_990 = STRING_REF(string_580, k_581);
POP_TRACE();
return res1154_990;
}}}

obj_t _string_ref_ur___r4_strings_6_7_226(obj_t env_1032, obj_t string_1033, obj_t k_1034)
{{unsigned char aux2128_1862;
{long aux2133_1867;
obj_t aux2129_1863;
{obj_t aux2134_1868;
if(INTEGERP(k_1034))aux2134_1868 = k_1034;
 else {FAILURE(symbol1413___r4_strings_6_7,string1384___r4_strings_6_7,k_1034);}aux2133_1867 = (long)CINT(aux2134_1868);
}if(STRINGP(string_1033))aux2129_1863 = string_1033;
 else {FAILURE(symbol1413___r4_strings_6_7,string1344___r4_strings_6_7,string_1033);}aux2128_1862 = string_ref_ur___r4_strings_6_7_193(aux2129_1863, aux2133_1867);
}return BCHAR(aux2128_1862);
}}

obj_t string_set_ur____r4_strings_6_7_47(obj_t string_582, long k_583, unsigned char char_584)
{{PUSH_TRACE(symbol1412___r4_strings_6_7);
{obj_t res1155_991;
res1155_991 = STRING_SET(string_582, k_583, char_584);
POP_TRACE();
return res1155_991;
}}}

obj_t _string_set_ur____r4_strings_6_7_76(obj_t env_1035, obj_t string_1036, obj_t k_1037, obj_t char_1038)
{{unsigned char aux2118_1852;
long aux2112_1846;
obj_t aux2108_1842;
{obj_t aux2119_1853;
if(CHARP(char_1038))aux2119_1853 = char_1038;
 else {FAILURE(symbol1411___r4_strings_6_7,string1359___r4_strings_6_7,char_1038);}aux2118_1852 = (unsigned char)CCHAR(aux2119_1853);
}{obj_t aux2113_1847;
if(INTEGERP(k_1037))aux2113_1847 = k_1037;
 else {FAILURE(symbol1411___r4_strings_6_7,string1384___r4_strings_6_7,k_1037);}aux2112_1846 = (long)CINT(aux2113_1847);
}if(STRINGP(string_1036))aux2108_1842 = string_1036;
 else {FAILURE(symbol1411___r4_strings_6_7,string1344___r4_strings_6_7,string_1036);}return string_set_ur____r4_strings_6_7_47(aux2108_1842, aux2112_1846, aux2118_1852);
}}

bool_t string_____r4_strings_6_7_232(obj_t string1_585, obj_t string2_586)
{{PUSH_TRACE(symbol1410___r4_strings_6_7);
{bool_t res1156_992;
res1156_992 = bigloo_strcmp(string1_585, string2_586);
POP_TRACE();
return res1156_992;
}}}

obj_t _string_____r4_strings_6_7_63(obj_t env_1039, obj_t string1_1040, obj_t string2_1041)
{{bool_t aux2094_1828;
{obj_t aux2099_1833;
obj_t aux2095_1829;
if(STRINGP(string2_1041))aux2099_1833 = string2_1041;
 else {FAILURE(symbol1409___r4_strings_6_7,string1344___r4_strings_6_7,string2_1041);}if(STRINGP(string1_1040))aux2095_1829 = string1_1040;
 else {FAILURE(symbol1409___r4_strings_6_7,string1344___r4_strings_6_7,string1_1040);}aux2094_1828 = string_____r4_strings_6_7_232(aux2095_1829, aux2099_1833);
}return BBOOL(aux2094_1828);
}}

bool_t string_ci_____r4_strings_6_7_52(obj_t string1_587, obj_t string2_588)
{{PUSH_TRACE(symbol1408___r4_strings_6_7);
{bool_t res1157_993;
res1157_993 = strcicmp(string1_587, string2_588);
POP_TRACE();
return res1157_993;
}}}

obj_t _string_ci_____r4_strings_6_7_221(obj_t env_1042, obj_t string1_1043, obj_t string2_1044)
{{bool_t aux2080_1814;
{obj_t aux2085_1819;
obj_t aux2081_1815;
if(STRINGP(string2_1044))aux2085_1819 = string2_1044;
 else {FAILURE(symbol1407___r4_strings_6_7,string1344___r4_strings_6_7,string2_1044);}if(STRINGP(string1_1043))aux2081_1815 = string1_1043;
 else {FAILURE(symbol1407___r4_strings_6_7,string1344___r4_strings_6_7,string1_1043);}aux2080_1814 = string_ci_____r4_strings_6_7_52(aux2081_1815, aux2085_1819);
}return BBOOL(aux2080_1814);
}}

bool_t string_____r4_strings_6_7_230(obj_t string1_589, obj_t string2_590)
{{PUSH_TRACE(symbol1406___r4_strings_6_7);
{bool_t res1158_994;
res1158_994 = string_lt(string1_589, string2_590);
POP_TRACE();
return res1158_994;
}}}

obj_t _string_____r4_strings_6_7_45(obj_t env_1045, obj_t string1_1046, obj_t string2_1047)
{{bool_t aux2066_1800;
{obj_t aux2071_1805;
obj_t aux2067_1801;
if(STRINGP(string2_1047))aux2071_1805 = string2_1047;
 else {FAILURE(symbol1405___r4_strings_6_7,string1344___r4_strings_6_7,string2_1047);}if(STRINGP(string1_1046))aux2067_1801 = string1_1046;
 else {FAILURE(symbol1405___r4_strings_6_7,string1344___r4_strings_6_7,string1_1046);}aux2066_1800 = string_____r4_strings_6_7_230(aux2067_1801, aux2071_1805);
}return BBOOL(aux2066_1800);
}}

bool_t string_____r4_strings_6_7_167(obj_t string1_591, obj_t string2_592)
{{PUSH_TRACE(symbol1404___r4_strings_6_7);
{bool_t res1159_995;
res1159_995 = string_gt(string1_591, string2_592);
POP_TRACE();
return res1159_995;
}}}

obj_t _string_____r4_strings_6_7_236(obj_t env_1048, obj_t string1_1049, obj_t string2_1050)
{{bool_t aux2052_1786;
{obj_t aux2057_1791;
obj_t aux2053_1787;
if(STRINGP(string2_1050))aux2057_1791 = string2_1050;
 else {FAILURE(symbol1403___r4_strings_6_7,string1344___r4_strings_6_7,string2_1050);}if(STRINGP(string1_1049))aux2053_1787 = string1_1049;
 else {FAILURE(symbol1403___r4_strings_6_7,string1344___r4_strings_6_7,string1_1049);}aux2052_1786 = string_____r4_strings_6_7_167(aux2053_1787, aux2057_1791);
}return BBOOL(aux2052_1786);
}}

bool_t string______r4_strings_6_7_208(obj_t string1_593, obj_t string2_594)
{{PUSH_TRACE(symbol1402___r4_strings_6_7);
{bool_t res1160_996;
res1160_996 = string_le(string1_593, string2_594);
POP_TRACE();
return res1160_996;
}}}

obj_t _string______r4_strings_6_7_172(obj_t env_1051, obj_t string1_1052, obj_t string2_1053)
{{bool_t aux2038_1772;
{obj_t aux2043_1777;
obj_t aux2039_1773;
if(STRINGP(string2_1053))aux2043_1777 = string2_1053;
 else {FAILURE(symbol1401___r4_strings_6_7,string1344___r4_strings_6_7,string2_1053);}if(STRINGP(string1_1052))aux2039_1773 = string1_1052;
 else {FAILURE(symbol1401___r4_strings_6_7,string1344___r4_strings_6_7,string1_1052);}aux2038_1772 = string______r4_strings_6_7_208(aux2039_1773, aux2043_1777);
}return BBOOL(aux2038_1772);
}}

bool_t string______r4_strings_6_7_155(obj_t string1_595, obj_t string2_596)
{{PUSH_TRACE(symbol1400___r4_strings_6_7);
{bool_t res1161_997;
res1161_997 = string_ge(string1_595, string2_596);
POP_TRACE();
return res1161_997;
}}}

obj_t _string______r4_strings_6_7_18(obj_t env_1054, obj_t string1_1055, obj_t string2_1056)
{{bool_t aux2024_1758;
{obj_t aux2029_1763;
obj_t aux2025_1759;
if(STRINGP(string2_1056))aux2029_1763 = string2_1056;
 else {FAILURE(symbol1399___r4_strings_6_7,string1344___r4_strings_6_7,string2_1056);}if(STRINGP(string1_1055))aux2025_1759 = string1_1055;
 else {FAILURE(symbol1399___r4_strings_6_7,string1344___r4_strings_6_7,string1_1055);}aux2024_1758 = string______r4_strings_6_7_155(aux2025_1759, aux2029_1763);
}return BBOOL(aux2024_1758);
}}

bool_t string_ci_____r4_strings_6_7_201(obj_t string1_597, obj_t string2_598)
{{PUSH_TRACE(symbol1398___r4_strings_6_7);
{bool_t res1162_998;
res1162_998 = string_cilt(string1_597, string2_598);
POP_TRACE();
return res1162_998;
}}}

obj_t _string_ci_____r4_strings_6_7_11(obj_t env_1057, obj_t string1_1058, obj_t string2_1059)
{{bool_t aux2010_1744;
{obj_t aux2015_1749;
obj_t aux2011_1745;
if(STRINGP(string2_1059))aux2015_1749 = string2_1059;
 else {FAILURE(symbol1397___r4_strings_6_7,string1344___r4_strings_6_7,string2_1059);}if(STRINGP(string1_1058))aux2011_1745 = string1_1058;
 else {FAILURE(symbol1397___r4_strings_6_7,string1344___r4_strings_6_7,string1_1058);}aux2010_1744 = string_ci_____r4_strings_6_7_201(aux2011_1745, aux2015_1749);
}return BBOOL(aux2010_1744);
}}

bool_t string_ci_____r4_strings_6_7_106(obj_t string1_599, obj_t string2_600)
{{PUSH_TRACE(symbol1396___r4_strings_6_7);
{bool_t res1163_999;
res1163_999 = string_cigt(string1_599, string2_600);
POP_TRACE();
return res1163_999;
}}}

obj_t _string_ci_____r4_strings_6_7_240(obj_t env_1060, obj_t string1_1061, obj_t string2_1062)
{{bool_t aux1996_1730;
{obj_t aux2001_1735;
obj_t aux1997_1731;
if(STRINGP(string2_1062))aux2001_1735 = string2_1062;
 else {FAILURE(symbol1395___r4_strings_6_7,string1344___r4_strings_6_7,string2_1062);}if(STRINGP(string1_1061))aux1997_1731 = string1_1061;
 else {FAILURE(symbol1395___r4_strings_6_7,string1344___r4_strings_6_7,string1_1061);}aux1996_1730 = string_ci_____r4_strings_6_7_106(aux1997_1731, aux2001_1735);
}return BBOOL(aux1996_1730);
}}

bool_t string_ci______r4_strings_6_7_112(obj_t string1_601, obj_t string2_602)
{{PUSH_TRACE(symbol1394___r4_strings_6_7);
{bool_t res1164_1000;
res1164_1000 = string_cile(string1_601, string2_602);
POP_TRACE();
return res1164_1000;
}}}

obj_t _string_ci______r4_strings_6_7_43(obj_t env_1063, obj_t string1_1064, obj_t string2_1065)
{{bool_t aux1982_1716;
{obj_t aux1987_1721;
obj_t aux1983_1717;
if(STRINGP(string2_1065))aux1987_1721 = string2_1065;
 else {FAILURE(symbol1393___r4_strings_6_7,string1344___r4_strings_6_7,string2_1065);}if(STRINGP(string1_1064))aux1983_1717 = string1_1064;
 else {FAILURE(symbol1393___r4_strings_6_7,string1344___r4_strings_6_7,string1_1064);}aux1982_1716 = string_ci______r4_strings_6_7_112(aux1983_1717, aux1987_1721);
}return BBOOL(aux1982_1716);
}}

bool_t string_ci______r4_strings_6_7_131(obj_t string1_603, obj_t string2_604)
{{PUSH_TRACE(symbol1392___r4_strings_6_7);
{bool_t res1165_1001;
res1165_1001 = string_cige(string1_603, string2_604);
POP_TRACE();
return res1165_1001;
}}}

obj_t _string_ci______r4_strings_6_7_12(obj_t env_1066, obj_t string1_1067, obj_t string2_1068)
{{bool_t aux1968_1702;
{obj_t aux1973_1707;
obj_t aux1969_1703;
if(STRINGP(string2_1068))aux1973_1707 = string2_1068;
 else {FAILURE(symbol1391___r4_strings_6_7,string1344___r4_strings_6_7,string2_1068);}if(STRINGP(string1_1067))aux1969_1703 = string1_1067;
 else {FAILURE(symbol1391___r4_strings_6_7,string1344___r4_strings_6_7,string1_1067);}aux1968_1702 = string_ci______r4_strings_6_7_131(aux1969_1703, aux1973_1707);
}return BBOOL(aux1968_1702);
}}

obj_t substring___r4_strings_6_7(obj_t string_605, long start_606, long end_607)
{{PUSH_TRACE(symbol1387___r4_strings_6_7);
{obj_t res1166_1002;
{bool_t test1946_1680;
if((end_607>=start_606)){if(BOUND_CHECK(start_606, (STRING_LENGTH(string_605)+1)))test1946_1680 = BOUND_CHECK(end_607, (STRING_LENGTH(string_605)+1));
 else test1946_1680 = ((bool_t)0);
} else test1946_1680 = ((bool_t)0);
if(test1946_1680){res1166_1002 = c_substring(string_605, start_606, end_607);
} else {obj_t aux1091_612;
aux1091_612 = MAKE_PAIR(BINT(start_606), BINT(end_607));
{obj_t aux1285_1175;
aux1285_1175 = error_location___error_27(string1388___r4_strings_6_7, string1389___r4_strings_6_7, aux1091_612, string1349___r4_strings_6_7, BINT(11590));
if(STRINGP(aux1285_1175)){res1166_1002 = aux1285_1175;
} else {{obj_t aux1287_1176;
aux1287_1176 = symbol1390___r4_strings_6_7;
error_location___error_27(aux1287_1176, string1344___r4_strings_6_7, aux1285_1175, string1349___r4_strings_6_7, BINT(11590));
}FAILURE(BFALSE,BFALSE,BFALSE);}}}}POP_TRACE();
return res1166_1002;
}}}

obj_t _substring___r4_strings_6_7(obj_t env_1069, obj_t string_1070, obj_t start_1071, obj_t end_1072)
{{long aux1938_1672;
long aux1932_1666;
obj_t aux1928_1662;
{obj_t aux1939_1673;
if(INTEGERP(end_1072))aux1939_1673 = end_1072;
 else {FAILURE(symbol1386___r4_strings_6_7,string1384___r4_strings_6_7,end_1072);}aux1938_1672 = (long)CINT(aux1939_1673);
}{obj_t aux1933_1667;
if(INTEGERP(start_1071))aux1933_1667 = start_1071;
 else {FAILURE(symbol1386___r4_strings_6_7,string1384___r4_strings_6_7,start_1071);}aux1932_1666 = (long)CINT(aux1933_1667);
}if(STRINGP(string_1070))aux1928_1662 = string_1070;
 else {FAILURE(symbol1386___r4_strings_6_7,string1344___r4_strings_6_7,string_1070);}return substring___r4_strings_6_7(aux1928_1662, aux1932_1666, aux1938_1672);
}}

obj_t substring_ur___r4_strings_6_7_255(obj_t string_613, long start_614, long end_615)
{{PUSH_TRACE(symbol1385___r4_strings_6_7);
{obj_t res1167_1003;
res1167_1003 = c_substring(string_613, start_614, end_615);
POP_TRACE();
return res1167_1003;
}}}

obj_t _substring_ur___r4_strings_6_7_194(obj_t env_1073, obj_t string_1074, obj_t start_1075, obj_t end_1076)
{{long aux1918_1652;
long aux1912_1646;
obj_t aux1908_1642;
{obj_t aux1919_1653;
if(INTEGERP(end_1076))aux1919_1653 = end_1076;
 else {FAILURE(symbol1383___r4_strings_6_7,string1384___r4_strings_6_7,end_1076);}aux1918_1652 = (long)CINT(aux1919_1653);
}{obj_t aux1913_1647;
if(INTEGERP(start_1075))aux1913_1647 = start_1075;
 else {FAILURE(symbol1383___r4_strings_6_7,string1384___r4_strings_6_7,start_1075);}aux1912_1646 = (long)CINT(aux1913_1647);
}if(STRINGP(string_1074))aux1908_1642 = string_1074;
 else {FAILURE(symbol1383___r4_strings_6_7,string1344___r4_strings_6_7,string_1074);}return substring_ur___r4_strings_6_7_255(aux1908_1642, aux1912_1646, aux1918_1652);
}}

obj_t loop_local1182(obj_t list_618)
{{bool_t test1868_1602;
{obj_t aux1092_619;
{obj_t pair_861;
if(PAIRP(list_618)){pair_861 = list_618;
} else {{obj_t aux1254_1158;
aux1254_1158 = symbol1382___r4_strings_6_7;
error_location___error_27(aux1254_1158, string1367___r4_strings_6_7, list_618, string1349___r4_strings_6_7, BINT(12279));
}FAILURE(BFALSE,BFALSE,BFALSE);}aux1092_619 = CDR(pair_861);
}test1868_1602 = NULLP(aux1092_619);
}if(test1868_1602){obj_t pair_862;
if(PAIRP(list_618)){pair_862 = list_618;
} else {{obj_t aux1262_1160;
aux1262_1160 = symbol1382___r4_strings_6_7;
error_location___error_27(aux1262_1160, string1367___r4_strings_6_7, list_618, string1349___r4_strings_6_7, BINT(12298));
}FAILURE(BFALSE,BFALSE,BFALSE);}return CAR(pair_862);
} else {obj_t aux1093_620;
{obj_t pair_863;
if(PAIRP(list_618)){pair_863 = list_618;
} else {{obj_t aux1265_1162;
aux1265_1162 = symbol1382___r4_strings_6_7;
error_location___error_27(aux1265_1162, string1367___r4_strings_6_7, list_618, string1349___r4_strings_6_7, BINT(12333));
}FAILURE(BFALSE,BFALSE,BFALSE);}aux1093_620 = CAR(pair_863);
}{obj_t aux1094_621;
{obj_t aux1095_622;
{obj_t pair_864;
if(PAIRP(list_618)){pair_864 = list_618;
} else {{obj_t aux1268_1164;
aux1268_1164 = symbol1382___r4_strings_6_7;
error_location___error_27(aux1268_1164, string1367___r4_strings_6_7, list_618, string1349___r4_strings_6_7, BINT(12350));
}FAILURE(BFALSE,BFALSE,BFALSE);}aux1095_622 = CDR(pair_864);
}aux1094_621 = loop_local1182(aux1095_622);
}{obj_t aux1901_1635;
obj_t aux1895_1629;
if(STRINGP(aux1094_621))aux1901_1635 = aux1094_621;
 else {{obj_t aux1275_1168;
aux1275_1168 = symbol1382___r4_strings_6_7;
error_location___error_27(aux1275_1168, string1344___r4_strings_6_7, aux1094_621, string1349___r4_strings_6_7, BINT(12316));
}FAILURE(BFALSE,BFALSE,BFALSE);}if(STRINGP(aux1093_620))aux1895_1629 = aux1093_620;
 else {{obj_t aux1273_1166;
aux1273_1166 = symbol1382___r4_strings_6_7;
error_location___error_27(aux1273_1166, string1344___r4_strings_6_7, aux1093_620, string1349___r4_strings_6_7, BINT(12316));
}FAILURE(BFALSE,BFALSE,BFALSE);}return string_append(aux1895_1629, aux1901_1635);
}}}}}

obj_t string_append___r4_strings_6_7_48(obj_t list_616)
{{PUSH_TRACE(symbol1379___r4_strings_6_7);
{obj_t res1168_1004;
if(NULLP(list_616)){res1168_1004 = string1380___r4_strings_6_7;
} else {{obj_t aux1249_1155;
aux1249_1155 = loop_local1182(list_616);
if(STRINGP(aux1249_1155)){res1168_1004 = aux1249_1155;
} else {{obj_t aux1251_1156;
aux1251_1156 = symbol1381___r4_strings_6_7;
error_location___error_27(aux1251_1156, string1344___r4_strings_6_7, aux1249_1155, string1349___r4_strings_6_7, BINT(12241));
}FAILURE(BFALSE,BFALSE,BFALSE);}}}POP_TRACE();
return res1168_1004;
}}}

obj_t _string_append___r4_strings_6_7_245(obj_t env_1077, obj_t list_1078)
{return string_append___r4_strings_6_7_48(list_1078);
}

obj_t list__string___r4_strings_6_7_155(obj_t list_623)
{{PUSH_TRACE(symbol1377___r4_strings_6_7);
{obj_t res1169_1005;
{long len_624;
len_624 = list_length(list_623);
{obj_t string_625;
{int k_865;
obj_t char_866;
k_865 = (int)(len_624);
char_866 = BNIL;
if(NULLP(char_866)){string_625 = make_string((long)(k_865), ((unsigned char)' '));
} else {obj_t aux1084_867;
{obj_t pair_868;
if(PAIRP(char_866)){pair_868 = char_866;
} else {{obj_t aux1238_1146;
aux1238_1146 = symbol1378___r4_strings_6_7;
error_location___error_27(aux1238_1146, string1367___r4_strings_6_7, char_866, string1349___r4_strings_6_7, BINT(6064));
}FAILURE(BFALSE,BFALSE,BFALSE);}aux1084_867 = CAR(pair_868);
}{unsigned char aux1813_1549;
{obj_t aux1815_1551;
if(CHARP(aux1084_867))aux1815_1551 = aux1084_867;
 else {{obj_t aux1240_1148;
aux1240_1148 = symbol1378___r4_strings_6_7;
error_location___error_27(aux1240_1148, string1359___r4_strings_6_7, aux1084_867, string1349___r4_strings_6_7, BINT(6047));
}FAILURE(BFALSE,BFALSE,BFALSE);}aux1813_1549 = (unsigned char)CCHAR(aux1815_1551);
}string_625 = make_string((long)(k_865), aux1813_1549);
}}}{{long i_627;
obj_t l_628;
i_627 = 0;
l_628 = list_623;
loop_626:
if((i_627==len_624)){res1169_1005 = string_625;
} else {{obj_t aux1096_629;
{obj_t pair_871;
if(PAIRP(l_628)){pair_871 = l_628;
} else {{obj_t aux1242_1150;
aux1242_1150 = symbol1378___r4_strings_6_7;
error_location___error_27(aux1242_1150, string1367___r4_strings_6_7, l_628, string1349___r4_strings_6_7, BINT(12786));
}FAILURE(BFALSE,BFALSE,BFALSE);}aux1096_629 = CAR(pair_871);
}{unsigned char char_874;
{obj_t aux1833_1567;
if(CHARP(aux1096_629))aux1833_1567 = aux1096_629;
 else {{obj_t aux1246_1152;
aux1246_1152 = symbol1378___r4_strings_6_7;
error_location___error_27(aux1246_1152, string1359___r4_strings_6_7, aux1096_629, string1349___r4_strings_6_7, BINT(12764));
}FAILURE(BFALSE,BFALSE,BFALSE);}char_874 = (unsigned char)CCHAR(aux1833_1567);
}{bool_t test1840_1574;
{long aux1086_875;
aux1086_875 = STRING_LENGTH(string_625);
test1840_1574 = BOUND_CHECK(i_627, aux1086_875);
}if(test1840_1574){STRING_SET(string_625, i_627, char_874);
} else {error_location___error_27(string1360___r4_strings_6_7, string1357___r4_strings_6_7, BINT(i_627), string1349___r4_strings_6_7, BINT(7412));
}}}}{long aux1097_630;
aux1097_630 = (i_627+1);
{obj_t aux1098_631;
{obj_t pair_879;
if(PAIRP(l_628)){pair_879 = l_628;
} else {{obj_t aux1248_1154;
aux1248_1154 = symbol1378___r4_strings_6_7;
error_location___error_27(aux1248_1154, string1367___r4_strings_6_7, l_628, string1349___r4_strings_6_7, BINT(12813));
}FAILURE(BFALSE,BFALSE,BFALSE);}aux1098_631 = CDR(pair_879);
}{obj_t l_1589;
long i_1588;
i_1588 = aux1097_630;
l_1589 = aux1098_631;
l_628 = l_1589;
i_627 = i_1588;
goto loop_626;
}}}}}}}}POP_TRACE();
return res1169_1005;
}}}

obj_t _list__string___r4_strings_6_7_204(obj_t env_1079, obj_t list_1080)
{return list__string___r4_strings_6_7_155(list_1080);
}

obj_t string__list___r4_strings_6_7_22(obj_t string_632)
{{PUSH_TRACE(symbol1376___r4_strings_6_7);
{obj_t res1170_1006;
{long len_633;
len_633 = STRING_LENGTH(string_632);
{long i_635;
obj_t acc_636;
i_635 = 0;
acc_636 = BNIL;
loop_634:
if((i_635==len_633)){res1170_1006 = reverse____r4_pairs_and_lists_6_3_107(acc_636);
} else {long aux1103_637;
aux1103_637 = (i_635+1);
{obj_t aux1104_638;
{obj_t aux1105_639;
{bool_t test1789_1523;
{long aux1085_887;
aux1085_887 = STRING_LENGTH(string_632);
test1789_1523 = BOUND_CHECK(i_635, aux1085_887);
}if(test1789_1523){aux1105_639 = BCHAR(STRING_REF(string_632, i_635));
} else {aux1105_639 = error_location___error_27(string1356___r4_strings_6_7, string1357___r4_strings_6_7, BINT(i_635), string1349___r4_strings_6_7, BINT(7001));
}}aux1104_638 = MAKE_PAIR(aux1105_639, acc_636);
}{obj_t acc_1533;
long i_1532;
i_1532 = aux1103_637;
acc_1533 = aux1104_638;
acc_636 = acc_1533;
i_635 = i_1532;
goto loop_634;
}}}}}POP_TRACE();
return res1170_1006;
}}}

obj_t _string__list___r4_strings_6_7_217(obj_t env_1081, obj_t string_1082)
{{obj_t aux1778_1512;
if(STRINGP(string_1082))aux1778_1512 = string_1082;
 else {FAILURE(symbol1375___r4_strings_6_7,string1344___r4_strings_6_7,string_1082);}return string__list___r4_strings_6_7_22(aux1778_1512);
}}

obj_t string_copy___r4_strings_6_7_30(obj_t string_640)
{{PUSH_TRACE(symbol1374___r4_strings_6_7);
{obj_t res1171_1007;
res1171_1007 = string_to_bstring(BSTRING_TO_STRING(string_640));
POP_TRACE();
return res1171_1007;
}}}

obj_t _string_copy___r4_strings_6_7_217(obj_t env_1083, obj_t string_1084)
{{obj_t aux1769_1503;
if(STRINGP(string_1084))aux1769_1503 = string_1084;
 else {FAILURE(symbol1373___r4_strings_6_7,string1344___r4_strings_6_7,string_1084);}return string_copy___r4_strings_6_7_30(aux1769_1503);
}}

obj_t string_fill____r4_strings_6_7_145(obj_t string_641, unsigned char char_642)
{{PUSH_TRACE(symbol1372___r4_strings_6_7);
{obj_t res1172_1008;
{long len_643;
len_643 = STRING_LENGTH(string_641);
{long i_645;
i_645 = 0;
loop_644:
if((i_645==len_643)){res1172_1008 = string_641;
} else {{bool_t test1759_1493;
{long aux1086_895;
aux1086_895 = STRING_LENGTH(string_641);
test1759_1493 = BOUND_CHECK(i_645, aux1086_895);
}if(test1759_1493){STRING_SET(string_641, i_645, char_642);
} else {error_location___error_27(string1360___r4_strings_6_7, string1357___r4_strings_6_7, BINT(i_645), string1349___r4_strings_6_7, BINT(7412));
}}{long aux1106_646;
aux1106_646 = (i_645+1);
{long i_1501;
i_1501 = aux1106_646;
i_645 = i_1501;
goto loop_644;
}}}}}POP_TRACE();
return res1172_1008;
}}}

obj_t _string_fill____r4_strings_6_7_203(obj_t env_1085, obj_t string_1086, obj_t char_1087)
{{unsigned char aux1748_1482;
obj_t aux1744_1478;
{obj_t aux1749_1483;
if(CHARP(char_1087))aux1749_1483 = char_1087;
 else {FAILURE(symbol1371___r4_strings_6_7,string1359___r4_strings_6_7,char_1087);}aux1748_1482 = (unsigned char)CCHAR(aux1749_1483);
}if(STRINGP(string_1086))aux1744_1478 = string_1086;
 else {FAILURE(symbol1371___r4_strings_6_7,string1344___r4_strings_6_7,string_1086);}return string_fill____r4_strings_6_7_145(aux1744_1478, aux1748_1482);
}}

obj_t string_upcase___r4_strings_6_7_224(obj_t string_647)
{{PUSH_TRACE(symbol1369___r4_strings_6_7);
{obj_t res1173_1009;
{long len_648;
len_648 = STRING_LENGTH(string_647);
{obj_t res_649;
{int k_900;
obj_t char_901;
k_900 = (int)(len_648);
char_901 = BNIL;
if(NULLP(char_901)){res_649 = make_string((long)(k_900), ((unsigned char)' '));
} else {obj_t aux1084_902;
{obj_t pair_903;
if(PAIRP(char_901)){pair_903 = char_901;
} else {{obj_t aux1221_1136;
aux1221_1136 = symbol1370___r4_strings_6_7;
error_location___error_27(aux1221_1136, string1367___r4_strings_6_7, char_901, string1349___r4_strings_6_7, BINT(6064));
}FAILURE(BFALSE,BFALSE,BFALSE);}aux1084_902 = CAR(pair_903);
}{unsigned char aux1701_1440;
{obj_t aux1703_1442;
if(CHARP(aux1084_902))aux1703_1442 = aux1084_902;
 else {{obj_t aux1223_1138;
aux1223_1138 = symbol1370___r4_strings_6_7;
error_location___error_27(aux1223_1138, string1359___r4_strings_6_7, aux1084_902, string1349___r4_strings_6_7, BINT(6047));
}FAILURE(BFALSE,BFALSE,BFALSE);}aux1701_1440 = (unsigned char)CCHAR(aux1703_1442);
}res_649 = make_string((long)(k_900), aux1701_1440);
}}}{{long i_651;
i_651 = 0;
loop_650:
if((i_651==len_648)){res1173_1009 = res_649;
} else {{unsigned char aux1110_652;
{obj_t aux1111_653;
{bool_t test1713_1452;
{long aux1085_908;
aux1085_908 = STRING_LENGTH(string_647);
test1713_1452 = BOUND_CHECK(i_651, aux1085_908);
}if(test1713_1452){aux1111_653 = BCHAR(STRING_REF(string_647, i_651));
} else {aux1111_653 = error_location___error_27(string1356___r4_strings_6_7, string1357___r4_strings_6_7, BINT(i_651), string1349___r4_strings_6_7, BINT(7001));
}}{unsigned char char_910;
{obj_t aux1721_1460;
if(CHARP(aux1111_653))aux1721_1460 = aux1111_653;
 else {{obj_t aux1230_1140;
aux1230_1140 = symbol1370___r4_strings_6_7;
error_location___error_27(aux1230_1140, string1359___r4_strings_6_7, aux1111_653, string1349___r4_strings_6_7, BINT(14378));
}FAILURE(BFALSE,BFALSE,BFALSE);}char_910 = (unsigned char)CCHAR(aux1721_1460);
}aux1110_652 = toupper(char_910);
}}{bool_t test1735_1468;
{long aux1086_914;
aux1086_914 = STRING_LENGTH(res_649);
test1735_1468 = BOUND_CHECK(i_651, aux1086_914);
}if(test1735_1468){STRING_SET(res_649, i_651, aux1110_652);
} else {error_location___error_27(string1360___r4_strings_6_7, string1357___r4_strings_6_7, BINT(i_651), string1349___r4_strings_6_7, BINT(7412));
}}}{long aux1112_654;
aux1112_654 = (i_651+1);
{long i_1476;
i_1476 = aux1112_654;
i_651 = i_1476;
goto loop_650;
}}}}}}}POP_TRACE();
return res1173_1009;
}}}

obj_t _string_upcase___r4_strings_6_7_209(obj_t env_1088, obj_t string_1089)
{{obj_t aux1682_1422;
if(STRINGP(string_1089))aux1682_1422 = string_1089;
 else {FAILURE(symbol1368___r4_strings_6_7,string1344___r4_strings_6_7,string_1089);}return string_upcase___r4_strings_6_7_224(aux1682_1422);
}}

obj_t string_downcase___r4_strings_6_7_41(obj_t string_655)
{{PUSH_TRACE(symbol1365___r4_strings_6_7);
{obj_t res1174_1010;
{long len_656;
len_656 = STRING_LENGTH(string_655);
{obj_t res_657;
{int k_919;
obj_t char_920;
k_919 = (int)(len_656);
char_920 = BNIL;
if(NULLP(char_920)){res_657 = make_string((long)(k_919), ((unsigned char)' '));
} else {obj_t aux1084_921;
{obj_t pair_922;
if(PAIRP(char_920)){pair_922 = char_920;
} else {{obj_t aux1210_1129;
aux1210_1129 = symbol1366___r4_strings_6_7;
error_location___error_27(aux1210_1129, string1367___r4_strings_6_7, char_920, string1349___r4_strings_6_7, BINT(6064));
}FAILURE(BFALSE,BFALSE,BFALSE);}aux1084_921 = CAR(pair_922);
}{unsigned char aux1642_1384;
{obj_t aux1644_1386;
if(CHARP(aux1084_921))aux1644_1386 = aux1084_921;
 else {{obj_t aux1212_1131;
aux1212_1131 = symbol1366___r4_strings_6_7;
error_location___error_27(aux1212_1131, string1359___r4_strings_6_7, aux1084_921, string1349___r4_strings_6_7, BINT(6047));
}FAILURE(BFALSE,BFALSE,BFALSE);}aux1642_1384 = (unsigned char)CCHAR(aux1644_1386);
}res_657 = make_string((long)(k_919), aux1642_1384);
}}}{{long i_659;
i_659 = 0;
loop_658:
if((i_659==len_656)){res1174_1010 = res_657;
} else {{unsigned char aux1113_660;
{obj_t aux1115_661;
{bool_t test1654_1396;
{long aux1085_927;
aux1085_927 = STRING_LENGTH(string_655);
test1654_1396 = BOUND_CHECK(i_659, aux1085_927);
}if(test1654_1396){aux1115_661 = BCHAR(STRING_REF(string_655, i_659));
} else {aux1115_661 = error_location___error_27(string1356___r4_strings_6_7, string1357___r4_strings_6_7, BINT(i_659), string1349___r4_strings_6_7, BINT(7001));
}}{unsigned char char_929;
{obj_t aux1662_1404;
if(CHARP(aux1115_661))aux1662_1404 = aux1115_661;
 else {{obj_t aux1218_1133;
aux1218_1133 = symbol1366___r4_strings_6_7;
error_location___error_27(aux1218_1133, string1359___r4_strings_6_7, aux1115_661, string1349___r4_strings_6_7, BINT(14848));
}FAILURE(BFALSE,BFALSE,BFALSE);}char_929 = (unsigned char)CCHAR(aux1662_1404);
}aux1113_660 = tolower(char_929);
}}{bool_t test1673_1412;
{long aux1086_933;
aux1086_933 = STRING_LENGTH(res_657);
test1673_1412 = BOUND_CHECK(i_659, aux1086_933);
}if(test1673_1412){STRING_SET(res_657, i_659, aux1113_660);
} else {error_location___error_27(string1360___r4_strings_6_7, string1357___r4_strings_6_7, BINT(i_659), string1349___r4_strings_6_7, BINT(7412));
}}}{long aux1116_662;
aux1116_662 = (i_659+1);
{long i_1420;
i_1420 = aux1116_662;
i_659 = i_1420;
goto loop_658;
}}}}}}}POP_TRACE();
return res1174_1010;
}}}

obj_t _string_downcase___r4_strings_6_7_212(obj_t env_1090, obj_t string_1091)
{{obj_t aux1624_1366;
if(STRINGP(string_1091))aux1624_1366 = string_1091;
 else {FAILURE(symbol1364___r4_strings_6_7,string1344___r4_strings_6_7,string_1091);}return string_downcase___r4_strings_6_7_41(aux1624_1366);
}}

obj_t string_upcase____r4_strings_6_7_99(obj_t string_663)
{{PUSH_TRACE(symbol1362___r4_strings_6_7);
{obj_t res1175_1011;
{long len_664;
len_664 = STRING_LENGTH(string_663);
{{long i_667;
i_667 = 0;
loop_666:
if((i_667==len_664)){res1175_1011 = string_663;
} else {{unsigned char aux1117_668;
{obj_t aux1119_669;
{bool_t test1594_1340;
{long aux1085_942;
aux1085_942 = STRING_LENGTH(string_663);
test1594_1340 = BOUND_CHECK(i_667, aux1085_942);
}if(test1594_1340){aux1119_669 = BCHAR(STRING_REF(string_663, i_667));
} else {aux1119_669 = error_location___error_27(string1356___r4_strings_6_7, string1357___r4_strings_6_7, BINT(i_667), string1349___r4_strings_6_7, BINT(7001));
}}{unsigned char char_944;
{obj_t aux1602_1348;
if(CHARP(aux1119_669))aux1602_1348 = aux1119_669;
 else {{obj_t aux1207_1126;
aux1207_1126 = symbol1363___r4_strings_6_7;
error_location___error_27(aux1207_1126, string1359___r4_strings_6_7, aux1119_669, string1349___r4_strings_6_7, BINT(15308));
}FAILURE(BFALSE,BFALSE,BFALSE);}char_944 = (unsigned char)CCHAR(aux1602_1348);
}aux1117_668 = toupper(char_944);
}}{bool_t test1613_1356;
{long aux1086_948;
aux1086_948 = STRING_LENGTH(string_663);
test1613_1356 = BOUND_CHECK(i_667, aux1086_948);
}if(test1613_1356){STRING_SET(string_663, i_667, aux1117_668);
} else {error_location___error_27(string1360___r4_strings_6_7, string1357___r4_strings_6_7, BINT(i_667), string1349___r4_strings_6_7, BINT(7412));
}}}{long aux1120_670;
aux1120_670 = (i_667+1);
{long i_1364;
i_1364 = aux1120_670;
i_667 = i_1364;
goto loop_666;
}}}}}}POP_TRACE();
return res1175_1011;
}}}

obj_t _string_upcase____r4_strings_6_7_92(obj_t env_1092, obj_t string_1093)
{{obj_t aux1585_1331;
if(STRINGP(string_1093))aux1585_1331 = string_1093;
 else {FAILURE(symbol1361___r4_strings_6_7,string1344___r4_strings_6_7,string_1093);}return string_upcase____r4_strings_6_7_99(aux1585_1331);
}}

obj_t string_downcase____r4_strings_6_7_100(obj_t string_671)
{{PUSH_TRACE(symbol1355___r4_strings_6_7);
{obj_t res1176_1012;
{long len_672;
len_672 = STRING_LENGTH(string_671);
{{long i_675;
i_675 = 0;
loop_674:
if((i_675==len_672)){res1176_1012 = string_671;
} else {{unsigned char aux1121_676;
{obj_t aux1124_677;
{bool_t test1557_1305;
{long aux1085_957;
aux1085_957 = STRING_LENGTH(string_671);
test1557_1305 = BOUND_CHECK(i_675, aux1085_957);
}if(test1557_1305){aux1124_677 = BCHAR(STRING_REF(string_671, i_675));
} else {aux1124_677 = error_location___error_27(string1356___r4_strings_6_7, string1357___r4_strings_6_7, BINT(i_675), string1349___r4_strings_6_7, BINT(7001));
}}{unsigned char char_959;
{obj_t aux1566_1313;
if(CHARP(aux1124_677))aux1566_1313 = aux1124_677;
 else {{obj_t aux1200_1123;
aux1200_1123 = symbol1358___r4_strings_6_7;
error_location___error_27(aux1200_1123, string1359___r4_strings_6_7, aux1124_677, string1349___r4_strings_6_7, BINT(15768));
}FAILURE(BFALSE,BFALSE,BFALSE);}char_959 = (unsigned char)CCHAR(aux1566_1313);
}aux1121_676 = tolower(char_959);
}}{bool_t test1575_1321;
{long aux1086_963;
aux1086_963 = STRING_LENGTH(string_671);
test1575_1321 = BOUND_CHECK(i_675, aux1086_963);
}if(test1575_1321){STRING_SET(string_671, i_675, aux1121_676);
} else {error_location___error_27(string1360___r4_strings_6_7, string1357___r4_strings_6_7, BINT(i_675), string1349___r4_strings_6_7, BINT(7412));
}}}{long aux1125_678;
aux1125_678 = (i_675+1);
{long i_1329;
i_1329 = aux1125_678;
i_675 = i_1329;
goto loop_674;
}}}}}}POP_TRACE();
return res1176_1012;
}}}

obj_t _string_downcase____r4_strings_6_7_39(obj_t env_1094, obj_t string_1095)
{{obj_t aux1547_1296;
if(STRINGP(string_1095))aux1547_1296 = string_1095;
 else {FAILURE(symbol1354___r4_strings_6_7,string1344___r4_strings_6_7,string_1095);}return string_downcase____r4_strings_6_7_100(aux1547_1296);
}}

obj_t string_for_read___r4_strings_6_7_226(obj_t string_679)
{{PUSH_TRACE(symbol1353___r4_strings_6_7);
{obj_t res1177_1013;
res1177_1013 = string_for_read(string_679);
POP_TRACE();
return res1177_1013;
}}}

obj_t _string_for_read___r4_strings_6_7_166(obj_t env_1096, obj_t string_1097)
{{obj_t aux1533_1288;
if(STRINGP(string_1097))aux1533_1288 = string_1097;
 else {FAILURE(symbol1352___r4_strings_6_7,string1344___r4_strings_6_7,string_1097);}return string_for_read___r4_strings_6_7_226(aux1533_1288);
}}

obj_t blit_string_ur____r4_strings_6_7_25(obj_t s1_680, obj_t o1_681, obj_t s2_682, obj_t o2_683, obj_t l_684)
{{PUSH_TRACE(symbol1351___r4_strings_6_7);
{obj_t res1178_1014;
res1178_1014 = blit_string(s1_680, o1_681, s2_682, o2_683, l_684);
POP_TRACE();
return res1178_1014;
}}}

obj_t _blit_string_ur____r4_strings_6_7_243(obj_t env_1098, obj_t s1_1099, obj_t o1_1100, obj_t s2_1101, obj_t o2_1102, obj_t l_1103)
{{obj_t aux1519_1280;
obj_t aux1515_1276;
obj_t aux1506_1272;
obj_t aux1501_1268;
obj_t aux1496_1264;
if(INTEGERP(l_1103))aux1519_1280 = l_1103;
 else {FAILURE(symbol1350___r4_strings_6_7,string1345___r4_strings_6_7,l_1103);}if(INTEGERP(o2_1102))aux1515_1276 = o2_1102;
 else {FAILURE(symbol1350___r4_strings_6_7,string1345___r4_strings_6_7,o2_1102);}if(STRINGP(s2_1101))aux1506_1272 = s2_1101;
 else {FAILURE(symbol1350___r4_strings_6_7,string1344___r4_strings_6_7,s2_1101);}if(INTEGERP(o1_1100))aux1501_1268 = o1_1100;
 else {FAILURE(symbol1350___r4_strings_6_7,string1345___r4_strings_6_7,o1_1100);}if(STRINGP(s1_1099))aux1496_1264 = s1_1099;
 else {FAILURE(symbol1350___r4_strings_6_7,string1344___r4_strings_6_7,s1_1099);}return blit_string_ur____r4_strings_6_7_25(aux1496_1264, aux1501_1268, aux1506_1272, aux1515_1276, aux1519_1280);
}}

obj_t blit_string____r4_strings_6_7_126(obj_t s1_685, obj_t o1_686, obj_t s2_687, obj_t o2_688, obj_t l_689)
{{PUSH_TRACE(symbol1346___r4_strings_6_7);
{obj_t res1179_1015;
{bool_t test1460_1237;
if(BOUND_CHECK(((long)CINT(l_689)+(long)CINT(o1_686)), (STRING_LENGTH(s1_685)+1)))test1460_1237 = BOUND_CHECK(((long)CINT(l_689)+(long)CINT(o2_688)), (STRING_LENGTH(s2_687)+1));
 else test1460_1237 = ((bool_t)0);
if(test1460_1237){res1179_1015 = blit_string(s1_685, o1_686, s2_687, o2_688, l_689);
} else {obj_t aux1137_696;
{long aux1138_697;
aux1138_697 = STRING_LENGTH(s1_685);
{long aux1142_698;
aux1142_698 = STRING_LENGTH(s2_687);
{obj_t l_979;
l_979 = MAKE_PAIR(BINT(aux1138_697), MAKE_PAIR(o1_686, MAKE_PAIR(BINT(aux1142_698), MAKE_PAIR(o2_688, MAKE_PAIR(l_689, BNIL)))));
aux1137_696 = l_979;
}}}res1179_1015 = error_location___error_27(string1347___r4_strings_6_7, string1348___r4_strings_6_7, aux1137_696, string1349___r4_strings_6_7, BINT(16873));
}}POP_TRACE();
return res1179_1015;
}}}

obj_t _blit_string____r4_strings_6_7_7(obj_t env_1104, obj_t s1_1105, obj_t o1_1106, obj_t s2_1107, obj_t o2_1108, obj_t l_1109)
{{obj_t aux1453_1231;
obj_t aux1449_1227;
obj_t aux1443_1223;
obj_t aux1437_1219;
obj_t aux1433_1215;
if(INTEGERP(l_1109))aux1453_1231 = l_1109;
 else {FAILURE(symbol1343___r4_strings_6_7,string1345___r4_strings_6_7,l_1109);}if(INTEGERP(o2_1108))aux1449_1227 = o2_1108;
 else {FAILURE(symbol1343___r4_strings_6_7,string1345___r4_strings_6_7,o2_1108);}if(STRINGP(s2_1107))aux1443_1223 = s2_1107;
 else {FAILURE(symbol1343___r4_strings_6_7,string1344___r4_strings_6_7,s2_1107);}if(INTEGERP(o1_1106))aux1437_1219 = o1_1106;
 else {FAILURE(symbol1343___r4_strings_6_7,string1345___r4_strings_6_7,o1_1106);}if(STRINGP(s1_1105))aux1433_1215 = s1_1105;
 else {FAILURE(symbol1343___r4_strings_6_7,string1344___r4_strings_6_7,s1_1105);}return blit_string____r4_strings_6_7_126(aux1433_1215, aux1437_1219, aux1443_1223, aux1449_1227, aux1453_1231);
}}

