;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.9/Llib/bigloo.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jan 20 08:24:40 1995                          */
;*    Last change :  Sat Apr  6 12:21:27 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The bigloo runtime utility functions                             */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __bigloo

   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
   	    (__evenv                   "Eval/evenv.scm"))

   (foreign (macro bool c-procedure-light? (obj)       "PROCEDURE_LIGHTP")
	    (macro bool va-procedure?      (procedure) "VA_PROCEDUREP")
	    (macro obj  procedure-entry    (procedure) "PROCEDURE_ENTRY")
	    (macro obj  tprocedure-l-entry (procedure) "PROCEDURE_L_ENTRY")
	    
	    (macro long procedure-arity (PROCEDURE)
		   "PROCEDURE_ARITY")
	    (macro bool correct-arity?  (procedure long)
		   "PROCEDURE_CORRECT_ARITYP")
	    
	    (macro procedure make-fx-procedure   (obj long long)
		   "make_fx_procedure")		 
	    (macro procedure make-va-procedure   (obj long long)
		   "make_va_procedure")
	    
	    (macro procedure make-s-fx-procedure (obj long long)
		   "MAKE_S_FX_PROCEDURE")		 
	    (macro procedure make-s-va-procedure (obj long long)
		   "MAKE_S_VA_PROCEDURE")
	    
	    (macro procedure make-el-procedure   (long)
		   "MAKE_EL_PROCEDURE")	 
	    (macro procedure make-el-procedure-1 (long)
		   "MAKE_EL_PROCEDURE_1")	 
	    (macro procedure make-s-el-procedure (long)
		   "MAKE_S_EL_PROCEDURE")
	    
	    (macro procedure  make-l-procedure   (obj long)
		   "MAKE_L_PROCEDURE")		 
	    (macro procedure  make-s-l-procedure (obj long)
		   "MAKE_S_L_PROCEDURE")		 
	    					 
	    (macro obj procedure-set!            (procedure long obj)
	       "PROCEDURE_SET")			 
	    (macro obj procedure-ref             (procedure long)
	       "PROCEDURE_REF")			 

	    (macro obj procedure-l-set!          (obj long obj)
	       "PROCEDURE_L_SET")		  
	    (macro obj procedure-l-ref           (obj long)
	       "PROCEDURE_L_REF")
	    
	    (macro obj procedure-el-set!         (obj long obj)
	       "PROCEDURE_EL_SET")		 
	    (macro obj procedure-el-ref          (obj long)
	       "PROCEDURE_EL_REF")
	    
	    (macro obj procedure-1-el-set!       (obj long obj)
	       "PROCEDURE_1_EL_SET")		 
	    (macro obj procedure-1-el-ref        (obj long)
	       "PROCEDURE_1_EL_REF")
	    
	    (macro obj make-cell  (obj)              "MAKE_CELL")
	    (macro obj cell-set!  (obj obj)          "CELL_SET")
	    (macro obj cell-ref   (obj)              "CELL_REF")
	    (macro bool cell?     (obj)              "CELLP")
	    
	    (macro bool c-cnst?   (obj)              "CNSTP")
	    
	    (macro obj __unspec__                    "BUNSPEC")
	    (macro obj __eoa__                       "BEOA")
	    
	    (macro obj declare-cnst-table  (obj)      "DECLARE_CNST_TABLE")
	    (macro obj cnst-table-set!     (long obj) "CNST_TABLE_SET")
	    (macro obj cnst-table-ref      (long)     "CNST_TABLE_REF")

	    (macro bstring make-init-string  obj     "make_init_string")
	    (macro obj     close-init-string (obj)   "close_init_string")
	    
	    (macro obj nop                ()         "NOP")

	    (macro obj var->root     (obj)           "(obj_t)&")
	    (macro obj GC-add-globv! (obj)           "GC_ADD_GLOBV")
	    (macro obj GC-add-roots! (obj obj)       "GC_ADD_ROOTS")

	    (macro obj bigloo-exit (obj)             "BIGLOO_EXIT"))
 
   (export  (check-version!                          ::obj ::string ::obj)
	    (inline cnst?::bool                      ::obj)
	    (inline closure-arity::long              ::procedure)
	    (inline unspecified::unspecified))

   (pragma  (make-fx-procedure (_s-alloc_ make-s-fx-procedure))
	    (make-va-procedure (_s-alloc_ make-s-va-procedure))
	    (make-el-procedure (_s-alloc_ make-s-el-procedure))
	    (make-l-procedure (_s-alloc_ make-s-l-procedure))
	    (cell? (_type-checker_ cell) _no_side_effect_)
	    (c-cnst? (_type-checker_ cnst) _no_side_effect_)))


;*---------------------------------------------------------------------*/
;*    The same hack as in __error but this time to prevent the         */
;*    compiler to check version in this module.                        */
;*---------------------------------------------------------------------*/
(define-macro (unsafe-version)
   ;; the variable *unsafe-version* is bound in the module
   ;; engine_param of the compiler
   (set! *unsafe-version* #t)
   #unspecified)

(unsafe-version)  

;*---------------------------------------------------------------------*/
;*    check-version! ...                                               */
;*    -------------------------------------------------------------    */
;*    This function is in charge of the coherence of all module        */
;*    of an executable (i.e. does all module compiled by the           */
;*    same Bigloo's version).                                          */
;*---------------------------------------------------------------------*/
(define (check-version! module release level)
   (cond
      ((not (string? *release*))
       (set! *modules* (list module))
       (set! *release* release)
       (set! *level*   level))
      ((or (let ((min (-fx (minfx (string-length release)
				  (string-length *release*))
			   1)))
	      (not (string=? (substring release 0 min)
			     (substring *release* 0 min))))
	   (and (char? level) (char? *level*) (not (char=? *level* level))))
       (define (release-name release level)
	  (if (char? level)
	      (let ((s " (level 0)"))
		 (string-set! s 8 level)
		 release)
	      release))
       (error (string-append "Some modules have been compiled by: "
			     (release-name *release* *level*))
	      (string-append "and other by: "
			     (release-name release *level*))
	      (cons module *modules*)))
      (else
       (set! *modules* (cons module *modules*)))))

;*---------------------------------------------------------------------*/
;*    Some variables for check-version!                                */
;*---------------------------------------------------------------------*/
(define *release* #f)
(define *level*   #f)
(define *modules* '())
   
;*---------------------------------------------------------------------*/
;*    closure-arity ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (closure-arity proc)
   (procedure-arity proc))

;*---------------------------------------------------------------------*/
;*    unspecified ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (unspecified)
   __unspec__)

;*---------------------------------------------------------------------*/
;*    cnst? ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (cnst? obj)
   (c-cnst? obj))
