/*
    CTHUGHA-X11
	
    Linux-X11-Version of CTHUGHA
	
-----------------------------------------------------------------------------*/

#define CTH_X11

#include "cthugha.h"
#include "cthugha-X11.h"
#include "information.h"			/* title, credits, ... */
#include "sound.h"
#include "net_sound.h"
#include "action.h"				/* display_sound() */
#include "translate.h"
#include "options.h"
#include "keys.h"
#include "cd_player.h"
#include "display.h"

#include <unistd.h>
#include <stdlib.h>
#include <time.h>
#include <stdio.h>

Display * cth_display;
Window cth_window, cth_window_pal;
Visual * cth_visual;
int cth_screen;
GC cth_gc;
int rev_byte_order;
int cth_planes;
Colormap cth_cmap;

void animate(void * data) {

    display_sound(); 

    AddTimeOut(0, animate, NULL);

    /* check for keys in text-window */
    display_do_selection();
    while( main_key_switch( getkey()) );
    
    if ( cthugha_finish) {
	exit_cthugha(0);
	exit(0);
    }
}

void redisplay(Widget w, int new_width, int new_height, void * data) {
    if ( ! display_on_root ) {
	if( (window_width != new_width) || (window_height != new_height) ) {
	    window_width = new_width;
	    window_height = new_height;

	    ClearDrawArea();

	    resize_display(window_width, window_height); 
	}
    }
    AddTimeOut(0, animate, NULL);
}

/*
 * Handlers for Buttons
 */
void quit(Widget w, void * data) {
    CloseWindow();
    exit_cthugha(0);  
    exit(0);
}
void change(Widget w, void * data) {
    general_change();
    update_status();
}

/*
 * create the menu buttons
 * handler for activated menu-items
 */
void MenuCB(Widget item, void *data) {
    opt_data * d = data;

    d->use = 1-d->use;
    SetMenuItemChecked(item, d->use);
}

Widget add_menu(char * name, opt_data * what, int nr) {
    Widget menu, item;
    int i;

    if (nr <= 0)
	return NULL;

    menu = MakeMenu(name);
    for(i=0; i < nr; i++) {
	item = MakeMenuItem(menu, what[i].name, MenuCB, &(what[i]) );
	SetMenuItemChecked(item, what[i].use);
    }
    return menu;
}

static Widget menu[6];
void init_menu() {

    /* create widgets */
    menu[0] = add_menu("Display", screens, nr_screens);
    menu[1] = add_menu("Wave", waves, nr_waves);	
    menu[2] = add_menu("Flame", flames, nr_flames);
    menu[3] = add_menu("Translation", translations, nr_translations);
    menu[4] = add_menu("Palette", palettes, nr_palettes);
    menu[5] = add_menu("PCX", pcxs, nr_pcx);

    /* set theire positions */
    SetWidgetPos(menu[1], PLACE_RIGHT, menu[0], NO_CARE, NULL);
    SetWidgetPos(menu[2], PLACE_RIGHT, menu[1], NO_CARE, NULL);
    SetWidgetPos(menu[3], PLACE_RIGHT, menu[2], NO_CARE, NULL);
    SetWidgetPos(menu[4], PLACE_RIGHT, menu[3], NO_CARE, NULL);
    SetWidgetPos(menu[5], PLACE_RIGHT, menu[4], NO_CARE, NULL);


}
/*
 *  main for cthugha-X11
 */
int main(int argc, char **argv) {
    Widget w[3];
    unsigned int byte_order_test = 0x04030201;
    
    argv[0] = "Cthugha";
    if( (argc=OpenDisplay(argc, argv)) == 0)
	return 1;

    /* I create this widgets before the init_cthugha. So I can use
       them to get the display.
       */
    w[1] = MakeButton("Quit!", quit, NULL);	
    w[2] = MakeButton("Change!", change, NULL); 

    cth_display = XtDisplay(w[1]);
    cth_screen = DefaultScreen( cth_display);
    cth_visual = DefaultVisual( cth_display, cth_screen);
    cth_planes = DefaultDepth(cth_display, cth_screen );

    rev_byte_order = (ImageByteOrder(cth_display) == MSBFirst) ? 1 : 0;
    if( *(char*)&byte_order_test == 4)
	rev_byte_order = !rev_byte_order;

    if( init_cthugha(argc, argv) )
	return 1;

    /* create the menu buttons */
    init_menu();
    /* Set Position of buttons */
    SetWidgetPos(w[1], PLACE_UNDER, menu[0], NO_CARE, NULL);
    SetWidgetPos(w[2], PLACE_RIGHT, w[1], PLACE_UNDER, menu[0]);
    /* Show Window with buttons */
    ShowDisplay();

    if ( display_on_root) {	/* display on root window */
	cth_window_pal = cth_window = DefaultRootWindow (cth_display);
	
	/* get size of screen */
	window_width  = DisplayWidth(cth_display, cth_screen);
	window_height = DisplayHeight(cth_display, cth_screen);

    } else {			/* display in a window */
	Widget w1,w2;
	w1 = MakeWindow("xcthugha", SAME_DISPLAY, NONEXCLUSIVE_WINDOW);
	w2 = MakeDrawArea(screen_width, screen_height, redisplay, NULL);
	SetKeypressCB(w2, keys_x11);

	ShowDisplay();
    
	cth_window = XtWindow(w2); 
	cth_window_pal = XtWindow(w1);
    }

    /* this also sets the first palette */
    if( init_graph_mode() ) 
	return exit_cthugha(-1);

    cth_gc = XCreateGC(cth_display, cth_window, 0, 0);

    /* make sure animation starts */
    AddTimeOut(0, animate, NULL);

    MainLoop();

    return exit_cthugha(0);
}
    


