/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgCpxMul.c                                                   */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:34 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "CpxMul"
#define ERROR(e) imgError(e,PRGNAME)
#define ARG_ERROR(e,arg) imgArgError(e,arg,PRGNAME)

int main(int argc,char **argv)
{
  it_image *in1,*in2;
  int width,height,x,y;
  it_complex *in1_ptr,*in2_ptr;
  double real,imag;

  IFHELP
    {
      fprintf(stderr,"img%s - Multiply two complex images\n",
	      PRGNAME);
      fprintf(stderr,"img%s [filename]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Complex\n");
      fprintf(stderr,"  stdout: Complex\n");
      fprintf(stderr,"  file: Complex\n");
      exit(0);
    }
  imgStart(PRGNAME);

  if(argc!=1 && argc!=2)
    ERROR("invalid arguments");

  /* Loop for all images */
  do {
    in1=i_read_image_file(stdin,IT_COMPLEX,IM_FRAGMENT);
    if(in1==NULL)
      ERROR("can't import image file");
    width=in1->width;
    height=in1->height;

    if(argc==1)
      {
	in2=i_read_image_file(stdin,IT_COMPLEX,IM_FRAGMENT);
	if(in2==NULL)
	  ERROR("can't import image file");
      }
    else
      {
	in2=i_load_image(argv[1],-1,IT_COMPLEX,IM_FRAGMENT);
	if(in2==NULL)
	  ARG_ERROR("can't load image file %s",argv[1]);
      }

    if(width!=in2->width || height!=in2->height)
      ERROR("images ar of different sizes");

    /* Multiply: in1 = in1 * in2 */
    for(y=0;y<height;y++)
      {
	in1_ptr=im_complex_row(in1,y);
	in2_ptr=im_complex_row(in2,y);
	for(x=0;x<width;x++)
	  {
	    /* Complex Multiply */
	    real=in1_ptr->Re * in2_ptr->Re - in1_ptr->Im * in2_ptr->Im;
	    imag=in1_ptr->Re * in2_ptr->Im + in1_ptr->Im * in2_ptr->Re;
	    in1_ptr->Re=real;
	    in1_ptr->Im=imag;
	    in1_ptr++;
	    in2_ptr++;
	  }
      }
    i_destroy_image(in2);
    i_write_image_file(stdout,in1,IF_BINARY);
    i_destroy_image(in1);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
