/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgCrop.c                                                     */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:35 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Crop"
#define ERROR(e) imgError(e,PRGNAME)
#define CROP_CASE_LOOP(type,tag)               \
  case type:                                   \
  for(y=0;y<valid_height;y++)                  \
    { CAT(it_,tag) *f1_ptr,*f2_ptr;              \
      f1_ptr=((CAT(it_,tag) **)(f1->field))[y+valid_y]+valid_x;\
      f2_ptr=((CAT(it_,tag) **)(f2->field))[y];  \
      for(x=0;x<valid_width;x++)               \
	*f2_ptr++ = *f1_ptr++;                 \
    }                                          \
  break

int main(int argc,char **argv)
{
  it_image *f1,*f2;
  int x,y,xx,yy,valid_x,valid_y,valid_height,valid_width;

  IFHELP
    {
      fprintf(stderr,"img%s - Extract an image sub-region\n",
	      PRGNAME);
      fprintf(stderr,"img%s [x y width height]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Any\n");
      fprintf(stderr,"  stdout: Any\n");
      exit(0);
    }
  imgStart(PRGNAME);
  
  if(argc!=1 && argc!=5)
    ERROR("invalid arguments");
  
  do {
    f1=i_read_image_file(stdin,IT_ANY,IM_FRAGMENT);
    if(f1==NULL)
      ERROR("can't import image file");
    if(argc==5)
      i_set_valid_region(f1,atoi(argv[1]),atoi(argv[2]),atoi(argv[3]),
			 atoi(argv[4]));
    valid_x=f1->valid_x;
    valid_y=f1->valid_y;
    valid_width=f1->valid_width;
    valid_height=f1->valid_height;
    f2=i_create_image(valid_width,valid_height,f1->type,IM_FRAGMENT);
    if(f2==NULL)
      ERROR("out of memory");
    f2->min_value=f1->min_value;
    f2->max_value=f1->max_value;

    /* Find out what type it is and do the appropriate loop */
    switch(f1->type)
      {
      case IT_BIT:
	for(yy=valid_y,y=0;y<valid_height;y++,yy++)
	  for(xx=valid_x,x=0;x<valid_width;x++,xx++)
	    im_put_bit_value(f2,x,y,im_get_bit_value(f1,xx,yy));
	break;
	CROP_CASE_LOOP(IT_BYTE,byte);
	CROP_CASE_LOOP(IT_LONG,long);
	CROP_CASE_LOOP(IT_FLOAT,float);
	CROP_CASE_LOOP(IT_DOUBLE,double);
	CROP_CASE_LOOP(IT_RGB,rgb);
	CROP_CASE_LOOP(IT_COMPLEX,complex);
	CROP_CASE_LOOP(IT_POLAR,polar);
      default:
	ERROR("unrecognised image type");
	break;
      }
    i_write_image_file(stdout,f2,IF_BINARY);
    i_destroy_image(f1);
    i_destroy_image(f2);
  } while(!feof(stdin));
  
  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
