/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgFlt2ToCpx.c                                                */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:40 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Flt2ToCpx"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *in1,*out1;
  int width,height,x,y;
  it_float *flt_ptr;
  it_complex *cpx_ptr;

  IFHELP
    {
      fprintf(stderr,"img%s - Convert 2 x Float to Complex image\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Float\n");
      fprintf(stderr,"  stdout: Complex\n");
      exit(0);
    }

  imgStart(PRGNAME);

  do {
    if((in1=i_read_image_file(stdin,IT_FLOAT,IM_FRAGMENT))==NULL)
      ERROR("can't import image file");
    width=in1->width;
    height=in1->height;
    if((out1=i_create_image(width,height,IT_COMPLEX,IM_FRAGMENT))==NULL)
      ERROR("out of memory");
    
    /* Copy real part across */
    for(y=0;y<height;y++)
      {
	flt_ptr=im_float_row(in1,y);
	cpx_ptr=im_complex_row(out1,y);
	for(x=0;x<width;x++)
	  (cpx_ptr++)->Re= *flt_ptr++;
      }
    out1->valid_x=in1->valid_x;
    out1->valid_y=in1->valid_y;
    out1->valid_width=in1->valid_width;
    out1->valid_height=in1->valid_height;
    i_destroy_image(in1);

    if((in1=i_read_image_file(stdin,IT_FLOAT,IM_FRAGMENT))==NULL)
      ERROR("can't import image file");
    if(in1->width!=width || in1->height!=height)
      ERROR("images are of different sizes");

    /* Copy imaginary part across */
    for(y=0;y<height;y++)
      {
	flt_ptr=im_float_row(in1,y);
	cpx_ptr=im_complex_row(out1,y);
	for(x=0;x<width;x++)
	  (cpx_ptr++)->Im= *flt_ptr++;
      }
    i_destroy_image(in1);

    /* Write resultant */
    i_write_image_file(stdout,out1,IF_BINARY);
    i_destroy_image(out1);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
