/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgGrad.c                                                     */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:43 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Grad"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *in1,*out1;
  int width,height,x,y,v_x,v_y,y_end,v_width;
  double aa,bb,cc,dd;
  it_float *in_ptr1,*in_ptr2;
  it_complex *out_ptr;

  IFHELP
    {
      fprintf(stderr,"img%s - Calculate image gradient vectors\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Float\n");
      fprintf(stderr,"  stdout: Complex\n");
      exit(0);
    }

  imgStart(PRGNAME);
  /* Loop for all images */
  do {
    in1=i_read_image_file(stdin,IT_FLOAT,IM_FRAGMENT);
    if(in1==NULL)
      ERROR("can't import image file");
    width=in1->width;
    height=in1->height;
    
    out1=i_create_image(width,height,IT_COMPLEX,IM_FRAGMENT);
    if(out1==NULL)
      ERROR("out of memory");

    v_x=in1->valid_x;
    v_y=in1->valid_y;
    v_width=in1->valid_width-1;
    y_end=v_y+in1->valid_height-1;

    /* Calculate gradient vectors from a 2x2 kernel */
    for(y=v_y;y<y_end;y++)
      {
	in_ptr1=im_float_row(in1,y)+v_x;
	in_ptr2=im_float_row(in1,y+1)+v_x;
	out_ptr=im_complex_row(out1,y)+v_x;
	for(x=0;x<v_width;x++)
	  {
	    aa= *in_ptr1++;
	    bb= *in_ptr1;
	    cc= *in_ptr2++;
	    dd= *in_ptr2;
	    out_ptr->Re=(bb+dd-aa-cc)*0.5;
	    out_ptr->Im=(aa+bb-cc-dd)*0.5;
	    out_ptr++;
	  }
      }
    
    out1->valid_x=v_x;
    out1->valid_y=v_y;
    out1->valid_width=v_width;
    out1->valid_height=in1->valid_height-1;

    i_destroy_image(in1);
    i_write_image_file(stdout,out1,IF_BINARY);
    i_destroy_image(out1);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
