/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgImpulse.c                                                  */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:44 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Impulse"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  int width,height,x,y;
  it_image *i;
  double val;

  IFHELP
    {
      fprintf(stderr,"img%s - Generate a single impulse for test purposes\n",
	      PRGNAME);
      fprintf(stderr,"img%s [width height [x y [value]]]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: None\n");
      fprintf(stderr,"  stdout: Float\n");
      exit(0);
    }

  width=height=256;
  val=1.0;
  imgStart(PRGNAME);

  if(argc>5)
    ERROR("too many arguments");
  if(argc>1)
    width=atoi(argv[1]);
  if(argc>2)
    height=atoi(argv[2]);
  x=width/2;
  y=height/2;
  if(argc>3)
    x=atoi(argv[3]);
  if(argc>4)
    y=atoi(argv[4]);
  if(argc>5)
    val=atof(argv[5]);

  if((i=i_create_image(width,height,IT_FLOAT,IM_FRAGMENT))==NULL)
    ERROR("out of memory");
  
  im_float_value(i,width/2,height/2)=val;
  if(val>0.0)
    {
      i->min_value=0.0;
      i->max_value=val;
    }
  else
    {
      i->min_value=val;
      i->max_value=0.0;
    }
  i_write_image_file(stdout,i,IF_BINARY);
  i_destroy_image(i);
  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
