/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgMagnify.c                                                  */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:47 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Magnify"
#define ERROR(e) imgError(e,PRGNAME)
#define MAGNIFY_CASE_LOOP(type,tag)                     \
    case type:                                          \
    for(y=yy=0;y<height;y++)                            \
      for(i=0;i<y_scale;i++)                            \
	{ CAT(it_,tag) *in_ptr,*out_ptr;                  \
	  in_ptr=((CAT(it_,tag) **)(in1->field))[y];      \
	  out_ptr=((CAT(it_,tag) **)(out1->field))[yy++]; \
	  for(x=0;x<width;x++,in_ptr++)                 \
	    for(j=0;j<x_scale;j++)                      \
	      *out_ptr++= *in_ptr;                      \
	}                                               \
    break

int main(int argc,char **argv)
{
  it_image *in1,*out1;
  int x_scale,y_scale,x,y,width,height,xx,yy,i,j;

  IFHELP
    {
      fprintf(stderr,"img%s - Increase pixel size of input images\n",
	      PRGNAME);
      fprintf(stderr,"img%s [scale]\n",
	      PRGNAME);
      fprintf(stderr,"img%s [x_scale y_scale]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Any\n");
      fprintf(stderr,"  stdout: Any\n");
      exit(0);
    }

  imgStart(PRGNAME);
  if(argc>3)
    ERROR("invalid arguments");

  x_scale=y_scale=2;
  if(argc>1)
    x_scale=atoi(argv[1]);
  if(argc==3)
    y_scale=atoi(argv[2]);
  else
    y_scale=x_scale;
  if(x_scale<1 || y_scale<1)
    ERROR("invalid arguments");

  do {
    in1=i_read_image_file(stdin,IT_ANY,IM_FRAGMENT);
    if(in1==NULL)
      ERROR("can't import image file");
    width=in1->width;
    height=in1->height;
    out1=i_create_image(x_scale*width,y_scale*height,in1->type,IM_FRAGMENT);
    if(out1==NULL)
      ERROR("out of memory");
    out1->min_value=in1->min_value;
    out1->max_value=in1->max_value;
    out1->valid_x=in1->valid_x*x_scale;
    out1->valid_y=in1->valid_y*y_scale;
    out1->valid_width=in1->valid_width*x_scale;
    out1->valid_height=in1->valid_height*y_scale;
    switch(in1->type)
      {
      case IT_BIT:
	for(y=yy=0;y<height;y++)
	  for(i=0;i<y_scale;i++,yy++)
	    for(x=xx=0;x<width;x++)
	      for(j=0;j<x_scale;j++,xx++)
		im_put_bit_value(out1,xx,yy,im_get_bit_value(in1,x,y));
	break;
	MAGNIFY_CASE_LOOP(IT_BYTE,byte);
	MAGNIFY_CASE_LOOP(IT_LONG,long);
	MAGNIFY_CASE_LOOP(IT_FLOAT,float);
	MAGNIFY_CASE_LOOP(IT_DOUBLE,double);
	MAGNIFY_CASE_LOOP(IT_RGB,rgb);
	MAGNIFY_CASE_LOOP(IT_COMPLEX,complex);
	MAGNIFY_CASE_LOOP(IT_POLAR,polar);
      default:
	ERROR("unrecognised image type");
	break;
      }

    i_destroy_image(in1);
    i_write_image_file(stdout,out1,IF_BINARY);
    i_destroy_image(out1);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
