/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgPrint.c                                                    */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:53 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Print"
#define ERROR(e) imgError(e,PRGNAME)
#define DISP_SIZE 7

int main(int argc,char **argv)
{
  it_image *image;
  int p_x,p_y,p_width,p_height;
  int pos_specified,width,height,x,y;
  int v_x,v_y,v_xend,v_yend;
  it_rgb *rgbptr;
  it_polar *plrptr;
  it_complex *cpxptr;

  IFHELP
    {
      fprintf(stderr,"img%s - Print contents of image sub-region\n",
	      PRGNAME);
      fprintf(stderr,"img%s [x y [width height]]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Any\n");
      fprintf(stderr,"  stdout: None\n");
      exit(0);
    }

  imgStart(PRGNAME);

  p_width=DISP_SIZE;
  p_height=DISP_SIZE;
  p_x=p_y=0;
  pos_specified=0;
  if(argc==2 || argc==4 || argc>5)
    ERROR("invalid arguments");
  if(argc>2)
    {
      p_x=atoi(argv[1]);
      p_y=atoi(argv[2]);
      pos_specified=1;
    }
  if(argc>4)
    {
      p_width=atoi(argv[3]);
      p_height=atoi(argv[4]);
    }

  do {
    image=i_read_image_file(stdin,IT_ANY,IM_FRAGMENT);
    if(image==NULL)
      ERROR("can't import image file");
    width=image->width;
    height=image->height;
    if(pos_specified)
      {
	i_set_valid_region(image,p_x,p_y,p_width,p_height);
	v_x=image->valid_x;
	v_y=image->valid_y;
	v_xend=v_x+image->valid_width;
	v_yend=v_y+image->valid_height;
      }
    else
      {
	v_x=image->valid_x;
	v_y=image->valid_y;
	i_set_valid_region(image,v_x,v_y,p_width,p_height);
	v_xend=v_x+image->valid_width;
	v_yend=v_y+image->valid_height;
      }	
    
    fprintf(stderr,"    ");
    if(image->type==IT_LONG || image->type==IT_DOUBLE || image->type==IT_FLOAT)
      for(x=v_x;x<v_xend;x++)
	fprintf(stderr,"    [%.3d]",x);
    else
      fprintf(stderr,"  [%.3d]",v_x);
    for(y=v_y;y<v_yend;y++)
      {
	fprintf(stderr,"\n[%.3d]  ",y);
	for(x=v_x;x<v_xend;x++)
	  {
	    switch(image->type)
	      {
	      case IT_BIT:
		fprintf(stderr,"%d ",im_get_bit_value(image,x,y));
		break;
	      case IT_BYTE:
		fprintf(stderr,"%d ",im_byte_value(image,x,y));
		break;
	      case IT_LONG:
		fprintf(stderr,"%8ld ",im_long_value(image,x,y));
		break;
	      case IT_FLOAT:
		fprintf(stderr,"%8g ",im_float_value(image,x,y));
		break;
	      case IT_DOUBLE:
		fprintf(stderr,"%8g ",im_double_value(image,x,y));
		break;
	      case IT_RGB:
		rgbptr= &im_rgb_value(image,x,y);
		fprintf(stderr,"(%d,%d,%d)",rgbptr->r,rgbptr->g,rgbptr->b);
		break;
	      case IT_COMPLEX:
		cpxptr= &im_complex_value(image,x,y);
		fprintf(stderr,"(%g+i%g)",cpxptr->Re,cpxptr->Im);
		break;
	      case IT_POLAR:
		plrptr= &im_polar_value(image,x,y);
		fprintf(stderr,"(%g,%g)",plrptr->rad,plrptr->ang);
		break;
	      default:
		break;
	      }
	  }
      }
    fprintf(stderr,"\n\n");
    i_destroy_image(image);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
