FloatingPoint (smallest, largest,
               gap, rational): trait
  assumes FPAssumptions
  includes
    Rational,
    TotalOrder (F)
  introduces
    mag: F -> Q
    approx: F, Q, Q -> Bool
    -__, abs, __\inv: F -> F
    __+__, __*__, __-__, __/__: F, F -> F
  asserts
    F generated by float
    \forall f, f1, f2: F, q, t: Q
      f1 <= f2 == rational(f1) <= rational(f2);
      mag(f) == abs(rational(f));
      approx(f, q, t) ==
        abs(q) <= largest
          => abs(rational(f) - q)
             <= (smallest + 
                 (gap*(mag(f) + abs(q) + t)));
      approx(-f, -rational(f), 0);
      f \neq 0 => approx(f\inv, rational(f)\inv, 0);
      approx(abs(f), mag(f), 0);
      approx(f1 + f2, rational(f1) + rational(f2),
             mag(f1) + mag(f2));
      approx(f1 * f2, rational(f1) * rational(f2), 0);
      approx(f1 - f2, rational(f1) - rational(f2),
             mag(f1) + mag(f2));
      f2 \neq 0 
        => approx(f1/f2, rational(f1)/rational(f2), 0)
