/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** aliasStack.h
*/

# ifndef aliasStack_H
# define aliasStack_H

typedef struct _aliasStack *aliasStack ;

typedef struct _aliasStack
{
  aliasTable elements;
  aliasStack thisbranch;
  aliasStack lastbranch;
  aliasStack parent;
  int lexlevel;
} _aliasStack ;

extern aliasStack aliasStack_new(void);

extern void aliasStack_newAlias (aliasStack s, sRef el, sRef al);
extern void aliasStack_clearAlias (aliasStack s, sRef el);
extern sRefSet aliasStack_canAlias (aliasStack s, sRef sr);

extern void aliasStack_push (aliasStack s, sRef el) ;
extern aliasStack aliasStack_pop (aliasStack s) ;
extern sRef aliasStack_top (aliasStack s) ;

extern cstring aliasStack_unparse (aliasStack s) ;
extern void aliasStack_free (/*@only@*/ aliasStack s) ;

extern sRefSet aliasStack_aliasedBy (aliasStack s, sRef sr);
extern aliasStack aliasStack_branch (aliasStack s);
extern aliasStack aliasStack_trueBranch (aliasStack s);
extern aliasStack aliasStack_altBranch (aliasStack s);
extern aliasStack aliasStack_popBranches (aliasStack alt);
extern aliasStack aliasStack_popTrueBranch (aliasStack s);
extern void aliasStack_checkGlobs (aliasStack s);

# define aliasStackBASESIZE MIDBASESIZE
# define aliasStackNULL ((aliasStack)0)
# else
# error "Multiple include"
# endif




