/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** aliasTable.h
*/

# ifndef aliasTable_H
# define aliasTable_H

typedef /*@only@*/ sRefSet o_sRefSet;
typedef /*@exposed@*/ sRef e_sRef;

struct _aliasTable
{
  int nelements;
  int nspace;
  /*@reldef@*/ /*@only@*/ e_sRef *keys;
  /*@reldef@*/ /*@only@*/ o_sRefSet *values;
} ; 

extern /*@unused@*/ /*@truenull@*/ bool aliasTable_isUndefined (aliasTable s);
extern /*@unused@*/ /*@truenull@*/ bool 
  aliasTable_isEmpty (/*@sef@*/ aliasTable s);
extern /*@falsenull@*/ bool aliasTable_isDefined (aliasTable s);

/*@constant null aliasTable aliasTable_undefined; @*/
# define aliasTable_undefined      ((aliasTable) NULL)
# define aliasTable_isDefined(s)   ((s) != aliasTable_undefined)
# define aliasTable_isUndefined(s) ((s) == aliasTable_undefined)
# define aliasTable_isEmpty(s)     (aliasTable_size(s) == 0)

extern int aliasTable_size (/*@sef@*/ aliasTable s);
# define aliasTable_size(s)  (aliasTable_isDefined (s) ? (s)->nelements : 0)

/*@iter aliasTable_elements (sef aliasTable t, yield exposed sRef key, yield exposed sRefSet values); @*/
# define aliasTable_elements(t, m_key, m_value) \
   { if (aliasTable_isDefined (t)) \
     { int m_ind; sRef *m_keys = &((t)->keys[0]); \
       sRefSet *m_values = &((t)->values[0]); \
       for (m_ind = 0 ; m_ind < (t)->nelements; m_ind++) \
         { sRef m_key = *(m_keys++); sRefSet m_value = *(m_values++);

# define end_aliasTable_elements }}}

extern aliasTable aliasTable_new (void) /*@*/ ;

extern void aliasTable_clearAliases (aliasTable s, sRef sr) 
   /*@modifies s, sr@*/ ;

extern /*@only@*/ sRefSet aliasTable_canAlias (aliasTable s, sRef sr) /*@*/ ;
extern aliasTable aliasTable_copy (aliasTable s) /*@*/ ;
 
extern /*@only@*/ cstring aliasTable_unparse (aliasTable s) /*@*/ ;
extern void aliasTable_free (/*@only@*/ aliasTable s) ;

extern aliasTable 
  aliasTable_addMustAlias (/*@returned@*/ aliasTable s, /*@exposed@*/ sRef sr, sRef al)
  /*@modifies s@*/ ;

extern aliasTable
  aliasTable_levelUnion (/*@returned@*/ aliasTable t1, aliasTable t2, int level) 
  /*@modifies t1@*/ ;

extern aliasTable 
  aliasTable_levelUnionNew (aliasTable t1, aliasTable t2, int level) 
  /*@modifies nothing*/ ;

extern void aliasTable_checkGlobs (aliasTable t) /*@modifies stderr@*/ ;
extern /*@only@*/ sRefSet aliasTable_aliasedBy (aliasTable s, sRef sr) /*@*/ ;
extern void aliasTable_fixSrefs (aliasTable s);
extern aliasTable aliasTable_levelUnionSeq (/*@returned@*/ aliasTable t1, 
					    /*@only@*/ aliasTable t2, int level);

/*@constant int aliasTableBASESIZE; @*/
# define aliasTableBASESIZE MIDBASESIZE

# else
# error "Multiple include"
# endif




