/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** cstring.h
*/

# ifndef CSTRING_H
# define CSTRING_H

/* does this cause problems on Solaris?  linux?  */
/* sgi's don't like it */
# ifndef IRIX
# ifdef NULL   /* hack so <strings.h> works */
# undef NULL
# endif
# endif

abst_typedef /*@null@*/ char *cstring;
typedef /*@only@*/ cstring o_cstring;

extern /*@notnull@*/ cstring cstring_create (int n) /*@*/ ;
extern /*@notnull@*/ cstring cstring_appendChar (/*@only@*/ cstring s1, char c);

extern /*@notnull@*/ cstring cstring_prependChar (char c, /*@temp@*/ cstring s1);
extern /*@notnull@*/ cstring cstring_prependCharO (char c, /*@only@*/ cstring s1);
extern cstring cstring_downcase (cstring s) /*@*/ ;
extern cstring cstring_copy (cstring s) /*@*/ ;
extern int cstring_toPosInt (cstring s) /*@*/ ;

typedef enum {
  CGE_SAME,     /* no differences */
  CGE_DISTINCT, /* significant differences */
  CGE_CASE,     /* case differences */
  CGE_LOOKALIKE /* lookalike differences */
  } cmpcode;

extern cmpcode cstring_genericEqual (cstring s, cstring t,
				     int nchars,
				     bool caseinsensitive,
				     bool lookalike) /*@*/ ;

extern void cstring_replaceLit (/*@unique@*/ cstring s, char *old, char *new);
extern char cstring_firstChar (cstring s);
extern char cstring_secondChar (cstring s);
extern char cstring_lastChar (cstring s) /*@*/ ;
extern char cstring_getChar (cstring s, int n);
extern void cstring_setChar (cstring s, int n, char c);

# define cstring_secondChar(s) cstring_getChar (s, 2)

extern int cstring_length (cstring s) /*@*/ ;
extern bool cstring_contains (/*@unique@*/ cstring c, cstring sub) /*@*/ ;
extern bool cstring_containsLit (/*@unique@*/ cstring c, char *sub) /*@*/ ;
# define cstring_containsLit(c,sub) (cstring_contains (c, cstring_fromChars (sub)))
extern bool cstring_containsChar (cstring c, char ch) /*@*/ ;
extern bool cstring_equal (cstring c1, cstring c2) /*@*/ ;
extern bool cstring_equalCaseInsensitive (cstring c1, cstring c2) /*@*/ ;
extern bool cstring_equalLen (cstring c1, cstring c2, int len) /*@*/ ;
extern bool cstring_equalLenCaseInsensitive (cstring c1, cstring c2, int len) /*@*/ ;
extern bool cstring_equalPrefix (cstring c1, char *c2) /*@*/ ;
extern bool cstring_equalLit (cstring c1, char *c2) /*@*/ ;
extern int cstring_compare (cstring c1, cstring c2) /*@*/ ;
extern int cstring_xcompare (cstring *c1, cstring *c2) /*@*/ ;
extern bool cstring_hasNonAlphaNumBar (cstring s) /*@*/ ;
extern cstring cstring_elide (cstring s, int len) /*@*/ ;
extern cstring cstring_clip (/*@returned@*/ cstring s, int len) 
   /*@modifies s*/ ;

extern /*@dependent@*/ cstring 
  cstring_bsearch (cstring key,
		   char **table,
		   int nentries);

extern bool cstring_lessthan (cstring s1, cstring s2) /*@*/ ;

# define cstring_lessthan(s1, s2) (cstring_compare (s1, s2) < 0)
# define cstring_equalLit(s, lit) (mstring_equal (cstring_toCharsSafe (s), lit))

extern bool cstring_equalFree (/*@only@*/ cstring c1, /*@only@*/ cstring c2);

/* really exposed! */
extern cstring 
  cstring_fromChars (/*@returned@*/ /*@null@*/ 
		     /*@exposed@*/ /*@temp@*/ char *cp) /*@*/ ;

extern cstring
  cstring_fromCharsO (/*@null@*/ /*@only@*/ char *cp) /*@*/ ;
/*@-mustfree@*/
# define cstring_fromCharsO(s) cstring_fromChars(s)
/*@=mustfree@*/

extern cstring cstring_fromCharsNew (/*@null@*/ char *s) /*@*/ ;
# define cstring_fromCharsNew(s) cstring_copy(cstring_fromChars(s))

extern /*@exposed@*/ /*@notnull@*/ char *
  cstring_toCharsSafe (/*@temp@*/ /*@exposed@*/ /*@returned@*/ cstring s)
     /*@*/ ;

extern /*@exposed@*/ /*@notnull@*/ 
  char *cstring_toCharsSafeO (/*@only@*/ /*@exposed@*/ /*@returned@*/ cstring s);
/*@-mustfree@*/
# define cstring_toCharsSafeO(s) cstring_toCharsSafe(s)
/*@=mustfree@*/

extern void cstring_free (/*@only@*/ cstring s);

/*@constant null cstring cstring_undefined;@*/
# define cstring_undefined     ((cstring)NULL)

extern cstring cstring_new (void);
extern /*@falsenull@*/ bool cstring_isDefined (cstring s) /*@*/ ;
extern /*@truenull@*/ bool cstring_isUndefined (cstring s) /*@*/ ;

extern bool cstring_isEmpty (cstring s) /*@*/ ;
extern /*@falsenull@*/ bool cstring_isNonEmpty (cstring s) /*@*/ ;

# define cstring_isDefined(s)   ((s) != cstring_undefined)
# define cstring_isUndefined(s) (!cstring_isDefined(s))
# define cstring_new()          (cstring_undefined)

# define cstring_isEmpty(s)     (cstring_length(s) == 0)
# define cstring_isNonEmpty(s)  (!cstring_isEmpty(s))

extern cstring cstring_makeLiteral (char *) /*@*/ ;
extern /*@observer@*/ /*@dependent@*/ cstring 
  cstring_makeLiteralTemp (char *) /*@*/ ;

# define cstring_makeLiteral(s) (cstring_copy (cstring_fromChars (s)))
# define cstring_makeLiteralTemp(s) (cstring_fromChars (s))

extern cstring cstring_capitalize (cstring s) /*@*/ ;
extern cstring cstring_capitalizeFree (/*@only@*/ cstring s) /*@modifies s@*/ ;
extern cstring cstring_fill (cstring s, int n) /*@*/ ;
extern cstring cstring_prefix (cstring s, int n) /*@*/ ;
extern /*@observer@*/ cstring cstring_suffix (cstring s, int n) /*@*/ ;
extern cstring cstring_concat (cstring s, cstring t) /*@*/ ;

extern cstring 
  cstring_concatFree (/*@only@*/ cstring s, /*@only@*/ cstring t)
  /*@modifies s, t@*/ ;

extern cstring 
  cstring_concatFree1 (/*@only@*/ cstring s, cstring t) 
  /*@modifies s@*/ ;

extern cstring 
  cstring_concatChars (/*@only@*/ cstring s, char *lit)
  /*@modifies s@*/ ;

extern lsymbol cstring_toSymbol (/*@only@*/ cstring s) /*@*/ ;
extern void cstring_markOwned (/*@owned@*/ cstring s) /*@modifies s@*/ ;

extern cstring cstring_beforeChar (cstring s, char c) /*@*/ ;

/*@iter cstring_chars (sef cstring s, yield char c);@*/
# define cstring_chars(s, m_c) \
  if (cstring_isDefined (s)) \
    { char *m_current = (char *) (s); \
      char m_c; \
      for (; (m_c = *m_current) != '\0'; m_current++) {
# define end_cstring_chars }}

# else
# error "Multiple include"
# endif



