/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
# ifndef exprNodeSList_H
# define exprNodeSList_H

/*
** like exprNodeList, except elements are dependent.
*/

typedef /*@dependent@*/ exprNode d_exprNode;

abst_typedef struct _exprNodeSList
{
  int nelements;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ d_exprNode *elements;
} *exprNodeSList;

/*@iter exprNodeSList_elements (sef exprNodeSList x, yield exposed exprNode el); @*/
# define exprNodeSList_elements(x, m_el) \
   { int m_ind; exprNode *m_elements = &((x)->elements[0]); \
     for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
       { exprNode m_el = *(m_elements++); 

# define end_exprNodeSList_elements }}

extern /*@only@*/ exprNodeSList exprNodeSList_new(void);

extern /*@only@*/ exprNodeSList exprNodeSList_singleton (/*@exposed@*/ /*@dependent@*/ exprNode e) ;

extern /*@unused@*/ void 
  exprNodeSList_addh (exprNodeSList s, /*@exposed@*/ /*@dependent@*/ exprNode el);

extern /*@only@*/ /*@unused@*/ cstring exprNodeSList_unparse (exprNodeSList s);
extern void exprNodeSList_free (/*@only@*/ exprNodeSList s) ;

extern exprNodeSList 
  exprNodeSList_append (/*@returned@*/ exprNodeSList s1, /*@only@*/ exprNodeSList s2) ;

/*@constant int exprNodeSListBASESIZE;@*/
# define exprNodeSListBASESIZE SMALLBASESIZE

# endif




