/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** flagMarkerList.h
*/

# ifndef flagMarkerList_H
# define flagMarkerList_H

typedef /*@only@*/ flagMarker o_flagMarker;

abst_typedef struct _flagMarkerList
{
  int nelements;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ o_flagMarker  *elements;
} *flagMarkerList ;

extern /*@only@*/ flagMarkerList flagMarkerList_new (void) /*@*/ ;

extern /*@unused@*/ /*@only@*/ cstring
  flagMarkerList_unparse (flagMarkerList s) /*@*/ ;
extern void flagMarkerList_free (/*@only@*/ flagMarkerList s) ;

extern void flagMarkerList_add (flagMarkerList s, /*@only@*/ flagMarker fm)
               /*@modifies s@*/ ;
extern void flagMarkerList_clear (flagMarkerList s) /*@modifies s@*/ ;
extern ynm 
  flagMarkerList_suppressError (flagMarkerList s, flagcode code, fileloc loc) /*@*/ ;

extern void flagMarkerList_checkSuppressCounts (flagMarkerList s) 
   /*@modifies stderr@*/ ;

extern bool
  flagMarkerList_inIgnore (flagMarkerList s, fileloc loc) /*@*/ ;

/*@constant int flagMarkerListBASESIZE;@*/
# define flagMarkerListBASESIZE SMALLBASESIZE

# else
# error "Multiple include"
# endif




