/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
typedef enum 
{
  ACT_SELF, ACT_ITER, ACT_ALTERNATE, 
  ACT_SEQUENCE
  } actionKind;

typedef struct _programNode {
  int wrapped; /* number of balanced parentheses around this program node */
  actionKind kind;
  union {
    struct _stmtNode *self;
    struct _programNodeList *args;
  } content;
} *programNode;

extern void programNode_free (/*@only@*/ /*@null@*/ programNode x);
extern /*@only@*/ cstring programNode_unparse (programNode p);

