/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** typeIdSet.h
**
** based on set_template.h
*/

# ifndef typeIdSET_H
# define typeIdSET_H

/* in forwardTypes.h: immut_typedef int typeIdSet;  */

extern typeIdSet typeIdSet_emptySet (void) 
   /*@modifies internalState@*/ ;

extern bool typeIdSet_member (typeIdSet s, typeId el) /*@*/ ;
extern bool typeIdSet_isEmpty (/*@sef@*/ typeIdSet s) /*@*/ ;

extern typeIdSet typeIdSet_single (typeId t)
   /*@modifies internalState@*/ ;

extern typeIdSet typeIdSet_singleOpt (typeId t)
   /*@modifies internalState@*/ ;

extern typeIdSet typeIdSet_insert (typeIdSet s, typeId el) 
   /*@modifies internalState@*/ ;

extern typeIdSet typeIdSet_removeFresh (typeIdSet s, typeId el) 
  /*@modifies internalState@*/ ;

extern cstring typeIdSet_unparse (typeIdSet s) /*@*/ ;

extern typeIdSet typeIdSet_subtract (typeIdSet s, typeIdSet t) 
   /*@modifies internalState*/ ;

extern int typeIdSet_compare (typeIdSet l1, typeIdSet l2);
extern cstring typeIdSet_dump (typeIdSet t);
extern typeIdSet typeIdSet_undump (char **s) 
   /*@modifies internalState, *s @*/ ;
extern typeIdSet typeIdSet_union (typeIdSet s1, typeIdSet s2) /*@*/ ; 

extern void typeIdSet_initMod (void) /*@modifies internalState@*/ ;
extern void typeIdSet_destroyMod (void) /*@modifies internalState@*/ ;

extern void typeIdSet_dumpTable (FILE *fout) /*@modifies *fout@*/ ;
extern void 
  typeIdSet_loadTable (FILE *fin) /*@modifies *fin, internalState@*/ ;

/*@constant typeIdSet typeIdSet_undefined;@*/
# define typeIdSet_undefined 0

/*@constant typeIdSet typeIdSet_empty;@*/
# define typeIdSet_empty 0

# else
# error "Multiple include"
# endif

