/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** clause.c
*/

# include "lclintMacros.nf"
# include "basic.h"

cstring
clause_unparse (clause cl)
{
  switch (cl)
    {
    case TRUECLAUSE:   return (cstring_makeLiteralTemp ("true"));
    case FALSECLAUSE:  return (cstring_makeLiteralTemp ("false"));
    case ANDCLAUSE:    return (cstring_makeLiteralTemp ("and"));
    case ORCLAUSE:     return (cstring_makeLiteralTemp ("or"));
    case DOWHILECLAUSE:  return (cstring_makeLiteralTemp ("do ... while"));
    case WHILECLAUSE:  return (cstring_makeLiteralTemp ("while"));
    case ITERCLAUSE:   return (cstring_makeLiteralTemp ("iter"));
    case FORCLAUSE:    return (cstring_makeLiteralTemp ("for"));
    case CASECLAUSE:   return (cstring_makeLiteralTemp ("case"));
    case NOCLAUSE:     return (cstring_makeLiteralTemp ("none"));
    case SWITCHCLAUSE: return (cstring_makeLiteralTemp ("switch"));
    case CONDCLAUSE:   return (cstring_makeLiteralTemp ("cond"));
    case TRUEEXITCLAUSE: return (cstring_makeLiteralTemp ("trueexit"));
    case FALSEEXITCLAUSE: return (cstring_makeLiteralTemp ("falseexit"));
    }

  BADEXIT;
}

cstring
clause_nameTaken (clause cl)
{
  switch (cl)
    {
    case TRUECLAUSE:   return (cstring_makeLiteralTemp ("in true branch"));
    case FALSECLAUSE:  return (cstring_makeLiteralTemp ("in true branch"));
    case ANDCLAUSE:    return (cstring_makeLiteralTemp ("in first and clause"));
    case ORCLAUSE:     return (cstring_makeLiteralTemp ("in first or clause"));
    case DOWHILECLAUSE:  return (cstring_makeLiteralTemp ("in do ... while body"));
    case WHILECLAUSE:  return (cstring_makeLiteralTemp ("in while body"));
    case ITERCLAUSE:   return (cstring_makeLiteralTemp ("in iter body"));
    case FORCLAUSE:    return (cstring_makeLiteralTemp ("in for body"));
    case CASECLAUSE:   return (cstring_makeLiteralTemp ("in one case"));
    case NOCLAUSE:     return (cstring_makeLiteralTemp ("in some clause"));
    case SWITCHCLAUSE: return (cstring_makeLiteralTemp ("in one possible execution"));
    case CONDCLAUSE:   return (cstring_makeLiteralTemp ("in true condition"));
    case TRUEEXITCLAUSE: return (cstring_makeLiteralTemp ("in trueexit"));
    case FALSEEXITCLAUSE: return (cstring_makeLiteralTemp ("in falseexit"));
    }
}

cstring
clause_nameAlternate (clause cl)
{
  switch (cl)
    {
    case TRUECLAUSE:   return (cstring_makeLiteralTemp ("in continuation"));  
    case FALSECLAUSE:  return (cstring_makeLiteralTemp ("in false branch"));
    case ANDCLAUSE:    return (cstring_makeLiteralTemp ("in second and clause"));
    case ORCLAUSE:     return (cstring_makeLiteralTemp ("in second or clause"));
    case DOWHILECLAUSE:  return (cstring_makeLiteralTemp ("if loop is not taken"));
    case WHILECLAUSE:  return (cstring_makeLiteralTemp ("if loop is not taken"));
    case ITERCLAUSE:   return (cstring_makeLiteralTemp ("if iter body does not execute"));
    case FORCLAUSE:    return (cstring_makeLiteralTemp ("if for loop body does not execute"));
    case CASECLAUSE:   return (cstring_makeLiteralTemp ("in other case"));
    case NOCLAUSE:
    case SWITCHCLAUSE: return (cstring_makeLiteralTemp ("in other possible execution"));
    case CONDCLAUSE:   return (cstring_makeLiteralTemp ("in false condition"));
    case TRUEEXITCLAUSE: return (cstring_makeLiteralTemp ("in trueexit"));
    case FALSEEXITCLAUSE: return (cstring_makeLiteralTemp ("in falseexit"));
    }
}

cstring clause_nameFlip (clause cl, bool flip)
{
  if (flip)
    {
      return clause_nameAlternate (cl);
    }
  else
    {
      return clause_nameTaken (cl);
    }
}

bool clause_isBreakable (clause cl)
{
  return (cl == SWITCHCLAUSE
	  || cl == WHILECLAUSE 
	  || cl == DOWHILECLAUSE
	  || cl == FORCLAUSE
	  || cl == ITERCLAUSE);
}

bool clause_isLoop (clause cl)
{
  return (cl == WHILECLAUSE 
	  || cl == FORCLAUSE
	  || cl == ITERCLAUSE
	  || cl == DOWHILECLAUSE);
}

bool clause_isConditional (clause cl)
{
  return (   cl == TRUECLAUSE
	  || cl == FALSECLAUSE
	  || cl == WHILECLAUSE
	  || cl == FORCLAUSE
	  || cl == SWITCHCLAUSE
	  || cl == ITERCLAUSE);
}

bool clause_isSwitch (clause cl)
{
  return (cl == SWITCHCLAUSE);
}

bool clause_isCase (clause cl)
{
  return (cl == CASECLAUSE);
}

bool clause_isNone (clause cl)
{
  return (cl == NOCLAUSE);
} 
