/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** declaratorInvNodeList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "llbasic.h"

declaratorInvNodeList
  declaratorInvNodeList_new ()
{
  declaratorInvNodeList s = (declaratorInvNodeList) dmalloc (sizeof (*s));

  s->nelements = 0;

  s->nspace = declaratorInvNodeListBASESIZE;
  s->elements = (declaratorInvNode *) 
    dmalloc (sizeof (*s->elements) * declaratorInvNodeListBASESIZE);

  return (s);
}

static void
declaratorInvNodeList_grow (declaratorInvNodeList s)
{
  int i;
  declaratorInvNode *newelements;

  s->nspace = declaratorInvNodeListBASESIZE + s->nspace;

   newelements = (declaratorInvNode *) 
     dmalloc (sizeof (*newelements) * (s->nelements + declaratorInvNodeListBASESIZE));

  if (newelements == (declaratorInvNode *) 0)
    {
      llfatalerror (cstring_makeLiteral ("declaratorInvNodeList_grow: out of memory!"));
    }

  for (i = 0; i < s->nelements; i++)
    {
      newelements[i] = s->elements[i];
    }

  sfree (s->elements); 
  s->elements = newelements;
}

declaratorInvNodeList
declaratorInvNodeList_add (declaratorInvNodeList s, declaratorInvNode el)
{
  if (s->nspace <= 0)
    {
      declaratorInvNodeList_grow (s);
    }

  s->nspace--;
  s->elements[s->nelements] = el;
  s->nelements++;

  return s;
}

/*@only@*/ cstring
declaratorInvNodeList_unparse (declaratorInvNodeList s)
{
  int i;
  cstring st = cstring_undefined;

  for (i = 0; i < s->nelements; i++)
    {
      st = message ("%q%q", st, declaratorInvNode_unparse (s->elements[i]));
    }

  return st;
}

void
declaratorInvNodeList_free (declaratorInvNodeList s)
{
  int i;
  for (i = 0; i < s->nelements; i++)
    {
      declaratorInvNode_free (s->elements[i]);
    }
  
  sfree (s->elements); 
  sfree (s);
}
