/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** idDecl.c
*/

# include "lclintMacros.nf"
# include "basic.h"

/*@only@*/ idDecl
  idDecl_create (/*@only@*/ cstring s, /*@only@*/ qtype t)
{
  idDecl d = (idDecl) dmalloc (sizeof (*d));

  d->id = s;
  d->typ = t;

  return (d);
}

void
idDecl_free (idDecl t)
{
  if (idDecl_isDefined (t))
    {
      cstring_free (t->id);
      qtype_free (t->typ);
      sfree (t);
    }
}

cstring
idDecl_unparse (idDecl d)
{
  if (idDecl_isDefined (d))
    {
      return (message ("%s : %q", d->id, qtype_unparse (d->typ)));
    }
  else
    {
      return (cstring_makeLiteral ("<undefined id>"));
    }
}

/*@observer@*/ cstring
idDecl_observeId (idDecl d)
{
  if (idDecl_isDefined (d))
    {
      return (d->id);
    }
  else
    {
      return cstring_undefined;
    }
}

qtype
idDecl_getTyp (idDecl d)
{
  llassert (idDecl_isDefined (d));

  return d->typ;
}

ctype
idDecl_getCtype (idDecl d)
{
  if (idDecl_isDefined (d))
    {
      return (qtype_getType (d->typ));
    }
  else
    {
      return ctype_unknown;
    }
}

qualList
idDecl_getQuals (idDecl d)
{
  if (idDecl_isDefined (d))
    {
      return (qtype_getQuals (d->typ));
    }
  else
    {
      return qualList_undefined;
    }
}

void
idDecl_addQual (idDecl d, qual q)
{
  llassert (idDecl_isDefined (d));

  (void) qtype_addQual (d->typ, q);
}

void
idDecl_setTyp (idDecl d, qtype c)
{
  llassert (idDecl_isDefined (d));

  qtype_free (d->typ);
  d->typ = c;
}

idDecl
idDecl_replaceCtype (/*@returned@*/ idDecl d, ctype c)
{
  llassert (idDecl_isDefined (d));

  qtype_setType (d->typ, c);
  DPRINTF (("decl: %s", idDecl_unparse (d)));
  return d;
}

idDecl
idDecl_fixBase (/*@returned@*/ idDecl t, qtype b)
{
  DPRINTF (("fix base: %s / %s",
	    idDecl_unparse (t),
	    qtype_unparse (b)));

  llassert (idDecl_isDefined (t));

  t->typ = qtype_newQbase (t->typ, b);
  return t;
}

idDecl
idDecl_fixParamBase (/*@returned@*/ idDecl t, qtype b)
{
  qtype q;
  ctype c;

  llassert (idDecl_isDefined (t));

  q = qtype_newQbase (t->typ, b);
  c = qtype_getType (q);

  /*
  ** For some reason, C adds an implicit pointer to function
  ** parameters.  It is "optional" syntax.
  */

  if (ctype_isFunction (c) && !ctype_isPointer (c))
    {
      qtype_setType (q, ctype_makePointer (c));
    }

  t->typ = q;
  /* LCLint thinks t->typ is kept. */
  /*@-compmempass@*/ return t; /*@=compmempass@*/
}

idDecl
idDecl_expectFunction (/*@returned@*/ idDecl d)
{
  DPRINTF (("expect function: %s", idDecl_unparse (d)));

  llassert (idDecl_isDefined (d));

  qtype_setType (d->typ, ctype_expectFunction (qtype_getType (d->typ)));
  return d;
}
