/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** sortSetList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "llbasic.h"

/*@only@*/ sortSetList
sortSetList_new ()
{
  sortSetList s = (sortSetList) dmalloc (sizeof (*s));
  
  s->nelements = 0;
  s->free = sortSetListBASESIZE;
  s->elements = (sortSet *) dmalloc (sizeof (*s->elements) * sortSetListBASESIZE);
  s->current = 0;
  
  return (s);
}

static void
sortSetList_grow (sortSetList s)
{
  int i;
  sortSet *newelements;

  s->free = sortSetListBASESIZE + s->free;
  newelements = (sortSet *) dmalloc (sizeof (*newelements)
				     * (s->nelements + sortSetListBASESIZE));
  
  if (newelements == (sortSet *) 0)
    {
      llfatalerror (cstring_makeLiteral ("sortSetList_grow: out of memory!"));
    }

  for (i = 0; i < s->nelements; i++)
    {
      newelements[i] = s->elements[i];
    }

  sfree (s->elements);
  s->elements = newelements;
}

void 
sortSetList_addh (sortSetList s, sortSet el)
{
  llassert (sortSetListBASESIZE > 0);

  if (s->free <= 0)
    sortSetList_grow (s);

  s->free--;
  s->elements[s->nelements] = el;
  s->nelements++;
}

void 
sortSetList_reset (sortSetList s)
{
  s->current = 0;
}

void 
sortSetList_advance (sortSetList s)
{
  s->current++;
}

/*@observer@*/ sortSet 
sortSetList_head (sortSetList s)
{
  llassert (s->nelements > 0);
  return (s->elements[0]);
}

/*@observer@*/ sortSet 
sortSetList_current (sortSetList s)
{
  if (s->current < 0 || s->current >= s->nelements)
    {
      llbug (message ("sortSetList_current: current out of range: %d (size: %d)",
		      s->current, s->nelements));
    }
  return (s->elements[s->current]);
}

/*@only@*/ cstring
sortSetList_unparse (sortSetList s)
{
  int i;
  cstring st = cstring_makeLiteral ("[ ");

  for (i = 0; i < s->nelements; i++)
    {
      if (i != 0)
	st = message ("%q, %q", st, sortSet_unparse (s->elements[i]));
      else
	st = message ("%q%q", st, sortSet_unparse (s->elements[i]));
    }
  
  st = message ("%q]", st);
  return st;
}

void
sortSetList_free (sortSetList s)
{
  /* note: elements are dependent */

  sfree (s->elements);	     
  sfree (s);
}
