/*****************************************************************
**
** MathSpad 0.60
**
** Copyright 1996, Eindhoven University of Technology (EUT)
** 
** Permission to use, copy, modify and distribute this software
** and its documentation for any purpose is hereby granted
** without fee, provided that the above copyright notice appear
** in all copies and that both that copyright notice and this
** permission notice appear in supporting documentation, and
** that the name of EUT not be used in advertising or publicity
** pertaining to distribution of the software without specific,
** written prior permission.  EUT makes no representations about
** the suitability of this software for any purpose. It is provided
** "as is" without express or implied warranty.
** 
** EUT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
** SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
** MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL EUT
** BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
** DAMAGES OR ANY DAMAGE WHATSOEVER RESULTING FROM
** LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
** OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
** OF THIS SOFTWARE.
** 
** 
** Roland Backhouse & Richard Verhoeven.
** Department of Mathematics and Computing Science.
** Eindhoven University of Technology.
**
********************************************************************/
/*
**   File : default.c
**   Datum: 11-4-92
**   Doel : Instellingen van het programma veranderen.
**          Vastleggen van de layout.
*/

#include "mathpad.h"
#include "system.h"
#include "funcs.h"
#include "sources.h"
#include "button.h"
#include "keymap.h"
#include "getstring.h"
#include "message.h"
#include "default.h"
#include "popup.h"
#include "helpfile.h"
#include "checkbox.h"

#define DEFAULTNAME  "MathSpad Default"
#define ICONNAME     "Default"
#define LEFT_LINE    5
#define MIDDLE_LINE  10
#define RIGHT_LINE   5
#define LINE_SP      5

enum button {SETBUTTON, SAVEBUTTON, DONEBUTTON, NR_BUTTON };

static
char *defaultbutton[NR_BUTTON] = { "Set", "Save", "Done" };
static
int defaulthelp[NR_BUTTON] =
{ DEFAULTSETHELP, DEFAULTSAVEHELP, DEFAULTDONEHELP };

#define NR_FIELD  22

/* static int saveponquit=0; */

static
struct {
    char *descript;
    void *data;
    int maxlen;
    char *text;
    Bool is_integer;       /* tevens layout_change-factor */
    int min, max, helpnr;
    void *variable;
} field[NR_FIELD] = {
{"Screen",       0,  0,0,False,0,  0,                0,NULL},
{"  Line space", 0, 15,0, True,0, 20,DEFAULTSCREENHELP,&line_space},
{"  Tab size",   0, 15,0, True,0,200,DEFAULTSCREENHELP,&screen_tab},
{"  Elastic space",0, 15,0, True,0, 20,DEFAULTSCREENHELP,&screen_space},
{"Latex",        0,  0,0,False,0,  0,                0,NULL},
{"  Line space", 0, 40,0,False,0,  0, DEFAULTLATEXHELP,&latex_line_unit},
{"  Tab size",   0, 40,0,False,0,  0, DEFAULTLATEXHELP,&latex_tab_unit},
{"  Elastic space",0, 40,0,False,0,  0, DEFAULTLATEXHELP,&latex_space_unit},
{"Left margin",  0, 15,0, True,0, 10,DEFAULTLMARGINHELP,&latex_side},
{"",             0,  0,0,False,0,  0,                0,NULL},
{"Directory",    0,  0,0,False,0,  0,                0,NULL},
{"  Documents",  0,512,0,False,0,  0,   DEFAULTDIRHELP,&userdir},
{"  Stencils",   0,512,0,False,0,  0,   DEFAULTDIRHELP,&notationdir},
{"  Output",     0,512,0,False,0,  0,   DEFAULTDIRHELP,&latexdir},
{"",             0,  0,0,False,0,  0,                0,NULL},
{"Fonts",        0,100,0,False,0,  0,  DEFAULTFONTHELP,&fontfile[EDITFONT]},
{"  Stencils",   0,100,0,False,0,  0,  DEFAULTFONTHELP,&fontfile[NOTATIONFONT]},
{"  Symbols",    0,100,0,False,0,  0,  DEFAULTFONTHELP,&fontfile[SYMBOLFONT]},
{"  Popups",     0,100,0,False,0,  0,  DEFAULTFONTHELP,&fontfile[POPUPFONT]},
{"",             0,  0,0,False,0,  0,                0,NULL},
{"Keys",         0,100,0,False,0,  0,  DEFAULTKEYSHELP,&keypath},
{"Save Time",    0, 15,0, True,1, 60, DEFAULTSTIMEHELP,&save_minute}
/* to add a checkbox, set third item to 0, last item to variable
{"Save Project", 0,  0,0, True,0,  1, DEFAULTSTIMEHELP,&saveponquit}
*/
};

#define intvar(A) *((int *) field[A].variable)
#define charrefvar(A) (*((char **) field[A].variable))
#define FONTFIELD 15
#define KEYFIELD  20

static Window defaultwin;
static int last_xpos = 0, last_ypos = 0, last_width = 0, last_height = 0;
static int x_offset, y_offset;
static int compens;
static int string_pos_x;
static XTextProperty default_name, icon_name;
static char *name = DEFAULTNAME, *iconname = ICONNAME;

#define sub_width(A) ((A) - string_pos_x - RIGHT_LINE)

#define nextfield(A)  do { if (A==NR_FIELD-1) A=0; else A++; } while (!field[A].maxlen)
#define prevfield(A)  do { if (!A) A=NR_FIELD-1;   else A--; } while (!field[A].maxlen)

static void close_window(Bool bad)
{
    int i;
    /* mogelijk het saven van defaults, of het vragen daarom
     */
    if (default_is_open) {
      default_iconized = False;
      default_is_open = False;
      for (i=0; i<NR_FIELD; i++)
	if (field[i].maxlen && field[i].data) string_destroy(field[i].data);
      pop_input();
      popup_remove(defaultwin);
      if (!bad) {
	  XDestroyWindow(display, defaultwin);
	  destroy_window(defaultwin);
      }
    }
}

static void default_bad_end(void *data)
{
    close_window(True);
}

static void default_draw(void *data)
{
    int i;

    if (!default_is_open) return;
    push_fontgroup(POPUPFONT);
    XDrawLine(display, defaultwin, get_GC(Normal,0),
	      0, INTERSPACE*2+button_height,
	      display_width, INTERSPACE*2+button_height);
    for (i=0; i<NR_FIELD; i++)
	XDrawString(display, defaultwin, get_GC_font(Normal, 0, TEXTFONT,0),
		    LEFT_LINE, y_offset+ i*(string_height()+LINE_SP)+compens,
		    field[i].descript, strlen(field[i].descript));
    pop_fontgroup();
}

static void default_set(void)
{
    char *newstring;
    int i,j;
    Bool lchanged = False;
    
    for (i=0; i<NR_FIELD; i++)
	if (field[i].variable) {
	    if (field[i].maxlen)
		if (field[i].is_integer) {
		    newstring = string_text(field[i].data);
		    if (sscanf(newstring, "%i", &j)) {
			if (j<field[i].min) j = field[i].min;
			if (j>field[i].max) j = field[i].max;
			sprintf(field[i].text, "%i", j);
			if (intvar(i) != j) {
			    intvar(i) = j;
			    lchanged = True;
			}
		    }
		    myfree(newstring);
		    string_refresh(field[i].data, field[i].text);
		} else {
		    if (i>=FONTFIELD && i<KEYFIELD) {
			if (new_fontfile(i-FONTFIELD,string_text(field[i].data))) {
			    field[i].text = charrefvar(i);
			    lchanged = True;
			} else
			    string_refresh(field[i].data, field[i].text);
		    } else if (i==KEYFIELD) {
			if (keypath_exist(string_text(field[i].data))) {
			    load_keypath();
			    field[i].text = charrefvar(i);
			} else
			    string_refresh(field[i].data, field[i].text);
		    } else {
			myfree(field[i].text);
			field[i].text = charrefvar(i) = standard_dir(string_text(field[i].data));
			string_refresh(field[i].data, field[i].text);
		    }
		}
	    else
		intvar(i) = checkbox_value(field[i].data);
	}
    if (lchanged)
	call_layout_change();
}

static void default_handle_button(void *data, int bnr)
{
    switch (bnr) {
    case SETBUTTON:
	default_set();
	message(MESSAGE,"Defaults set.");
	break;
    case SAVEBUTTON:
        default_set();
	save_defaults();
	message(MESSAGE, "Defaults saved.");
	break;
    case DONEBUTTON:
	if (can_close_default) default_close();
	break;
    }
}

static void default_layout_change(void *data)
{
    int i,j, wl, wr;
    int win_width, win_height;
    XSizeHints size_hints;

    push_fontgroup(POPUPFONT);
    if (default_is_open) {
	win_height = INTERSPACE*4+button_height +
	    (string_height()+LINE_SP)* NR_FIELD;
	wl = wr = 0;
	for (i=0; i<NR_FIELD; i++) {
	    if ((j=string_width(TEXTFONT,field[i].descript,-1)) > wl) wl=j;
	    if ((j=string_window_width(field[i].maxlen)) >wr) wr=j;
	}
	win_width = wl+wr+LEFT_LINE+ MIDDLE_LINE + RIGHT_LINE;
	size_hints.flags = PMinSize;
	size_hints.min_width = win_width;
	size_hints.min_height = win_height;
	XSetWMNormalHints(display, defaultwin, &size_hints);
	XResizeWindow(display, defaultwin, win_width, win_height);
	XClearWindow(display, defaultwin);
	x_offset = LEFT_LINE + wl + MIDDLE_LINE;
	y_offset = button_height+INTERSPACE*3 + LINE_SP;
	string_pos_x = x_offset;
	compens = (string_height() + LINE_SP -
		   font_height(TEXTFONT,0))/2 - 2 + font_ascent(TEXTFONT,0);
	for (i=0; i<NR_FIELD; i++) {
	    if (field[i].maxlen) {
		string_move(field[i].data, x_offset,
			    y_offset+i*(string_height()+LINE_SP));
		string_resize(field[i].data, sub_width(win_width));
	    }
	}
	if (!default_iconized)
	    default_draw(NULL);
    }
    pop_fontgroup();
}

static MENU fontfilemenu;
static int popup_nr=0;

static void remove_fontfile(unsigned int c)
{
    if (fontfilemenu.line) myfree(fontfilemenu.line[0].txt);
    myfree(fontfilemenu.line);
    fontfilemenu.line=NULL;
    popup_nr = 0;
}

static void handle_fontfilename(void *data, int nr)
{
    if (default_is_open && fontfilemenu.line && popup_nr) {
	int i=0;
	Char *c=fontfilemenu.line[nr].txt;
	char *h;
	while (c[i]) i++;
	h= (char*) malloc(sizeof(char)*(i+1));
	i=0;
	if (h) {
	    while ((h[i]=(char) c[i])) i++;
	    string_refresh(field[popup_nr].data, h);
	}
    }
    remove_fontfile(0);
}

static int check_name(char *ext, char *cname)
{
    int i,j;
    if ((i=strlen(ext))>=(j=strlen(cname))) return 0;
    return !strcmp(cname+j-i,ext);
}

#define FONTFILEEXT ".mpf"

static void make_fontfile_popup(int nr, Bool motion)
{
    char *ownfiles=NULL, *progfiles=NULL;
    char *dirs=NULL;
    int nf=0,nd=0,npf=0,ffel,npd,i,j;
    Char *c;

    if (fontfilemenu.line) return;
    ffel=strlen(FONTFILEEXT);
    i = read_dir_contents(userdir, True, check_name, FONTFILEEXT,
				 &dirs, &nd, &ownfiles,&nf);
    if (dirs) { myfree(dirs); dirs=NULL; }
    if (strcmp(userdir, program_dir)) {
	i = read_dir_contents(program_dir, True, check_name, FONTFILEEXT,
			      &dirs, &npd, &progfiles, &npf);
    }
    if (dirs) { myfree(dirs); dirs=NULL; }
    if (!npf && !nf) {
	myfree(ownfiles);
	myfree(progfiles);
	return;
    }
    fontfilemenu.line = (MENULINE*) malloc(sizeof(MENULINE)*(npf+nf+1));
    c = fontfilemenu.line[0].txt =
	(Char*) malloc(((nf?strlen(ownfiles):0)+(npf?strlen(progfiles):0)+2)
		       *sizeof(Char));
    i=0;j=0;
    if (nf) {
	dirs = ownfiles;
	do {
	    if (*dirs=='\n' || *dirs=='\0') {
		fontfilemenu.line[i].len=j-ffel;
		fontfilemenu.line[i].txt=c-j;
		c[-ffel]=0;
		*c++=0;
		j=0;
		fontfilemenu.line[i].func=handle_fontfilename;
		fontfilemenu.line[i].fdata=NULL;
		fontfilemenu.line[i].fint=i;
		fontfilemenu.line[i].submenu=NULL;
		i++;
	    } else {
		*c++=*dirs;
		j++;
	    }
	} while (*dirs++);
	free(ownfiles);
    }
    if (npf) {
	dirs = progfiles;
	do {
	    if (*dirs=='\n' || *dirs=='\0') {
		fontfilemenu.line[i].len=j-ffel;
		fontfilemenu.line[i].txt=c-j;
		c[-ffel]=0;
		*c++=0;
		j=0;
		fontfilemenu.line[i].func=handle_fontfilename;
		fontfilemenu.line[i].fdata=NULL;
		fontfilemenu.line[i].fint=i;
		fontfilemenu.line[i].submenu=NULL;
		i++;
	    } else {
		*c++=*dirs;
		j++;
	    }
	} while (*dirs++);
	free(progfiles);
    }
    fontfilemenu.nr=i;
    fontfilemenu.selline=fontfilemenu.defline=-1;
    fontfilemenu.stickopt=False;
    fontfilemenu.title=NULL;
    fontfilemenu.help=NULL;
    fontfilemenu.freesub=False;
    fontfilemenu.endfunc=remove_fontfile;
    fontfilemenu.transwin=defaultwin;
    get_motion_hints(root_window,0);
    motion_get_pos(&fontfilemenu.x,&fontfilemenu.y);
    stop_motion_hints();
    (void) popup_make(&fontfilemenu);
    popup_nr = nr;
}

static void default_press(void *data, XButtonEvent *event)
{
    int i;
    if (!default_is_open) return;
    push_fontgroup(POPUPFONT);
    i = (event->y- y_offset)/(string_height()+LINE_SP);
    if (i>=FONTFIELD && i<KEYFIELD)
	make_fontfile_popup(i,True);
    pop_fontgroup();
    get_motion_hints(defaultwin,-1);
}

static void default_motion(void *data, int x, int y)
{
}

static void default_release(void *data, XButtonEvent *event)
{
    stop_motion_hints();
}

static void default_resize(void *data, XConfigureEvent *event)
{
    int i,x,y;

    if (default_is_open) {
	last_width = event->width;
	last_height = event->height;
	window_manager_added(defaultwin, &x,&y);
	last_xpos = event->x-x;
	last_ypos = event->y-y;
	for (i=0; i<NR_FIELD; i++)
	    if (field[i].maxlen)
		string_resize(field[i].data, sub_width(event->width));
    }
}

static void default_iconize(void *data)
{
    int i;

    default_iconized = True;
    for (i=0; i<NR_FIELD; i++)
	if (field[i].maxlen)
	    string_unmap(field[i].data);
}

static void default_deiconize(void *data)
{
    int i;

    default_iconized = False;
    for (i=0; i<NR_FIELD; i++)
	if (field[i].maxlen)
	    string_map(field[i].data);
}

static int default_last_pos(int *x, int *y, int *w, int *h)
{
    *x = last_xpos;
    *y = last_ypos;
    *w = last_width;
    *h = last_height;
    return False;
}

static void default_set_last_pos(int x, int y, int w, int h)
{
    last_xpos = x;
    last_ypos = y;
    last_width = w;
    last_height = h;
}

FUNCTIONS defaultfuncs = {
    default_bad_end, default_draw, default_resize, default_press,
    default_release, default_motion, default_iconize, default_deiconize,
    NULL, NULL, default_layout_change, NULL, NULL, NULL, NULL, NULL, 
    default_last_pos, default_set_last_pos };


void default_update(void)
{
    int i;
    for (i=0; i<NR_FIELD; i++) {
	if (field[i].variable) {
	    if (field[i].is_integer) {
		if (field[i].maxlen) {
		    if (!field[i].text)
			field[i].text = (char *) malloc(field[i].maxlen+1);
		    sprintf(field[i].text, "%i", intvar(i));
		}
	    } else
		field[i].text = charrefvar(i);
	}
    }
}

void default_init(void)
{
    int i,j, wl,wr, lw, lh;

    default_update();
    push_fontgroup(POPUPFONT);
    lh = INTERSPACE*4+button_height + (string_height()+LINE_SP)* NR_FIELD;
    wl = wr = 0;
    for (i=0; i<NR_FIELD; i++) {
	if ((j=string_width(TEXTFONT,field[i].descript,-1)) > wl) wl=j;
	if ((j=string_window_width(field[i].maxlen)) >wr) wr=j;
    }
    lw = wl+wr+LEFT_LINE+ MIDDLE_LINE + RIGHT_LINE;
    x_offset = LEFT_LINE + wl + MIDDLE_LINE;
    y_offset = button_height+INTERSPACE*3 + LINE_SP;
    string_pos_x = x_offset;
    compens = (string_height() + LINE_SP - font_height(TEXTFONT,0))/2 - 2
	+ font_ascent(TEXTFONT,0);
    if (!last_width) {
	last_width = lw;
	last_height = lh;
	last_xpos = (display_width - lw)/2;
	last_ypos = (display_height - lh)/2;
    }
    if (!XStringListToTextProperty(&name, 1, &default_name) ||
	!XStringListToTextProperty(&iconname, 1, &icon_name)) {
	message(EXIT-1, "No location for defaultname.");
    }
    pop_fontgroup();
}

void default_open(void)
{
    XSetWindowAttributes default_attr;
    unsigned long default_mask;
    int x,y;
    int i,j;
    XSizeHints size_hints;

    default_mask = (CWBackPixel | CWBorderPixel | CWBitGravity |
		    CWColormap | CWEventMask);
    default_attr.background_pixel = white_pixel;
    default_attr.border_pixel = black_pixel;
    default_attr.colormap = colormap;
    default_attr.bit_gravity = NorthWestGravity;
    default_attr.event_mask = (ExposureMask | ButtonPressMask |
			       ButtonMotionMask | PointerMotionHintMask |
			       ButtonReleaseMask | KeyPressMask |
			       StructureNotifyMask | VisibilityChangeMask);
    defaultwin = XCreateWindow(display, root_window,
			       last_xpos, last_ypos, last_width, last_height,
			       BORDERWIDTH, CopyFromParent, InputOutput,
			       visual,
			       default_mask, &default_attr);
    size_hints.flags = PPosition | PSize | PMinSize;
    size_hints.min_width = last_width;
    size_hints.min_height = last_height;
    XSetWMProperties(display, defaultwin, &default_name, &icon_name,
		     NULL, 0, &size_hints, &wm_hints, &class_hints);
    set_protocols(defaultwin);
    i=0;
    x = LEFT_LINE;
    y = INTERSPACE;
    push_fontgroup(POPUPFONT);
    if (add_window(defaultwin, DEFAULTWINDOW, root_window,
		   NULL,helpname[DEFAULTHELP])) {
	while (i<NR_BUTTON &&
	       button_make(i, defaultwin, defaultbutton[i], &x, y, 1, NULL,
			   helpname[defaulthelp[i]], NULL, NULL, NULL,
		           default_handle_button, NULL, NULL))
	    i++,x+=BINTERSPACE;
	if (i==NR_BUTTON) {
	    i=0;
	    while (i<NR_FIELD &&
		   (!field[i].variable ||
		    (field[i].maxlen &&
		     (field[i].data =
		      string_make(defaultwin,
				  (field[i].is_integer?field[i].text:charrefvar(i)),
				  field[i].maxlen, sub_width(last_width),
				  helpname[field[i].helpnr],x_offset,
				  y_offset+i*(string_height()+LINE_SP),
				  field[i].is_integer ))) ||
		    (!field[i].maxlen &&
		     (field[i].data =
		      checkbox_make(defaultwin, x_offset,
				    y_offset+i*(string_height()+LINE_SP),
				    intvar(i))))))
		i++;
	    if (i<NR_FIELD) i=0;
	} else
	    i=0;
    }
    if (!i)
	XDestroyWindow(display, defaultwin);
    else {
	x = 0; prevfield(x);   /* x == prevfield(i)      */
	i = x; nextfield(i);   /* i == element           */
	y = i; nextfield(y);   /* y == nextfield(i)      */
	j = i;                 /* houd startpositie bij  */
	do {
	    string_relation(field[i].data, field[x].data, field[y].data);
	    x = i;               /*  eq. met  nextfield(x) */
	    i = y;               /*  eq. met  nextfield(i) */
	    nextfield(y);
	} while (i!=j);
	XMapSubwindows(display, defaultwin);
	XMapWindow(display, defaultwin);
	push_input();
	string_get_input(field[j].data);
	default_iconized = False;
	default_is_open = True;
    }
    pop_fontgroup();

}

void default_close(void)
{
    close_window(False);
}
