/*****************************************************************
**
** MathSpad 0.60
**
** Copyright 1996, Eindhoven University of Technology (EUT)
** 
** Permission to use, copy, modify and distribute this software
** and its documentation for any purpose is hereby granted
** without fee, provided that the above copyright notice appear
** in all copies and that both that copyright notice and this
** permission notice appear in supporting documentation, and
** that the name of EUT not be used in advertising or publicity
** pertaining to distribution of the software without specific,
** written prior permission.  EUT makes no representations about
** the suitability of this software for any purpose. It is provided
** "as is" without express or implied warranty.
** 
** EUT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
** SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
** MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL EUT
** BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
** DAMAGES OR ANY DAMAGE WHATSOEVER RESULTING FROM
** LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
** OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
** OF THIS SOFTWARE.
** 
** 
** Roland Backhouse & Richard Verhoeven.
** Department of Mathematics and Computing Science.
** Eindhoven University of Technology.
**
********************************************************************/
/*
**   File: message.c
*/

#include "mathpad.h"
#include "system.h"
#include "funcs.h"
#include "sources.h"
#include "output.h"
#include "remark.h"
#include "message.h"


void message(int lvl, char *text)
{
    Bool to_standard = False;

    if (menu_is_open) {
	message_time = last_time;
	switch (lvl) {
	case MESSAGE:
	    out_message(text);
	    break;
	case MESSAGECURS:
	    out_message_curs(text);
	    break;
	case ERROR:
	    out_message(text);
	    XBell(display, 0);
	    break;
	case CLICKREMARK:
	    kind_of_remark = LONG_REMARK;
	    to_standard = (!remark_make(0, NULL, NULL, REMARK_CENTRE,
					char2Char(text), NULL, NULL, 0, NULL));
	    break;
	case KEYREMARK:
	    kind_of_remark = SHORT_REMARK;
	    to_standard = (!remark_make(0, NULL, NULL, REMARK_CENTRE,
					char2Char(text), NULL, NULL, 0, NULL));
	    break;
	default:   /* EXIT -... */
	    to_standard = True;
	    break;
	}
    } else
	to_standard = True;
    if (to_standard) {
	/*
	**  beep beep
	*/
	fprintf(stderr, "%s: %s\n", progname, text);
	if (lvl>KEYREMARK) {
	    /*
	    **  mogelijk menu_bad_end() of server_close()  (geven zelf exit)
	    */
	    exit(lvl-EXIT);
	}
    }
}

void message2(int lvl, char *text1, char *text2)
{
    char *temp;

    temp = concat(text1, text2);
    message(lvl, temp);
    myfree(temp);
}
