type fontInfo =
   Family of string
 | Weight of string
 | Slant of string
 | FontIndex of int
 | FontDelta of int

(* type fontDesc *)

type fontDesc =
  { mutable family : string;
    mutable weight : string;
    mutable slant : string;
    mutable pxlsz : int }

val default : fontDesc ref
val merge : fontDesc -> fontInfo list -> fontDesc
val compute_tag : fontDesc -> string * Tk.options list

val font_index : int -> int
val pxlsz : int -> int
