(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*        Daniel de Rauglaudre, projet Cristal, INRIA Rocquencourt     *)
(*                                                                     *)
(*  Copyright 1996 Institut National de Recherche en Informatique et   *)
(*  Automatique.  Distributed only by permission.                      *)
(*                                                                     *)
(***********************************************************************)

(* $Id: pstream.mli,v 1.3 1996/04/30 14:49:47 xleroy Exp $ *)

(* Conversion of streams and parsers into Objective Caml syntax *)

open Parsetree

type stream_pattern_component =
    Spat_term of pattern * expression option
  | Spat_nterm of pattern * expression
  | Spat_sterm of pattern
type stream_expr_component =
    Sexp_term of expression
  | Sexp_nterm of expression

val cparser :
  pattern option *
    ((stream_pattern_component * expression option) list *
     pattern option *
     expression) list ->
  expression
val cstream : stream_expr_component list -> expression
