#ifndef QTETRIS_H
#define QTETRIS_H

#include "qtetrisb.h"
#include <qframe.h>
#include <qlcdnum.h>
#include <qpushbt.h>
#include <qpainter.h>


class ShowNextPiece : public QFrame
{
    Q_OBJECT
    friend class QTetris;
public:
    ShowNextPiece( QWidget *parent=0, const char *name=0  );
public slots:
    void drawNextSquare( int x, int y,QColor *color );
signals:
    void update();
private:
    void paintEvent( QPaintEvent * );
    void resizeEvent( QResizeEvent * );
    
    int      blockWidth,blockHeight;
    int      xOffset,yOffset;
};


class QTetris : public QWidget
{
    Q_OBJECT
public:
    QTetris( QWidget *parent=0, const char *name=0 );
    void startGame() { board->startGame(); }

public slots:
    void gameOver();
    void quit();
private:
    void keyPressEvent( QKeyEvent *e ) { board->keyPressEvent(e); }

    QTetrisBoard  *board;
    ShowNextPiece *showNext;
    QLCDNumber    *showScore;
    QLCDNumber    *showLevel;
    QLCDNumber    *showLines;
    QPushButton   *quitButton;
    QPushButton   *startButton;
    QPushButton   *pauseButton;
};


void drawTetrisButton( QPainter *, int x, int y, int w, int h,
		       const QColor *color );


#endif
