/****************************************************************************
** $Id: qbttngrp.h,v 2.0 1996/09/24 10:16:15 agulbra Exp $
**
** Definition of QButtonGroup class
**
** Created : 950130
**
** Copyright (C) 1992-1997 Troll Tech AS.  All rights reserved.
**
** This file is part of the non-commercial distribution of Qt 1.2.
**
** See the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** (This file differs from the one in the commercial distribution of
** Qt only by this comment.)
**
*****************************************************************************/

#ifndef QBTTNGRP_H
#define QBTTNGRP_H

#include "qgrpbox.h"


class QButton;
class QButtonList;


class QButtonGroup : public QGroupBox
{
    Q_OBJECT
public:
    QButtonGroup( QWidget *parent=0, const char *name=0 );
    QButtonGroup( const char *title, QWidget *parent=0, const char *name=0 );
   ~QButtonGroup();

    bool	isExclusive() const;
    void	setExclusive( bool );

    int		insert( QButton *, int id=-1 );
    void	remove( QButton * );
    QButton    *find( int id ) const;

signals:
    void	pressed( int id );
    void	released( int id );
    void	clicked( int id );

protected slots:
    void	buttonPressed();
    void	buttonReleased();
    void	buttonClicked();

private:
    void	init();
    bool	excl_grp;
    QButtonList *buttons;

private:	// Disabled copy constructor and operator=
    QButtonGroup( const QButtonGroup & ) {}
    QButtonGroup &operator=( const QButtonGroup & ) { return *this; }
};


#endif // QBTTNGRP_H
