/*
 *
 *  (c) COPYRIGHT MIT and INRIA, 1996.
 *  Please first read the full copyright statement in file COPYRIGHT.
 *
 */

/*
 * Amaya editing functions called form Thot and declared in HTML.A
 * These functions concern Image elements.
 *
 * Author: I. Vatton
 *
 */

/* Included headerfiles */
#define THOT_EXPORT extern
#include "amaya.h"

#define ImageURL	1
#define ImageLabel	2
#define ImageDir	3
#define ImageSel	4
#define FormImage	5
#define IMAGE_MAX_REF	6

static int          BaseImage;
static char         DirectoryImage[MAX_LENGTH];
static char         LastURLImage[MAX_LENGTH];
static char         ImageName[MAX_LENGTH];

#include "init_f.h"
#include "AHTURLTools_f.h"
#include "EDITimage_f.h"
#include "HTMLimage_f.h"
#include "HTMLedit_f.h"


/*----------------------------------------------------------------------
   CallbackImage manage returns of Picture form.                   
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                CallbackImage (int ref, int typedata, char *data)
#else  /* __STDC__ */
void                CallbackImage (ref, typedata, data)
int                 ref;
int                 typedata;
char               *data;

#endif /* __STDC__ */
{
   int                 val;
   char                tempfile[MAX_LENGTH];
   char                tempname[MAX_LENGTH];
   boolean             change;

   val = (int) data;
   switch (ref - BaseImage)
	 {
	       /* *********Load URL or local image********* */
	    case FormImage:
	       if (val == 2)
		 {
		    /* Clear */
		    LastURLImage[0] = EOS;
		    TtaSetTextForm (BaseImage + ImageURL, LastURLImage);
		 }
	       else
		 {
		    TtaDestroyDialogue (BaseImage + FormImage);
		    if (val == 0)
		       LastURLImage[0] = EOS;
		 }
	       break;
	    case ImageURL:
	       if (data == NULL)
		  break;
	       if (IsW3Path (data))
		 {
		    /* save the URL name */
		    strcpy (LastURLImage, data);
		    ImageName[0] = EOS;
		 }
	       else
		 {
		    change = NormalizeFile (data, LastURLImage);
		    if (change)
		       TtaSetTextForm (BaseImage + ImageURL, LastURLImage);
		    if (LastURLImage[strlen (LastURLImage) - 1] == DIR_SEP)
		      {
			 strcpy (DirectoryImage, LastURLImage);
			 ImageName[0] = EOS;
			 LastURLImage[0] = EOS;
			 /* reinitialize directories and document lists */
			 TtaListDirectory (DirectoryImage, BaseImage + FormImage,
					   TtaGetMessage (LIB, TMSG_DOC_DIR), BaseImage + ImageDir,
					   "", TtaGetMessage (AMAYA, AM_FILES), BaseImage + ImageSel);
		      }
		    else
		       TtaExtractName (LastURLImage, DirectoryImage, ImageName);
		 }
	       break;
	    case ImageDir:
	       if (!strcmp (data, ".."))
		 {
		    /* suppress last directory */
		    strcpy (tempname, DirectoryImage);
		    TtaExtractName (tempname, DirectoryImage, tempfile);
		 }
	       else
		 {
		    strcat (DirectoryImage, DIR_STR);
		    strcat (DirectoryImage, data);
		 }
	       TtaSetTextForm (BaseImage + ImageURL, DirectoryImage);
	       TtaListDirectory (DirectoryImage, BaseImage + FormImage,
		    TtaGetMessage (LIB, TMSG_DOC_DIR), BaseImage + ImageDir,
		 "", TtaGetMessage (AMAYA, AM_FILES), BaseImage + ImageSel);
	       ImageName[0] = EOS;
	       break;
	    case ImageSel:
	       if (DirectoryImage[0] == EOS)
		 {
		    /* set path on current directory */
		    getcwd (DirectoryImage, MAX_LENGTH);
		 }
	       /* construct the image full name */
	       strcpy (LastURLImage, DirectoryImage);
	       val = strlen (LastURLImage) - 1;
	       if (LastURLImage[val] != DIR_SEP)
		 strcat (LastURLImage, DIR_STR);
	       strcat (LastURLImage, data);
	       TtaSetTextForm (BaseImage + ImageURL, LastURLImage);
	       break;
	    default:
	       break;
	 }
}

/*----------------------------------------------------------------------
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                InitImage (void)
#else  /* __STDC__ */
void                InitImage ()
#endif				/* __STDC__ */
{
   BaseImage = TtaSetCallback (CallbackImage, IMAGE_MAX_REF);
   LastURLImage[0] = EOS;
   /* set path on current directory */
   getcwd (DirectoryImage, MAX_LENGTH);

}


/*----------------------------------------------------------------------
   GetImageURL initializes the Picture form                             
  ----------------------------------------------------------------------*/
#ifdef __STDC__
char               *GetImageURL (Document document, View view)
#else  /* __STDC__ */
char               *GetImageURL (Document document, View view)
Document            document;
View                view;

#endif /* __STDC__ */
{
   int                 i;
   char               *s;

   s = TtaGetMemory (MAX_LENGTH);
   /* Dialogue form for open URL or local */
   i = 0;
   strcpy (&s[i], TtaGetMessage (LIB, TMSG_LIB_CONFIRM));
   i += strlen (&s[i]) + 1;
   strcpy (&s[i], TtaGetMessage (AMAYA, AM_CLEAR));

   TtaNewSheet (BaseImage + FormImage, TtaGetViewFrame (document, view),  TtaGetMessage (AMAYA, AM_OPEN_URL),
		2,
		s, TRUE, 2, 'L', D_CANCEL);
   TtaNewTextForm (BaseImage + ImageURL, BaseImage + FormImage,
		   TtaGetMessage (AMAYA, AM_OPEN_URL), 50, 1, TRUE);
   TtaNewLabel (BaseImage + ImageLabel, BaseImage + FormImage, " ");
   TtaListDirectory (DirectoryImage, BaseImage + FormImage,
		     TtaGetMessage (LIB, TMSG_DOC_DIR),		/* std thot msg */
		     BaseImage + ImageDir, "",
		     TtaGetMessage (AMAYA, AM_FILES), BaseImage + ImageSel);
   if (LastURLImage[0] != EOS)
      TtaSetTextForm (BaseImage + ImageURL, LastURLImage);
   else
     {
	strcpy (s, DirectoryImage);
	strcat (s, DIR_STR);
	strcat (s, ImageName);
	TtaSetTextForm (BaseImage + ImageURL, s);
     }
   TtaSetDialoguePosition ();
   TtaShowDialogue (BaseImage + FormImage, FALSE);
   TtaWaitShowDialogue ();
   TtaFreeMemory (s);
   return (LastURLImage);
}


/*----------------------------------------------------------------------
   ComputeSRCattribute  computes the SRC attribute value.		
   		Get text as the proposed value for SRCattribute.	
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                ComputeSRCattribute (Element el, Document doc, Document originDocument, Attribute attr, char *text)
#else  /* __STDC__ */
void                ComputeSRCattribute (el, doc, originDocument, attr, text)
Element             el;
Document            doc;
Document            originDocument;
Attribute           attr;
char               *text;

#endif /* __STDC__ */
{
   char                name[MAX_LENGTH];
   char                pathdoc[MAX_LENGTH];
   char                pathimage[MAX_LENGTH];
   char                localname[MAX_LENGTH];
   char                imagename[MAX_LENGTH];
   LoadedImageDesc    *desc;

   NormalizeURL (text, originDocument, pathimage, name);
   /* copy the text into the SRC attribute */
   if (IsHTTPPath (DocumentURLs[doc]))
     {
	if (!IsHTTPPath (pathimage))
	  {
	     /* try to load a local image within a remote document */
	     /* copy image file into the temporary directory of the document */
	     TtaExtractName (pathimage, localname, imagename);
	     NormalizeURL (imagename, doc, localname, imagename);
	     AddLoadedImage (imagename, localname, doc, &desc);
	     desc->status = IMAGE_MODIFIED;
	     /* JK: was name, seems it should be pathimage */
	     TtaFileCopy (pathimage, desc->localName);

	     TtaExtractName (DocumentURLs[doc], pathdoc, name);
	     TtaExtractName (imagename, pathimage, name);
	     if (!strcmp (pathimage, pathdoc))
		/* convert absolute SRC into local */
		TtaSetAttributeText (attr, name, el, doc);
	     else
		TtaSetAttributeText (attr, imagename, el, doc);

	     /* set contents of the picture element */
	     TtaSetTextContent (el, desc->localName, SPACE, doc);
	     DisplayImage (doc, el, desc->localName);
	  }
	else
	  {
	     /* load from the Web */
	     /* set stop button */
	     ActiveTransfer (doc);
	     TtaSetAttributeText (attr, pathimage, el, doc);
	     FetchImage (doc, el);
	     ResetStop (doc);
	  }
     }
   else
     {
	TtaSetAttributeText (attr, pathimage, el, doc);
	if (!IsHTTPPath (pathimage))
	  {
	     /* set the element content */
	     TtaSetTextContent (el, pathimage, SPACE, doc);
	     DisplayImage (doc, el, pathimage);
	  }
	else
	  {
	     /* set stop button */
	     ActiveTransfer (doc);
	     TtaSetAttributeText (attr, pathimage, el, doc);
	     FetchImage (doc, el);
	     ResetStop (doc);
	  }
     }

}

/*----------------------------------------------------------------------
   UpdateSRCattribute  creates or updates the SRC attribute value	
   		when the contents of element IMG is set.		
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                UpdateSRCattribute (NotifyElement * event)
#else  /* __STDC__ */
void                UpdateSRCattribute (event)
NotifyElement      *event;

#endif /* __STDC__ */
{
   AttributeType       attrType;
   Attribute           attrSRC;
   Element             elSRC, el;
   char               *text;
   Document            doc;

   /* Select an image name */
   el = event->element;
   doc = event->document;
   text = GetImageURL (doc, 1);
   if (text == NULL || text[0] == EOS)
     {
	/* JK: remove the empty SRC element */
	TtaRemoveTree (el, doc);
	return;
     }
   /* search the SRC attribute */
   attrType.AttrSSchema = TtaGetDocumentSSchema (doc);
   attrType.AttrTypeNum = HTML_ATTR_SRC;
   elSRC = TtaGetParent (el);
   if (elSRC != NULL)
      elSRC = el;
   attrSRC = TtaGetAttribute (elSRC, attrType);
   if (attrSRC == 0)
     {
	attrSRC = TtaNewAttribute (attrType);
	TtaAttachAttribute (elSRC, attrSRC, doc);
     }
   ComputeSRCattribute (elSRC, doc, 0, attrSRC, text);
}


/*----------------------------------------------------------------------
   SRCattrModified updates the contents of element IMG according   
   to the new value of attribute SRC.                      
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                SRCattrModified (NotifyAttribute * event)
#else  /* __STDC__ */
void                SRCattrModified (event)
NotifyAttribute    *event;

#endif /* __STDC__ */
{
   Element             el;
   Attribute           attr;
   Document            doc;
   int                 length;
   char               *buf1, *buf2, *imageName;

   doc = event->document;
   el = event->element;
   attr = event->attribute;
   /* get a buffer for the attribute value */
   length = TtaGetTextAttributeLength (attr);
   buf1 = TtaGetMemory (length + 1);
   buf2 = TtaGetMemory (length + 1);
   imageName = TtaGetMemory (length + 1);
   /* copy the SRC attribute into the buffer */
   TtaGiveTextAttributeValue (attr, buf1, &length);
   /* extract image name from full name */
   TtaExtractName (buf1, buf2, imageName);
   if (strlen (imageName) == 0)
      /* full names ends with ''/ */
      TtaExtractName (buf2, buf1, imageName);
   if (strlen (imageName) != 0)
      TtaSetTextContent (el, imageName, TtaGetDefaultLanguage (), doc);
   TtaFreeMemory (buf1);
   TtaFreeMemory (buf2);
   TtaFreeMemory (imageName);
}


/*----------------------------------------------------------------------
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                CreateImage (Document document, View view)
#else  /* __STDC__ */
void                CreateImage (document, view)
Document            document;
View                view;

#endif /* __STDC__ */
{
   ElementType         elType;

   elType.ElSSchema = TtaGetDocumentSSchema (document);
   elType.ElTypeNum = HTML_EL_PICTURE_UNIT;
   TtaCreateElement (elType, document);
}

/*----------------------------------------------------------------------
   AddLocalImage adds a new local image into image descriptor table   
   with the purpose of having it saved through the Net later.    
   This function copy the image in the TempFileDirectory.        
   fullname is the complete path to the local file.              
   name is the name of the local file.                           
   url is the complete URL of the distant location.              
  ----------------------------------------------------------------------*/
#ifdef __STDC__
boolean             AddLocalImage (char *fullname, char *name, char *url, Document doc, LoadedImageDesc ** desc)
#else  /* __STDC__ */
boolean             AddLocalImage (fullname, name, url, doc, desc)
char               *fullname;
char               *name;
char               *url;
Document            doc;
LoadedImageDesc   **desc;

#endif /* __STDC__ */
{
   LoadedImageDesc    *pImage, *previous;
   char                localname[MAX_LENGTH];

   if (!TtaFileExist (fullname))
      return (FALSE);

   *desc = NULL;
   if (url == NULL || name == NULL)
      return (FALSE);
   else if (IsHTTPPath (url))
     {
	/* It is an image loaded from the Web */
	sprintf (localname, "%s%s%d%s", TempFileDirectory, DIR_STR, doc, DIR_STR);
	strcat (localname, name);
     }
   else
      /* it is a local image */
      return (FALSE);		/* nothing to do */

   pImage = ImageURLs;
   previous = NULL;
   while (pImage != NULL)
     {
	if ((pImage->document == doc) &&
	    (strcmp (url, pImage->originalName) == 0))
	  {
	     /* image already loaded */
	     *desc = pImage;
	     break;
	  }
	else
	  {
	     /* see the next descriptor */
	     previous = pImage;
	     pImage = pImage->nextImage;
	  }
     }

   /*
    * copy the image in place.
    */
   TtaFileCopy (fullname, localname);

   /*
    * add a new identifier to the list if necessary.
    */
   if (pImage == NULL)
     {
	/* It is a new loaded image */
	pImage = (LoadedImageDesc *) TtaGetMemory (sizeof (LoadedImageDesc));
	pImage->originalName = TtaGetMemory (strlen (url) + 1);
	strcpy (pImage->originalName, url);
	pImage->localName = TtaGetMemory (strlen (localname) + 1);
	strcpy (pImage->localName, localname);
	pImage->prevImage = previous;
	if (previous != NULL)
	   previous->nextImage = pImage;
	else
	   ImageURLs = pImage;
	pImage->nextImage = NULL;
	pImage->document = doc;
	pImage->elImage = NULL;
     }
   pImage->status = IMAGE_MODIFIED;
   *desc = pImage;
   return (TRUE);
}

/*----------------------------------------------------------------------
   RemoveDocumentImages removes loaded images of the document.        
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                RemoveDocumentImages (Document doc)
#else  /* __STDC__ */
void                RemoveDocumentImages (doc)
Document            doc;

#endif /* __STDC__ */
{
   LoadedImageDesc    *pImage, *previous, *next;

   pImage = ImageURLs;
   previous = NULL;
   if (doc == (Document) None)
      return;			/* nothing to do */

   while (pImage != NULL)
     {
	next = pImage->nextImage;
	/* does the current image belong to the document ? */
	if (pImage->document == doc)
	  {
	     pImage->status = IMAGE_NOT_LOADED;
	     /* remove the image */
	     TtaFileUnlink (pImage->localName);
	     /* free the descriptor */
	     if (pImage->originalName != NULL)
		TtaFreeMemory (pImage->originalName);
	     if (pImage->localName != NULL)
		TtaFreeMemory (pImage->localName);

	     /* set up the image descriptors link */
	     if (previous != NULL)
		previous->nextImage = next;
	     else
		ImageURLs = next;
	     if (next != NULL)
		next->prevImage = previous;
	     TtaFreeMemory ((char *) pImage);
	     pImage = previous;
	  }
	/* next descriptor */
	previous = pImage;
	pImage = next;
     }
}

/*----------------------------------------------------------------------
   	UpdateImageMap sets or updates Ref_IMG MAP attributes for the	
   		    current image.					
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                UpdateImageMap (Element image, Document document)
#else  /* __STDC__ */
void                UpdateImageMap (image, document)
Element             image;
Document            document;

#endif /* __STDC__ */
{
   AttributeType       attrType;
   Attribute           attr;
   Element             el, child;
   char               *text;
   int                 shape, w, h, length;

   /* Search the USEMAP attribute */
   attrType.AttrSSchema = TtaGetDocumentSSchema (document);
   attrType.AttrTypeNum = HTML_ATTR_USEMAP;
   attr = TtaGetAttribute (image, attrType);
   if (attr != NULL)
     {
	/* ask Thot to stop displaying changes made in the document */
	TtaSetDisplayMode (document, DeferredDisplay);

	/* Search the MAP element associated with IMAGE element */
	length = TtaGetTextAttributeLength (attr);
	length++;
	text = TtaGetMemory (length);
	TtaGiveTextAttributeValue (attr, text, &length);
	if (text[0] == '#')
	   el = SearchNAMEattribute (document, &text[1], NULL);
	else
	   el = NULL;
	TtaFreeMemory (text);
	if (el == NULL)
	   return;

	/* Update MAP attribute */
	attrType.AttrTypeNum = HTML_ATTR_Ref_IMG;
	attr = TtaGetAttribute (el, attrType);
	if (attr == NULL)
	  {
	     /* create it */
	     attr = TtaNewAttribute (attrType);
	     TtaAttachAttribute (el, attr, document);
	  }
	TtaSetAttributeReference (attr, el, document, image, document);

	/* Update AREAs attribute */
	el = TtaGetFirstChild (el);
	TtaGiveBoxSize (image, document, 1, UnPixel, &w, &h);
	while (el != NULL)
	  {
	     /* Search the shape attribute */
	     attrType.AttrTypeNum = HTML_ATTR_shape;
	     attr = TtaGetAttribute (el, attrType);
	     if (attr != NULL)
	       {
		  shape = TtaGetAttributeValue (attr);
		  if (shape == HTML_ATTR_shape_VAL_polygon)
		    {
		       attrType.AttrTypeNum = HTML_ATTR_AreaRef_IMG;
		       attr = TtaGetAttribute (el, attrType);
		       if (attr == NULL)
			 {
			    /* create it */
			    attr = TtaNewAttribute (attrType);
			    TtaAttachAttribute (el, attr, document);
			 }
		       TtaSetAttributeReference (attr, el, document, image, document);

		       if (shape == HTML_ATTR_shape_VAL_polygon)
			 {
			    child = TtaGetFirstChild (el);
			    TtaChangeLimitOfPolyline (child, UnPixel, w, h, document);
			 }
		    }
	       }
	     TtaNextSibling (&el);
	  }
     }

   /* ask Thot to display changes made in the document */
   TtaSetDisplayMode (document, DisplayImmediately);
}
