	{ Ce schema donne les regles pour la traduction d'un Rapport
	  en ISO Latin 1

	  V. Quint	Mai 1989 }

TRANSLATION Rapport;

LINELENGTH 78;

BUFFERS
   NomImage(Picture);

COUNTERS

   CptAffiliation: Rank of Affiliation;
   CptBiblio: Rank of Citation_biblio;
   CptFigure: Set 1 on Rapport  Add 1 on Figure;
   CptFormule: Set 1 on Rapport  Add 1 on Formule_num\351rot\351e;
   CptSect1: Rank of Section;
   CptSect2: Rank of Section 2;
   CptSect3: Rank of Section 3;
   CptSect4: Rank of Section 4;
   CptAnnexe: Rank of Annexe;
   CptNote: Rank of Note;
   CptImage: Set 0 on Rapport  Add 1 on PICTURE_UNIT;

CONST
   NL = '\12';
   NLNL = '\12\12';
   Espace = ' ';

VAR

   VarAffiliation : '(' Value(CptAffiliation) ')';
   VarSect1 : Value(CptSect1);
   VarSect2 : Value(CptSect2) '.' Value(CptSect1);
   VarSect3 : Value(CptSect3) '.' Value(CptSect2) '.' Value(CptSect1);
   VarSect4 : Value(CptSect4) '.' Value(CptSect3) '.' Value(CptSect2) '.' Value(CptSect1);
   VarFormule : '(' Value(CptFormule) ')';
   VarBiblio : '[' Value(CptBiblio) ']';
   VarFigure : 'Fig. ' Value(CptFigure);
   VarNote: '<' Value(CptNote) '>';
   VarAnnexe: Value(CptAnnexe);

RULES

   Rapport :
	BEGIN
	Use ParagraphA for Paragraphe;
	Use RefBibA for RefBib;
        Use DrawT1 for Draw;
	Use Draw2T1 for Draw2;
        Use TableT for Table;
        Use Arbre2A for Arbre2;
	Use FichierA for Fichier;
	Get Notes After;
	END;

   Entete:
	BEGIN
	END;

   Titre_courant :
	Remove;

   Auteurs_courants:
	Remove;

   R\351f\351rence:
	Create NL After;

   Statut:
	Create NL After;

   Date_de_mise_a_jour :
	Create NL After;

   Titre :
	BEGIN
	Create NLNL Before;
	Create NLNL After;
	END;

   Auteurs :
	Create NL;

   Auteur :
	Create NL After;

   Affiliations :
	Create NL;

   Affiliation :
	BEGIN
	if referred
	    BEGIN
	    create VarAffiliation before;
	    create '  ' before;
	    END;
	Create NL After;
	END;

   R\351sum\351 :
	BEGIN
	Create NL;
	Create 'Re''sume'' :\12';
	END;

   Mots_cl\351s :
	BEGIN
	Create NL;
	Create 'Mots cle''s : ';
	END;

   Heading :
	BEGIN
	END;

   Title:
	BEGIN
	Create NL;
	Create 'Title:\12';
	END;
	
   Abstract :
	BEGIN
	Create NL;
	Create 'Abstract:\12';
	END;

   Keywords :
	BEGIN
	Create NL;
	Create 'Keywords: ';
	END;
	
   Corps:
	BEGIN
	END;

   Pr\351ambule :
	Create NL;

   Bibliographie :
	Create '\12BIBLIOGRAPHIE\12';

   Citation_biblio :
	BEGIN
	Create NL;
	Create VarBiblio;
	Create Espace;
	Create NL after;
	END;

   Ref_affiliation:
	Create referred VarAffiliation;

   Annexe :
	BEGIN
	Create (NL 'Annexe ');
	Create VarAnnexe;
	Create Espace;
	END;

   Titre_annexe:
	Create NLNL after;

   Titre_courant_annexe:
	Remove;

   Section :
	Create NL;

   Titre_section :
	BEGIN
	IF Within 1 Section Create VarSect1;
	IF Within 2 Section Create VarSect2;
	IF Within 3 Section Create VarSect3;
	IF Within 4 Section Create VarSect4;
	IF Within <5 Section Create ' ';
	Create NLNL After;
	END;

   Titre_groupe :
	Create NLNL after;

   Image :
	BEGIN
	END;

   Formule_num\351rot\351e :
	Create VarFormule After;

   Figure :
	BEGIN
	Create NL After;
	END;

   Illustration :
	BEGIN
	END;
   
   L\351gende_figure :
	BEGIN
	Create VarFigure;
	Create Espace;
	Create NL after;
	END;

   Notes :
	Create '\12\12NOTES\12\12';

   Note :
	BEGIN
	Create VarNote;
	Create Espace;
	END;

   Indice :
	BEGIN
	END;

   Exposant :
	BEGIN
	END;

   Ref_note :
	Create Refered VarNote;

   Ref_biblio :
	Create Refered VarBiblio;

   Ref_figure :
	Create Refered VarFigure;

   Ref_formule :
	Create Refered VarFormule;

   Ref_section :
	BEGIN
	If target within 0 Section Create referred VarSect1;
	If target within 1 Section Create referred VarSect2;
	If target within 2 Section Create referred VarSect3;
	If target within >2 Section Create referred VarSect4;
	END;

   Ref_annexe:
	Create Refered VarAnnexe;

   Ref_groupe_titr\351:
	Create Referred Titre_groupe;

   Math :
	Use MathT;

   GRAPHICS_UNIT :
	Remove;

   PICTURE_UNIT :
	BEGIN
	Create ('PICTURE_UNIT-' Value(CptImage) NL);
	Create NomImage After;
	Create NL after;
	END;

ATTRIBUTES

   Importance = D\351finition :
	BEGIN
	END;

   Importance = Important :
	BEGIN
	END;

   Num\351ro_prem_page:
	BEGIN
	END;

   Num\351ro_prem_section:
	BEGIN
	END;

   Type_auteur = Auteur_principal :
	BEGIN
	END;

   Type_auteur = Auteur_secondaire :
	BEGIN
	END;

TextTRANSLATE   Latin
	BEGIN
	'\212' -> '\12';
	'\240' -> ' ';
	'\327' -> 'OE';
	'\367' -> 'oe';
	END;
END
